/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.geocoder.model;

import com.google.code.geocoder.model.GeocoderComponent;
import com.google.code.geocoder.model.LatLng;
import com.google.code.geocoder.model.LatLngBounds;
import java.io.Serializable;
import java.util.EnumMap;

public class GeocoderRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String channel;
    private String address;
    private String language;
    private String region;
    private LatLngBounds bounds;
    private LatLng location;
    private final EnumMap<GeocoderComponent, String> components = new EnumMap(GeocoderComponent.class);

    public GeocoderRequest() {
    }

    public GeocoderRequest(String address, String language) {
        this();
        this.address = address;
        this.language = language;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public LatLngBounds getBounds() {
        return this.bounds;
    }

    public void setBounds(LatLngBounds bounds) {
        this.bounds = bounds;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public LatLng getLocation() {
        return this.location;
    }

    public void setLocation(LatLng location) {
        this.location = location;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void addComponent(GeocoderComponent component, String value) {
        this.components.put(component, value);
    }

    public EnumMap<GeocoderComponent, String> getComponents() {
        return this.components;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeocoderRequest that = (GeocoderRequest)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.bounds != null ? !this.bounds.equals(that.bounds) : that.bounds != null) {
            return false;
        }
        if (this.channel != null ? !this.channel.equals(that.channel) : that.channel != null) {
            return false;
        }
        if (this.components != null ? !this.components.equals((Object)that.components) : that.components != null) {
            return false;
        }
        if (this.language != null ? !this.language.equals(that.language) : that.language != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        return !(this.region != null ? !this.region.equals(that.region) : that.region != null);
    }

    public int hashCode() {
        int result = this.channel != null ? this.channel.hashCode() : 0;
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        result = 31 * result + (this.bounds != null ? this.bounds.hashCode() : 0);
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.components != null ? this.components.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GeocoderRequest{channel='" + this.channel + '\'' + ", address='" + this.address + '\'' + ", language='" + this.language + '\'' + ", region='" + this.region + '\'' + ", bounds=" + this.bounds + ", location=" + this.location + ", components=" + this.components + '}';
    }
}

