/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.geocoder;

import com.google.code.geocoder.GeoSearchableAddress;
import com.google.code.geocoder.Geocoder;
import com.google.code.geocoder.GeocoderRequestBuilder;
import com.google.code.geocoder.model.GeocodeResponse;
import com.google.code.geocoder.model.GeocoderGeometry;
import com.google.code.geocoder.model.GeocoderLocationType;
import com.google.code.geocoder.model.GeocoderResult;
import com.google.code.geocoder.model.GeocoderStatus;
import com.google.code.geocoder.model.LatLng;
import java.util.List;
import javax.annotation.PostConstruct;

public class GeoAddressService
implements GeoSearchableAddress {
    private static Geocoder geocoder;

    @PostConstruct
    public void initializeProperties() {
        geocoder = new Geocoder();
    }

    @Override
    public GeocoderResult getAddress(String address) {
        GeocoderRequestBuilder buildQuery = this.buildQuery(address, null);
        GeocodeResponse geocode = geocoder.geocode(buildQuery.getGeocoderRequest());
        GeocoderResult filteredGeoCodingResult = this.findMostAccurateGeoCoderResult(geocode);
        return filteredGeoCodingResult;
    }

    @Override
    public GeocoderResult getAddress(String address, String ccTLD) {
        GeocoderRequestBuilder buildQuery = this.buildQuery(address, ccTLD);
        GeocodeResponse geocode = geocoder.geocode(buildQuery.getGeocoderRequest());
        GeocoderResult filteredGeoCodingResult = this.findMostAccurateGeoCoderResult(geocode);
        return filteredGeoCodingResult;
    }

    private GeocoderRequestBuilder buildQuery(String address, String ccTLD) {
        GeocoderRequestBuilder geocoderRequestBuilder = new GeocoderRequestBuilder().setAddress(address);
        if (ccTLD != null && !ccTLD.trim().isEmpty()) {
            geocoderRequestBuilder.setRegion(ccTLD);
        }
        return geocoderRequestBuilder;
    }

    private GeocoderResult findMostAccurateGeoCoderResult(GeocodeResponse geocode) {
        List<GeocoderResult> geocodingResults;
        GeocoderResult geocodingResultMostAccurate = null;
        if (geocode != null && geocode.getStatus() == GeocoderStatus.OK && (geocodingResults = geocode.getResults()).size() != 0) {
            geocodingResultMostAccurate = geocodingResults.get(0);
            GeocoderLocationType locationType = this.getGeometryLocationType(geocodingResultMostAccurate);
            for (GeocoderResult geocoderResult : geocodingResults) {
                GeocoderLocationType newLocationType = this.getGeometryLocationType(geocoderResult);
                if (newLocationType.compareTo(locationType) <= 0) continue;
                locationType = newLocationType;
                geocodingResultMostAccurate = geocoderResult;
            }
        }
        return geocodingResultMostAccurate;
    }

    private GeocoderLocationType getGeometryLocationType(GeocoderResult geocoderResult) {
        GeocoderLocationType locationType = null;
        GeocoderGeometry geometry = geocoderResult.getGeometry();
        if (geometry != null && geometry.getLocationType() != null) {
            locationType = geometry.getLocationType();
        }
        return locationType;
    }

    @Override
    public LatLng getLatLngPointsByAddress(String address) {
        GeocoderResult result = this.getAddress(address);
        if (result == null) {
            return null;
        }
        return result.getGeometry().getLocation();
    }
}

