/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.geocoder.model;

import com.google.code.geocoder.model.LatLng;
import java.io.Serializable;

public class LatLngBounds
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LatLng southwest;
    private LatLng northeast;

    public LatLngBounds() {
    }

    public LatLngBounds(LatLng southwest, LatLng northeast) {
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLng getSouthwest() {
        return this.southwest;
    }

    public void setSouthwest(LatLng southwest) {
        this.southwest = southwest;
    }

    public LatLng getNortheast() {
        return this.northeast;
    }

    public void setNortheast(LatLng northeast) {
        this.northeast = northeast;
    }

    public String toUrlValue() {
        return this.toUrlValue(6);
    }

    public String toUrlValue(int precision) {
        return this.getSouthwest().toUrlValue(precision) + "," + this.getNortheast().toUrlValue(precision);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLngBounds that = (LatLngBounds)o;
        if (this.northeast != null ? !this.northeast.equals(that.northeast) : that.northeast != null) {
            return false;
        }
        return !(this.southwest != null ? !this.southwest.equals(that.southwest) : that.southwest != null);
    }

    public int hashCode() {
        int result = this.southwest != null ? this.southwest.hashCode() : 0;
        result = 31 * result + (this.northeast != null ? this.northeast.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LatLngBounds{southwest=" + this.southwest + ", northeast=" + this.northeast + '}';
    }
}

