## Build Requirements

* Java 6
* Maven (2 or 3)


## Installing additional libraries

### Install Arch plugins as Maven artifacts

1. git clone https://github.com/Phillipus/archi.git

2. cd archi

3. mvn org.eclipse.tycho:tycho-pomgenerator-plugin:generate-poms -DgroupId=com.archimatetool

4. edit the generated pom.xml:

    4.1 add the p2 repositories:

        <repositories>  
          <repository>  
            <id>juno</id>  
            <layout>p2</layout>  
            <url>http://download.eclipse.org/releases/juno</url>  
          </repository>  
          <repository>
            <id>updates</id>
            <layout>p2</layout>
            <url>http://download.eclipse.org/eclipse/updates/3.8</url>
          </repository>
        </repositories>
        
    4.2 add the target platform configuration:
    
        <plugin>
          <groupId>org.eclipse.tycho</groupId>
          <artifactId>target-platform-configuration</artifactId>
          <version>${tycho-version}</version>
          <configuration>
            <environments>
              <environment>
                <os>win32</os>
                <ws>win32</ws>
                <arch>x86</arch>
              </environment>
              <environment>
                <os>win32</os>
                <ws>win32</ws>
                <arch>x86_64</arch>
              </environment>
              <environment>
                <os>linux</os>
                <ws>gtk</ws>
                <arch>x86</arch>
              </environment>
              <environment>
                <os>linux</os>
                <ws>gtk</ws>
                <arch>x86_64</arch>
              </environment>
              <environment>
                <os>macosx</os>
                <ws>cocoa</ws>
                <arch>x86</arch>
              </environment>
              <environment>
                <os>macosx</os>
                <ws>cocoa</ws>
                <arch>x86_64</arch>
              </environment>
            </environments>
          </configuration>
        </plugin>

    4.3 edit the pom.xml of platform dependent plugins to add the target platform configuration:
        
        com.archimatetool.editor.fullscreen.macos
        
        <build>
          <plugins>
            <plugin>
              <groupId>org.eclipse.tycho</groupId>
              <artifactId>target-platform-configuration</artifactId>
              <version>${tycho-version}</version>
              <configuration>
                <environments>
                  <environment>
                    <os>macosx</os>
                    <ws>cocoa</ws>
                    <arch>x86</arch>
                  </environment>
                  <environment>
                    <os>macosx</os>
                    <ws>cocoa</ws>
                    <arch>x86_64</arch>
                  </environment>
                </environments>
              </configuration>
            </plugin>
          </plugins>
        </build>

        com.archimatetool.editor.launch.win32
        
        <build>
          <plugins>
            <plugin>
              <groupId>org.eclipse.tycho</groupId>
              <artifactId>target-platform-configuration</artifactId>
              <version>${tycho-version}</version>
              <configuration>
                <environments>
                  <environment>
                    <os>win32</os>
                    <ws>win32</ws>
                    <arch>x86</arch>
                  </environment>
                  <environment>
                    <os>win32</os>
                    <ws>win32</ws>
                    <arch>x86_64</arch>
                  </environment>
                </environments>
              </configuration>
            </plugin>
          </plugins>
        </build>

5. mvn clean install

6. cd com.archimatetool.editor/build

7. create a new pom.xml

        <project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
          xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">
          <modelVersion>4.0.0</modelVersion>
          <parent>
            <groupId>com.archimatetool</groupId>
            <artifactId>archi</artifactId>
            <version>0.0.1-SNAPSHOT</version>
          </parent>
          <artifactId>archi-product</artifactId>
          <packaging>eclipse-repository</packaging>
          <build>
            <plugins>
              <plugin>
                <groupId>org.eclipse.tycho</groupId>
                <artifactId>tycho-p2-director-plugin</artifactId>
                <version>${tycho.version}</version>
                <executions>
                  <execution>
                    <id>materialize-products</id>
                    <goals>
                      <goal>materialize-products</goal>
                    </goals>
                  </execution>
                </executions>
              </plugin>
            </plugins>
          </build>
        </project>
        
8. edit archimate.product and comment out these plugins:

        <plugin id="org.eclipse.swt.gtk.aix.ppc" fragment="true"/>
        <plugin id="org.eclipse.swt.gtk.aix.ppc64" fragment="true"/>
        <plugin id="org.eclipse.swt.gtk.hpux.ia64_32" fragment="true"/>
        <plugin id="org.eclipse.swt.gtk.linux.ppc" fragment="true"/>
        <plugin id="org.eclipse.swt.gtk.linux.ppc64" fragment="true"/>
        <plugin id="org.eclipse.swt.gtk.linux.s390" fragment="true"/>
        <plugin id="org.eclipse.swt.gtk.linux.s390x" fragment="true"/>
        <plugin id="org.eclipse.swt.gtk.solaris.sparc" fragment="true"/>
        <plugin id="org.eclipse.swt.gtk.solaris.x86" fragment="true"/>

9. mvn clean package

### Install CMDBuild Maven artifacts

see [CMDBuild](https://bitbucket.org/tecnoteca/cmdbuild/wiki/Home)


## Compiling the software

1. hg clone https://bitbucket.org/bompani/cmdbuild-unibo

2. cd cmdbuild-unibo

3. mvn clean install

4. cd cmdbuild-archimate

5. mvn clean package

6. edit diffDir.sh variables:

    6.1 DIST={cmdbuild-unibo}/cmdbuild-archimate/cmdbuild-archimate-product/target/repository/plugins/
    
    6.2 DIST_OLD={archi}/com.archimatetool.build/target/repository/plugins/
    
    6.3 DIST_UPGRADE={distribution}/plugins/
    
7. zip -r cmdbuild-archimate.zip {distribution}/plugins/

## CMDBuild plugin for Archi

### Install plugins

1. extract cmdbuild-archimate.zip into {Archi_HOME}/plugins

### Create CMDBuild classes and domain to host Archimate models

1. authenticate on cmdbuild at http://localhost:8080/cmdbuild

2. open url http://localhost:8080/cmdbuild/services/cmdb-schema/

3. upload cmdbuild-archimate-plugin/model/lookup.xsd

4. upload cmdbuild-archimate-plugin/model/class.xsd

5. upload cmdbuild-archimate-plugin/model/domain.xsd

6. restart CMDBuild

### Configuration
0. delete old Archi setting folder:
    * @user.home/uk.ac.bolton/Archi on linux
    * @user.home/Application Data/uk.ac.bolton/Archi on windows
    * @user.home/Library/Application Support/uk.ac.bolton/Archi on mac

1. run Archi

2. open Edit -> Preferences -> CMDB Import / Export


