/**
 */
package it.unibo.cmdb.cmdbf.client.model.cmdbf.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfFactory;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.DeregisterRequestType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemListType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdListType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.Model;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelMetadata;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RegisterRequestType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipListType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Model</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelImpl#getRegister <em>Register</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelImpl#getDeregister <em>Deregister</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelImpl#getItem <em>Item</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelImpl#getRelationship <em>Relationship</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelImpl#getModelMetadata <em>Model Metadata</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelImpl#getMdrId <em>Mdr Id</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelImpl#getRemovedItemId <em>Removed Item Id</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelImpl#getRemovedRelationshipId <em>Removed Relationship Id</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ModelImpl extends MinimalEObjectImpl.Container implements Model {
	/**
	 * The cached value of the '{@link #getRegister() <em>Register</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRegister()
	 * @generated
	 * @ordered
	 */
	protected RegisterRequestType register;
	/**
	 * The cached value of the '{@link #getDeregister() <em>Deregister</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeregister()
	 * @generated
	 * @ordered
	 */
	protected DeregisterRequestType deregister;
	/**
	 * The cached value of the '{@link #getModelMetadata() <em>Model Metadata</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelMetadata()
	 * @generated
	 * @ordered
	 */
	protected ModelMetadata modelMetadata;

	/**
	 * The default value of the '{@link #getMdrId() <em>Mdr Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMdrId()
	 * @generated
	 * @ordered
	 */
	protected static final String MDR_ID_EDEFAULT = null;
	

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CmdbfPackage.Literals.MODEL;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RegisterRequestType getRegister() {
		if(register == null)
			setRegister(CmdbfFactory.eINSTANCE.createRegisterRequestType());	
		return register;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRegister(RegisterRequestType newRegister, NotificationChain msgs) {
		RegisterRequestType oldRegister = register;
		register = newRegister;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CmdbfPackage.MODEL__REGISTER, oldRegister, newRegister);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRegister(RegisterRequestType newRegister) {
		if (newRegister != register) {
			NotificationChain msgs = null;
			if (register != null)
				msgs = ((InternalEObject)register).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CmdbfPackage.MODEL__REGISTER, null, msgs);
			if (newRegister != null)
				msgs = ((InternalEObject)newRegister).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CmdbfPackage.MODEL__REGISTER, null, msgs);
			msgs = basicSetRegister(newRegister, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.MODEL__REGISTER, newRegister, newRegister));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public DeregisterRequestType getDeregister() {
		if(deregister == null)
			setDeregister(CmdbfFactory.eINSTANCE.createDeregisterRequestType());
		return deregister;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDeregister(DeregisterRequestType newDeregister, NotificationChain msgs) {
		DeregisterRequestType oldDeregister = deregister;
		deregister = newDeregister;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CmdbfPackage.MODEL__DEREGISTER, oldDeregister, newDeregister);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeregister(DeregisterRequestType newDeregister) {
		if (newDeregister != deregister) {
			NotificationChain msgs = null;
			if (deregister != null)
				msgs = ((InternalEObject)deregister).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CmdbfPackage.MODEL__DEREGISTER, null, msgs);
			if (newDeregister != null)
				msgs = ((InternalEObject)newDeregister).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CmdbfPackage.MODEL__DEREGISTER, null, msgs);
			msgs = basicSetDeregister(newDeregister, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.MODEL__DEREGISTER, newDeregister, newDeregister));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public EList<ItemType> getItem() {
		return getItemList().getItem();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public EList<RelationshipType> getRelationship() {
		return getRelationshipList().getRelationship();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelMetadata getModelMetadata() {
		if (modelMetadata != null && modelMetadata.eIsProxy()) {
			InternalEObject oldModelMetadata = (InternalEObject)modelMetadata;
			modelMetadata = (ModelMetadata)eResolveProxy(oldModelMetadata);
			if (modelMetadata != oldModelMetadata) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, CmdbfPackage.MODEL__MODEL_METADATA, oldModelMetadata, modelMetadata));
			}
		}
		return modelMetadata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelMetadata basicGetModelMetadata() {
		return modelMetadata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setModelMetadata(ModelMetadata newModelMetadata) {
		ModelMetadata oldModelMetadata = modelMetadata;
		modelMetadata = newModelMetadata;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.MODEL__MODEL_METADATA, oldModelMetadata, modelMetadata));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public String getMdrId() {
		return register!=null ? register.getMdrId() : (deregister!=null ? deregister.getMdrId() : null);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public void setMdrId(String newMdrId) {
		if(register == null)
			setRegister(CmdbfFactory.eINSTANCE.createRegisterRequestType());
		if(deregister == null)
			setDeregister(CmdbfFactory.eINSTANCE.createDeregisterRequestType());		
		register.setMdrId(newMdrId);		
		deregister.setMdrId(newMdrId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public EList<MdrScopedIdType> getRemovedItemId() {
		MdrScopedIdListType itemIdList = getDeregister().getItemIdList();
		if(itemIdList == null) {
			itemIdList = CmdbfFactory.eINSTANCE.createMdrScopedIdListType();
			getDeregister().setItemIdList(itemIdList);
		}
		return getDeregister().getItemIdList().getInstanceId();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public EList<MdrScopedIdType> getRemovedRelationshipId() {
		MdrScopedIdListType relationshipIdList = getDeregister().getRelationshipIdList();
		if(relationshipIdList == null) {
			relationshipIdList = CmdbfFactory.eINSTANCE.createMdrScopedIdListType();
			getDeregister().setRelationshipIdList(relationshipIdList);
		}
		return getDeregister().getRelationshipIdList().getInstanceId();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public ItemType addItem() {
		ItemType item = CmdbfFactory.eINSTANCE.createItemType();
		getItem().add(item);
		return item;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RelationshipType addRelationship() {
		RelationshipType relationship = CmdbfFactory.eINSTANCE.createRelationshipType();
		getRelationship().add(relationship);
		return relationship;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public EList<ItemType> getItemByTemplate(String templateId) {
		EList<ItemType> list = new BasicEList<ItemType>();
		for(ItemType item : getItem()) {
			if(item.getTemplateId().contains(templateId))
				list.add(item);
		}
		return ECollections.unmodifiableEList(list);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public EList<RelationshipType> getRelationshipByTemplate(String templateId) {
		EList<RelationshipType> list = new BasicEList<RelationshipType>();
		for(RelationshipType relationship : getRelationship()) {
			if(relationship.getTemplateId().contains(templateId))
				list.add(relationship);
		}
		return ECollections.unmodifiableEList(list);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public ItemType findItem(MdrScopedIdType id) {
		return getItemList().find(id);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public ItemType findItem(ItemType item) {
		return getItemList().find(item);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public ItemType findItem(String mdrId, String localId) {
		MdrScopedIdType instanceId = CmdbfFactory.eINSTANCE.createMdrScopedIdType();
		instanceId.setMdrId(mdrId);
		instanceId.setLocalId(localId);
		return findItem(instanceId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RelationshipType findRelationship(MdrScopedIdType id) {
		return getRelationshipList().find(id);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RelationshipType findRelationship(RelationshipType relationship) {
		RelationshipType result = getRelationshipList().find(relationship);
		if(result == null) {
			ItemType source = null;
			if(relationship.getSourceItem() != null)
				source = findItem(relationship.getSourceItem());			
			ItemType target = null;
			if(relationship.getTargetItem() != null)
				target = findItem(relationship.getTargetItem());
			if(source != null && target != null) {
				for(RelationshipType sourceRel : source.getRelationshipBySource()) {
					if(relationship.getInstanceId().isEmpty() || sourceRel.getInstanceId().isEmpty()) {					
						if(sourceRel.getTargetItem() == target) {
							if(result == null)
								result = sourceRel;
							else
								throw new IllegalArgumentException("Found more than one relationship: " + relationship);
						}
					}
				}				
			}			
		}
		else
			result = getRelationshipList().find(relationship);			
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RelationshipType findRelationship(String mdrId, String localId) {
		MdrScopedIdType instanceId = CmdbfFactory.eINSTANCE.createMdrScopedIdType();
		instanceId.setMdrId(mdrId);
		instanceId.setLocalId(localId);
		return findRelationship(instanceId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean remove(ItemType item) {
		boolean member = item.getParent()!=null && this.equals(item.getParent().getParent());		
		if(member) {
			//item.getRecord().clear();
			getRemovedItemId().add(EcoreUtil.copy(item.findInstanceId()));
			List<RelationshipType> list = new ArrayList<RelationshipType>();
			for(RelationshipType relationship : item.getRelationshipBySource())
				list.add(relationship);
			for(RelationshipType relationship : item.getRelationshipByTarget())
				list.add(relationship);
			for(RelationshipType relationship : list) {
				boolean removed = false;
				for(MdrScopedIdType id : relationship.getInstanceId())
					removed |= getRemovedRelationshipId().contains(id); 
				if(!removed)
					remove(relationship);
			}
		}			
		return member;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean remove(RelationshipType relationship) {
		boolean member = relationship.getParent()!=null && this.equals(relationship.getParent().getParent());
		if(member) {
			//relationship.getRecord().clear();
			getRemovedRelationshipId().add(EcoreUtil.copy(relationship.findInstanceId()));
		}			
		return member;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CmdbfPackage.MODEL__REGISTER:
				return basicSetRegister(null, msgs);
			case CmdbfPackage.MODEL__DEREGISTER:
				return basicSetDeregister(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CmdbfPackage.MODEL__REGISTER:
				return getRegister();
			case CmdbfPackage.MODEL__DEREGISTER:
				return getDeregister();
			case CmdbfPackage.MODEL__ITEM:
				return getItem();
			case CmdbfPackage.MODEL__RELATIONSHIP:
				return getRelationship();
			case CmdbfPackage.MODEL__MODEL_METADATA:
				if (resolve) return getModelMetadata();
				return basicGetModelMetadata();
			case CmdbfPackage.MODEL__MDR_ID:
				return getMdrId();
			case CmdbfPackage.MODEL__REMOVED_ITEM_ID:
				return getRemovedItemId();
			case CmdbfPackage.MODEL__REMOVED_RELATIONSHIP_ID:
				return getRemovedRelationshipId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CmdbfPackage.MODEL__REGISTER:
				setRegister((RegisterRequestType)newValue);
				return;
			case CmdbfPackage.MODEL__DEREGISTER:
				setDeregister((DeregisterRequestType)newValue);
				return;
			case CmdbfPackage.MODEL__MODEL_METADATA:
				setModelMetadata((ModelMetadata)newValue);
				return;
			case CmdbfPackage.MODEL__MDR_ID:
				setMdrId((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CmdbfPackage.MODEL__REGISTER:
				setRegister((RegisterRequestType)null);
				return;
			case CmdbfPackage.MODEL__DEREGISTER:
				setDeregister((DeregisterRequestType)null);
				return;
			case CmdbfPackage.MODEL__MODEL_METADATA:
				setModelMetadata((ModelMetadata)null);
				return;
			case CmdbfPackage.MODEL__MDR_ID:
				setMdrId(MDR_ID_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CmdbfPackage.MODEL__REGISTER:
				return register != null;
			case CmdbfPackage.MODEL__DEREGISTER:
				return deregister != null;
			case CmdbfPackage.MODEL__ITEM:
				return !getItem().isEmpty();
			case CmdbfPackage.MODEL__RELATIONSHIP:
				return !getRelationship().isEmpty();
			case CmdbfPackage.MODEL__MODEL_METADATA:
				return modelMetadata != null;
			case CmdbfPackage.MODEL__MDR_ID:
				return MDR_ID_EDEFAULT == null ? getMdrId() != null : !MDR_ID_EDEFAULT.equals(getMdrId());
			case CmdbfPackage.MODEL__REMOVED_ITEM_ID:
				return !getRemovedItemId().isEmpty();
			case CmdbfPackage.MODEL__REMOVED_RELATIONSHIP_ID:
				return !getRemovedRelationshipId().isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case CmdbfPackage.MODEL___ADD_ITEM:
				return addItem();
			case CmdbfPackage.MODEL___ADD_RELATIONSHIP:
				return addRelationship();
			case CmdbfPackage.MODEL___GET_ITEM_BY_TEMPLATE__STRING:
				return getItemByTemplate((String)arguments.get(0));
			case CmdbfPackage.MODEL___GET_RELATIONSHIP_BY_TEMPLATE__STRING:
				return getRelationshipByTemplate((String)arguments.get(0));
			case CmdbfPackage.MODEL___FIND_ITEM__MDRSCOPEDIDTYPE:
				return findItem((MdrScopedIdType)arguments.get(0));
			case CmdbfPackage.MODEL___FIND_ITEM__ITEMTYPE:
				return findItem((ItemType)arguments.get(0));
			case CmdbfPackage.MODEL___FIND_ITEM__STRING_STRING:
				return findItem((String)arguments.get(0), (String)arguments.get(1));
			case CmdbfPackage.MODEL___FIND_RELATIONSHIP__MDRSCOPEDIDTYPE:
				return findRelationship((MdrScopedIdType)arguments.get(0));
			case CmdbfPackage.MODEL___FIND_RELATIONSHIP__RELATIONSHIPTYPE:
				return findRelationship((RelationshipType)arguments.get(0));
			case CmdbfPackage.MODEL___FIND_RELATIONSHIP__STRING_STRING:
				return findRelationship((String)arguments.get(0), (String)arguments.get(1));
			case CmdbfPackage.MODEL___REMOVE__ITEMTYPE:
				return remove((ItemType)arguments.get(0));
			case CmdbfPackage.MODEL___REMOVE__RELATIONSHIPTYPE:
				return remove((RelationshipType)arguments.get(0));
		}
		return super.eInvoke(operationID, arguments);
	}
	
	private ItemListType getItemList() {
		ItemListType itemList = getRegister().getItemList();
		if(itemList == null) {
			itemList = CmdbfFactory.eINSTANCE.createItemListType();
			getRegister().setItemList(itemList);
		}
		return getRegister().getItemList();
	}

	private RelationshipListType getRelationshipList() {
		RelationshipListType relationshipList = getRegister().getRelationshipList();
		if(relationshipList == null) {
			relationshipList = CmdbfFactory.eINSTANCE.createRelationshipListType();
			getRegister().setRelationshipList(relationshipList);
		}		
		return getRegister().getRelationshipList();
	}

} //ModelImpl
