/**
 */
package it.unibo.cmdb.cmdbf.client.model.cmdbf.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfFactory;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ContentSelectorType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.InstanceIdConstraintType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelTemplate;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.QueryType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordConstraintType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.SelectedRecordTypeType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Model Template</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelTemplateImpl#getContentSelector <em>Content Selector</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelTemplateImpl#getInstanceIdConstraint <em>Instance Id Constraint</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelTemplateImpl#getRecordConstraint <em>Record Constraint</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelTemplateImpl#getAny <em>Any</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelTemplateImpl#getId <em>Id</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelTemplateImpl#isSuppressFromResult <em>Suppress From Result</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelTemplateImpl#getQuery <em>Query</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ModelTemplateImpl extends MinimalEObjectImpl.Container implements ModelTemplate {
	/**
	 * The cached value of the '{@link #getContentSelector() <em>Content Selector</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContentSelector()
	 * @generated
	 * @ordered
	 */
	protected ContentSelectorType contentSelector;

	/**
	 * The cached value of the '{@link #getInstanceIdConstraint() <em>Instance Id Constraint</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstanceIdConstraint()
	 * @generated
	 * @ordered
	 */
	protected InstanceIdConstraintType instanceIdConstraint;

	/**
	 * The cached value of the '{@link #getRecordConstraint() <em>Record Constraint</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecordConstraint()
	 * @generated
	 * @ordered
	 */
	protected EList<RecordConstraintType> recordConstraint;

	/**
	 * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAny()
	 * @generated
	 * @ordered
	 */
	protected FeatureMap any;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #isSuppressFromResult() <em>Suppress From Result</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSuppressFromResult()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SUPPRESS_FROM_RESULT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isSuppressFromResult() <em>Suppress From Result</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSuppressFromResult()
	 * @generated
	 * @ordered
	 */
	protected boolean suppressFromResult = SUPPRESS_FROM_RESULT_EDEFAULT;

	/**
	 * This is true if the Suppress From Result attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean suppressFromResultESet;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelTemplateImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CmdbfPackage.Literals.MODEL_TEMPLATE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ContentSelectorType getContentSelector() {
		return contentSelector;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetContentSelector(ContentSelectorType newContentSelector, NotificationChain msgs) {
		ContentSelectorType oldContentSelector = contentSelector;
		contentSelector = newContentSelector;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CmdbfPackage.MODEL_TEMPLATE__CONTENT_SELECTOR, oldContentSelector, newContentSelector);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContentSelector(ContentSelectorType newContentSelector) {
		if (newContentSelector != contentSelector) {
			NotificationChain msgs = null;
			if (contentSelector != null)
				msgs = ((InternalEObject)contentSelector).eInverseRemove(this, CmdbfPackage.CONTENT_SELECTOR_TYPE__PARENT, ContentSelectorType.class, msgs);
			if (newContentSelector != null)
				msgs = ((InternalEObject)newContentSelector).eInverseAdd(this, CmdbfPackage.CONTENT_SELECTOR_TYPE__PARENT, ContentSelectorType.class, msgs);
			msgs = basicSetContentSelector(newContentSelector, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.MODEL_TEMPLATE__CONTENT_SELECTOR, newContentSelector, newContentSelector));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InstanceIdConstraintType getInstanceIdConstraint() {
		return instanceIdConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInstanceIdConstraint(InstanceIdConstraintType newInstanceIdConstraint, NotificationChain msgs) {
		InstanceIdConstraintType oldInstanceIdConstraint = instanceIdConstraint;
		instanceIdConstraint = newInstanceIdConstraint;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CmdbfPackage.MODEL_TEMPLATE__INSTANCE_ID_CONSTRAINT, oldInstanceIdConstraint, newInstanceIdConstraint);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInstanceIdConstraint(InstanceIdConstraintType newInstanceIdConstraint) {
		if (newInstanceIdConstraint != instanceIdConstraint) {
			NotificationChain msgs = null;
			if (instanceIdConstraint != null)
				msgs = ((InternalEObject)instanceIdConstraint).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CmdbfPackage.MODEL_TEMPLATE__INSTANCE_ID_CONSTRAINT, null, msgs);
			if (newInstanceIdConstraint != null)
				msgs = ((InternalEObject)newInstanceIdConstraint).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CmdbfPackage.MODEL_TEMPLATE__INSTANCE_ID_CONSTRAINT, null, msgs);
			msgs = basicSetInstanceIdConstraint(newInstanceIdConstraint, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.MODEL_TEMPLATE__INSTANCE_ID_CONSTRAINT, newInstanceIdConstraint, newInstanceIdConstraint));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<RecordConstraintType> getRecordConstraint() {
		if (recordConstraint == null) {
			recordConstraint = new EObjectContainmentWithInverseEList<RecordConstraintType>(RecordConstraintType.class, this, CmdbfPackage.MODEL_TEMPLATE__RECORD_CONSTRAINT, CmdbfPackage.RECORD_CONSTRAINT_TYPE__PARENT);
		}
		return recordConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FeatureMap getAny() {
		if (any == null) {
			any = new BasicFeatureMap(this, CmdbfPackage.MODEL_TEMPLATE__ANY);
		}
		return any;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.MODEL_TEMPLATE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSuppressFromResult() {
		return suppressFromResult;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSuppressFromResult(boolean newSuppressFromResult) {
		boolean oldSuppressFromResult = suppressFromResult;
		suppressFromResult = newSuppressFromResult;
		boolean oldSuppressFromResultESet = suppressFromResultESet;
		suppressFromResultESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.MODEL_TEMPLATE__SUPPRESS_FROM_RESULT, oldSuppressFromResult, suppressFromResult, !oldSuppressFromResultESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetSuppressFromResult() {
		boolean oldSuppressFromResult = suppressFromResult;
		boolean oldSuppressFromResultESet = suppressFromResultESet;
		suppressFromResult = SUPPRESS_FROM_RESULT_EDEFAULT;
		suppressFromResultESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, CmdbfPackage.MODEL_TEMPLATE__SUPPRESS_FROM_RESULT, oldSuppressFromResult, SUPPRESS_FROM_RESULT_EDEFAULT, oldSuppressFromResultESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetSuppressFromResult() {
		return suppressFromResultESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public QueryType getQuery() {
		InternalEObject container = eInternalContainer();
		while(container!=null && !(container instanceof QueryType))
			container = container.eInternalContainer();
		return (QueryType)container;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public MdrScopedIdType addInstanceIdConstraint(String localId) {
		return addInstanceIdConstraint(getQuery().getMdrId(), localId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public MdrScopedIdType addInstanceIdConstraint(String mdrId, String localId) {
		if(getInstanceIdConstraint() == null)
			setInstanceIdConstraint(CmdbfFactory.eINSTANCE.createInstanceIdConstraintType());
		MdrScopedIdType instanceId = CmdbfFactory.eINSTANCE.createMdrScopedIdType();
		instanceId.setMdrId(mdrId);
		instanceId.setLocalId(localId);
		getInstanceIdConstraint().getInstanceId().add(instanceId);
		return instanceId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RecordConstraintType addRecordConstraint() {
		RecordConstraintType recordConstraint = CmdbfFactory.eINSTANCE.createRecordConstraintType();
		getRecordConstraint().add(recordConstraint);
		return recordConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public SelectedRecordTypeType addContentSelector(String type) {
		String localName = getQuery().getLocalName(type);
		String namespace = getQuery().getNamespace(type);
		return addContentSelector(namespace, localName);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public SelectedRecordTypeType addContentSelector(String namespace, String localName) {
		if(getContentSelector() == null)
			setContentSelector(CmdbfFactory.eINSTANCE.createContentSelectorType());
		SelectedRecordTypeType selectedRecordType = CmdbfFactory.eINSTANCE.createSelectedRecordTypeType();
		selectedRecordType.setNamespace(namespace);
		selectedRecordType.setLocalName(localName);
		getContentSelector().getSelectedRecordType().add(selectedRecordType);
		return selectedRecordType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CmdbfPackage.MODEL_TEMPLATE__CONTENT_SELECTOR:
				if (contentSelector != null)
					msgs = ((InternalEObject)contentSelector).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CmdbfPackage.MODEL_TEMPLATE__CONTENT_SELECTOR, null, msgs);
				return basicSetContentSelector((ContentSelectorType)otherEnd, msgs);
			case CmdbfPackage.MODEL_TEMPLATE__RECORD_CONSTRAINT:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRecordConstraint()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CmdbfPackage.MODEL_TEMPLATE__CONTENT_SELECTOR:
				return basicSetContentSelector(null, msgs);
			case CmdbfPackage.MODEL_TEMPLATE__INSTANCE_ID_CONSTRAINT:
				return basicSetInstanceIdConstraint(null, msgs);
			case CmdbfPackage.MODEL_TEMPLATE__RECORD_CONSTRAINT:
				return ((InternalEList<?>)getRecordConstraint()).basicRemove(otherEnd, msgs);
			case CmdbfPackage.MODEL_TEMPLATE__ANY:
				return ((InternalEList<?>)getAny()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CmdbfPackage.MODEL_TEMPLATE__CONTENT_SELECTOR:
				return getContentSelector();
			case CmdbfPackage.MODEL_TEMPLATE__INSTANCE_ID_CONSTRAINT:
				return getInstanceIdConstraint();
			case CmdbfPackage.MODEL_TEMPLATE__RECORD_CONSTRAINT:
				return getRecordConstraint();
			case CmdbfPackage.MODEL_TEMPLATE__ANY:
				if (coreType) return getAny();
				return ((FeatureMap.Internal)getAny()).getWrapper();
			case CmdbfPackage.MODEL_TEMPLATE__ID:
				return getId();
			case CmdbfPackage.MODEL_TEMPLATE__SUPPRESS_FROM_RESULT:
				return isSuppressFromResult();
			case CmdbfPackage.MODEL_TEMPLATE__QUERY:
				return getQuery();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CmdbfPackage.MODEL_TEMPLATE__CONTENT_SELECTOR:
				setContentSelector((ContentSelectorType)newValue);
				return;
			case CmdbfPackage.MODEL_TEMPLATE__INSTANCE_ID_CONSTRAINT:
				setInstanceIdConstraint((InstanceIdConstraintType)newValue);
				return;
			case CmdbfPackage.MODEL_TEMPLATE__RECORD_CONSTRAINT:
				getRecordConstraint().clear();
				getRecordConstraint().addAll((Collection<? extends RecordConstraintType>)newValue);
				return;
			case CmdbfPackage.MODEL_TEMPLATE__ANY:
				((FeatureMap.Internal)getAny()).set(newValue);
				return;
			case CmdbfPackage.MODEL_TEMPLATE__ID:
				setId((String)newValue);
				return;
			case CmdbfPackage.MODEL_TEMPLATE__SUPPRESS_FROM_RESULT:
				setSuppressFromResult((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CmdbfPackage.MODEL_TEMPLATE__CONTENT_SELECTOR:
				setContentSelector((ContentSelectorType)null);
				return;
			case CmdbfPackage.MODEL_TEMPLATE__INSTANCE_ID_CONSTRAINT:
				setInstanceIdConstraint((InstanceIdConstraintType)null);
				return;
			case CmdbfPackage.MODEL_TEMPLATE__RECORD_CONSTRAINT:
				getRecordConstraint().clear();
				return;
			case CmdbfPackage.MODEL_TEMPLATE__ANY:
				getAny().clear();
				return;
			case CmdbfPackage.MODEL_TEMPLATE__ID:
				setId(ID_EDEFAULT);
				return;
			case CmdbfPackage.MODEL_TEMPLATE__SUPPRESS_FROM_RESULT:
				unsetSuppressFromResult();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CmdbfPackage.MODEL_TEMPLATE__CONTENT_SELECTOR:
				return contentSelector != null;
			case CmdbfPackage.MODEL_TEMPLATE__INSTANCE_ID_CONSTRAINT:
				return instanceIdConstraint != null;
			case CmdbfPackage.MODEL_TEMPLATE__RECORD_CONSTRAINT:
				return recordConstraint != null && !recordConstraint.isEmpty();
			case CmdbfPackage.MODEL_TEMPLATE__ANY:
				return any != null && !any.isEmpty();
			case CmdbfPackage.MODEL_TEMPLATE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case CmdbfPackage.MODEL_TEMPLATE__SUPPRESS_FROM_RESULT:
				return isSetSuppressFromResult();
			case CmdbfPackage.MODEL_TEMPLATE__QUERY:
				return getQuery() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case CmdbfPackage.MODEL_TEMPLATE___ADD_INSTANCE_ID_CONSTRAINT__STRING:
				return addInstanceIdConstraint((String)arguments.get(0));
			case CmdbfPackage.MODEL_TEMPLATE___ADD_INSTANCE_ID_CONSTRAINT__STRING_STRING:
				return addInstanceIdConstraint((String)arguments.get(0), (String)arguments.get(1));
			case CmdbfPackage.MODEL_TEMPLATE___ADD_RECORD_CONSTRAINT:
				return addRecordConstraint();
			case CmdbfPackage.MODEL_TEMPLATE___ADD_CONTENT_SELECTOR__STRING:
				return addContentSelector((String)arguments.get(0));
			case CmdbfPackage.MODEL_TEMPLATE___ADD_CONTENT_SELECTOR__STRING_STRING:
				return addContentSelector((String)arguments.get(0), (String)arguments.get(1));
		}
		return super.eInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (any: ");
		result.append(any);
		result.append(", id: ");
		result.append(id);
		result.append(", suppressFromResult: ");
		if (suppressFromResultESet) result.append(suppressFromResult); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //ModelTemplateImpl
