/**
 */
package it.unibo.cmdb.cmdbf.client.model.cmdbf.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage
 * @generated
 */
public class CmdbfAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static CmdbfPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CmdbfAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = CmdbfPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CmdbfSwitch<Adapter> modelSwitch =
		new CmdbfSwitch<Adapter>() {
			@Override
			public Adapter caseAcceptedType(AcceptedType object) {
				return createAcceptedTypeAdapter();
			}
			@Override
			public Adapter caseComparisonOperatorType(ComparisonOperatorType object) {
				return createComparisonOperatorTypeAdapter();
			}
			@Override
			public Adapter caseConstraintType(ConstraintType object) {
				return createConstraintTypeAdapter();
			}
			@Override
			public Adapter caseContentSelectorType(ContentSelectorType object) {
				return createContentSelectorTypeAdapter();
			}
			@Override
			public Adapter caseDeclinedType(DeclinedType object) {
				return createDeclinedTypeAdapter();
			}
			@Override
			public Adapter caseDepthLimitType(DepthLimitType object) {
				return createDepthLimitTypeAdapter();
			}
			@Override
			public Adapter caseDeregisterInstanceResponseType(DeregisterInstanceResponseType object) {
				return createDeregisterInstanceResponseTypeAdapter();
			}
			@Override
			public Adapter caseDeregisterRequestType(DeregisterRequestType object) {
				return createDeregisterRequestTypeAdapter();
			}
			@Override
			public Adapter caseDeregisterResponseType(DeregisterResponseType object) {
				return createDeregisterResponseTypeAdapter();
			}
			@Override
			public Adapter caseDeregistrationErrorFaultType(DeregistrationErrorFaultType object) {
				return createDeregistrationErrorFaultTypeAdapter();
			}
			@Override
			public Adapter caseDocumentRoot(DocumentRoot object) {
				return createDocumentRootAdapter();
			}
			@Override
			public Adapter caseEdgesType(EdgesType object) {
				return createEdgesTypeAdapter();
			}
			@Override
			public Adapter caseEqualOperatorType(EqualOperatorType object) {
				return createEqualOperatorTypeAdapter();
			}
			@Override
			public Adapter caseExpensiveQueryErrorFaultType(ExpensiveQueryErrorFaultType object) {
				return createExpensiveQueryErrorFaultTypeAdapter();
			}
			@Override
			public Adapter caseInstanceIdConstraintType(InstanceIdConstraintType object) {
				return createInstanceIdConstraintTypeAdapter();
			}
			@Override
			public Adapter caseInvalidMDRFaultType(InvalidMDRFaultType object) {
				return createInvalidMDRFaultTypeAdapter();
			}
			@Override
			public Adapter caseInvalidPropertyTypeFaultType(InvalidPropertyTypeFaultType object) {
				return createInvalidPropertyTypeFaultTypeAdapter();
			}
			@Override
			public Adapter caseInvalidRecordFaultType(InvalidRecordFaultType object) {
				return createInvalidRecordFaultTypeAdapter();
			}
			@Override
			public Adapter caseItemListType(ItemListType object) {
				return createItemListTypeAdapter();
			}
			@Override
			public Adapter caseItemTemplateType(ItemTemplateType object) {
				return createItemTemplateTypeAdapter();
			}
			@Override
			public Adapter caseItemType(ItemType object) {
				return createItemTypeAdapter();
			}
			@Override
			public Adapter caseMdrScopedIdListType(MdrScopedIdListType object) {
				return createMdrScopedIdListTypeAdapter();
			}
			@Override
			public Adapter caseMdrScopedIdType(MdrScopedIdType object) {
				return createMdrScopedIdTypeAdapter();
			}
			@Override
			public Adapter caseNodesType(NodesType object) {
				return createNodesTypeAdapter();
			}
			@Override
			public Adapter caseNullOperatorType(NullOperatorType object) {
				return createNullOperatorTypeAdapter();
			}
			@Override
			public Adapter casePrefixMappingType(PrefixMappingType object) {
				return createPrefixMappingTypeAdapter();
			}
			@Override
			public Adapter casePropertyNameType(PropertyNameType object) {
				return createPropertyNameTypeAdapter();
			}
			@Override
			public Adapter casePropertySetType(PropertySetType object) {
				return createPropertySetTypeAdapter();
			}
			@Override
			public Adapter casePropertyValueType(PropertyValueType object) {
				return createPropertyValueTypeAdapter();
			}
			@Override
			public Adapter caseQNameType(QNameType object) {
				return createQNameTypeAdapter();
			}
			@Override
			public Adapter caseQueryErrorFaultType(QueryErrorFaultType object) {
				return createQueryErrorFaultTypeAdapter();
			}
			@Override
			public Adapter caseQueryResultType(QueryResultType object) {
				return createQueryResultTypeAdapter();
			}
			@Override
			public Adapter caseQueryType(QueryType object) {
				return createQueryTypeAdapter();
			}
			@Override
			public Adapter caseRecordConstraintType(RecordConstraintType object) {
				return createRecordConstraintTypeAdapter();
			}
			@Override
			public Adapter caseRecordMetadataType(RecordMetadataType object) {
				return createRecordMetadataTypeAdapter();
			}
			@Override
			public Adapter caseRecordType(RecordType object) {
				return createRecordTypeAdapter();
			}
			@Override
			public Adapter caseRecordTypeType(RecordTypeType object) {
				return createRecordTypeTypeAdapter();
			}
			@Override
			public Adapter caseRegisterInstanceResponseType(RegisterInstanceResponseType object) {
				return createRegisterInstanceResponseTypeAdapter();
			}
			@Override
			public Adapter caseRegisterRequestType(RegisterRequestType object) {
				return createRegisterRequestTypeAdapter();
			}
			@Override
			public Adapter caseRegisterResponseType(RegisterResponseType object) {
				return createRegisterResponseTypeAdapter();
			}
			@Override
			public Adapter caseRegistrationErrorFaultType(RegistrationErrorFaultType object) {
				return createRegistrationErrorFaultTypeAdapter();
			}
			@Override
			public Adapter caseRelationshipListType(RelationshipListType object) {
				return createRelationshipListTypeAdapter();
			}
			@Override
			public Adapter caseRelationshipRefType(RelationshipRefType object) {
				return createRelationshipRefTypeAdapter();
			}
			@Override
			public Adapter caseRelationshipTemplateType(RelationshipTemplateType object) {
				return createRelationshipTemplateTypeAdapter();
			}
			@Override
			public Adapter caseRelationshipType(RelationshipType object) {
				return createRelationshipTypeAdapter();
			}
			@Override
			public Adapter caseSelectedRecordTypeType(SelectedRecordTypeType object) {
				return createSelectedRecordTypeTypeAdapter();
			}
			@Override
			public Adapter caseSelectorType(SelectorType object) {
				return createSelectorTypeAdapter();
			}
			@Override
			public Adapter caseStringOperatorType(StringOperatorType object) {
				return createStringOperatorTypeAdapter();
			}
			@Override
			public Adapter caseUnknownTemplateIDFaultType(UnknownTemplateIDFaultType object) {
				return createUnknownTemplateIDFaultTypeAdapter();
			}
			@Override
			public Adapter caseUnsupportedConstraintFaultType(UnsupportedConstraintFaultType object) {
				return createUnsupportedConstraintFaultTypeAdapter();
			}
			@Override
			public Adapter caseUnsupportedRecordTypeFaultType(UnsupportedRecordTypeFaultType object) {
				return createUnsupportedRecordTypeFaultTypeAdapter();
			}
			@Override
			public Adapter caseUnsupportedSelectorFaultType(UnsupportedSelectorFaultType object) {
				return createUnsupportedSelectorFaultTypeAdapter();
			}
			@Override
			public Adapter caseXPathErrorFaultType(XPathErrorFaultType object) {
				return createXPathErrorFaultTypeAdapter();
			}
			@Override
			public Adapter caseXPathExpressionType(XPathExpressionType object) {
				return createXPathExpressionTypeAdapter();
			}
			@Override
			public Adapter caseModelElement(ModelElement object) {
				return createModelElementAdapter();
			}
			@Override
			public Adapter caseModelTemplate(ModelTemplate object) {
				return createModelTemplateAdapter();
			}
			@Override
			public Adapter caseModelUpdateInstanceResponse(ModelUpdateInstanceResponse object) {
				return createModelUpdateInstanceResponseAdapter();
			}
			@Override
			public Adapter caseModelUpdateResponse(ModelUpdateResponse object) {
				return createModelUpdateResponseAdapter();
			}
			@Override
			public Adapter caseModelRecordType(ModelRecordType object) {
				return createModelRecordTypeAdapter();
			}
			@Override
			public Adapter caseModel(Model object) {
				return createModelAdapter();
			}
			@Override
			public Adapter caseModelMetadata(ModelMetadata object) {
				return createModelMetadataAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.AcceptedType <em>Accepted Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.AcceptedType
	 * @generated
	 */
	public Adapter createAcceptedTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ComparisonOperatorType <em>Comparison Operator Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ComparisonOperatorType
	 * @generated
	 */
	public Adapter createComparisonOperatorTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ConstraintType <em>Constraint Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ConstraintType
	 * @generated
	 */
	public Adapter createConstraintTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ContentSelectorType <em>Content Selector Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ContentSelectorType
	 * @generated
	 */
	public Adapter createContentSelectorTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.DeclinedType <em>Declined Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.DeclinedType
	 * @generated
	 */
	public Adapter createDeclinedTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.DepthLimitType <em>Depth Limit Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.DepthLimitType
	 * @generated
	 */
	public Adapter createDepthLimitTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.DeregisterInstanceResponseType <em>Deregister Instance Response Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.DeregisterInstanceResponseType
	 * @generated
	 */
	public Adapter createDeregisterInstanceResponseTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.DeregisterRequestType <em>Deregister Request Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.DeregisterRequestType
	 * @generated
	 */
	public Adapter createDeregisterRequestTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.DeregisterResponseType <em>Deregister Response Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.DeregisterResponseType
	 * @generated
	 */
	public Adapter createDeregisterResponseTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.DeregistrationErrorFaultType <em>Deregistration Error Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.DeregistrationErrorFaultType
	 * @generated
	 */
	public Adapter createDeregistrationErrorFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.DocumentRoot <em>Document Root</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.DocumentRoot
	 * @generated
	 */
	public Adapter createDocumentRootAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.EdgesType <em>Edges Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.EdgesType
	 * @generated
	 */
	public Adapter createEdgesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.EqualOperatorType <em>Equal Operator Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.EqualOperatorType
	 * @generated
	 */
	public Adapter createEqualOperatorTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ExpensiveQueryErrorFaultType <em>Expensive Query Error Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ExpensiveQueryErrorFaultType
	 * @generated
	 */
	public Adapter createExpensiveQueryErrorFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.InstanceIdConstraintType <em>Instance Id Constraint Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.InstanceIdConstraintType
	 * @generated
	 */
	public Adapter createInstanceIdConstraintTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.InvalidMDRFaultType <em>Invalid MDR Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.InvalidMDRFaultType
	 * @generated
	 */
	public Adapter createInvalidMDRFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.InvalidPropertyTypeFaultType <em>Invalid Property Type Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.InvalidPropertyTypeFaultType
	 * @generated
	 */
	public Adapter createInvalidPropertyTypeFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.InvalidRecordFaultType <em>Invalid Record Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.InvalidRecordFaultType
	 * @generated
	 */
	public Adapter createInvalidRecordFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemListType <em>Item List Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemListType
	 * @generated
	 */
	public Adapter createItemListTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemTemplateType <em>Item Template Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemTemplateType
	 * @generated
	 */
	public Adapter createItemTemplateTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemType <em>Item Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemType
	 * @generated
	 */
	public Adapter createItemTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdListType <em>Mdr Scoped Id List Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdListType
	 * @generated
	 */
	public Adapter createMdrScopedIdListTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdType <em>Mdr Scoped Id Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdType
	 * @generated
	 */
	public Adapter createMdrScopedIdTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.NodesType <em>Nodes Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.NodesType
	 * @generated
	 */
	public Adapter createNodesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.NullOperatorType <em>Null Operator Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.NullOperatorType
	 * @generated
	 */
	public Adapter createNullOperatorTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.PrefixMappingType <em>Prefix Mapping Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.PrefixMappingType
	 * @generated
	 */
	public Adapter createPrefixMappingTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.PropertyNameType <em>Property Name Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.PropertyNameType
	 * @generated
	 */
	public Adapter createPropertyNameTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.PropertySetType <em>Property Set Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.PropertySetType
	 * @generated
	 */
	public Adapter createPropertySetTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.PropertyValueType <em>Property Value Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.PropertyValueType
	 * @generated
	 */
	public Adapter createPropertyValueTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.QNameType <em>QName Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.QNameType
	 * @generated
	 */
	public Adapter createQNameTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.QueryErrorFaultType <em>Query Error Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.QueryErrorFaultType
	 * @generated
	 */
	public Adapter createQueryErrorFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.QueryResultType <em>Query Result Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.QueryResultType
	 * @generated
	 */
	public Adapter createQueryResultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.QueryType <em>Query Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.QueryType
	 * @generated
	 */
	public Adapter createQueryTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordConstraintType <em>Record Constraint Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordConstraintType
	 * @generated
	 */
	public Adapter createRecordConstraintTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordMetadataType <em>Record Metadata Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordMetadataType
	 * @generated
	 */
	public Adapter createRecordMetadataTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordType <em>Record Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordType
	 * @generated
	 */
	public Adapter createRecordTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordTypeType <em>Record Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordTypeType
	 * @generated
	 */
	public Adapter createRecordTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RegisterInstanceResponseType <em>Register Instance Response Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RegisterInstanceResponseType
	 * @generated
	 */
	public Adapter createRegisterInstanceResponseTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RegisterRequestType <em>Register Request Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RegisterRequestType
	 * @generated
	 */
	public Adapter createRegisterRequestTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RegisterResponseType <em>Register Response Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RegisterResponseType
	 * @generated
	 */
	public Adapter createRegisterResponseTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RegistrationErrorFaultType <em>Registration Error Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RegistrationErrorFaultType
	 * @generated
	 */
	public Adapter createRegistrationErrorFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipListType <em>Relationship List Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipListType
	 * @generated
	 */
	public Adapter createRelationshipListTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipRefType <em>Relationship Ref Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipRefType
	 * @generated
	 */
	public Adapter createRelationshipRefTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipTemplateType <em>Relationship Template Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipTemplateType
	 * @generated
	 */
	public Adapter createRelationshipTemplateTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipType <em>Relationship Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipType
	 * @generated
	 */
	public Adapter createRelationshipTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.SelectedRecordTypeType <em>Selected Record Type Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.SelectedRecordTypeType
	 * @generated
	 */
	public Adapter createSelectedRecordTypeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.SelectorType <em>Selector Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.SelectorType
	 * @generated
	 */
	public Adapter createSelectorTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.StringOperatorType <em>String Operator Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.StringOperatorType
	 * @generated
	 */
	public Adapter createStringOperatorTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.UnknownTemplateIDFaultType <em>Unknown Template ID Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.UnknownTemplateIDFaultType
	 * @generated
	 */
	public Adapter createUnknownTemplateIDFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.UnsupportedConstraintFaultType <em>Unsupported Constraint Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.UnsupportedConstraintFaultType
	 * @generated
	 */
	public Adapter createUnsupportedConstraintFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.UnsupportedRecordTypeFaultType <em>Unsupported Record Type Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.UnsupportedRecordTypeFaultType
	 * @generated
	 */
	public Adapter createUnsupportedRecordTypeFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.UnsupportedSelectorFaultType <em>Unsupported Selector Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.UnsupportedSelectorFaultType
	 * @generated
	 */
	public Adapter createUnsupportedSelectorFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.XPathErrorFaultType <em>XPath Error Fault Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.XPathErrorFaultType
	 * @generated
	 */
	public Adapter createXPathErrorFaultTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.XPathExpressionType <em>XPath Expression Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.XPathExpressionType
	 * @generated
	 */
	public Adapter createXPathExpressionTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelElement <em>Model Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelElement
	 * @generated
	 */
	public Adapter createModelElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelTemplate <em>Model Template</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelTemplate
	 * @generated
	 */
	public Adapter createModelTemplateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelUpdateInstanceResponse <em>Model Update Instance Response</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelUpdateInstanceResponse
	 * @generated
	 */
	public Adapter createModelUpdateInstanceResponseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelUpdateResponse <em>Model Update Response</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelUpdateResponse
	 * @generated
	 */
	public Adapter createModelUpdateResponseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelRecordType <em>Model Record Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelRecordType
	 * @generated
	 */
	public Adapter createModelRecordTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.Model <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.Model
	 * @generated
	 */
	public Adapter createModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelMetadata <em>Model Metadata</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelMetadata
	 * @generated
	 */
	public Adapter createModelMetadataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //CmdbfAdapterFactory
