package it.unibo.cmdb.cmdbf.client.model.cmdbf.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfFactory;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.DocumentRoot;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.EdgesType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.Model;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelElement;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelMetadata;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.NodesType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.QueryResultType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RegisterRequestType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipType;

public class CmdbfResourceHandler implements XMLResource.ResourceHandler {
	private ModelMetadata modelMetadata;
	private EStructuralFeature sourceFeature;
	private EStructuralFeature targetFeature;
	
	
	public CmdbfResourceHandler(ExtendedMetaData extendedMetaData, ModelMetadata modelMetadata) {
		this.modelMetadata = modelMetadata;
		
		sourceFeature = extendedMetaData.demandFeature(CmdbfPackage.eINSTANCE.getNsURI(), "source", true);
		sourceFeature.setEType(CmdbfPackage.eINSTANCE.getMdrScopedIdType());
		
		targetFeature = extendedMetaData.demandFeature(CmdbfPackage.eINSTANCE.getNsURI(), "target", true);
		targetFeature.setEType(CmdbfPackage.eINSTANCE.getMdrScopedIdType());
	}

	@Override
	public void preLoad(XMLResource resource, InputStream inputStream, Map<?, ?> options) {}

	@Override
	public void postLoad(XMLResource resource, InputStream inputStream,	Map<?, ?> options) {
		Model model = null;
		if(!resource.getContents().isEmpty()) {
			EObject content = resource.getContents().get(0);
			if(content instanceof DocumentRoot) {
				DocumentRoot documentRoot = (DocumentRoot)content;
				model = documentRoot.getModel();
				if(model != null)
					model.setModelMetadata(modelMetadata);
				else {				
					QueryResultType result = documentRoot.getQueryResult();
					if(result != null) {
						model = CmdbfFactory.eINSTANCE.createModel();
						model.setModelMetadata(modelMetadata);
						for(NodesType nodesType : result.getNodes()) {
							Iterator<ItemType> iterator = nodesType.getItem().iterator();
			        		while(iterator.hasNext()) {
			        			ItemType item = iterator.next();			        			
			        			item.getTemplateId().add(nodesType.getTemplateId());
			        			for(RecordType record : item.getRecord())
			        				record.getTemplateId().add(nodesType.getTemplateId());
			        			ModelElement modelElement = model.findItem(item);
			        			if(modelElement != null) {
			        				modelElement.merge(item);
			        				iterator.remove();
			        			}
			        			else {
			        				iterator.remove();				        			
			        				model.getItem().add(item);
			        			}
			        		}
			        	}
			        	for(EdgesType edgesType : result.getEdges()) {
			        		Iterator<RelationshipType> iterator = edgesType.getRelationship().iterator();
			        		while(iterator.hasNext()) {
			        			RelationshipType relationship = iterator.next();
			        			relationship.getTemplateId().add(edgesType.getTemplateId());
			        			for(RecordType record : relationship.getRecord())
			        				record.getTemplateId().add(edgesType.getTemplateId());
			        			ModelElement modelElement = model.findRelationship(relationship);
			        			if(modelElement != null) {
			        				modelElement.merge(relationship);
			        				iterator.remove();
			        			}
			        			else {
			        				iterator.remove();
			        				model.getRelationship().add(relationship);
			        			}
			        		}
			        	}
			        	documentRoot.getMixed().clear();
			        	documentRoot.setModel(model);
					}
				}
			}
		}
		
		final Map<EObject, AnyType> extensionMap = resource.getEObjectToExtensionMap();	 	
		if(model != null) {
		 	for(Map.Entry<EObject, AnyType> extension : extensionMap.entrySet()) {
				EObject owner = extension.getKey();
				AnyType anyType = extension.getValue();
				if(owner.eContainer() != null) {			
					if(owner instanceof RelationshipType) {
						RelationshipType relationship = (RelationshipType)owner;
						for(FeatureMap.Entry entry : anyType.getMixed()) {
							EStructuralFeature feature = entry.getEStructuralFeature();
							if(feature == sourceFeature){
								MdrScopedIdType instanceId = (MdrScopedIdType)entry.getValue();
								ModelElement element = model.findItem(instanceId);
								if(element == null) {
									ItemType item = model.addItem();
									item.getInstanceId().add(EcoreUtil.copy(instanceId));
									element = item;
								}
								if(element instanceof ItemType)
									relationship.setSourceItem((ItemType)element);				
							}
							else if(feature == targetFeature){
								MdrScopedIdType instanceId = (MdrScopedIdType)entry.getValue();
								ModelElement element = model.findItem(instanceId);
								if(element == null) {
									ItemType item = model.addItem();
									item.getInstanceId().add(EcoreUtil.copy(instanceId));
									element = item;
								}
								if(element instanceof ItemType)
									relationship.setTargetItem((ItemType)element);
								
							}
						}		
					}
				}
			}
		}
	 	extensionMap.clear();
	}

	@Override
	public void preSave(XMLResource resource, OutputStream outputStream, Map<?, ?> options) {
		RegisterRequestType register = null;
		final Map<EObject, AnyType> extensionMap = resource.getEObjectToExtensionMap();
	 	if(!resource.getContents().isEmpty()) {
	 		EObject content = resource.getContents().get(0);
			if(content instanceof DocumentRoot) {
				DocumentRoot documentRoot = (DocumentRoot)content;
				Model model = documentRoot.getModel();
				if(model != null)
					register = model.getRegister();
				else
					register = documentRoot.getRegisterRequest();				
			}
		}
	 	
	 	if(register != null) {
	 		if(register.getRelationshipList()!=null) {
				for(RelationshipType relationship : register.getRelationshipList().getRelationship()) {
					AnyType anyType = XMLTypeFactory.eINSTANCE.createAnyType();					
					if(relationship.getSourceItem() != null)
						anyType.getMixed().add(sourceFeature, EcoreUtil.copy(relationship.getSourceItem().findInstanceId()));
					if(relationship.getTargetItem() != null)
						anyType.getMixed().add(targetFeature, EcoreUtil.copy(relationship.getTargetItem().findInstanceId()));					
	    			extensionMap.put(relationship, anyType);		        			
	        	}
			}
	 	}
	}

	@Override
	public void postSave(XMLResource resource, OutputStream outputStream, Map<?, ?> options) {}
}
