/**
 */
package it.unibo.cmdb.monitoring.model.icinga.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import it.unibo.cmdb.monitoring.model.icinga.Checkable;
import it.unibo.cmdb.monitoring.model.icinga.IcingaPackage;
import it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime;
import it.unibo.cmdb.monitoring.model.icinga.TimeRange;
import it.unibo.cmdb.monitoring.model.icinga.Zone;
import it.unibo.cmdb.monitoring.model.icinga.ZoneElement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Scheduled Downtime</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ScheduledDowntimeImpl#getZone <em>Zone</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ScheduledDowntimeImpl#getCheckable <em>Checkable</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ScheduledDowntimeImpl#getAuthor <em>Author</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ScheduledDowntimeImpl#getComment <em>Comment</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ScheduledDowntimeImpl#isFixed <em>Fixed</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ScheduledDowntimeImpl#getDuration <em>Duration</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ScheduledDowntimeImpl#getRanges <em>Ranges</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ScheduledDowntimeImpl extends ConfigurationObjectImpl implements ScheduledDowntime {
	/**
	 * The cached value of the '{@link #getZone() <em>Zone</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getZone()
	 * @generated
	 * @ordered
	 */
	protected Zone zone;

	/**
	 * The cached value of the '{@link #getCheckable() <em>Checkable</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCheckable()
	 * @generated
	 * @ordered
	 */
	protected Checkable checkable;

	/**
	 * The default value of the '{@link #getAuthor() <em>Author</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAuthor()
	 * @generated
	 * @ordered
	 */
	protected static final String AUTHOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAuthor() <em>Author</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAuthor()
	 * @generated
	 * @ordered
	 */
	protected String author = AUTHOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
	protected static final String COMMENT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
	protected String comment = COMMENT_EDEFAULT;

	/**
	 * The default value of the '{@link #isFixed() <em>Fixed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFixed()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FIXED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isFixed() <em>Fixed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFixed()
	 * @generated
	 * @ordered
	 */
	protected boolean fixed = FIXED_EDEFAULT;

	/**
	 * The default value of the '{@link #getDuration() <em>Duration</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDuration()
	 * @generated
	 * @ordered
	 */
	protected static final String DURATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDuration() <em>Duration</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDuration()
	 * @generated
	 * @ordered
	 */
	protected String duration = DURATION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getRanges() <em>Ranges</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRanges()
	 * @generated
	 * @ordered
	 */
	protected EList<TimeRange> ranges;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ScheduledDowntimeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IcingaPackage.Literals.SCHEDULED_DOWNTIME;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Zone getZone() {
		if (zone != null && zone.eIsProxy()) {
			InternalEObject oldZone = (InternalEObject)zone;
			zone = (Zone)eResolveProxy(oldZone);
			if (zone != oldZone) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IcingaPackage.SCHEDULED_DOWNTIME__ZONE, oldZone, zone));
			}
		}
		return zone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Zone basicGetZone() {
		return zone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetZone(Zone newZone, NotificationChain msgs) {
		Zone oldZone = zone;
		zone = newZone;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IcingaPackage.SCHEDULED_DOWNTIME__ZONE, oldZone, newZone);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setZone(Zone newZone) {
		if (newZone != zone) {
			NotificationChain msgs = null;
			if (zone != null)
				msgs = ((InternalEObject)zone).eInverseRemove(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
			if (newZone != null)
				msgs = ((InternalEObject)newZone).eInverseAdd(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
			msgs = basicSetZone(newZone, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.SCHEDULED_DOWNTIME__ZONE, newZone, newZone));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Checkable getCheckable() {
		if (checkable != null && checkable.eIsProxy()) {
			InternalEObject oldCheckable = (InternalEObject)checkable;
			checkable = (Checkable)eResolveProxy(oldCheckable);
			if (checkable != oldCheckable) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IcingaPackage.SCHEDULED_DOWNTIME__CHECKABLE, oldCheckable, checkable));
			}
		}
		return checkable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Checkable basicGetCheckable() {
		return checkable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCheckable(Checkable newCheckable, NotificationChain msgs) {
		Checkable oldCheckable = checkable;
		checkable = newCheckable;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IcingaPackage.SCHEDULED_DOWNTIME__CHECKABLE, oldCheckable, newCheckable);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCheckable(Checkable newCheckable) {
		if (newCheckable != checkable) {
			NotificationChain msgs = null;
			if (checkable != null)
				msgs = ((InternalEObject)checkable).eInverseRemove(this, IcingaPackage.CHECKABLE__SCHEDULED_DOWNTIMES, Checkable.class, msgs);
			if (newCheckable != null)
				msgs = ((InternalEObject)newCheckable).eInverseAdd(this, IcingaPackage.CHECKABLE__SCHEDULED_DOWNTIMES, Checkable.class, msgs);
			msgs = basicSetCheckable(newCheckable, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.SCHEDULED_DOWNTIME__CHECKABLE, newCheckable, newCheckable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAuthor() {
		return author;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAuthor(String newAuthor) {
		String oldAuthor = author;
		author = newAuthor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.SCHEDULED_DOWNTIME__AUTHOR, oldAuthor, author));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getComment() {
		return comment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setComment(String newComment) {
		String oldComment = comment;
		comment = newComment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.SCHEDULED_DOWNTIME__COMMENT, oldComment, comment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFixed() {
		return fixed;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFixed(boolean newFixed) {
		boolean oldFixed = fixed;
		fixed = newFixed;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.SCHEDULED_DOWNTIME__FIXED, oldFixed, fixed));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDuration() {
		return duration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDuration(String newDuration) {
		String oldDuration = duration;
		duration = newDuration;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.SCHEDULED_DOWNTIME__DURATION, oldDuration, duration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TimeRange> getRanges() {
		if (ranges == null) {
			ranges = new EObjectResolvingEList<TimeRange>(TimeRange.class, this, IcingaPackage.SCHEDULED_DOWNTIME__RANGES);
		}
		return ranges;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IcingaPackage.SCHEDULED_DOWNTIME__ZONE:
				if (zone != null)
					msgs = ((InternalEObject)zone).eInverseRemove(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
				return basicSetZone((Zone)otherEnd, msgs);
			case IcingaPackage.SCHEDULED_DOWNTIME__CHECKABLE:
				if (checkable != null)
					msgs = ((InternalEObject)checkable).eInverseRemove(this, IcingaPackage.CHECKABLE__SCHEDULED_DOWNTIMES, Checkable.class, msgs);
				return basicSetCheckable((Checkable)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IcingaPackage.SCHEDULED_DOWNTIME__ZONE:
				return basicSetZone(null, msgs);
			case IcingaPackage.SCHEDULED_DOWNTIME__CHECKABLE:
				return basicSetCheckable(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IcingaPackage.SCHEDULED_DOWNTIME__ZONE:
				if (resolve) return getZone();
				return basicGetZone();
			case IcingaPackage.SCHEDULED_DOWNTIME__CHECKABLE:
				if (resolve) return getCheckable();
				return basicGetCheckable();
			case IcingaPackage.SCHEDULED_DOWNTIME__AUTHOR:
				return getAuthor();
			case IcingaPackage.SCHEDULED_DOWNTIME__COMMENT:
				return getComment();
			case IcingaPackage.SCHEDULED_DOWNTIME__FIXED:
				return isFixed();
			case IcingaPackage.SCHEDULED_DOWNTIME__DURATION:
				return getDuration();
			case IcingaPackage.SCHEDULED_DOWNTIME__RANGES:
				return getRanges();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IcingaPackage.SCHEDULED_DOWNTIME__ZONE:
				setZone((Zone)newValue);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__CHECKABLE:
				setCheckable((Checkable)newValue);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__AUTHOR:
				setAuthor((String)newValue);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__COMMENT:
				setComment((String)newValue);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__FIXED:
				setFixed((Boolean)newValue);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__DURATION:
				setDuration((String)newValue);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__RANGES:
				getRanges().clear();
				getRanges().addAll((Collection<? extends TimeRange>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IcingaPackage.SCHEDULED_DOWNTIME__ZONE:
				setZone((Zone)null);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__CHECKABLE:
				setCheckable((Checkable)null);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__AUTHOR:
				setAuthor(AUTHOR_EDEFAULT);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__COMMENT:
				setComment(COMMENT_EDEFAULT);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__FIXED:
				setFixed(FIXED_EDEFAULT);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__DURATION:
				setDuration(DURATION_EDEFAULT);
				return;
			case IcingaPackage.SCHEDULED_DOWNTIME__RANGES:
				getRanges().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IcingaPackage.SCHEDULED_DOWNTIME__ZONE:
				return zone != null;
			case IcingaPackage.SCHEDULED_DOWNTIME__CHECKABLE:
				return checkable != null;
			case IcingaPackage.SCHEDULED_DOWNTIME__AUTHOR:
				return AUTHOR_EDEFAULT == null ? author != null : !AUTHOR_EDEFAULT.equals(author);
			case IcingaPackage.SCHEDULED_DOWNTIME__COMMENT:
				return COMMENT_EDEFAULT == null ? comment != null : !COMMENT_EDEFAULT.equals(comment);
			case IcingaPackage.SCHEDULED_DOWNTIME__FIXED:
				return fixed != FIXED_EDEFAULT;
			case IcingaPackage.SCHEDULED_DOWNTIME__DURATION:
				return DURATION_EDEFAULT == null ? duration != null : !DURATION_EDEFAULT.equals(duration);
			case IcingaPackage.SCHEDULED_DOWNTIME__RANGES:
				return ranges != null && !ranges.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == ZoneElement.class) {
			switch (derivedFeatureID) {
				case IcingaPackage.SCHEDULED_DOWNTIME__ZONE: return IcingaPackage.ZONE_ELEMENT__ZONE;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == ZoneElement.class) {
			switch (baseFeatureID) {
				case IcingaPackage.ZONE_ELEMENT__ZONE: return IcingaPackage.SCHEDULED_DOWNTIME__ZONE;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (author: ");
		result.append(author);
		result.append(", comment: ");
		result.append(comment);
		result.append(", fixed: ");
		result.append(fixed);
		result.append(", duration: ");
		result.append(duration);
		result.append(')');
		return result.toString();
	}

} //ScheduledDowntimeImpl
