package tests;

import static org.junit.Assert.*;

import org.apache.chemistry.opencmis.client.api.Document;
import org.junit.Before;
import org.junit.Test;
import static org.mockito.Mockito.*;

import java.util.Arrays;

public class Units {
	
	@Before
	public void setUp() {
		 
	}
	@Test
	public void test() {
		// Is it expected behavior of  getPaths() ? (in CmisDmsService.search()
		Document cmisDocument = mock(Document.class);
		
		when(cmisDocument.getPaths()).thenReturn(Arrays.asList("/path1/spath1","/path2/spath2"));
		
		final StringBuilder cmisPath = new StringBuilder();
		
		for(String p : cmisDocument.getPaths()) {
			if(cmisPath.length() > 0)
				cmisPath.append("/");
			cmisPath.append(p);
		}
		assertEquals("/path1/spath1//path2/spath2",cmisPath.toString());
	}

}
