package tests.configuration;

import static org.junit.Assert.*;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.cmdbuild.config.DmsProperties;
import org.cmdbuild.dms.cmis.nuxeo.NuxeoForwardingService;
import org.junit.Before;
import org.junit.Test;

import static org.mockito.Mockito.*;

public class DMSPropertiesWithForwardingProperties {
  @Before
  public void prepare() {
	  
  }
  
  @Test
  public void testBindingTypeNames() {
	 DmsProperties properties = new DmsProperties();
	 
	 ForwardingDMSProperties realProperties = new ForwardingDMSProperties(properties);
	 ForwardingDMSProperties spyProperties = spy(realProperties);
	 
	 when(spyProperties.getCmisBindingType()).thenReturn(
			 "atompub",
			 "browser",
			 "local",
			 "webservices",
			 "badName"
			 );
	 
	 when(spyProperties.stringPropertyNames()).thenReturn(
			 Collections.singleton("cmis.param.some.param.name")
			 );
	 
	 when(spyProperties.getProperty("cmis.param.some.param.name")).thenReturn("some.param.value");
	 
	 
	 assertEquals(BindingType.ATOMPUB, BindingType.fromValue(spyProperties.getCmisBindingType()));
	 assertEquals(BindingType.BROWSER,BindingType.fromValue(spyProperties.getCmisBindingType()));
	 assertEquals(BindingType.LOCAL,BindingType.fromValue(spyProperties.getCmisBindingType()));
	 assertEquals(BindingType.WEBSERVICES,BindingType.fromValue(spyProperties.getCmisBindingType()));
	 boolean occured = false;
	 try {
		 assertEquals(BindingType.WEBSERVICES,BindingType.fromValue(spyProperties.getCmisBindingType()));
	 } catch (java.lang.IllegalArgumentException e) {
			 occured=true;
	 }
	 assertTrue(occured);
	 Map<String, String> params = spyProperties.getSessionParameters();
	 System.out.println(params);
	 assertEquals("some.param.value",params.get("some.param.name"));
	
	 
  }
  
  

  @Test
  public void readUnfilled() throws IOException{
	  DmsProperties properties = new DmsProperties();
	  properties.load("src/test/resources/confs/dms.conf");
	  ForwardingDMSProperties dmsProperties = new ForwardingDMSProperties(properties);
	  
	  {
		ForwardingDMSProperties dmsSubProperties = (ForwardingDMSProperties)dmsProperties;
		  
		Set<String> names = dmsSubProperties.stringPropertyNames();
		
		assertTrue(names.contains("cmis.binding"));
		assertTrue(names.contains("cmis.local.factory"));
		
		assertEquals("atompub",dmsSubProperties.getCmisBindingType());
		assertEquals(
				"org.cmdbuild.dms.cmis.nuxeo.NuxeoServiceFactory",
				dmsSubProperties.getLocalServiceFactory()
				);		
		assertEquals(0,dmsSubProperties.getSessionParameters().entrySet().size());
	  }
  }
  @Test
  public void ForwardingProperties() throws IOException{
	  DmsProperties properties = new DmsProperties();
	 properties.load("src/test/resources/confs/dms.conf");
	  properties.put("cmis.param." + "someParameter","someParameterValue");
	  properties.put("cmis.param." + "anotherParameter","someParameterValue");
	  
	  ForwardingDMSProperties dmsProperties = new ForwardingDMSProperties(properties);
	  
	  assertEquals(2,dmsProperties.getSessionParameters().entrySet().size());
  }
  @Test
  public void NuxeoForwardingProperties() throws IOException{
	  DmsProperties properties = new DmsProperties();
	  properties.load("src/test/resources/confs/dms-with-nuxeo-params.conf");
	  ForwardingDMSProperties dmsProperties = new ForwardingDMSProperties(properties);
	  
	  Map<String, String> params = dmsProperties.getSessionParameters();
	  assertEquals(
			  "http://localhost/nuxeo/api/v1/automation",
			  params.get(NuxeoForwardingService.NUXEO_AUTOMATION_URL)
			  );
	  assertEquals("NuxeoUser",params.get(NuxeoForwardingService.NUXEO_AUTOMATION_USER));
	  assertEquals("NuxeoPassword",params.get(NuxeoForwardingService.NUXEO_AUTOMATION_PASSWORD));
	  
	  
	  
  }	
  
 }
  
