package it.unibo.cmdbuild.rest;

import org.json.JSONException;
import org.json.JSONObject;

public class Attribute extends Schema {

	public enum AttributeType {
		BOOLEAN, INTEGER, DECIMAL, DOUBLE, DATE, TIMESTAMP, CHAR, STRING, TEXT, REFERENCE, FOREIGNKEY, LOOKUP, INET, TIME, REGCLASS, POINT, LINESTRING, POLYGON, BINARY, INTARRAY, STRINGARRAY;
	}

	private AttributeType type;
	private Schema schema;
	private int length;
	private int precision;
	private int scale;
	private boolean isNotNull;
	private boolean isUnique;
	private String defaultValue;
	private String description;
	private int index;
	private boolean isBaseDSP;
	private boolean isInherited;
	private int referenceDomain;
	private boolean isReferenceDirect;
	private String referenceFilter;
	private String lookupType;
	private int fkDestination;
	private String group;

	public Attribute(JSONObject json, Schema schema) throws JSONException {
		super(json, schema.getCMDB(), null);
		assert (json.getInt("idClass") == schema.getId());
		this.schema = schema;
		this.description = json.optString("description", null);
		this.type = Enum.valueOf(AttributeType.class, json.getString("type")
				.toUpperCase());
		this.isBaseDSP = json.getBoolean("isbasedsp");
		this.isUnique = json.getBoolean("isunique");
		this.isNotNull = json.getBoolean("isnotnull");
		this.isInherited = json.getBoolean("inherited");
		this.index = json.getInt("index");
		this.group = json.optString("group", null);
		this.length = json.getInt("len");
		this.precision = json.getInt("precision");
		this.scale = json.getInt("scale");
		this.defaultValue = json.optString("defaultvalue", null);
		assert (!(this.type == AttributeType.LOOKUP) || json.has("lookup"));
		this.lookupType = json.optString("lookup", null);
		assert (!(this.type == AttributeType.REFERENCE) || json.has("idDomain"));
		referenceDomain = json.optInt("idDomain", -1);
		assert (!(this.type == AttributeType.REFERENCE) || json
				.has("domainDirection"));
		isReferenceDirect = json.optBoolean("domainDirection", false);
		assert (!(this.type == AttributeType.REFERENCE) || json
				.has("fieldFilter"));
		referenceFilter = json.optString("fieldFilter", null);
		assert (!(this.type == AttributeType.FOREIGNKEY) || json
				.has("fkDestination"));
		fkDestination = json.optInt("fkDestination", -1);
	}

	public AttributeValue parse(JSONObject json) throws JSONException {
		String value = json.optString(getName());
		AttributeValue attributeValue = new AttributeValue(this, value);
		return attributeValue;
	}

	public AttributeType getType() {
		return type;
	}

	public Schema getSchema() {
		return schema;
	}

	public int getLength() {
		return length;
	}

	public int getPrecision() {
		return precision;
	}

	public int getScale() {
		return scale;
	}

	public boolean isNotNull() {
		return isNotNull;
	}

	public boolean isUnique() {
		return isUnique;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public String getDescription() {
		return description;
	}

	public int getIndex() {
		return index;
	}

	public boolean isBaseDSP() {
		return isBaseDSP;
	}

	public boolean isInherited() {
		return isInherited;
	}

	public Domain getReferenceDomain() {
		return type == AttributeType.REFERENCE ? getCMDB().getDomain(
				referenceDomain) : null;
	}

	public boolean isReferenceDirect() {
		return isReferenceDirect;
	}

	public String getReferenceFilter() {
		return referenceFilter;
	}

	public LookupType getLookupType() {
		return type == AttributeType.LOOKUP ? getCMDB().getlookupType(
				lookupType) : null;
	}

	public Table getFKDestination() {
		return getCMDB().getClass(fkDestination);
	}

	public String getGroup() {
		return group;
	}
}