package it.unibo.cmdbuild.rest;

import java.util.TreeMap;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AttributeMap extends TreeMap<String, Attribute> {
	private static final long serialVersionUID = 8929256611454169244L;

	public AttributeMap(JSONArray jsArray, Schema schema) throws JSONException {
		if (jsArray != null) {
			for (int i = 0; i < jsArray.length(); i++) {
				JSONObject jsItem = jsArray.getJSONObject(i);
				Attribute attribute = new Attribute(jsItem, schema);
				this.put(attribute.getName(), attribute);
			}
		}
	}

}
