package it.unibo.cmdbuild.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;

public class Card extends Element {

	private List<Relation> relations = new ArrayList<Relation>();
	private List<Relation> inverseRelations = new ArrayList<Relation>();

	public Card(JSONObject json, Table schema) throws JSONException {
		super(json, schema);
		parseAttributes(json);
	}

	public void addRelation(Relation relation, Relation.Direction direction) {
		if (direction == Relation.Direction.DIRECT) {
			assert (relation.getCard1() == this);
			relations.add(relation);
		} else {
			assert (relation.getCard2() == this);
			inverseRelations.add(relation);
		}
	}

	public Collection<Relation> relations(Relation.Direction direction) {
		if (direction == Relation.Direction.DIRECT)
			return relations;
		else
			return inverseRelations;
	}

	public boolean isInstanceOf(Table schema) {
		return ((Table) getSchema()).isSubclassOf(schema);
	}

	@Override
	public String toString() {
		//return getSchema().toString() + get("Code").getValue();
		return get("Code").getValue();
	}
}
