package it.unibo.cmdbuild.rest;

import org.json.JSONException;
import org.json.JSONObject;

public class Domain extends Schema {

	private int class1;
	private int class2;
	private boolean isInherited;
	private String cardinality;
	private boolean isMasterDetail;
	private String mdLabel;
	private String description;
	private String descriptionDirect;
	private String descriptionInverse;

	public Domain(JSONObject json, CMDBuildClient cmdb) throws JSONException {
		super(json, cmdb, "idDomain");
		class1 = json.getInt("class1id");
		class2 = json.getInt("class2id");
		isInherited = json.optBoolean("inherited", false);
		cardinality = json.getString("cardinality");
		isMasterDetail = json.getBoolean("md");
		mdLabel = json.optString("md_label", null);
		description = json.optString("description", null);
		descriptionDirect = json.optString("descrdir", null);
		descriptionInverse = json.optString("descrinv", null);
	}

	protected String getJSONId() {
		return "idDomain";
	}

	public String getDescriptionDirect() {
		return descriptionDirect;
	}

	public String getDescriptionInverse() {
		return descriptionInverse;
	}

	public Table getClass1() {
		return getCMDB().getClass(class1);
	}

	public Table getClass2() {
		return getCMDB().getClass(class2);
	}

	public final boolean isInherited() {
		return isInherited;
	}

	public String getCardinality() {
		return cardinality;
	}

	public String getDescription() {
		return description;
	}

	public final boolean isMasterDetail() {
		return isMasterDetail;
	}

	public String getMDLabel() {
		return mdLabel;
	}
}
