package it.unibo.cmdbuild.rest;

import org.json.JSONException;
import org.json.JSONObject;

public class Lookup extends Element {
	private int id;
	private String description;
	private String code;
	private String notes;
	private int number;
	private boolean isDefault;

	public Lookup(JSONObject json) throws JSONException {
		super(json, null);
		id = json.getInt("Id");
		description = json.optString("Description", null);
		code = json.getString("Code");
		notes = json.optString("Notes", null);
		number = json.getInt("Number");
		isDefault = json.optBoolean("Default", false);
	}
	
	public int getId() {
		return id;
	}

	public String getDescription() {
		return description;
	}

	public String getCode() {
		return code;
	}

	public int getNumber() {
		return number;
	}

	public String getNotes() {
		return notes;
	}

	public boolean isDefault() {
		return isDefault;
	}
}