package it.unibo.cmdb.archimate;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.model.IArchimateModel;

public class CMDBDialog extends Dialog {
	private Combo modelCombo;	
	private Button queryButton;
	private IArchimateModel model;
	private Button ignoreMetadataButton;
	private boolean isImport;
	private String query;
	private boolean ignoreMetadata;
    
	
	public CMDBDialog(Shell parentShell, IArchimateModel model, boolean isImport) {
		super(parentShell);
		this.model = model;
		this.isImport = isImport;
	}

	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite)super.createDialogArea(parent);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		composite.setLayout(gridLayout);
		Label modelLabel = new Label(composite, SWT.NONE);
		modelLabel.setText(Messages.CMDBDialog_Model);		
		modelCombo = new Combo(composite, SWT.NONE);
		for (IArchimateModel m : IEditorModelManager.INSTANCE.getModels())
			modelCombo.add(m.getName());
		if(model != null)
			modelCombo.select(IEditorModelManager.INSTANCE.getModels().indexOf(model));
		if(isImport) {
			Label queryLabel = new Label(composite, SWT.NONE);
			queryLabel.setText(Messages.CMDBDialog_Query);		
			queryButton = new Button(composite, SWT.PUSH);
			queryButton.setText("Query...");
			queryButton.addSelectionListener(new SelectionListener() {
				
				@Override
				public void widgetSelected(SelectionEvent e) {
					QueryDialog dialog = new QueryDialog(Display.getCurrent().getActiveShell(), query);
					if (dialog.open() == Window.OK)
						query = dialog.getQuery();
				}
				
				@Override
				public void widgetDefaultSelected(SelectionEvent e) {
					widgetSelected(e);
				}
			});
			
			if(CMDBPlugin.INSTANCE.getConfiguration().getQuery() != null) {
				try {
					query = ModelUtils.toString(CMDBPlugin.INSTANCE.getConfiguration().getQuery());
				} catch (Exception e) {
					IStatus status = new Status(IStatus.ERROR, CMDBPlugin.PLUGIN_ID, e.getMessage(), e);
					CMDBPlugin.INSTANCE.getLog().log(status);
					query = "";
				}
			}
			else
				query = "";
		}
		else {
			Label ignoreMetadataLabel = new Label(composite, SWT.NONE);
			ignoreMetadataLabel.setText(Messages.CMDBDialog_IgnoreMetadata);		
			ignoreMetadataButton = new Button(composite, SWT.CHECK);			
			
		}
		return composite;
	}
	
	 protected void okPressed() {
		 int modelIndex = modelCombo.getSelectionIndex();
		 if(modelIndex != -1)
			 model = IEditorModelManager.INSTANCE.getModels().get(modelIndex);
		 if(!isImport)
			 ignoreMetadata = ignoreMetadataButton.getSelection();
		 super.okPressed();
	 }
	
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.CMDBDialog_Title);
    }
	
	public IArchimateModel getModel() {
		return model;
	}
	
	public String getQuery() {
		return query;
	}

	public boolean getIgnoreMetadata() {
		return ignoreMetadata;
	}
	
}
