package it.unibo.cmdb.archimate;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;

import javax.xml.namespace.QName;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.window.Window;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.archimatetool.editor.ArchimateEditorPlugin;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimatePackage;

import it.unibo.cmdb.archimate.model.transformationUtil.TransformationUtilPackage;
import it.unibo.cmdb.cmdbf.client.CMDBClient;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage;

public class CMDBPlugin extends AbstractUIPlugin {
	
	public static final String PLUGIN_ID = "archimate-cmdbuild-plugin";
	private CMDBConfiguration configuration = null;
	private CMDBClient cmdbClient = null;
	private ModelTransformer modelTransformer = null;

	public CMDBPlugin() {
		INSTANCE = this;
	}
	
	public static CMDBPlugin INSTANCE;
	
	@Override
	public void start(BundleContext context) throws Exception {
        super.start(context);
        
        File configFile = new File(ArchimateEditorPlugin.INSTANCE.getUserDataFolder(), "cmdb.xml");
        if(configFile.exists())
        	configuration = CMDBConfiguration.load(configFile.toURI());
        else {
        	configuration = CMDBConfiguration.getDefaults();
        	configuration.setUri(configFile.toURI());
        }
        configuration.addPropertyChangeListener(new PropertyChangeListener(){
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				cmdbClient = null;
				modelTransformer = null;
			}
        });
        
        IEditorModelManager.INSTANCE.addPropertyChangeListener(new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				if(evt.getNewValue() instanceof IArchimateModel &&
					(evt.getPropertyName()==IEditorModelManager.PROPERTY_MODEL_CREATED ||
					evt.getPropertyName()==IEditorModelManager.PROPERTY_MODEL_OPENED)){
					IArchimateModel model = (IArchimateModel)evt.getNewValue();
					CMDBContentAdapter.getAdapter(model);
				}
			}
		});
	}
	
	public File getUserDataFolder() {
		return ArchimateEditorPlugin.INSTANCE.getUserDataFolder();
	}
	
	public CMDBConfiguration getConfiguration() {
		return configuration;
	}
	
	public CMDBClient getCmdbClient() throws Exception {
		class CredentialJob implements Runnable
		{
			boolean ok;
			String username;
			String password;

			@Override
			public void run() {
				PasswordDialog passwordDialog = new PasswordDialog(Display.getCurrent().getActiveShell());
				if(passwordDialog.open() == Window.OK) {
					ok = true;
					username = passwordDialog.getUsername();
					password = passwordDialog.getPassword();
				}
				else
					ok = false;
			}
		}
		
		if(cmdbClient == null || cmdbClient.isInvalid()) {
			CredentialJob credentialJob = new CredentialJob();
			Display.getDefault().syncExec(credentialJob);
			
			if (credentialJob.ok) {
				String username = credentialJob.username;
				String password = credentialJob.password;				
				URL queryServiceWSDL = new URL(CMDBPlugin.INSTANCE.getConfiguration().getQueryWSDL());
		    	QName queryServiceName = CMDBPlugin.INSTANCE.getConfiguration().getQueryService();
		    	QName queryPortName = CMDBPlugin.INSTANCE.getConfiguration().getQueryPort();
		    	URL registrationServiceWSDL = new URL(CMDBPlugin.INSTANCE.getConfiguration().getRegistrationWSDL());
		    	QName registrationServiceName = CMDBPlugin.INSTANCE.getConfiguration().registrationService;
		    	QName registrationPortName = CMDBPlugin.INSTANCE.getConfiguration().getRegistrationPort();
				cmdbClient = new CMDBClient(queryServiceWSDL, queryServiceName, queryPortName, registrationServiceWSDL, registrationServiceName, registrationPortName, username, password);
			}
			else
				cmdbClient = null;
		}
		return cmdbClient;
	}
	
	public ModelTransformer getModelTransformer() throws NoSuchAlgorithmException, ATLCoreException, IOException {
		if(modelTransformer == null) {
			URI archi2cmdbTransformation = URI.createURI(CMDBPlugin.INSTANCE.getConfiguration().getArchi2cmdb());
	        URI cmdb2archiTransformation = URI.createURI(CMDBPlugin.INSTANCE.getConfiguration().getCmdb2archi());        			
			modelTransformer = new ModelTransformer("Archimate", "Cmdb", "Util", IArchimatePackage.eINSTANCE.getNsURI(), CmdbfPackage.eINSTANCE.getNsURI(), TransformationUtilPackage.eINSTANCE.getNsURI(), archi2cmdbTransformation, cmdb2archiTransformation);
		}			
		return modelTransformer;
	}

}
