package it.unibo.cmdb.archimate;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.UUID;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public class LogUtils {
	
	public static void logInfo(String message) {
		IStatus status = new Status(IStatus.INFO,CMDBPlugin.PLUGIN_ID, message);
        CMDBPlugin.INSTANCE.getLog().log(status);
	}
	
	public static void logWarning(String message) {
		IStatus status = new Status(IStatus.WARNING,CMDBPlugin.PLUGIN_ID, message);
        CMDBPlugin.INSTANCE.getLog().log(status);
	}
	
	public static void logException(Throwable e) {
		IStatus status = new Status(IStatus.ERROR, CMDBPlugin.PLUGIN_ID, e.getMessage(), e);
		CMDBPlugin.INSTANCE.getLog().log(status);        
	}
	
	public static void logEMF(EObject eObject) throws IOException {
		boolean tempResource = false;
		Resource resource = eObject.eResource();
		if(resource == null) {
			resource = new XMLResourceImpl(URI.createURI(UUID.randomUUID().toString()));
			resource.getContents().add(eObject);
			tempResource = true;
		}
		ByteArrayOutputStream stream = new ByteArrayOutputStream();
		eObject.eResource().save(stream, Collections.EMPTY_MAP);
		CMDBPlugin.INSTANCE.getLog().log(new Status(IStatus.INFO,CMDBPlugin.PLUGIN_ID, stream.toString()));
		if(tempResource)
			resource.getContents().clear();
	}
}
