/**
 */
package it.unibo.cmdb.archimate.model.transformationUtil.impl;

import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelElement;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IProperty;
import com.archimatetool.model.IRelationship;
import com.archimatetool.model.impl.ArchimateFactory;

import it.unibo.cmdb.archimate.CMDBContentAdapter;
import it.unibo.cmdb.archimate.DiagramSerializer;
import it.unibo.cmdb.archimate.LogUtils;
import it.unibo.cmdb.archimate.ModelUtils;
import it.unibo.cmdb.archimate.model.transformationUtil.TransformationUtil;
import it.unibo.cmdb.archimate.model.transformationUtil.TransformationUtilPackage;
import it.unibo.cmdb.cmdbf.client.CMDBClient;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelRecordType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordType;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Stack;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Transformation Util</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link it.unibo.cmdb.archimate.model.transformationUtil.impl.TransformationUtilImpl#getCmdbfClient <em>Cmdbf Client</em>}</li>
 *   <li>{@link it.unibo.cmdb.archimate.model.transformationUtil.impl.TransformationUtilImpl#getDiagramSerializer <em>Diagram Serializer</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TransformationUtilImpl extends MinimalEObjectImpl.Container implements TransformationUtil {

	/**
	 * The default value of the '{@link #getCmdbfClient() <em>Cmdbf Client</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCmdbfClient()
	 * @generated
	 * @ordered
	 */
	protected static final Object CMDBF_CLIENT_EDEFAULT = null;
	/**
	 * The cached value of the '{@link #getCmdbfClient() <em>Cmdbf Client</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCmdbfClient()
	 * @generated
	 * @ordered
	 */
	protected Object cmdbfClient = CMDBF_CLIENT_EDEFAULT;
	/**
	 * The default value of the '{@link #getDiagramSerializer() <em>Diagram Serializer</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDiagramSerializer()
	 * @generated
	 * @ordered
	 */
	protected static final Object DIAGRAM_SERIALIZER_EDEFAULT = null;
	/**
	 * The cached value of the '{@link #getDiagramSerializer() <em>Diagram Serializer</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDiagramSerializer()
	 * @generated
	 * @ordered
	 */
	protected Object diagramSerializer = DIAGRAM_SERIALIZER_EDEFAULT;
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	protected TransformationUtilImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TransformationUtilPackage.Literals.TRANSFORMATION_UTIL;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getCmdbfClient() {
		return cmdbfClient;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCmdbfClient(Object newCmdbfClient) {
		Object oldCmdbfClient = cmdbfClient;
		cmdbfClient = newCmdbfClient;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TransformationUtilPackage.TRANSFORMATION_UTIL__CMDBF_CLIENT, oldCmdbfClient, cmdbfClient));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getDiagramSerializer() {
		return diagramSerializer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDiagramSerializer(Object newDiagramSerializer) {
		Object oldDiagramSerializer = diagramSerializer;
		diagramSerializer = newDiagramSerializer;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TransformationUtilPackage.TRANSFORMATION_UTIL__DIAGRAM_SERIALIZER, oldDiagramSerializer, diagramSerializer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public void serialize(IDiagramModel diagram, RecordType record, String field) {
		try {						
			((DiagramSerializer) getDiagramSerializer()).serialize(diagram, record, field);
		} catch (Exception e) {
			LogUtils.logException(e);
			throw new Error(e);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public void deserialize(IDiagramModel diagram, RecordType record, String field) {
		try {
			((DiagramSerializer) getDiagramSerializer()).deserialize(diagram, record, field);
		} catch (Exception e) {
			throw new Error(e);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public String createImage(IDiagramModel diagram) {
		byte[] image =  ((DiagramSerializer) getDiagramSerializer()).createImage(diagram);
		return XMLTypeFactory.eINSTANCE.convertBase64Binary(image);		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public String normalizeFilename(String filename) {
		return ModelUtils.normalizeFilename(filename);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean isDeleted(IArchimateModelElement element) {
		CMDBContentAdapter adapter = CMDBContentAdapter.getAdapter(element);
		return adapter!=null && adapter.isDeleted(element);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean isDerived(IRelationship relationship) {
		CMDBContentAdapter adapter = CMDBContentAdapter.getAdapter(relationship);
		return adapter.isDerived(relationship);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean instanceOf(String baseTypeNS, String baseTypeName, String typeNS, String typeName) {
		boolean instanceOf = false;
		if(getCmdbfClient() instanceof CMDBClient && baseTypeNS!=null && baseTypeName!=null && typeNS!=null && typeName!=null) {
			CMDBClient client = (CMDBClient)getCmdbfClient();
			ModelRecordType baseType = client.getRecordType(baseTypeNS, baseTypeName);
			ModelRecordType type = client.getRecordType(typeNS, typeName);
			if(type!=null && baseType!=null)
				instanceOf = baseType.isAssignableFrom(type);
		}
		return instanceOf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public void setFolder(IArchimateModel model, EObject element, String path) {
		String[] parts = path.split("(?!\\\\)/");
		IFolder folder = model.getDefaultFolderForElement(element);
		if(folder != null) {
			for(String name : parts) {
				IFolder subfolder = null;
				Iterator<IFolder> folderIterator = folder.getFolders().iterator(); 
				while(subfolder == null && folderIterator.hasNext()) {
					IFolder current = folderIterator.next();
					if(current.getName().equals(name.replace("\\/", "/")))
						subfolder = current;
				}
				if(subfolder == null) {
					subfolder = ArchimateFactory.eINSTANCE.createFolder();
					subfolder.setName(name);
		    		folder.getFolders().add(subfolder);
				}
				folder = subfolder;
			}
			folder.getElements().add(element);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public String getFolder(EObject element) {
		StringBuilder path = new StringBuilder();
		while(element!=null) {
			element = element.eContainer();
			if(element instanceof IFolder && element.eContainer() instanceof IFolder) {
				if(path.length() > 0)
					path.insert(0, "/");
				path.insert(0, ((IFolder)element).getName().replace("/", "\\/"));
			}
			else
				element = null;
		}
		return path.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public String getFolderFromType(ModelRecordType type, int skip) {
		Stack<String> stack = new Stack<String>();
		while(type!=null) {
			stack.push(type.getLocalName().replace("/", "\\/"));
			if(type.getSuperType().isEmpty())
				type = null;
			else
				type = type.getSuperType().get(0);
		}
		for(int i=0; !stack.isEmpty() && i<skip; i++)
			stack.pop();		
		StringBuilder path = new StringBuilder();		
		while(!stack.isEmpty()) {
			if(path.length() > 0)
				path.append("/");
			path.append(stack.pop());
		}
		return path.toString();
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public String getId(EObject eObject) {
		return eObject.eResource().getURIFragment(eObject);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public String getProperty(IProperties element, String name) {
		IProperty property = null;
        for(IProperty p : element.getProperties()) {
            if(p.getKey().equals(name)) {
                property = p;
            }
        }
        return property!=null ? property.getValue() : "";		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public void setProperty(IProperties element, String name, String value) {
		IProperty property = null;
        for(IProperty p : element.getProperties()) {
            if(p.getKey().equals(name)) {
                property = p;
            }
        }
        if(property == null) {
        	property = IArchimateFactory.eINSTANCE.createProperty();
        	property.setKey(name);
        	element.getProperties().add(property);
        }
        boolean deliver = property.eDeliver();
        property.eSetDeliver(false);
        property.setValue(value);
        property.eSetDeliver(deliver);        
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TransformationUtilPackage.TRANSFORMATION_UTIL__CMDBF_CLIENT:
				return getCmdbfClient();
			case TransformationUtilPackage.TRANSFORMATION_UTIL__DIAGRAM_SERIALIZER:
				return getDiagramSerializer();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TransformationUtilPackage.TRANSFORMATION_UTIL__CMDBF_CLIENT:
				setCmdbfClient(newValue);
				return;
			case TransformationUtilPackage.TRANSFORMATION_UTIL__DIAGRAM_SERIALIZER:
				setDiagramSerializer(newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TransformationUtilPackage.TRANSFORMATION_UTIL__CMDBF_CLIENT:
				setCmdbfClient(CMDBF_CLIENT_EDEFAULT);
				return;
			case TransformationUtilPackage.TRANSFORMATION_UTIL__DIAGRAM_SERIALIZER:
				setDiagramSerializer(DIAGRAM_SERIALIZER_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TransformationUtilPackage.TRANSFORMATION_UTIL__CMDBF_CLIENT:
				return CMDBF_CLIENT_EDEFAULT == null ? cmdbfClient != null : !CMDBF_CLIENT_EDEFAULT.equals(cmdbfClient);
			case TransformationUtilPackage.TRANSFORMATION_UTIL__DIAGRAM_SERIALIZER:
				return DIAGRAM_SERIALIZER_EDEFAULT == null ? diagramSerializer != null : !DIAGRAM_SERIALIZER_EDEFAULT.equals(diagramSerializer);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case TransformationUtilPackage.TRANSFORMATION_UTIL___SERIALIZE__IDIAGRAMMODEL_RECORDTYPE_STRING:
				serialize((IDiagramModel)arguments.get(0), (RecordType)arguments.get(1), (String)arguments.get(2));
				return null;
			case TransformationUtilPackage.TRANSFORMATION_UTIL___DESERIALIZE__IDIAGRAMMODEL_RECORDTYPE_STRING:
				deserialize((IDiagramModel)arguments.get(0), (RecordType)arguments.get(1), (String)arguments.get(2));
				return null;
			case TransformationUtilPackage.TRANSFORMATION_UTIL___CREATE_IMAGE__IDIAGRAMMODEL:
				return createImage((IDiagramModel)arguments.get(0));
			case TransformationUtilPackage.TRANSFORMATION_UTIL___NORMALIZE_FILENAME__STRING:
				return normalizeFilename((String)arguments.get(0));
			case TransformationUtilPackage.TRANSFORMATION_UTIL___IS_DELETED__IARCHIMATEMODELELEMENT:
				return isDeleted((IArchimateModelElement)arguments.get(0));
			case TransformationUtilPackage.TRANSFORMATION_UTIL___IS_DERIVED__IRELATIONSHIP:
				return isDerived((IRelationship)arguments.get(0));
			case TransformationUtilPackage.TRANSFORMATION_UTIL___INSTANCE_OF__STRING_STRING_STRING_STRING:
				return instanceOf((String)arguments.get(0), (String)arguments.get(1), (String)arguments.get(2), (String)arguments.get(3));
			case TransformationUtilPackage.TRANSFORMATION_UTIL___SET_FOLDER__IARCHIMATEMODEL_EOBJECT_STRING:
				setFolder((IArchimateModel)arguments.get(0), (EObject)arguments.get(1), (String)arguments.get(2));
				return null;
			case TransformationUtilPackage.TRANSFORMATION_UTIL___GET_FOLDER__EOBJECT:
				return getFolder((EObject)arguments.get(0));
			case TransformationUtilPackage.TRANSFORMATION_UTIL___GET_FOLDER_FROM_TYPE__MODELRECORDTYPE_INT:
				return getFolderFromType((ModelRecordType)arguments.get(0), (Integer)arguments.get(1));
			case TransformationUtilPackage.TRANSFORMATION_UTIL___GET_PROPERTY__IPROPERTIES_STRING:
				return getProperty((IProperties)arguments.get(0), (String)arguments.get(1));
			case TransformationUtilPackage.TRANSFORMATION_UTIL___SET_PROPERTY__IPROPERTIES_STRING_STRING:
				setProperty((IProperties)arguments.get(0), (String)arguments.get(1), (String)arguments.get(2));
				return null;
		}
		return super.eInvoke(operationID, arguments);
	}
		
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (cmdbfClient: ");
		result.append(cmdbfClient);
		result.append(", diagramSerializer: ");
		result.append(diagramSerializer);
		result.append(')');
		return result.toString();
	}

} //TransformationUtilImpl
