
package it.unibo.cmdb.cmdbf.client;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.SelectorType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.UnsupportedSelectorFaultType;

public class UnsupportedSelectorException extends Exception{
	private static final long serialVersionUID = -8797689810169426022L;
	protected String localName;
    protected String namespace;
    
    public UnsupportedSelectorException(UnsupportedSelectorFaultType fault){
    	SelectorType selector = fault.getSelector();
    	if(selector != null) {
    		this.localName = selector.getLocalName();
    		this.namespace = selector.getNamespace();
    	}
    }

    public String getLocalName() {
        return localName;
    }


    public String getNamespace() {
        return namespace;
    }
}
