/**
 */
package it.unibo.cmdb.cmdbf.client.model.cmdbf.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap.Entry;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.Model;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelElement;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelMetadata;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelRecordType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.PropertySetType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordMetadataType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordType;

import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Record Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RecordTypeImpl#getAny <em>Any</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RecordTypeImpl#getPropertySet <em>Property Set</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RecordTypeImpl#getRecordMetadata <em>Record Metadata</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RecordTypeImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RecordTypeImpl#getTemplateId <em>Template Id</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RecordTypeImpl#getRecordId <em>Record Id</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RecordTypeImpl#getLastModified <em>Last Modified</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RecordTypeImpl#getType <em>Type</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RecordTypeImpl#getContent <em>Content</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RecordTypeImpl#getPropertyName <em>Property Name</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RecordTypeImpl extends MinimalEObjectImpl.Container implements RecordType {
	
	protected interface RecordProperty {
		String getName();
		EClassifier getType();
		boolean isSet();
		Object get();
		void set(Object value);
		void unset();
	}
	
	protected class EObjectProperty implements RecordProperty {
		private EStructuralFeature feature;
		private EObject owner;
		
		public EObjectProperty(EStructuralFeature feature, EObject owner) {
			this.feature = feature;
			this.owner = owner;			
		}

		@Override
		public String getName() {
			return feature.getName();
		}
		
		@Override		
		public EClassifier getType() {
			return feature.getEType();
		}

		@Override
		public boolean isSet() {
			return owner.eIsSet(feature);
		}

		@Override
		public Object get() {
			return owner.eGet(feature);
		}

		@Override
		public void set(Object value) {
			owner.eSet(feature, value);			
		}

		@Override
		public void unset() {
			owner.eUnset(feature);			
		}
	}
	
	protected class FeatureMapProperty implements RecordProperty {
		private EStructuralFeature feature;
		private FeatureMap owner;

		FeatureMapProperty(EStructuralFeature feature, FeatureMap owner) {
			this.feature = feature;
			this.owner = owner;				
		}	

		@Override
		public String getName() {
			return feature.getName();
		}
		
		@Override		
		public EClassifier getType() {
			return feature.getEType();
		}

		@Override
		public boolean isSet() {
			return owner.isSet(feature);
		}

		@Override
		public Object get() {
			return owner.get(feature, true);
		}

		@Override
		public void set(Object value) {
			owner.set(feature, value);			
		}

		@Override
		public void unset() {
			owner.unset(feature);			
		}		
	}
	
	/**
	 * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAny()
	 * @generated
	 * @ordered
	 */
	protected FeatureMap any;

	/**
	 * The cached value of the '{@link #getPropertySet() <em>Property Set</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPropertySet()
	 * @generated
	 * @ordered
	 */
	protected PropertySetType propertySet;

	/**
	 * The cached value of the '{@link #getRecordMetadata() <em>Record Metadata</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecordMetadata()
	 * @generated
	 * @ordered
	 */
	protected RecordMetadataType recordMetadata;

	/**
	 * The cached value of the '{@link #getTemplateId() <em>Template Id</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTemplateId()
	 * @generated
	 * @ordered
	 */
	protected EList<String> templateId;

	/**
	 * The default value of the '{@link #getRecordId() <em>Record Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecordId()
	 * @generated
	 * @ordered
	 */
	protected static final String RECORD_ID_EDEFAULT = "";

	/**
	 * The cached value of the '{@link #getRecordId() <em>Record Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecordId()
	 * @generated
	 * @ordered
	 */
	protected String recordId = RECORD_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getLastModified() <em>Last Modified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastModified()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar LAST_MODIFIED_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLastModified() <em>Last Modified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastModified()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar lastModified = LAST_MODIFIED_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RecordTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CmdbfPackage.Literals.RECORD_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FeatureMap getAny() {
		if (any == null) {
			any = new BasicFeatureMap(this, CmdbfPackage.RECORD_TYPE__ANY);
		}
		return any;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PropertySetType getPropertySet() {
		return propertySet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPropertySet(PropertySetType newPropertySet, NotificationChain msgs) {
		PropertySetType oldPropertySet = propertySet;
		propertySet = newPropertySet;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CmdbfPackage.RECORD_TYPE__PROPERTY_SET, oldPropertySet, newPropertySet);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPropertySet(PropertySetType newPropertySet) {
		if (newPropertySet != propertySet) {
			NotificationChain msgs = null;
			if (propertySet != null)
				msgs = ((InternalEObject)propertySet).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CmdbfPackage.RECORD_TYPE__PROPERTY_SET, null, msgs);
			if (newPropertySet != null)
				msgs = ((InternalEObject)newPropertySet).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CmdbfPackage.RECORD_TYPE__PROPERTY_SET, null, msgs);
			msgs = basicSetPropertySet(newPropertySet, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.RECORD_TYPE__PROPERTY_SET, newPropertySet, newPropertySet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RecordMetadataType getRecordMetadata() {
		return recordMetadata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRecordMetadata(RecordMetadataType newRecordMetadata, NotificationChain msgs) {
		RecordMetadataType oldRecordMetadata = recordMetadata;
		recordMetadata = newRecordMetadata;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CmdbfPackage.RECORD_TYPE__RECORD_METADATA, oldRecordMetadata, newRecordMetadata);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRecordMetadata(RecordMetadataType newRecordMetadata) {
		if (newRecordMetadata != recordMetadata) {
			NotificationChain msgs = null;
			if (recordMetadata != null)
				msgs = ((InternalEObject)recordMetadata).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CmdbfPackage.RECORD_TYPE__RECORD_METADATA, null, msgs);
			if (newRecordMetadata != null)
				msgs = ((InternalEObject)newRecordMetadata).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CmdbfPackage.RECORD_TYPE__RECORD_METADATA, null, msgs);
			msgs = basicSetRecordMetadata(newRecordMetadata, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.RECORD_TYPE__RECORD_METADATA, newRecordMetadata, newRecordMetadata));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelElement getParent() {
		if (eContainerFeatureID() != CmdbfPackage.RECORD_TYPE__PARENT) return null;
		return (ModelElement)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParent(ModelElement newParent, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newParent, CmdbfPackage.RECORD_TYPE__PARENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(ModelElement newParent) {
		if (newParent != eInternalContainer() || (eContainerFeatureID() != CmdbfPackage.RECORD_TYPE__PARENT && newParent != null)) {
			if (EcoreUtil.isAncestor(this, newParent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, CmdbfPackage.MODEL_ELEMENT__RECORD, ModelElement.class, msgs);
			msgs = basicSetParent(newParent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.RECORD_TYPE__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<String> getTemplateId() {
		if (templateId == null) {
			templateId = new EDataTypeUniqueEList<String>(String.class, this, CmdbfPackage.RECORD_TYPE__TEMPLATE_ID);
		}
		return templateId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getRecordId() {
		return recordId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRecordId(String newRecordId) {
		String oldRecordId = recordId;
		recordId = newRecordId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.RECORD_TYPE__RECORD_ID, oldRecordId, recordId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public XMLGregorianCalendar getLastModified() {
		return lastModified;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastModified(XMLGregorianCalendar newLastModified) {
		XMLGregorianCalendar oldLastModified = lastModified;
		lastModified = newLastModified;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.RECORD_TYPE__LAST_MODIFIED, oldLastModified, lastModified));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public ModelRecordType getType() {
		String namespace = null;
		String localName = null;
		if(!getAny().isEmpty()) {
			EStructuralFeature feature = getAny().get(0).getEStructuralFeature();
			EClassifier eClassifier = feature.getEType();
			namespace = getModelMetadata().getNamespace(eClassifier);
			localName = getModelMetadata().getLocalName(eClassifier);
		}
		else if(getPropertySet() != null) { 
			namespace = getPropertySet().getNamespace();
			localName = getPropertySet().getLocalName();		
		}
		ModelRecordType type = null;		
		if(namespace!=null && localName != null)
			type = getModelMetadata().getRecordType(namespace, localName);
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public void setType(ModelRecordType newType) {
		getAny().clear();
		setPropertySet(null);
		if(newType != null) {
			EStructuralFeature feature = getModelMetadata().getElement(newType.getNamespace(), newType.getLocalName());		
			EClass eClass = (EClass)feature.getEType();
			EObject content = eClass.getEPackage().getEFactoryInstance().create(eClass);
			getAny().set(feature, content);
		}
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	@Override
	public EObject getContent() {
		return !getAny().isEmpty() ? (EObject) getAny().get(0).getValue() : null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public EList<String> getPropertyName() {
		EList<String> properties = new BasicEList<String>();		
		if(getContent() != null)
			fetchProperties(getContent(), properties);
		else if(getPropertySet() != null)
			fetchProperties(getPropertySet(), properties);
		return properties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public Object get(String name) {
		return get(name, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public void set(String name, Object value) {
		set(name, value, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public void unset(String name) {
		RecordProperty property = null;
		if(getContent() != null)
			property = getProperty(getContent(), name, false);
		else if(getPropertySet() != null)
			property = getProperty(getPropertySet(), name, false);
		if(property != null)
			property.unset();		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean isSet(String name) {
		RecordProperty property = null;
		if(getContent() != null)
			property = getProperty(getContent(), name, false);
		else if(getPropertySet() != null)
			property = getProperty(getPropertySet(), name, false);
		return property != null ? property.isSet() : false;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean has(String name) {
		RecordProperty property = null;
		if(getContent() != null)
			property = getProperty(getContent(), name, false);
		else if(getPropertySet() != null)
			property = getProperty(getPropertySet(), name, false);
		return property != null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public String getAsString(String name) {
		return (String)get(name, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public void setAsString(String name, String value) {
		set(name, value, true);
	}
	
	private void fetchProperties(EObject eObject, EList<String> properties) {
		fetchProperties(eObject.eClass(), properties);		
	}
	
	private void fetchProperties(PropertySetType propertySet, EList<String> properties) {
		ModelMetadata metadata = getModelMetadata();
		if(metadata != null) {
			EStructuralFeature typeFeature = getModelMetadata().getElement(getPropertySet().getNamespace(), getPropertySet().getLocalName());
			fetchProperties(typeFeature.getEType(), properties);
		}
		else {
			for(Entry entry : getPropertySet().getAny()) {
				EStructuralFeature feature = entry.getEStructuralFeature();
				properties.add(feature.getName());
			}
		}
	}
	
	private void fetchProperties(EClassifier type, EList<String> properties) {
		if(type instanceof EClass) {
			for(EStructuralFeature feature : ((EClass)type).getEAllStructuralFeatures())
				properties.add(feature.getName());
		}
	}
	
	private RecordProperty getProperty(EObject eObject, String name, boolean create) {
		RecordProperty property = null;
		int pos = name.indexOf('.');
		String featureName = pos>0 ? name.substring(0, pos) : name;
		EStructuralFeature feature = eObject.eClass().getEStructuralFeature(featureName);
		if(feature != null) {		
			if(pos < 0) {
				property = new EObjectProperty(feature, eObject);
			}
			else {
				Object value = eObject.eGet(feature);
				if(value == null && create && feature.getEType() instanceof EClass) {
					EClass type = (EClass)feature.getEType();
					value = type.getEPackage().getEFactoryInstance().create(type);
					eObject.eSet(feature, value);
				}								
				if(value instanceof EObject)
					property =  getProperty((EObject)value, name.substring(pos+1), create);							
			}
		}
		return property;
	}
	
	private RecordProperty getProperty(PropertySetType propertySet, String name, boolean create) {
		RecordProperty property = null;		
		int pos = name.indexOf('.');
		String featureName = pos>0 ? name.substring(0, pos) : name;
		EStructuralFeature feature = null;
		
		ModelMetadata metadata = getModelMetadata();		
		if(metadata != null) {
			feature = metadata.getElement(propertySet.getNamespace(), propertySet.getLocalName());			
		}
		else {
			Iterator<Entry> iterator = propertySet.getAny().iterator();
			while(feature == null && iterator.hasNext()) {
				Entry entry = iterator.next();
				if(entry.getEStructuralFeature().getName().equals(featureName))
					feature = entry.getEStructuralFeature();
			}
		}
		
		if(feature != null) {		
			if(pos < 0) {
				property = new FeatureMapProperty(feature, propertySet.getAny());
			}
			else {
				Object value = propertySet.getAny().get(feature, true);
				if(value == null && create && feature.getEType() instanceof EClass) {
					EClass type = (EClass)feature.getEType();
					value = type.getEPackage().getEFactoryInstance().create(type);
					propertySet.getAny().set(feature, value);
				}				
				if(value instanceof EObject)
					property = getProperty((EObject)value, name.substring(pos+1), create);
			}
		}
		return property;	
	}
		
	private Object get(String name, boolean asString) {
		RecordProperty property = null;
		if(getContent() != null)
			property = getProperty(getContent(), name, false);
		else if(getPropertySet() != null)
			property = getProperty(getPropertySet(), name, false);
		
		if(property != null) {
			Object object = property.get();
			if(object instanceof String && ((String)object).isEmpty())
				object = null;
			
			if(object!=null && asString) {
				EClassifier type = property.getType();
				if(type instanceof EDataType)
					object = EcoreUtil.convertToString((EDataType)type, object);
				else
					throw new ClassCastException(type.getName());
			}			
			return object;
		}
		else
			throw new NoSuchElementException(name);				
	}

	private void set(String name, Object value, boolean asString) {
		RecordProperty property = null;
		if(getContent() != null)
			property = getProperty(getContent(), name, true);
		else if(getPropertySet() != null)
			property = getProperty(getPropertySet(), name, true);
		
		if(property != null) {
			if(value instanceof String && ((String)value).isEmpty())
				value = null;
			
			if(value != null) {
				EClassifier type = property.getType();
				if(type instanceof EDataType) {
					if(((EDataType)type).getInstanceClass().equals(XMLGregorianCalendar.class) && value instanceof Date) {
						GregorianCalendar calendar = new GregorianCalendar();
						calendar.setTime((Date) value);
						try {
							value = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
						} catch (DatatypeConfigurationException e) {
							throw new IllegalArgumentException(e.getMessage(), e);
						}
					}
					else if(!((EDataType)type).isInstance(value)) {
						value = EcoreUtil.createFromString((EDataType)type, value.toString());
					}
				}
			}
			property.set(value);
		}
		else
			throw new NoSuchElementException(name);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean instanceOf(String type) {
		String localName = getModelMetadata().getLocalName(type);
		String namespace = getModelMetadata().getNamespace(type);
		return instanceOf(namespace, localName);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean instanceOf(String namespace, String localName) {
		ModelRecordType superType = getModelMetadata().getRecordType(namespace, localName);
		return instanceOf(superType);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean instanceOf(ModelRecordType superType) {
		return superType!=null && superType.isAssignableFrom(getType());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean merge(RecordType element) {
		boolean modified = false;
		for(String name : element.getPropertyName()) {
			if(element.isSet(name)) {
				Object value = element.get(name);
				set(name, value);
				modified = true;
			}
		}
		return modified;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CmdbfPackage.RECORD_TYPE__PARENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetParent((ModelElement)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CmdbfPackage.RECORD_TYPE__ANY:
				return ((InternalEList<?>)getAny()).basicRemove(otherEnd, msgs);
			case CmdbfPackage.RECORD_TYPE__PROPERTY_SET:
				return basicSetPropertySet(null, msgs);
			case CmdbfPackage.RECORD_TYPE__RECORD_METADATA:
				return basicSetRecordMetadata(null, msgs);
			case CmdbfPackage.RECORD_TYPE__PARENT:
				return basicSetParent(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case CmdbfPackage.RECORD_TYPE__PARENT:
				return eInternalContainer().eInverseRemove(this, CmdbfPackage.MODEL_ELEMENT__RECORD, ModelElement.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CmdbfPackage.RECORD_TYPE__ANY:
				if (coreType) return getAny();
				return ((FeatureMap.Internal)getAny()).getWrapper();
			case CmdbfPackage.RECORD_TYPE__PROPERTY_SET:
				return getPropertySet();
			case CmdbfPackage.RECORD_TYPE__RECORD_METADATA:
				return getRecordMetadata();
			case CmdbfPackage.RECORD_TYPE__PARENT:
				return getParent();
			case CmdbfPackage.RECORD_TYPE__TEMPLATE_ID:
				return getTemplateId();
			case CmdbfPackage.RECORD_TYPE__RECORD_ID:
				return getRecordId();
			case CmdbfPackage.RECORD_TYPE__LAST_MODIFIED:
				return getLastModified();
			case CmdbfPackage.RECORD_TYPE__TYPE:
				return getType();
			case CmdbfPackage.RECORD_TYPE__CONTENT:
				return getContent();
			case CmdbfPackage.RECORD_TYPE__PROPERTY_NAME:
				return getPropertyName();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CmdbfPackage.RECORD_TYPE__ANY:
				((FeatureMap.Internal)getAny()).set(newValue);
				return;
			case CmdbfPackage.RECORD_TYPE__PROPERTY_SET:
				setPropertySet((PropertySetType)newValue);
				return;
			case CmdbfPackage.RECORD_TYPE__RECORD_METADATA:
				setRecordMetadata((RecordMetadataType)newValue);
				return;
			case CmdbfPackage.RECORD_TYPE__PARENT:
				setParent((ModelElement)newValue);
				return;
			case CmdbfPackage.RECORD_TYPE__TEMPLATE_ID:
				getTemplateId().clear();
				getTemplateId().addAll((Collection<? extends String>)newValue);
				return;
			case CmdbfPackage.RECORD_TYPE__RECORD_ID:
				setRecordId((String)newValue);
				return;
			case CmdbfPackage.RECORD_TYPE__LAST_MODIFIED:
				setLastModified((XMLGregorianCalendar)newValue);
				return;
			case CmdbfPackage.RECORD_TYPE__TYPE:
				setType((ModelRecordType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CmdbfPackage.RECORD_TYPE__ANY:
				getAny().clear();
				return;
			case CmdbfPackage.RECORD_TYPE__PROPERTY_SET:
				setPropertySet((PropertySetType)null);
				return;
			case CmdbfPackage.RECORD_TYPE__RECORD_METADATA:
				setRecordMetadata((RecordMetadataType)null);
				return;
			case CmdbfPackage.RECORD_TYPE__PARENT:
				setParent((ModelElement)null);
				return;
			case CmdbfPackage.RECORD_TYPE__TEMPLATE_ID:
				getTemplateId().clear();
				return;
			case CmdbfPackage.RECORD_TYPE__RECORD_ID:
				setRecordId(RECORD_ID_EDEFAULT);
				return;
			case CmdbfPackage.RECORD_TYPE__LAST_MODIFIED:
				setLastModified(LAST_MODIFIED_EDEFAULT);
				return;
			case CmdbfPackage.RECORD_TYPE__TYPE:
				setType((ModelRecordType)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CmdbfPackage.RECORD_TYPE__ANY:
				return any != null && !any.isEmpty();
			case CmdbfPackage.RECORD_TYPE__PROPERTY_SET:
				return propertySet != null;
			case CmdbfPackage.RECORD_TYPE__RECORD_METADATA:
				return recordMetadata != null;
			case CmdbfPackage.RECORD_TYPE__PARENT:
				return getParent() != null;
			case CmdbfPackage.RECORD_TYPE__TEMPLATE_ID:
				return templateId != null && !templateId.isEmpty();
			case CmdbfPackage.RECORD_TYPE__RECORD_ID:
				return RECORD_ID_EDEFAULT == null ? recordId != null : !RECORD_ID_EDEFAULT.equals(recordId);
			case CmdbfPackage.RECORD_TYPE__LAST_MODIFIED:
				return LAST_MODIFIED_EDEFAULT == null ? lastModified != null : !LAST_MODIFIED_EDEFAULT.equals(lastModified);
			case CmdbfPackage.RECORD_TYPE__TYPE:
				return getType() != null;
			case CmdbfPackage.RECORD_TYPE__CONTENT:
				return getContent() != null;
			case CmdbfPackage.RECORD_TYPE__PROPERTY_NAME:
				return !getPropertyName().isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case CmdbfPackage.RECORD_TYPE___GET__STRING:
				return get((String)arguments.get(0));
			case CmdbfPackage.RECORD_TYPE___SET__STRING_OBJECT:
				set((String)arguments.get(0), arguments.get(1));
				return null;
			case CmdbfPackage.RECORD_TYPE___UNSET__STRING:
				unset((String)arguments.get(0));
				return null;
			case CmdbfPackage.RECORD_TYPE___IS_SET__STRING:
				return isSet((String)arguments.get(0));
			case CmdbfPackage.RECORD_TYPE___HAS__STRING:
				return has((String)arguments.get(0));
			case CmdbfPackage.RECORD_TYPE___GET_AS_STRING__STRING:
				return getAsString((String)arguments.get(0));
			case CmdbfPackage.RECORD_TYPE___SET_AS_STRING__STRING_STRING:
				setAsString((String)arguments.get(0), (String)arguments.get(1));
				return null;
			case CmdbfPackage.RECORD_TYPE___INSTANCE_OF__STRING:
				return instanceOf((String)arguments.get(0));
			case CmdbfPackage.RECORD_TYPE___INSTANCE_OF__STRING_STRING:
				return instanceOf((String)arguments.get(0), (String)arguments.get(1));
			case CmdbfPackage.RECORD_TYPE___INSTANCE_OF__MODELRECORDTYPE:
				return instanceOf((ModelRecordType)arguments.get(0));
			case CmdbfPackage.RECORD_TYPE___MERGE__RECORDTYPE:
				return merge((RecordType)arguments.get(0));
		}
		return super.eInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(/*super.toString()*/);
		result.append(" (");
		ModelRecordType type = getType();
		if(type != null)
			result.append(type.toString());
		//result.append(", any: ");
		//result.append(any);
		//result.append(", templateId: ");
		//result.append(templateId);
		result.append(')');
		return result.toString();
	}
	
	@Override
	public boolean equals(final Object obj) {
		boolean equals = false;
		if (obj instanceof RecordType) {
			final RecordType record = (RecordType) obj;
			equals = (record.getRecordId() == null && getRecordMetadata() == null) ||
				(record.getRecordId() != null && record.getRecordId().equals(getRecordId()));
		}
		return equals;
	}
	
	private ModelMetadata getModelMetadata(){
		Model model = null;
		EObject eObject = this;
		while(model == null && eObject!=null) {
			if(eObject instanceof Model)
				model = (Model)eObject;
			eObject = eObject.eContainer();
		}		
		return model!=null ? model.getModelMetadata() : null;
	}
} //RecordTypeImpl
