package it.unibo.cmdb.monitoring;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;

import org.eclipse.acceleo.common.IAcceleoConstants;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoParser;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoProject;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoProjectClasspathEntry;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.resource.AcceleoResourceSetImpl;
import org.eclipse.acceleo.model.mtl.resource.EMtlBinaryResourceFactoryImpl;
import org.eclipse.acceleo.model.mtl.resource.EMtlResourceFactoryImpl;
import org.eclipse.acceleo.parser.AcceleoParserInfo;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoParserWarning;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.expressions.ExpressionsPackage;

public class Model2Text {
	private final static Logger LOGGER = Logger.getLogger(Model2Text.class.getName()); 	
	private String templateName;
	private Module module;

	public Model2Text(String compiledPath, String templateName, URI transformation) throws IOException {
		this.templateName = templateName;
		
		File transformationFile = new File(transformation.toFileString()); 
		File projectRoot = transformationFile.getParentFile();	
		File inputDirectory = projectRoot;
		File outputDirectory = new File(compiledPath);
		AcceleoProjectClasspathEntry entry = new AcceleoProjectClasspathEntry(inputDirectory, outputDirectory);
		Set<AcceleoProjectClasspathEntry> entries = new LinkedHashSet<AcceleoProjectClasspathEntry>();
		entries.add(entry);
		AcceleoProject project = new AcceleoProject(projectRoot, entries);
		File outputFile = project.getOutputFile(transformationFile);
		
		AcceleoParser parser = new AcceleoParser(project, false, true, false);
		parser.buildFile(transformationFile, new BasicMonitor());
		for(AcceleoParserProblem problem : parser.getProblems(transformationFile)) {
			String message = String.format("%s:%d:%d-%d: %s", transformationFile.getAbsolutePath(),
				problem.getLine(), problem.getPosBegin(), problem.getPosEnd(), problem.getMessage());
			LOGGER.severe(message);
		}
		for(AcceleoParserWarning warning : parser.getWarnings(transformationFile)) {
			String message = String.format("%s:%d:%d-%d: %s", transformationFile.getAbsolutePath(),
					warning.getLine(), warning.getPosBegin(), warning.getPosEnd(), warning.getMessage());
				LOGGER.severe(message);
		}
		for(AcceleoParserInfo info : parser.getInfos(transformationFile)) {
			String message = String.format("%s:%d:%d-%d: %s", transformationFile.getAbsolutePath(),
					info.getLine(), info.getPosBegin(), info.getPosEnd(), info.getMessage());
				LOGGER.severe(message);
		}
		
		ResourceSet resourceSet = new AcceleoResourceSetImpl();
		registerResourceFactories(resourceSet);
		registerPackages(resourceSet);
		
		EObject eObject = ModelUtils.load(outputFile, resourceSet);
		module = (Module)eObject;
	}
	
	public void transform(Resource resource, String generationPath) {
		File generationRoot = new File(generationPath);
		AcceleoService service = new AcceleoService();
		for(EObject eObject : resource.getContents()) {  
			service.doGenerate(module, templateName, eObject, generationRoot, null);
		}
	}
	
	/* org.eclipse.acceleo.engine.service.AbstractAcceleoGenerator */
	
	public void registerResourceFactories(ResourceSet resourceSet) {
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
		resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put(IAcceleoConstants.BINARY_CONTENT_TYPE, new EMtlBinaryResourceFactoryImpl());
		resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put(IAcceleoConstants.XMI_CONTENT_TYPE, new EMtlResourceFactoryImpl());
	}
	
	private void registerPackages(ResourceSet resourceSet) {
		resourceSet.getPackageRegistry().put(EcorePackage.eINSTANCE.getNsURI(), EcorePackage.eINSTANCE);
		resourceSet.getPackageRegistry().put(org.eclipse.ocl.ecore.EcorePackage.eINSTANCE.getNsURI(), org.eclipse.ocl.ecore.EcorePackage.eINSTANCE);
		resourceSet.getPackageRegistry().put(ExpressionsPackage.eINSTANCE.getNsURI(), ExpressionsPackage.eINSTANCE);
		resourceSet.getPackageRegistry().put(MtlPackage.eINSTANCE.getNsURI(), MtlPackage.eINSTANCE);
		resourceSet.getPackageRegistry().put("http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore", getOCLStdLibPackage());
	}
	
	private EPackage getOCLStdLibPackage() {
		EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory();
		EcoreEnvironment environment = (EcoreEnvironment)factory.createEnvironment();
		EPackage oclStdLibPackage = (EPackage)EcoreUtil.getRootContainer(environment.getOCLStandardLibrary().getBag());
		environment.dispose();
		return oclStdLibPackage;
	}

	
	
}
