/**
 */
package it.unibo.cmdb.monitoring.model.icinga;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Zone</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getEndpoints <em>Endpoints</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getParent <em>Parent</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.Zone#isGlobal <em>Global</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getElements <em>Elements</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getSubzones <em>Subzones</em>}</li>
 * </ul>
 * </p>
 *
 * @see it.unibo.cmdb.monitoring.model.icinga.IcingaPackage#getZone()
 * @model
 * @generated
 */
public interface Zone extends ConfigurationObject {
	/**
	 * Returns the value of the '<em><b>Endpoints</b></em>' reference list.
	 * The list contents are of type {@link it.unibo.cmdb.monitoring.model.icinga.Endpoint}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Endpoints</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Endpoints</em>' reference list.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IcingaPackage#getZone_Endpoints()
	 * @model
	 * @generated
	 */
	EList<Endpoint> getEndpoints();

	/**
	 * Returns the value of the '<em><b>Parent</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getSubzones <em>Subzones</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parent</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parent</em>' container reference.
	 * @see #setParent(Zone)
	 * @see it.unibo.cmdb.monitoring.model.icinga.IcingaPackage#getZone_Parent()
	 * @see it.unibo.cmdb.monitoring.model.icinga.Zone#getSubzones
	 * @model opposite="subzones" transient="false"
	 * @generated
	 */
	Zone getParent();

	/**
	 * Sets the value of the '{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getParent <em>Parent</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parent</em>' container reference.
	 * @see #getParent()
	 * @generated
	 */
	void setParent(Zone value);

	/**
	 * Returns the value of the '<em><b>Global</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Global</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Global</em>' attribute.
	 * @see #setGlobal(boolean)
	 * @see it.unibo.cmdb.monitoring.model.icinga.IcingaPackage#getZone_Global()
	 * @model
	 * @generated
	 */
	boolean isGlobal();

	/**
	 * Sets the value of the '{@link it.unibo.cmdb.monitoring.model.icinga.Zone#isGlobal <em>Global</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Global</em>' attribute.
	 * @see #isGlobal()
	 * @generated
	 */
	void setGlobal(boolean value);

	/**
	 * Returns the value of the '<em><b>Elements</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link it.unibo.cmdb.monitoring.model.icinga.ZoneElement#getZone <em>Zone</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Elements</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Elements</em>' reference.
	 * @see #setElements(ZoneElement)
	 * @see it.unibo.cmdb.monitoring.model.icinga.IcingaPackage#getZone_Elements()
	 * @see it.unibo.cmdb.monitoring.model.icinga.ZoneElement#getZone
	 * @model opposite="zone"
	 * @generated
	 */
	ZoneElement getElements();

	/**
	 * Sets the value of the '{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getElements <em>Elements</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Elements</em>' reference.
	 * @see #getElements()
	 * @generated
	 */
	void setElements(ZoneElement value);

	/**
	 * Returns the value of the '<em><b>Subzones</b></em>' containment reference list.
	 * The list contents are of type {@link it.unibo.cmdb.monitoring.model.icinga.Zone}.
	 * It is bidirectional and its opposite is '{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Subzones</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Subzones</em>' containment reference list.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IcingaPackage#getZone_Subzones()
	 * @see it.unibo.cmdb.monitoring.model.icinga.Zone#getParent
	 * @model opposite="parent" containment="true"
	 * @generated
	 */
	EList<Zone> getSubzones();

} // Zone
