/**
 */
package it.unibo.cmdb.monitoring.model.icinga.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import it.unibo.cmdb.monitoring.model.icinga.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class IcingaFactoryImpl extends EFactoryImpl implements IcingaFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static IcingaFactory init() {
		try {
			IcingaFactory theIcingaFactory = (IcingaFactory)EPackage.Registry.INSTANCE.getEFactory(IcingaPackage.eNS_URI);
			if (theIcingaFactory != null) {
				return theIcingaFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new IcingaFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IcingaFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case IcingaPackage.USER_VAR: return createUserVar();
			case IcingaPackage.SIMPLE_USER_VALUE: return createSimpleUserValue();
			case IcingaPackage.STRING_USER_VALUE: return createStringUserValue();
			case IcingaPackage.NUMERIC_USER_VALUE: return createNumericUserValue();
			case IcingaPackage.COMPLEX_USER_VALUE: return createComplexUserValue();
			case IcingaPackage.COMMAND_ARGUMENT: return createCommandArgument();
			case IcingaPackage.COMMAND_ENV: return createCommandEnv();
			case IcingaPackage.DATABASE_CLEANUP: return createDatabaseCleanup();
			case IcingaPackage.TIME_RANGE: return createTimeRange();
			case IcingaPackage.NOTIFICATION_TIMES: return createNotificationTimes();
			case IcingaPackage.CHECK_COMMAND: return createCheckCommand();
			case IcingaPackage.NOTIFICATION_COMMAND: return createNotificationCommand();
			case IcingaPackage.EVENT_COMMAND: return createEventCommand();
			case IcingaPackage.SCHEDULED_DOWNTIME: return createScheduledDowntime();
			case IcingaPackage.DEPENDENCY: return createDependency();
			case IcingaPackage.NOTIFICATION: return createNotification();
			case IcingaPackage.TIME_PERIOD: return createTimePeriod();
			case IcingaPackage.HOST: return createHost();
			case IcingaPackage.HOST_GROUP: return createHostGroup();
			case IcingaPackage.SERVICE: return createService();
			case IcingaPackage.SERVICE_GROUP: return createServiceGroup();
			case IcingaPackage.USER: return createUser();
			case IcingaPackage.USER_GROUP: return createUserGroup();
			case IcingaPackage.ZONE: return createZone();
			case IcingaPackage.ENDPOINT: return createEndpoint();
			case IcingaPackage.CHECKER_COMPONENT: return createCheckerComponent();
			case IcingaPackage.NOTIFICATION_COMPONENT: return createNotificationComponent();
			case IcingaPackage.CHECK_RESULT_READER: return createCheckResultReader();
			case IcingaPackage.API_LISTENER: return createApiListener();
			case IcingaPackage.LIVE_STATUS_LISTENER: return createLiveStatusListener();
			case IcingaPackage.EXTERNAL_COMMAND_LISTENER: return createExternalCommandListener();
			case IcingaPackage.COMPAT_LOGGER: return createCompatLogger();
			case IcingaPackage.FILE_LOGGER: return createFileLogger();
			case IcingaPackage.SYSLOG_LOGGER: return createSyslogLogger();
			case IcingaPackage.GELF_WRITER: return createGelfWriter();
			case IcingaPackage.GRAPHITE_WRITER: return createGraphiteWriter();
			case IcingaPackage.ICINGA_STATUS_WRITER: return createIcingaStatusWriter();
			case IcingaPackage.OPEN_TSDB_WRITER: return createOpenTsdbWriter();
			case IcingaPackage.PERFDATA_WRITER: return createPerfdataWriter();
			case IcingaPackage.STATUS_DATA_WRITER: return createStatusDataWriter();
			case IcingaPackage.IDO_MY_SQL_CONNECTION: return createIdoMySqlConnection();
			case IcingaPackage.IDO_PG_SQL_CONNECTION: return createIdoPgSqlConnection();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case IcingaPackage.DATABASE_CATEGORY:
				return createDatabaseCategoryFromString(eDataType, initialValue);
			case IcingaPackage.NOTIFICATION_TYPE:
				return createNotificationTypeFromString(eDataType, initialValue);
			case IcingaPackage.LOG_ROTATION_METHOD:
				return createLogRotationMethodFromString(eDataType, initialValue);
			case IcingaPackage.LOG_SEVERITY:
				return createLogSeverityFromString(eDataType, initialValue);
			case IcingaPackage.SOCKET_TYPE:
				return createSocketTypeFromString(eDataType, initialValue);
			case IcingaPackage.STATE:
				return createStateFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case IcingaPackage.DATABASE_CATEGORY:
				return convertDatabaseCategoryToString(eDataType, instanceValue);
			case IcingaPackage.NOTIFICATION_TYPE:
				return convertNotificationTypeToString(eDataType, instanceValue);
			case IcingaPackage.LOG_ROTATION_METHOD:
				return convertLogRotationMethodToString(eDataType, instanceValue);
			case IcingaPackage.LOG_SEVERITY:
				return convertLogSeverityToString(eDataType, instanceValue);
			case IcingaPackage.SOCKET_TYPE:
				return convertSocketTypeToString(eDataType, instanceValue);
			case IcingaPackage.STATE:
				return convertStateToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UserVar createUserVar() {
		UserVarImpl userVar = new UserVarImpl();
		return userVar;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public <T> SimpleUserValue<T> createSimpleUserValue() {
		SimpleUserValueImpl<T> simpleUserValue = new SimpleUserValueImpl<T>();
		return simpleUserValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StringUserValue createStringUserValue() {
		StringUserValueImpl stringUserValue = new StringUserValueImpl();
		return stringUserValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NumericUserValue createNumericUserValue() {
		NumericUserValueImpl numericUserValue = new NumericUserValueImpl();
		return numericUserValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComplexUserValue createComplexUserValue() {
		ComplexUserValueImpl complexUserValue = new ComplexUserValueImpl();
		return complexUserValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CommandArgument createCommandArgument() {
		CommandArgumentImpl commandArgument = new CommandArgumentImpl();
		return commandArgument;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CommandEnv createCommandEnv() {
		CommandEnvImpl commandEnv = new CommandEnvImpl();
		return commandEnv;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DatabaseCleanup createDatabaseCleanup() {
		DatabaseCleanupImpl databaseCleanup = new DatabaseCleanupImpl();
		return databaseCleanup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TimeRange createTimeRange() {
		TimeRangeImpl timeRange = new TimeRangeImpl();
		return timeRange;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationTimes createNotificationTimes() {
		NotificationTimesImpl notificationTimes = new NotificationTimesImpl();
		return notificationTimes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CheckCommand createCheckCommand() {
		CheckCommandImpl checkCommand = new CheckCommandImpl();
		return checkCommand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationCommand createNotificationCommand() {
		NotificationCommandImpl notificationCommand = new NotificationCommandImpl();
		return notificationCommand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EventCommand createEventCommand() {
		EventCommandImpl eventCommand = new EventCommandImpl();
		return eventCommand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ScheduledDowntime createScheduledDowntime() {
		ScheduledDowntimeImpl scheduledDowntime = new ScheduledDowntimeImpl();
		return scheduledDowntime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Dependency createDependency() {
		DependencyImpl dependency = new DependencyImpl();
		return dependency;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Notification createNotification() {
		NotificationImpl notification = new NotificationImpl();
		return notification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TimePeriod createTimePeriod() {
		TimePeriodImpl timePeriod = new TimePeriodImpl();
		return timePeriod;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Host createHost() {
		HostImpl host = new HostImpl();
		return host;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HostGroup createHostGroup() {
		HostGroupImpl hostGroup = new HostGroupImpl();
		return hostGroup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Service createService() {
		ServiceImpl service = new ServiceImpl();
		return service;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceGroup createServiceGroup() {
		ServiceGroupImpl serviceGroup = new ServiceGroupImpl();
		return serviceGroup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public User createUser() {
		UserImpl user = new UserImpl();
		return user;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UserGroup createUserGroup() {
		UserGroupImpl userGroup = new UserGroupImpl();
		return userGroup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Zone createZone() {
		ZoneImpl zone = new ZoneImpl();
		return zone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Endpoint createEndpoint() {
		EndpointImpl endpoint = new EndpointImpl();
		return endpoint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CheckerComponent createCheckerComponent() {
		CheckerComponentImpl checkerComponent = new CheckerComponentImpl();
		return checkerComponent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationComponent createNotificationComponent() {
		NotificationComponentImpl notificationComponent = new NotificationComponentImpl();
		return notificationComponent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CheckResultReader createCheckResultReader() {
		CheckResultReaderImpl checkResultReader = new CheckResultReaderImpl();
		return checkResultReader;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ApiListener createApiListener() {
		ApiListenerImpl apiListener = new ApiListenerImpl();
		return apiListener;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LiveStatusListener createLiveStatusListener() {
		LiveStatusListenerImpl liveStatusListener = new LiveStatusListenerImpl();
		return liveStatusListener;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExternalCommandListener createExternalCommandListener() {
		ExternalCommandListenerImpl externalCommandListener = new ExternalCommandListenerImpl();
		return externalCommandListener;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CompatLogger createCompatLogger() {
		CompatLoggerImpl compatLogger = new CompatLoggerImpl();
		return compatLogger;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FileLogger createFileLogger() {
		FileLoggerImpl fileLogger = new FileLoggerImpl();
		return fileLogger;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SyslogLogger createSyslogLogger() {
		SyslogLoggerImpl syslogLogger = new SyslogLoggerImpl();
		return syslogLogger;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GelfWriter createGelfWriter() {
		GelfWriterImpl gelfWriter = new GelfWriterImpl();
		return gelfWriter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GraphiteWriter createGraphiteWriter() {
		GraphiteWriterImpl graphiteWriter = new GraphiteWriterImpl();
		return graphiteWriter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IcingaStatusWriter createIcingaStatusWriter() {
		IcingaStatusWriterImpl icingaStatusWriter = new IcingaStatusWriterImpl();
		return icingaStatusWriter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OpenTsdbWriter createOpenTsdbWriter() {
		OpenTsdbWriterImpl openTsdbWriter = new OpenTsdbWriterImpl();
		return openTsdbWriter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PerfdataWriter createPerfdataWriter() {
		PerfdataWriterImpl perfdataWriter = new PerfdataWriterImpl();
		return perfdataWriter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StatusDataWriter createStatusDataWriter() {
		StatusDataWriterImpl statusDataWriter = new StatusDataWriterImpl();
		return statusDataWriter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IdoMySqlConnection createIdoMySqlConnection() {
		IdoMySqlConnectionImpl idoMySqlConnection = new IdoMySqlConnectionImpl();
		return idoMySqlConnection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IdoPgSqlConnection createIdoPgSqlConnection() {
		IdoPgSqlConnectionImpl idoPgSqlConnection = new IdoPgSqlConnectionImpl();
		return idoPgSqlConnection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DatabaseCategory createDatabaseCategoryFromString(EDataType eDataType, String initialValue) {
		DatabaseCategory result = DatabaseCategory.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDatabaseCategoryToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationType createNotificationTypeFromString(EDataType eDataType, String initialValue) {
		NotificationType result = NotificationType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertNotificationTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LogRotationMethod createLogRotationMethodFromString(EDataType eDataType, String initialValue) {
		LogRotationMethod result = LogRotationMethod.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertLogRotationMethodToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LogSeverity createLogSeverityFromString(EDataType eDataType, String initialValue) {
		LogSeverity result = LogSeverity.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertLogSeverityToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SocketType createSocketTypeFromString(EDataType eDataType, String initialValue) {
		SocketType result = SocketType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertSocketTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public State createStateFromString(EDataType eDataType, String initialValue) {
		State result = State.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertStateToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IcingaPackage getIcingaPackage() {
		return (IcingaPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static IcingaPackage getPackage() {
		return IcingaPackage.eINSTANCE;
	}

} //IcingaFactoryImpl
