/**
 */
package it.unibo.cmdb.monitoring.model.icinga.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

import it.unibo.cmdb.monitoring.model.icinga.DatabaseCategory;
import it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup;
import it.unibo.cmdb.monitoring.model.icinga.IcingaPackage;
import it.unibo.cmdb.monitoring.model.icinga.IdoConnection;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Ido Connection</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#getHost <em>Host</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#getPort <em>Port</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#getUser <em>User</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#getPassword <em>Password</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#getDatabase <em>Database</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#getTable_prefix <em>Table prefix</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#getInstance_name <em>Instance name</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#getInstance_description <em>Instance description</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#isEnable_ha <em>Enable ha</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#getFailover_timeout <em>Failover timeout</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#getCleanup <em>Cleanup</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl#getCategories <em>Categories</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class IdoConnectionImpl extends ConfigurationObjectImpl implements IdoConnection {
	/**
	 * The default value of the '{@link #getHost() <em>Host</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHost()
	 * @generated
	 * @ordered
	 */
	protected static final String HOST_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHost() <em>Host</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHost()
	 * @generated
	 * @ordered
	 */
	protected String host = HOST_EDEFAULT;

	/**
	 * The default value of the '{@link #getPort() <em>Port</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPort()
	 * @generated
	 * @ordered
	 */
	protected static final short PORT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPort() <em>Port</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPort()
	 * @generated
	 * @ordered
	 */
	protected short port = PORT_EDEFAULT;

	/**
	 * The default value of the '{@link #getUser() <em>User</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUser()
	 * @generated
	 * @ordered
	 */
	protected static final String USER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUser() <em>User</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUser()
	 * @generated
	 * @ordered
	 */
	protected String user = USER_EDEFAULT;

	/**
	 * The default value of the '{@link #getPassword() <em>Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPassword()
	 * @generated
	 * @ordered
	 */
	protected static final String PASSWORD_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPassword() <em>Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPassword()
	 * @generated
	 * @ordered
	 */
	protected String password = PASSWORD_EDEFAULT;

	/**
	 * The default value of the '{@link #getDatabase() <em>Database</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDatabase()
	 * @generated
	 * @ordered
	 */
	protected static final String DATABASE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDatabase() <em>Database</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDatabase()
	 * @generated
	 * @ordered
	 */
	protected String database = DATABASE_EDEFAULT;

	/**
	 * The default value of the '{@link #getTable_prefix() <em>Table prefix</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTable_prefix()
	 * @generated
	 * @ordered
	 */
	protected static final String TABLE_PREFIX_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTable_prefix() <em>Table prefix</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTable_prefix()
	 * @generated
	 * @ordered
	 */
	protected String table_prefix = TABLE_PREFIX_EDEFAULT;

	/**
	 * The default value of the '{@link #getInstance_name() <em>Instance name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstance_name()
	 * @generated
	 * @ordered
	 */
	protected static final String INSTANCE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getInstance_name() <em>Instance name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstance_name()
	 * @generated
	 * @ordered
	 */
	protected String instance_name = INSTANCE_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getInstance_description() <em>Instance description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstance_description()
	 * @generated
	 * @ordered
	 */
	protected static final String INSTANCE_DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getInstance_description() <em>Instance description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstance_description()
	 * @generated
	 * @ordered
	 */
	protected String instance_description = INSTANCE_DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #isEnable_ha() <em>Enable ha</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_ha()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ENABLE_HA_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isEnable_ha() <em>Enable ha</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_ha()
	 * @generated
	 * @ordered
	 */
	protected boolean enable_ha = ENABLE_HA_EDEFAULT;

	/**
	 * The default value of the '{@link #getFailover_timeout() <em>Failover timeout</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFailover_timeout()
	 * @generated
	 * @ordered
	 */
	protected static final String FAILOVER_TIMEOUT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFailover_timeout() <em>Failover timeout</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFailover_timeout()
	 * @generated
	 * @ordered
	 */
	protected String failover_timeout = FAILOVER_TIMEOUT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCleanup() <em>Cleanup</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCleanup()
	 * @generated
	 * @ordered
	 */
	protected DatabaseCleanup cleanup;

	/**
	 * The cached value of the '{@link #getCategories() <em>Categories</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCategories()
	 * @generated
	 * @ordered
	 */
	protected EList<DatabaseCategory> categories;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdoConnectionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IcingaPackage.Literals.IDO_CONNECTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getHost() {
		return host;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHost(String newHost) {
		String oldHost = host;
		host = newHost;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__HOST, oldHost, host));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getPort() {
		return port;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPort(short newPort) {
		short oldPort = port;
		port = newPort;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__PORT, oldPort, port));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUser() {
		return user;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUser(String newUser) {
		String oldUser = user;
		user = newUser;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__USER, oldUser, user));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPassword(String newPassword) {
		String oldPassword = password;
		password = newPassword;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__PASSWORD, oldPassword, password));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDatabase() {
		return database;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDatabase(String newDatabase) {
		String oldDatabase = database;
		database = newDatabase;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__DATABASE, oldDatabase, database));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTable_prefix() {
		return table_prefix;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTable_prefix(String newTable_prefix) {
		String oldTable_prefix = table_prefix;
		table_prefix = newTable_prefix;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__TABLE_PREFIX, oldTable_prefix, table_prefix));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getInstance_name() {
		return instance_name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInstance_name(String newInstance_name) {
		String oldInstance_name = instance_name;
		instance_name = newInstance_name;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__INSTANCE_NAME, oldInstance_name, instance_name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getInstance_description() {
		return instance_description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInstance_description(String newInstance_description) {
		String oldInstance_description = instance_description;
		instance_description = newInstance_description;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__INSTANCE_DESCRIPTION, oldInstance_description, instance_description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isEnable_ha() {
		return enable_ha;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnable_ha(boolean newEnable_ha) {
		boolean oldEnable_ha = enable_ha;
		enable_ha = newEnable_ha;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__ENABLE_HA, oldEnable_ha, enable_ha));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getFailover_timeout() {
		return failover_timeout;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFailover_timeout(String newFailover_timeout) {
		String oldFailover_timeout = failover_timeout;
		failover_timeout = newFailover_timeout;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__FAILOVER_TIMEOUT, oldFailover_timeout, failover_timeout));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DatabaseCleanup getCleanup() {
		return cleanup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCleanup(DatabaseCleanup newCleanup, NotificationChain msgs) {
		DatabaseCleanup oldCleanup = cleanup;
		cleanup = newCleanup;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__CLEANUP, oldCleanup, newCleanup);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCleanup(DatabaseCleanup newCleanup) {
		if (newCleanup != cleanup) {
			NotificationChain msgs = null;
			if (cleanup != null)
				msgs = ((InternalEObject)cleanup).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - IcingaPackage.IDO_CONNECTION__CLEANUP, null, msgs);
			if (newCleanup != null)
				msgs = ((InternalEObject)newCleanup).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - IcingaPackage.IDO_CONNECTION__CLEANUP, null, msgs);
			msgs = basicSetCleanup(newCleanup, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.IDO_CONNECTION__CLEANUP, newCleanup, newCleanup));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<DatabaseCategory> getCategories() {
		if (categories == null) {
			categories = new EDataTypeUniqueEList<DatabaseCategory>(DatabaseCategory.class, this, IcingaPackage.IDO_CONNECTION__CATEGORIES);
		}
		return categories;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IcingaPackage.IDO_CONNECTION__CLEANUP:
				return basicSetCleanup(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IcingaPackage.IDO_CONNECTION__HOST:
				return getHost();
			case IcingaPackage.IDO_CONNECTION__PORT:
				return getPort();
			case IcingaPackage.IDO_CONNECTION__USER:
				return getUser();
			case IcingaPackage.IDO_CONNECTION__PASSWORD:
				return getPassword();
			case IcingaPackage.IDO_CONNECTION__DATABASE:
				return getDatabase();
			case IcingaPackage.IDO_CONNECTION__TABLE_PREFIX:
				return getTable_prefix();
			case IcingaPackage.IDO_CONNECTION__INSTANCE_NAME:
				return getInstance_name();
			case IcingaPackage.IDO_CONNECTION__INSTANCE_DESCRIPTION:
				return getInstance_description();
			case IcingaPackage.IDO_CONNECTION__ENABLE_HA:
				return isEnable_ha();
			case IcingaPackage.IDO_CONNECTION__FAILOVER_TIMEOUT:
				return getFailover_timeout();
			case IcingaPackage.IDO_CONNECTION__CLEANUP:
				return getCleanup();
			case IcingaPackage.IDO_CONNECTION__CATEGORIES:
				return getCategories();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IcingaPackage.IDO_CONNECTION__HOST:
				setHost((String)newValue);
				return;
			case IcingaPackage.IDO_CONNECTION__PORT:
				setPort((Short)newValue);
				return;
			case IcingaPackage.IDO_CONNECTION__USER:
				setUser((String)newValue);
				return;
			case IcingaPackage.IDO_CONNECTION__PASSWORD:
				setPassword((String)newValue);
				return;
			case IcingaPackage.IDO_CONNECTION__DATABASE:
				setDatabase((String)newValue);
				return;
			case IcingaPackage.IDO_CONNECTION__TABLE_PREFIX:
				setTable_prefix((String)newValue);
				return;
			case IcingaPackage.IDO_CONNECTION__INSTANCE_NAME:
				setInstance_name((String)newValue);
				return;
			case IcingaPackage.IDO_CONNECTION__INSTANCE_DESCRIPTION:
				setInstance_description((String)newValue);
				return;
			case IcingaPackage.IDO_CONNECTION__ENABLE_HA:
				setEnable_ha((Boolean)newValue);
				return;
			case IcingaPackage.IDO_CONNECTION__FAILOVER_TIMEOUT:
				setFailover_timeout((String)newValue);
				return;
			case IcingaPackage.IDO_CONNECTION__CLEANUP:
				setCleanup((DatabaseCleanup)newValue);
				return;
			case IcingaPackage.IDO_CONNECTION__CATEGORIES:
				getCategories().clear();
				getCategories().addAll((Collection<? extends DatabaseCategory>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IcingaPackage.IDO_CONNECTION__HOST:
				setHost(HOST_EDEFAULT);
				return;
			case IcingaPackage.IDO_CONNECTION__PORT:
				setPort(PORT_EDEFAULT);
				return;
			case IcingaPackage.IDO_CONNECTION__USER:
				setUser(USER_EDEFAULT);
				return;
			case IcingaPackage.IDO_CONNECTION__PASSWORD:
				setPassword(PASSWORD_EDEFAULT);
				return;
			case IcingaPackage.IDO_CONNECTION__DATABASE:
				setDatabase(DATABASE_EDEFAULT);
				return;
			case IcingaPackage.IDO_CONNECTION__TABLE_PREFIX:
				setTable_prefix(TABLE_PREFIX_EDEFAULT);
				return;
			case IcingaPackage.IDO_CONNECTION__INSTANCE_NAME:
				setInstance_name(INSTANCE_NAME_EDEFAULT);
				return;
			case IcingaPackage.IDO_CONNECTION__INSTANCE_DESCRIPTION:
				setInstance_description(INSTANCE_DESCRIPTION_EDEFAULT);
				return;
			case IcingaPackage.IDO_CONNECTION__ENABLE_HA:
				setEnable_ha(ENABLE_HA_EDEFAULT);
				return;
			case IcingaPackage.IDO_CONNECTION__FAILOVER_TIMEOUT:
				setFailover_timeout(FAILOVER_TIMEOUT_EDEFAULT);
				return;
			case IcingaPackage.IDO_CONNECTION__CLEANUP:
				setCleanup((DatabaseCleanup)null);
				return;
			case IcingaPackage.IDO_CONNECTION__CATEGORIES:
				getCategories().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IcingaPackage.IDO_CONNECTION__HOST:
				return HOST_EDEFAULT == null ? host != null : !HOST_EDEFAULT.equals(host);
			case IcingaPackage.IDO_CONNECTION__PORT:
				return port != PORT_EDEFAULT;
			case IcingaPackage.IDO_CONNECTION__USER:
				return USER_EDEFAULT == null ? user != null : !USER_EDEFAULT.equals(user);
			case IcingaPackage.IDO_CONNECTION__PASSWORD:
				return PASSWORD_EDEFAULT == null ? password != null : !PASSWORD_EDEFAULT.equals(password);
			case IcingaPackage.IDO_CONNECTION__DATABASE:
				return DATABASE_EDEFAULT == null ? database != null : !DATABASE_EDEFAULT.equals(database);
			case IcingaPackage.IDO_CONNECTION__TABLE_PREFIX:
				return TABLE_PREFIX_EDEFAULT == null ? table_prefix != null : !TABLE_PREFIX_EDEFAULT.equals(table_prefix);
			case IcingaPackage.IDO_CONNECTION__INSTANCE_NAME:
				return INSTANCE_NAME_EDEFAULT == null ? instance_name != null : !INSTANCE_NAME_EDEFAULT.equals(instance_name);
			case IcingaPackage.IDO_CONNECTION__INSTANCE_DESCRIPTION:
				return INSTANCE_DESCRIPTION_EDEFAULT == null ? instance_description != null : !INSTANCE_DESCRIPTION_EDEFAULT.equals(instance_description);
			case IcingaPackage.IDO_CONNECTION__ENABLE_HA:
				return enable_ha != ENABLE_HA_EDEFAULT;
			case IcingaPackage.IDO_CONNECTION__FAILOVER_TIMEOUT:
				return FAILOVER_TIMEOUT_EDEFAULT == null ? failover_timeout != null : !FAILOVER_TIMEOUT_EDEFAULT.equals(failover_timeout);
			case IcingaPackage.IDO_CONNECTION__CLEANUP:
				return cleanup != null;
			case IcingaPackage.IDO_CONNECTION__CATEGORIES:
				return categories != null && !categories.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (host: ");
		result.append(host);
		result.append(", port: ");
		result.append(port);
		result.append(", user: ");
		result.append(user);
		result.append(", password: ");
		result.append(password);
		result.append(", database: ");
		result.append(database);
		result.append(", table_prefix: ");
		result.append(table_prefix);
		result.append(", instance_name: ");
		result.append(instance_name);
		result.append(", instance_description: ");
		result.append(instance_description);
		result.append(", enable_ha: ");
		result.append(enable_ha);
		result.append(", failover_timeout: ");
		result.append(failover_timeout);
		result.append(", categories: ");
		result.append(categories);
		result.append(')');
		return result.toString();
	}

} //IdoConnectionImpl
