/**
 */
package it.unibo.cmdb.monitoring.model.icinga.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import it.unibo.cmdb.monitoring.model.icinga.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see it.unibo.cmdb.monitoring.model.icinga.IcingaPackage
 * @generated
 */
public class IcingaSwitch<T1> extends Switch<T1> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static IcingaPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IcingaSwitch() {
		if (modelPackage == null) {
			modelPackage = IcingaPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @parameter ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T1 doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case IcingaPackage.USER_VAR: {
				UserVar userVar = (UserVar)theEObject;
				T1 result = caseUserVar(userVar);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.USER_VALUE: {
				UserValue userValue = (UserValue)theEObject;
				T1 result = caseUserValue(userValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.SIMPLE_USER_VALUE: {
				SimpleUserValue<?> simpleUserValue = (SimpleUserValue<?>)theEObject;
				T1 result = caseSimpleUserValue(simpleUserValue);
				if (result == null) result = caseUserValue(simpleUserValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.STRING_USER_VALUE: {
				StringUserValue stringUserValue = (StringUserValue)theEObject;
				T1 result = caseStringUserValue(stringUserValue);
				if (result == null) result = caseSimpleUserValue(stringUserValue);
				if (result == null) result = caseUserValue(stringUserValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.NUMERIC_USER_VALUE: {
				NumericUserValue numericUserValue = (NumericUserValue)theEObject;
				T1 result = caseNumericUserValue(numericUserValue);
				if (result == null) result = caseSimpleUserValue(numericUserValue);
				if (result == null) result = caseUserValue(numericUserValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.COMPLEX_USER_VALUE: {
				ComplexUserValue complexUserValue = (ComplexUserValue)theEObject;
				T1 result = caseComplexUserValue(complexUserValue);
				if (result == null) result = caseUserValue(complexUserValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.COMMAND_ARGUMENT: {
				CommandArgument commandArgument = (CommandArgument)theEObject;
				T1 result = caseCommandArgument(commandArgument);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.COMMAND_ENV: {
				CommandEnv commandEnv = (CommandEnv)theEObject;
				T1 result = caseCommandEnv(commandEnv);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.DATABASE_CLEANUP: {
				DatabaseCleanup databaseCleanup = (DatabaseCleanup)theEObject;
				T1 result = caseDatabaseCleanup(databaseCleanup);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.TIME_RANGE: {
				TimeRange timeRange = (TimeRange)theEObject;
				T1 result = caseTimeRange(timeRange);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.NOTIFICATION_TIMES: {
				NotificationTimes notificationTimes = (NotificationTimes)theEObject;
				T1 result = caseNotificationTimes(notificationTimes);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.CHECKABLE: {
				Checkable checkable = (Checkable)theEObject;
				T1 result = caseCheckable(checkable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.ZONE_ELEMENT: {
				ZoneElement zoneElement = (ZoneElement)theEObject;
				T1 result = caseZoneElement(zoneElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.CONFIGURATION_OBJECT: {
				ConfigurationObject configurationObject = (ConfigurationObject)theEObject;
				T1 result = caseConfigurationObject(configurationObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.COMMAND: {
				Command command = (Command)theEObject;
				T1 result = caseCommand(command);
				if (result == null) result = caseConfigurationObject(command);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.CHECK_COMMAND: {
				CheckCommand checkCommand = (CheckCommand)theEObject;
				T1 result = caseCheckCommand(checkCommand);
				if (result == null) result = caseCommand(checkCommand);
				if (result == null) result = caseZoneElement(checkCommand);
				if (result == null) result = caseConfigurationObject(checkCommand);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.NOTIFICATION_COMMAND: {
				NotificationCommand notificationCommand = (NotificationCommand)theEObject;
				T1 result = caseNotificationCommand(notificationCommand);
				if (result == null) result = caseCommand(notificationCommand);
				if (result == null) result = caseZoneElement(notificationCommand);
				if (result == null) result = caseConfigurationObject(notificationCommand);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.EVENT_COMMAND: {
				EventCommand eventCommand = (EventCommand)theEObject;
				T1 result = caseEventCommand(eventCommand);
				if (result == null) result = caseCommand(eventCommand);
				if (result == null) result = caseConfigurationObject(eventCommand);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.SCHEDULED_DOWNTIME: {
				ScheduledDowntime scheduledDowntime = (ScheduledDowntime)theEObject;
				T1 result = caseScheduledDowntime(scheduledDowntime);
				if (result == null) result = caseConfigurationObject(scheduledDowntime);
				if (result == null) result = caseZoneElement(scheduledDowntime);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.DEPENDENCY: {
				Dependency dependency = (Dependency)theEObject;
				T1 result = caseDependency(dependency);
				if (result == null) result = caseConfigurationObject(dependency);
				if (result == null) result = caseZoneElement(dependency);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.NOTIFICATION: {
				Notification notification = (Notification)theEObject;
				T1 result = caseNotification(notification);
				if (result == null) result = caseConfigurationObject(notification);
				if (result == null) result = caseZoneElement(notification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.TIME_PERIOD: {
				TimePeriod timePeriod = (TimePeriod)theEObject;
				T1 result = caseTimePeriod(timePeriod);
				if (result == null) result = caseConfigurationObject(timePeriod);
				if (result == null) result = caseZoneElement(timePeriod);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.HOST: {
				Host host = (Host)theEObject;
				T1 result = caseHost(host);
				if (result == null) result = caseConfigurationObject(host);
				if (result == null) result = caseCheckable(host);
				if (result == null) result = caseZoneElement(host);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.HOST_GROUP: {
				HostGroup hostGroup = (HostGroup)theEObject;
				T1 result = caseHostGroup(hostGroup);
				if (result == null) result = caseConfigurationObject(hostGroup);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.SERVICE: {
				Service service = (Service)theEObject;
				T1 result = caseService(service);
				if (result == null) result = caseConfigurationObject(service);
				if (result == null) result = caseCheckable(service);
				if (result == null) result = caseZoneElement(service);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.SERVICE_GROUP: {
				ServiceGroup serviceGroup = (ServiceGroup)theEObject;
				T1 result = caseServiceGroup(serviceGroup);
				if (result == null) result = caseConfigurationObject(serviceGroup);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.USER: {
				User user = (User)theEObject;
				T1 result = caseUser(user);
				if (result == null) result = caseConfigurationObject(user);
				if (result == null) result = caseZoneElement(user);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.USER_GROUP: {
				UserGroup userGroup = (UserGroup)theEObject;
				T1 result = caseUserGroup(userGroup);
				if (result == null) result = caseConfigurationObject(userGroup);
				if (result == null) result = caseZoneElement(userGroup);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.ZONE: {
				Zone zone = (Zone)theEObject;
				T1 result = caseZone(zone);
				if (result == null) result = caseConfigurationObject(zone);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.ENDPOINT: {
				Endpoint endpoint = (Endpoint)theEObject;
				T1 result = caseEndpoint(endpoint);
				if (result == null) result = caseConfigurationObject(endpoint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.CHECKER_COMPONENT: {
				CheckerComponent checkerComponent = (CheckerComponent)theEObject;
				T1 result = caseCheckerComponent(checkerComponent);
				if (result == null) result = caseConfigurationObject(checkerComponent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.NOTIFICATION_COMPONENT: {
				NotificationComponent notificationComponent = (NotificationComponent)theEObject;
				T1 result = caseNotificationComponent(notificationComponent);
				if (result == null) result = caseConfigurationObject(notificationComponent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.CHECK_RESULT_READER: {
				CheckResultReader checkResultReader = (CheckResultReader)theEObject;
				T1 result = caseCheckResultReader(checkResultReader);
				if (result == null) result = caseConfigurationObject(checkResultReader);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.API_LISTENER: {
				ApiListener apiListener = (ApiListener)theEObject;
				T1 result = caseApiListener(apiListener);
				if (result == null) result = caseConfigurationObject(apiListener);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.LIVE_STATUS_LISTENER: {
				LiveStatusListener liveStatusListener = (LiveStatusListener)theEObject;
				T1 result = caseLiveStatusListener(liveStatusListener);
				if (result == null) result = caseConfigurationObject(liveStatusListener);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.EXTERNAL_COMMAND_LISTENER: {
				ExternalCommandListener externalCommandListener = (ExternalCommandListener)theEObject;
				T1 result = caseExternalCommandListener(externalCommandListener);
				if (result == null) result = caseConfigurationObject(externalCommandListener);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.COMPAT_LOGGER: {
				CompatLogger compatLogger = (CompatLogger)theEObject;
				T1 result = caseCompatLogger(compatLogger);
				if (result == null) result = caseConfigurationObject(compatLogger);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.FILE_LOGGER: {
				FileLogger fileLogger = (FileLogger)theEObject;
				T1 result = caseFileLogger(fileLogger);
				if (result == null) result = caseConfigurationObject(fileLogger);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.SYSLOG_LOGGER: {
				SyslogLogger syslogLogger = (SyslogLogger)theEObject;
				T1 result = caseSyslogLogger(syslogLogger);
				if (result == null) result = caseConfigurationObject(syslogLogger);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.GELF_WRITER: {
				GelfWriter gelfWriter = (GelfWriter)theEObject;
				T1 result = caseGelfWriter(gelfWriter);
				if (result == null) result = caseConfigurationObject(gelfWriter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.GRAPHITE_WRITER: {
				GraphiteWriter graphiteWriter = (GraphiteWriter)theEObject;
				T1 result = caseGraphiteWriter(graphiteWriter);
				if (result == null) result = caseConfigurationObject(graphiteWriter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.ICINGA_STATUS_WRITER: {
				IcingaStatusWriter icingaStatusWriter = (IcingaStatusWriter)theEObject;
				T1 result = caseIcingaStatusWriter(icingaStatusWriter);
				if (result == null) result = caseConfigurationObject(icingaStatusWriter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.OPEN_TSDB_WRITER: {
				OpenTsdbWriter openTsdbWriter = (OpenTsdbWriter)theEObject;
				T1 result = caseOpenTsdbWriter(openTsdbWriter);
				if (result == null) result = caseConfigurationObject(openTsdbWriter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.PERFDATA_WRITER: {
				PerfdataWriter perfdataWriter = (PerfdataWriter)theEObject;
				T1 result = casePerfdataWriter(perfdataWriter);
				if (result == null) result = caseConfigurationObject(perfdataWriter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.STATUS_DATA_WRITER: {
				StatusDataWriter statusDataWriter = (StatusDataWriter)theEObject;
				T1 result = caseStatusDataWriter(statusDataWriter);
				if (result == null) result = caseConfigurationObject(statusDataWriter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.IDO_CONNECTION: {
				IdoConnection idoConnection = (IdoConnection)theEObject;
				T1 result = caseIdoConnection(idoConnection);
				if (result == null) result = caseConfigurationObject(idoConnection);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.IDO_MY_SQL_CONNECTION: {
				IdoMySqlConnection idoMySqlConnection = (IdoMySqlConnection)theEObject;
				T1 result = caseIdoMySqlConnection(idoMySqlConnection);
				if (result == null) result = caseIdoConnection(idoMySqlConnection);
				if (result == null) result = caseConfigurationObject(idoMySqlConnection);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IcingaPackage.IDO_PG_SQL_CONNECTION: {
				IdoPgSqlConnection idoPgSqlConnection = (IdoPgSqlConnection)theEObject;
				T1 result = caseIdoPgSqlConnection(idoPgSqlConnection);
				if (result == null) result = caseIdoConnection(idoPgSqlConnection);
				if (result == null) result = caseConfigurationObject(idoPgSqlConnection);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>User Var</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>User Var</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseUserVar(UserVar object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>User Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>User Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseUserValue(UserValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Simple User Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Simple User Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public <T> T1 caseSimpleUserValue(SimpleUserValue<T> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>String User Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>String User Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStringUserValue(StringUserValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Numeric User Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Numeric User Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseNumericUserValue(NumericUserValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Complex User Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Complex User Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseComplexUserValue(ComplexUserValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Command Argument</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Command Argument</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseCommandArgument(CommandArgument object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Command Env</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Command Env</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseCommandEnv(CommandEnv object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Database Cleanup</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Database Cleanup</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDatabaseCleanup(DatabaseCleanup object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Time Range</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Time Range</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseTimeRange(TimeRange object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Notification Times</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Notification Times</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseNotificationTimes(NotificationTimes object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Checkable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Checkable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseCheckable(Checkable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zone Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zone Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseZoneElement(ZoneElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Configuration Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Configuration Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseConfigurationObject(ConfigurationObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Command</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Command</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseCommand(Command object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Check Command</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Check Command</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseCheckCommand(CheckCommand object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Notification Command</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Notification Command</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseNotificationCommand(NotificationCommand object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event Command</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event Command</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseEventCommand(EventCommand object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Scheduled Downtime</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Scheduled Downtime</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseScheduledDowntime(ScheduledDowntime object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Dependency</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Dependency</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDependency(Dependency object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Notification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Notification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseNotification(Notification object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Time Period</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Time Period</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseTimePeriod(TimePeriod object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Host</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Host</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseHost(Host object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Host Group</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Host Group</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseHostGroup(HostGroup object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Service</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Service</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseService(Service object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Service Group</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Service Group</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseServiceGroup(ServiceGroup object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>User</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>User</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseUser(User object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>User Group</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>User Group</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseUserGroup(UserGroup object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zone</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zone</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseZone(Zone object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Endpoint</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Endpoint</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseEndpoint(Endpoint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Checker Component</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Checker Component</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseCheckerComponent(CheckerComponent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Notification Component</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Notification Component</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseNotificationComponent(NotificationComponent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Check Result Reader</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Check Result Reader</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseCheckResultReader(CheckResultReader object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Api Listener</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Api Listener</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseApiListener(ApiListener object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Live Status Listener</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Live Status Listener</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseLiveStatusListener(LiveStatusListener object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Command Listener</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Command Listener</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseExternalCommandListener(ExternalCommandListener object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Compat Logger</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Compat Logger</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseCompatLogger(CompatLogger object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>File Logger</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>File Logger</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseFileLogger(FileLogger object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Syslog Logger</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Syslog Logger</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSyslogLogger(SyslogLogger object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Gelf Writer</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Gelf Writer</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseGelfWriter(GelfWriter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Graphite Writer</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Graphite Writer</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseGraphiteWriter(GraphiteWriter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Status Writer</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Status Writer</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseIcingaStatusWriter(IcingaStatusWriter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Open Tsdb Writer</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Open Tsdb Writer</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseOpenTsdbWriter(OpenTsdbWriter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Perfdata Writer</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Perfdata Writer</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 casePerfdataWriter(PerfdataWriter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Status Data Writer</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Status Data Writer</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStatusDataWriter(StatusDataWriter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ido Connection</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ido Connection</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseIdoConnection(IdoConnection object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ido My Sql Connection</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ido My Sql Connection</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseIdoMySqlConnection(IdoMySqlConnection object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ido Pg Sql Connection</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ido Pg Sql Connection</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseIdoPgSqlConnection(IdoPgSqlConnection object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T1 defaultCase(EObject object) {
		return null;
	}

} //IcingaSwitch
