package it.unibo.cmdbuild.nagios;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;

public class ScpClient {

	private class ScpUserInfo implements UserInfo {
		private String password;

		public ScpUserInfo(String password) {
			this.password = password;
		}

		public void showMessage(String message) {
			System.err.println(message);
		}

		public boolean promptYesNo(String message) {
			System.err.println(message);
			return true;
		}

		public boolean promptPassword(String message) {
			System.err.println(message);
			return true;
		}

		public boolean promptPassphrase(String message) {
			System.err.println(message);
			return true;
		}

		public String getPassword() {
			return password;
		}

		public String getPassphrase() {
			return password;
		}
	};
	
	private class ScpLogger implements Logger {

		public boolean isEnabled(int level) {
			return true;
		}

		public void log(int level, String message) {
			System.err.println(message);
		}

	}

	private JSch jsch;
	
	public ScpClient() throws JSchException {
		JSch.setLogger(new ScpLogger());
		jsch = new JSch();
	}
	
	public void addIdentity(String path) throws JSchException {
		jsch.addIdentity(path);
	}

	public void write(String content, String target) throws IOException, JSchException {
		String user = target.substring(0, target.indexOf('@'));
	    target = target.substring(target.indexOf('@')+1);
	    String host = target.substring(0, target.indexOf(':'));
	    String file = target.substring(target.indexOf(':')+1);
		
		Session session  = jsch.getSession(user, host, 22);
		session.setUserInfo(new ScpUserInfo(null));
		session.connect();

		try {
			StringBuffer message = new StringBuffer();

			// exec 'scp -t rfile' remotely
			String command = "scp " + " -t " + file;
			Channel channel = session.openChannel("exec");

			try {
				((ChannelExec) channel).setCommand(command);

				// get I/O streams for remote scp
				OutputStream out = channel.getOutputStream();
				InputStream in = channel.getInputStream();

				try {
					channel.connect();
					if (checkAck(in, message) != 0)
						throw new JSchException(message.toString());

					byte[] bytes = content.getBytes("US-ASCII");

					// send "C0664 filesize filename", where filename should not
					// include '/'
					long filesize = bytes.length;
					command = "C0664 " + filesize + " ";
					if (file.lastIndexOf('/') > 0)
						command += file.substring(file.lastIndexOf('/') + 1);
					else
						command += file;
					command += "\n";
					out.write(command.getBytes());
					out.flush();
					if (checkAck(in, message) != 0)
						throw new JSchException(message.toString());

					// send a content of lfile
					out.write(bytes);

					// send '\0'
					out.write(new byte[] { 0 });
					out.flush();
					if (checkAck(in, message) != 0)
						throw new JSchException(message.toString());
				} finally {
					out.close();
					in.close();
				}
			} finally {
				channel.disconnect();
			}
		} finally {
			session.disconnect();
		}
	}

	private int checkAck(InputStream in, StringBuffer message)
			throws IOException {
		// b may be 0 for success,
		// 1 for error,
		// 2 for fatal error,
		// -1
		int b = in.read();
		if (b == 1 || b == 2) {
			int c;
			do {
				c = in.read();
				message.append((char) c);
			} while (c != '\n');
		}
		return b;
	}
}