/**
 */
package org.cmdbuild.monitoring.model.monitoring;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.cmdbuild.monitoring.model.monitoring.MonitoringFactory
 * @model kind="package"
 * @generated
 */
public interface MonitoringPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "monitoring";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.cmdbuild.org/monitoring";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "monitoring";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	MonitoringPackage eINSTANCE = org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.ComponentGroupImpl <em>Component Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.ComponentGroupImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getComponentGroup()
	 * @generated
	 */
	int COMPONENT_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_GROUP__MEMBER = 0;

	/**
	 * The number of structural features of the '<em>Component Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_GROUP_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Component Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_GROUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.ComponentImpl <em>Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.ComponentImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getComponent()
	 * @generated
	 */
	int COMPONENT = 1;

	/**
	 * The feature id for the '<em><b>Host</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__HOST = 0;

	/**
	 * The feature id for the '<em><b>Dependency</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__DEPENDENCY = 1;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__PROPERTY = 2;

	/**
	 * The number of structural features of the '<em>Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.DeviceImpl <em>Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.DeviceImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getDevice()
	 * @generated
	 */
	int DEVICE = 2;

	/**
	 * The feature id for the '<em><b>Host</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__HOST = COMPONENT__HOST;

	/**
	 * The feature id for the '<em><b>Dependency</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__DEPENDENCY = COMPONENT__DEPENDENCY;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__PROPERTY = COMPONENT__PROPERTY;

	/**
	 * The feature id for the '<em><b>Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE__ADDRESS = COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_FEATURE_COUNT = COMPONENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_OPERATION_COUNT = COMPONENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.ClusterImpl <em>Cluster</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.ClusterImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getCluster()
	 * @generated
	 */
	int CLUSTER = 3;

	/**
	 * The feature id for the '<em><b>Host</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLUSTER__HOST = COMPONENT__HOST;

	/**
	 * The feature id for the '<em><b>Dependency</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLUSTER__DEPENDENCY = COMPONENT__DEPENDENCY;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLUSTER__PROPERTY = COMPONENT__PROPERTY;

	/**
	 * The feature id for the '<em><b>Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLUSTER__MEMBER = COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Cluster</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLUSTER_FEATURE_COUNT = COMPONENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Cluster</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLUSTER_OPERATION_COUNT = COMPONENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.PropertyImpl <em>Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.PropertyImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getProperty()
	 * @generated
	 */
	int PROPERTY = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.TemplateImpl <em>Template</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.TemplateImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getTemplate()
	 * @generated
	 */
	int TEMPLATE = 5;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE__PARENT = 0;

	/**
	 * The feature id for the '<em><b>Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE__CHECK = 1;

	/**
	 * The feature id for the '<em><b>Notification</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE__NOTIFICATION = 2;

	/**
	 * The number of structural features of the '<em>Template</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Template</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.CheckImpl <em>Check</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.CheckImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getCheck()
	 * @generated
	 */
	int CHECK = 6;

	/**
	 * The number of structural features of the '<em>Check</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Check</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.NotificationImpl <em>Notification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.NotificationImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getNotification()
	 * @generated
	 */
	int NOTIFICATION = 7;

	/**
	 * The feature id for the '<em><b>Group</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__GROUP = 0;

	/**
	 * The number of structural features of the '<em>Notification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Notification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.UserGroupImpl <em>User Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.UserGroupImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getUserGroup()
	 * @generated
	 */
	int USER_GROUP = 8;

	/**
	 * The feature id for the '<em><b>Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_GROUP__MEMBER = 0;

	/**
	 * The number of structural features of the '<em>User Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_GROUP_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>User Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_GROUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.UserImpl <em>User</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.UserImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getUser()
	 * @generated
	 */
	int USER = 9;

	/**
	 * The number of structural features of the '<em>User</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>User</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.DiagramImpl <em>Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.DiagramImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getDiagram()
	 * @generated
	 */
	int DIAGRAM = 10;

	/**
	 * The feature id for the '<em><b>Component</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIAGRAM__COMPONENT = 0;

	/**
	 * The number of structural features of the '<em>Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.ComponentPositionImpl <em>Component Position</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.ComponentPositionImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getComponentPosition()
	 * @generated
	 */
	int COMPONENT_POSITION = 11;

	/**
	 * The feature id for the '<em><b>Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_POSITION__COMPONENT = 0;

	/**
	 * The feature id for the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_POSITION__X = 1;

	/**
	 * The feature id for the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_POSITION__Y = 2;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_POSITION__WIDTH = 3;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_POSITION__HEIGHT = 4;

	/**
	 * The number of structural features of the '<em>Component Position</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_POSITION_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Component Position</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_POSITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.MonitoringModelImpl <em>Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringModelImpl
	 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getMonitoringModel()
	 * @generated
	 */
	int MONITORING_MODEL = 12;

	/**
	 * The feature id for the '<em><b>Component</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MONITORING_MODEL__COMPONENT = 0;

	/**
	 * The feature id for the '<em><b>Component Group</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MONITORING_MODEL__COMPONENT_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Template</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MONITORING_MODEL__TEMPLATE = 2;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MONITORING_MODEL__DIAGRAM = 3;

	/**
	 * The feature id for the '<em><b>User</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MONITORING_MODEL__USER = 4;

	/**
	 * The feature id for the '<em><b>User Group</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MONITORING_MODEL__USER_GROUP = 5;

	/**
	 * The number of structural features of the '<em>Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MONITORING_MODEL_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MONITORING_MODEL_OPERATION_COUNT = 0;


	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.ComponentGroup <em>Component Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Group</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.ComponentGroup
	 * @generated
	 */
	EClass getComponentGroup();

	/**
	 * Returns the meta object for the reference list '{@link org.cmdbuild.monitoring.model.monitoring.ComponentGroup#getMember <em>Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Member</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.ComponentGroup#getMember()
	 * @see #getComponentGroup()
	 * @generated
	 */
	EReference getComponentGroup_Member();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.Component <em>Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Component
	 * @generated
	 */
	EClass getComponent();

	/**
	 * Returns the meta object for the reference '{@link org.cmdbuild.monitoring.model.monitoring.Component#getHost <em>Host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Host</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Component#getHost()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_Host();

	/**
	 * Returns the meta object for the reference list '{@link org.cmdbuild.monitoring.model.monitoring.Component#getDependency <em>Dependency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Dependency</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Component#getDependency()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_Dependency();

	/**
	 * Returns the meta object for the containment reference list '{@link org.cmdbuild.monitoring.model.monitoring.Component#getProperty <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Property</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Component#getProperty()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_Property();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.Device <em>Device</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Device</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Device
	 * @generated
	 */
	EClass getDevice();

	/**
	 * Returns the meta object for the attribute '{@link org.cmdbuild.monitoring.model.monitoring.Device#getAddress <em>Address</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Address</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Device#getAddress()
	 * @see #getDevice()
	 * @generated
	 */
	EAttribute getDevice_Address();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.Cluster <em>Cluster</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cluster</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Cluster
	 * @generated
	 */
	EClass getCluster();

	/**
	 * Returns the meta object for the reference list '{@link org.cmdbuild.monitoring.model.monitoring.Cluster#getMember <em>Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Member</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Cluster#getMember()
	 * @see #getCluster()
	 * @generated
	 */
	EReference getCluster_Member();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.Property <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Property
	 * @generated
	 */
	EClass getProperty();

	/**
	 * Returns the meta object for the attribute '{@link org.cmdbuild.monitoring.model.monitoring.Property#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Property#getName()
	 * @see #getProperty()
	 * @generated
	 */
	EAttribute getProperty_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.cmdbuild.monitoring.model.monitoring.Property#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Property#getValue()
	 * @see #getProperty()
	 * @generated
	 */
	EAttribute getProperty_Value();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.Template <em>Template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Template</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Template
	 * @generated
	 */
	EClass getTemplate();

	/**
	 * Returns the meta object for the reference list '{@link org.cmdbuild.monitoring.model.monitoring.Template#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Parent</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Template#getParent()
	 * @see #getTemplate()
	 * @generated
	 */
	EReference getTemplate_Parent();

	/**
	 * Returns the meta object for the containment reference list '{@link org.cmdbuild.monitoring.model.monitoring.Template#getCheck <em>Check</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Check</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Template#getCheck()
	 * @see #getTemplate()
	 * @generated
	 */
	EReference getTemplate_Check();

	/**
	 * Returns the meta object for the containment reference list '{@link org.cmdbuild.monitoring.model.monitoring.Template#getNotification <em>Notification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Notification</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Template#getNotification()
	 * @see #getTemplate()
	 * @generated
	 */
	EReference getTemplate_Notification();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.Check <em>Check</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Check</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Check
	 * @generated
	 */
	EClass getCheck();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.Notification <em>Notification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Notification</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Notification
	 * @generated
	 */
	EClass getNotification();

	/**
	 * Returns the meta object for the reference list '{@link org.cmdbuild.monitoring.model.monitoring.Notification#getGroup <em>Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Group</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Notification#getGroup()
	 * @see #getNotification()
	 * @generated
	 */
	EReference getNotification_Group();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.UserGroup <em>User Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>User Group</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.UserGroup
	 * @generated
	 */
	EClass getUserGroup();

	/**
	 * Returns the meta object for the reference list '{@link org.cmdbuild.monitoring.model.monitoring.UserGroup#getMember <em>Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Member</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.UserGroup#getMember()
	 * @see #getUserGroup()
	 * @generated
	 */
	EReference getUserGroup_Member();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.User <em>User</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>User</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.User
	 * @generated
	 */
	EClass getUser();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.Diagram <em>Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Diagram</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Diagram
	 * @generated
	 */
	EClass getDiagram();

	/**
	 * Returns the meta object for the containment reference list '{@link org.cmdbuild.monitoring.model.monitoring.Diagram#getComponent <em>Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Component</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.Diagram#getComponent()
	 * @see #getDiagram()
	 * @generated
	 */
	EReference getDiagram_Component();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.ComponentPosition <em>Component Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Position</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.ComponentPosition
	 * @generated
	 */
	EClass getComponentPosition();

	/**
	 * Returns the meta object for the reference '{@link org.cmdbuild.monitoring.model.monitoring.ComponentPosition#getComponent <em>Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Component</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.ComponentPosition#getComponent()
	 * @see #getComponentPosition()
	 * @generated
	 */
	EReference getComponentPosition_Component();

	/**
	 * Returns the meta object for the attribute '{@link org.cmdbuild.monitoring.model.monitoring.ComponentPosition#getX <em>X</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>X</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.ComponentPosition#getX()
	 * @see #getComponentPosition()
	 * @generated
	 */
	EAttribute getComponentPosition_X();

	/**
	 * Returns the meta object for the attribute '{@link org.cmdbuild.monitoring.model.monitoring.ComponentPosition#getY <em>Y</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Y</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.ComponentPosition#getY()
	 * @see #getComponentPosition()
	 * @generated
	 */
	EAttribute getComponentPosition_Y();

	/**
	 * Returns the meta object for the attribute '{@link org.cmdbuild.monitoring.model.monitoring.ComponentPosition#getWidth <em>Width</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Width</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.ComponentPosition#getWidth()
	 * @see #getComponentPosition()
	 * @generated
	 */
	EAttribute getComponentPosition_Width();

	/**
	 * Returns the meta object for the attribute '{@link org.cmdbuild.monitoring.model.monitoring.ComponentPosition#getHeight <em>Height</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Height</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.ComponentPosition#getHeight()
	 * @see #getComponentPosition()
	 * @generated
	 */
	EAttribute getComponentPosition_Height();

	/**
	 * Returns the meta object for class '{@link org.cmdbuild.monitoring.model.monitoring.MonitoringModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Model</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.MonitoringModel
	 * @generated
	 */
	EClass getMonitoringModel();

	/**
	 * Returns the meta object for the containment reference list '{@link org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getComponent <em>Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Component</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getComponent()
	 * @see #getMonitoringModel()
	 * @generated
	 */
	EReference getMonitoringModel_Component();

	/**
	 * Returns the meta object for the containment reference list '{@link org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getComponentGroup <em>Component Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Component Group</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getComponentGroup()
	 * @see #getMonitoringModel()
	 * @generated
	 */
	EReference getMonitoringModel_ComponentGroup();

	/**
	 * Returns the meta object for the containment reference list '{@link org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getTemplate <em>Template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Template</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getTemplate()
	 * @see #getMonitoringModel()
	 * @generated
	 */
	EReference getMonitoringModel_Template();

	/**
	 * Returns the meta object for the containment reference list '{@link org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getDiagram <em>Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Diagram</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getDiagram()
	 * @see #getMonitoringModel()
	 * @generated
	 */
	EReference getMonitoringModel_Diagram();

	/**
	 * Returns the meta object for the containment reference list '{@link org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getUser <em>User</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>User</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getUser()
	 * @see #getMonitoringModel()
	 * @generated
	 */
	EReference getMonitoringModel_User();

	/**
	 * Returns the meta object for the containment reference list '{@link org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getUserGroup <em>User Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>User Group</em>'.
	 * @see org.cmdbuild.monitoring.model.monitoring.MonitoringModel#getUserGroup()
	 * @see #getMonitoringModel()
	 * @generated
	 */
	EReference getMonitoringModel_UserGroup();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	MonitoringFactory getMonitoringFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.ComponentGroupImpl <em>Component Group</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.ComponentGroupImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getComponentGroup()
		 * @generated
		 */
		EClass COMPONENT_GROUP = eINSTANCE.getComponentGroup();

		/**
		 * The meta object literal for the '<em><b>Member</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_GROUP__MEMBER = eINSTANCE.getComponentGroup_Member();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.ComponentImpl <em>Component</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.ComponentImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getComponent()
		 * @generated
		 */
		EClass COMPONENT = eINSTANCE.getComponent();

		/**
		 * The meta object literal for the '<em><b>Host</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT__HOST = eINSTANCE.getComponent_Host();

		/**
		 * The meta object literal for the '<em><b>Dependency</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT__DEPENDENCY = eINSTANCE.getComponent_Dependency();

		/**
		 * The meta object literal for the '<em><b>Property</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT__PROPERTY = eINSTANCE.getComponent_Property();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.DeviceImpl <em>Device</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.DeviceImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getDevice()
		 * @generated
		 */
		EClass DEVICE = eINSTANCE.getDevice();

		/**
		 * The meta object literal for the '<em><b>Address</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DEVICE__ADDRESS = eINSTANCE.getDevice_Address();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.ClusterImpl <em>Cluster</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.ClusterImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getCluster()
		 * @generated
		 */
		EClass CLUSTER = eINSTANCE.getCluster();

		/**
		 * The meta object literal for the '<em><b>Member</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLUSTER__MEMBER = eINSTANCE.getCluster_Member();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.PropertyImpl <em>Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.PropertyImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getProperty()
		 * @generated
		 */
		EClass PROPERTY = eINSTANCE.getProperty();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY__NAME = eINSTANCE.getProperty_Name();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY__VALUE = eINSTANCE.getProperty_Value();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.TemplateImpl <em>Template</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.TemplateImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getTemplate()
		 * @generated
		 */
		EClass TEMPLATE = eINSTANCE.getTemplate();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEMPLATE__PARENT = eINSTANCE.getTemplate_Parent();

		/**
		 * The meta object literal for the '<em><b>Check</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEMPLATE__CHECK = eINSTANCE.getTemplate_Check();

		/**
		 * The meta object literal for the '<em><b>Notification</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEMPLATE__NOTIFICATION = eINSTANCE.getTemplate_Notification();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.CheckImpl <em>Check</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.CheckImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getCheck()
		 * @generated
		 */
		EClass CHECK = eINSTANCE.getCheck();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.NotificationImpl <em>Notification</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.NotificationImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getNotification()
		 * @generated
		 */
		EClass NOTIFICATION = eINSTANCE.getNotification();

		/**
		 * The meta object literal for the '<em><b>Group</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTIFICATION__GROUP = eINSTANCE.getNotification_Group();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.UserGroupImpl <em>User Group</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.UserGroupImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getUserGroup()
		 * @generated
		 */
		EClass USER_GROUP = eINSTANCE.getUserGroup();

		/**
		 * The meta object literal for the '<em><b>Member</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference USER_GROUP__MEMBER = eINSTANCE.getUserGroup_Member();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.UserImpl <em>User</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.UserImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getUser()
		 * @generated
		 */
		EClass USER = eINSTANCE.getUser();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.DiagramImpl <em>Diagram</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.DiagramImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getDiagram()
		 * @generated
		 */
		EClass DIAGRAM = eINSTANCE.getDiagram();

		/**
		 * The meta object literal for the '<em><b>Component</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DIAGRAM__COMPONENT = eINSTANCE.getDiagram_Component();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.ComponentPositionImpl <em>Component Position</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.ComponentPositionImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getComponentPosition()
		 * @generated
		 */
		EClass COMPONENT_POSITION = eINSTANCE.getComponentPosition();

		/**
		 * The meta object literal for the '<em><b>Component</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_POSITION__COMPONENT = eINSTANCE.getComponentPosition_Component();

		/**
		 * The meta object literal for the '<em><b>X</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT_POSITION__X = eINSTANCE.getComponentPosition_X();

		/**
		 * The meta object literal for the '<em><b>Y</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT_POSITION__Y = eINSTANCE.getComponentPosition_Y();

		/**
		 * The meta object literal for the '<em><b>Width</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT_POSITION__WIDTH = eINSTANCE.getComponentPosition_Width();

		/**
		 * The meta object literal for the '<em><b>Height</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPONENT_POSITION__HEIGHT = eINSTANCE.getComponentPosition_Height();

		/**
		 * The meta object literal for the '{@link org.cmdbuild.monitoring.model.monitoring.impl.MonitoringModelImpl <em>Model</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringModelImpl
		 * @see org.cmdbuild.monitoring.model.monitoring.impl.MonitoringPackageImpl#getMonitoringModel()
		 * @generated
		 */
		EClass MONITORING_MODEL = eINSTANCE.getMonitoringModel();

		/**
		 * The meta object literal for the '<em><b>Component</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MONITORING_MODEL__COMPONENT = eINSTANCE.getMonitoringModel_Component();

		/**
		 * The meta object literal for the '<em><b>Component Group</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MONITORING_MODEL__COMPONENT_GROUP = eINSTANCE.getMonitoringModel_ComponentGroup();

		/**
		 * The meta object literal for the '<em><b>Template</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MONITORING_MODEL__TEMPLATE = eINSTANCE.getMonitoringModel_Template();

		/**
		 * The meta object literal for the '<em><b>Diagram</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MONITORING_MODEL__DIAGRAM = eINSTANCE.getMonitoringModel_Diagram();

		/**
		 * The meta object literal for the '<em><b>User</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MONITORING_MODEL__USER = eINSTANCE.getMonitoringModel_User();

		/**
		 * The meta object literal for the '<em><b>User Group</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MONITORING_MODEL__USER_GROUP = eINSTANCE.getMonitoringModel_UserGroup();

	}

} //MonitoringPackage
