package it.unibo.cmdb.archimate;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QueryDialog extends Dialog {	
	private Text queryText;
	private String query;
	
	public QueryDialog(Shell parentShell, String query) {
		super(parentShell);
		this.query = query;
	}

	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite)super.createDialogArea(parent);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		composite.setLayout(gridLayout);
		Label queryLabel = new Label(composite, SWT.NONE);
		queryLabel.setText(Messages.CMDBDialog_Query);		
		queryText = new Text(composite, SWT.MULTI | SWT.V_SCROLL | SWT.BORDER);
		GridData queryGridData = new GridData();
		queryGridData.horizontalAlignment = GridData.FILL;
		queryGridData.grabExcessHorizontalSpace = true;
		queryGridData.heightHint = 400;
		queryText.setLayoutData(queryGridData);
		queryText.setText(query);
		return composite;
	}
	
	public String getQuery() {
		return query;
	}
	
	@Override
	protected void okPressed() {
		query = queryText.getText();			
		super.okPressed();
	}
		
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText("Insert CMDBf query");
    }
}
