/**
 */
package it.unibo.cmdb.archimate.model.transformationUtil;

import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelElement;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IRelationship;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelRecordType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordType;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Transformation Util</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link it.unibo.cmdb.archimate.model.transformationUtil.TransformationUtil#getCmdbfClient <em>Cmdbf Client</em>}</li>
 *   <li>{@link it.unibo.cmdb.archimate.model.transformationUtil.TransformationUtil#getDiagramSerializer <em>Diagram Serializer</em>}</li>
 * </ul>
 * </p>
 *
 * @see it.unibo.cmdb.archimate.model.transformationUtil.TransformationUtilPackage#getTransformationUtil()
 * @model
 * @generated
 */
public interface TransformationUtil extends EObject {
	/**
	 * Returns the value of the '<em><b>Cmdbf Client</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Cmdbf Client</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Cmdbf Client</em>' attribute.
	 * @see #setCmdbfClient(Object)
	 * @see it.unibo.cmdb.archimate.model.transformationUtil.TransformationUtilPackage#getTransformationUtil_CmdbfClient()
	 * @model required="true" transient="true"
	 * @generated
	 */
	Object getCmdbfClient();

	/**
	 * Sets the value of the '{@link it.unibo.cmdb.archimate.model.transformationUtil.TransformationUtil#getCmdbfClient <em>Cmdbf Client</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cmdbf Client</em>' attribute.
	 * @see #getCmdbfClient()
	 * @generated
	 */
	void setCmdbfClient(Object value);

	/**
	 * Returns the value of the '<em><b>Diagram Serializer</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Diagram Serializer</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Diagram Serializer</em>' attribute.
	 * @see #setDiagramSerializer(Object)
	 * @see it.unibo.cmdb.archimate.model.transformationUtil.TransformationUtilPackage#getTransformationUtil_DiagramSerializer()
	 * @model
	 * @generated
	 */
	Object getDiagramSerializer();

	/**
	 * Sets the value of the '{@link it.unibo.cmdb.archimate.model.transformationUtil.TransformationUtil#getDiagramSerializer <em>Diagram Serializer</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Diagram Serializer</em>' attribute.
	 * @see #getDiagramSerializer()
	 * @generated
	 */
	void setDiagramSerializer(Object value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model fieldDataType="org.eclipse.emf.ecore.xml.type.String"
	 * @generated
	 */
	void serialize(IDiagramModel diagram, RecordType record, String field);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model fieldDataType="org.eclipse.emf.ecore.xml.type.String"
	 * @generated
	 */
	void deserialize(IDiagramModel diagram, RecordType record, String field);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	String createImage(IDiagramModel diagram);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	String normalizeFilename(String filename);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	boolean isDeleted(IArchimateModelElement element);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model relationRequired="true"
	 * @generated
	 */
	boolean isDerived(IRelationship relation);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	boolean instanceOf(String baseTypeNS, String baseType, String typeNS, String type);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	void setFolder(IArchimateModel model, EObject element, String path);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	String getFolder(EObject element);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	String getFolderFromType(ModelRecordType type, int skip);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	String getProperty(IProperties element, String name);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	void setProperty(IProperties element, String name, String value);
	
} // TransformationUtil
