package it.unibo.cmdb.archimate.preferences;

import javax.xml.namespace.QName;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

import it.unibo.cmdb.archimate.CMDBConfiguration;
import it.unibo.cmdb.archimate.CMDBPlugin;
import it.unibo.cmdb.archimate.ModelUtils;

public class CMDBPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    
    private static String HELP_ID = "it.unibo.cmdb.archimate.help.prefs"; //$NON-NLS-1$
    
    private Text textArchiMdrId;
    private Label labelArchiMdrId;
    private Text textArchiLocalId;
    private Label labelArchiLocalId;        
    private Text textQuery;
    private Label labelQuery;
    private Text textArchi2Cmdb;
    private Label labelArchi2Cmdb;
    private Text textCmdb2Archi;
    private Label labelCmdb2Archi;
    private Text textQueryService;
    private Label labelQueryService;
    private Text textQueryPort;
    private Label labelQueryPort;
    private Text textQueryWsdl;
    private Label labelQueryWsdl;
    private Text textRegistrationService;
    private Label labelRegistrationService;
    private Text textRegistrationPort;
    private Label labelRegistrationPort;
    private Text textRegistrationWsdl;
    private Label labelRegistrationWsdl;
    private Button buttonDedupRelationships;
    private Label labelDedupRelationships;
    private Button buttonDetectDerivedRelationships;
    private Label labelDetectDerivedRelationships;
   
    public CMDBPreferencePage() {
		setPreferenceStore(CMDBPlugin.INSTANCE.getPreferenceStore());
	}
	
    @Override
    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, HELP_ID);
        Composite client = new Composite(parent, SWT.NULL);
        client.setLayout(new GridLayout());
        
        Group cmdbQuery = new Group(client, SWT.NULL);
        cmdbQuery.setText(Messages.CMDBPreferencePage_CMDBF_QUERY);
        cmdbQuery.setLayout(new GridLayout(2, false));
        cmdbQuery.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        labelQueryService = new Label(cmdbQuery, SWT.NULL);
        labelQueryService.setText(Messages.CMDBPreferencePage_QUERY_SERVICE);
        textQueryService = new Text(cmdbQuery, SWT.NULL);
        textQueryService.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        labelQueryPort = new Label(cmdbQuery, SWT.NULL);
        labelQueryPort.setText(Messages.CMDBPreferencePage_QUERY_PORT);
        textQueryPort = new Text(cmdbQuery, SWT.NULL);
        textQueryPort.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        labelQueryWsdl = new Label(cmdbQuery, SWT.NULL);
        labelQueryWsdl.setText(Messages.CMDBPreferencePage_QUERY_WSDL);
        textQueryWsdl = new Text(cmdbQuery, SWT.NULL);
        textQueryWsdl.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        Group cmdbRegistration = new Group(client, SWT.NULL);
        cmdbRegistration.setText(Messages.CMDBPreferencePage_CMDBF_REGISTRATION);
        cmdbRegistration.setLayout(new GridLayout(2, false));
        cmdbRegistration.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        labelRegistrationService = new Label(cmdbRegistration, SWT.NULL);
        labelRegistrationService.setText(Messages.CMDBPreferencePage_REGISTRATION_SERVICE);
        textRegistrationService = new Text(cmdbRegistration, SWT.NULL);
        textRegistrationService.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        labelRegistrationPort = new Label(cmdbRegistration, SWT.NULL);
        labelRegistrationPort.setText(Messages.CMDBPreferencePage_REGISTRATION_PORT);
        textRegistrationPort = new Text(cmdbRegistration, SWT.NULL);
        textRegistrationPort.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        labelRegistrationWsdl = new Label(cmdbRegistration, SWT.NULL);
        labelRegistrationWsdl.setText(Messages.CMDBPreferencePage_REGISTRATION_WSDL);
        textRegistrationWsdl = new Text(cmdbRegistration, SWT.NULL);
        textRegistrationWsdl.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        Group cmdbTransformation = new Group(client, SWT.NULL);
        cmdbTransformation.setText(Messages.CMDBPreferencePage_ATL_TRANSFORMATION);
        cmdbTransformation.setLayout(new GridLayout(2, false));
        cmdbTransformation.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        labelArchi2Cmdb = new Label(cmdbTransformation, SWT.NULL);
        labelArchi2Cmdb.setText(Messages.CMDBPreferencePage_ARCHI2CMDB);        
        textArchi2Cmdb = new Text(cmdbTransformation, SWT.NULL);
        textArchi2Cmdb.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        labelCmdb2Archi = new Label(cmdbTransformation, SWT.NULL);
        labelCmdb2Archi.setText(Messages.CMDBPreferencePage_CMDB2ARCHI);      
        textCmdb2Archi = new Text(cmdbTransformation, SWT.NULL);
        textCmdb2Archi.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        labelQuery = new Label(cmdbTransformation, SWT.NULL);
        labelQuery.setText(Messages.CMDBPreferencePage_QUERY);
        textQuery = new Text(cmdbTransformation, SWT.MULTI | SWT.V_SCROLL | SWT.BORDER);
        GridData querydata = new GridData(GridData.FILL_HORIZONTAL);
        querydata.heightHint = 100;
        textQuery.setLayoutData(querydata);
        
        labelArchiMdrId = new Label(cmdbTransformation, SWT.NULL);
        labelArchiMdrId.setText(Messages.CMDBPreferencePage_ARCHI_MDRID);
        textArchiMdrId = new Text(cmdbTransformation, SWT.NULL);
        textArchiMdrId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        labelArchiLocalId = new Label(cmdbTransformation, SWT.NULL);
        labelArchiLocalId.setText(Messages.CMDBPreferencePage_ARCHI_LOCALID);
        textArchiLocalId = new Text(cmdbTransformation, SWT.NULL);
        textArchiLocalId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        labelDedupRelationships = new Label(cmdbTransformation, SWT.NULL);
        labelDedupRelationships.setText(Messages.CMDBPreferencePage_DEDUP_RELATIONSHIPS);
        buttonDedupRelationships = new Button(cmdbTransformation, SWT.CHECK);
        buttonDedupRelationships.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        labelDetectDerivedRelationships = new Label(cmdbTransformation, SWT.NULL);
        labelDetectDerivedRelationships.setText(Messages.CMDBPreferencePage_DETECT_DERIVED_RELATIONSHIPS);
        buttonDetectDerivedRelationships = new Button(cmdbTransformation, SWT.CHECK);
        buttonDetectDerivedRelationships.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
                      
        setValues();
        
        return client;
    }

    private void setValues() {
    	try {
			textQuery.setText(ModelUtils.toString(getConfiguration().getQuery()));
		} catch (Exception e) {
			IStatus status = new Status(IStatus.ERROR, CMDBPlugin.PLUGIN_ID, e.getMessage(), e);
			CMDBPlugin.INSTANCE.getLog().log(status);
			textQuery.setText("");
		}
        textArchi2Cmdb.setText(getConfiguration().getArchi2cmdb());
        textCmdb2Archi.setText(getConfiguration().getCmdb2archi());
        textQueryService.setText(getConfiguration().getQueryService() !=null ? getConfiguration().getQueryService().toString() : "");
        textQueryPort.setText(getConfiguration().getQueryPort() !=null ? getConfiguration().getQueryPort().toString() : "");
        textQueryWsdl.setText(getConfiguration().getQueryWSDL());
        textRegistrationService.setText(getConfiguration().getRegistrationService() != null ? getConfiguration().getRegistrationService().toString() : "");
        textRegistrationPort.setText(getConfiguration().getRegistrationPort() != null ? getConfiguration().getRegistrationPort().toString() : "");
        textRegistrationWsdl.setText(getConfiguration().getRegistrationWSDL());
        buttonDedupRelationships.setSelection(getConfiguration().isDedupRelationships());
        buttonDetectDerivedRelationships.setSelection(getConfiguration().isDetectDerivedRelationships());
    }
    
    @Override
    public boolean performOk() {
    	try {
			getConfiguration().setQuery(ModelUtils.parseXml(textQuery.getText()));
	    	getConfiguration().setArchi2cmdb(textArchi2Cmdb.getText());
	    	getConfiguration().setCmdb2archi(textCmdb2Archi.getText());
	    	getConfiguration().setQueryService(QName.valueOf(textQueryService.getText()));
	    	getConfiguration().setQueryPort(QName.valueOf(textQueryPort.getText()));
	    	getConfiguration().setQueryWSDL(textQueryWsdl.getText());
	    	getConfiguration().setRegistrationService(QName.valueOf(textRegistrationService.getText()));
	    	getConfiguration().setRegistrationPort(QName.valueOf(textRegistrationPort.getText()));
	    	getConfiguration().setRegistrationWSDL(textRegistrationWsdl.getText());
	    	getConfiguration().setDedupRelationships(buttonDedupRelationships.getSelection());
	    	getConfiguration().setDetectDerivedRelationships(buttonDetectDerivedRelationships.getSelection());
	        getConfiguration().save();
	        setValid(true);
		} catch (Exception e) {
			IStatus status = new Status(IStatus.ERROR, CMDBPlugin.PLUGIN_ID, e.getMessage(), e);
			CMDBPlugin.INSTANCE.getLog().log(status);
			setValid(false);
		} 
    	return isValid();
    }
    
    @Override
    protected void performDefaults() {
    	super.performDefaults();
    	
    	CMDBConfiguration defaultConfiguration = CMDBConfiguration.getDefaults();
    	
    	try {
			textQuery.setText(ModelUtils.toString(defaultConfiguration.getQuery()));
		} catch (Exception e) {
			IStatus status = new Status(IStatus.ERROR, CMDBPlugin.PLUGIN_ID, e.getMessage(), e);
			CMDBPlugin.INSTANCE.getLog().log(status);
			textQuery.setText("");
		}
        textArchi2Cmdb.setText(defaultConfiguration.getArchi2cmdb());
        textCmdb2Archi.setText(defaultConfiguration.getCmdb2archi());
        textQueryService.setText(defaultConfiguration.getQueryService() !=null ? defaultConfiguration.getQueryService().toString() : "");
        textQueryPort.setText(defaultConfiguration.getQueryPort() !=null ? defaultConfiguration.getQueryPort().toString() : "");
        textQueryWsdl.setText(defaultConfiguration.getQueryWSDL());
        textRegistrationService.setText(defaultConfiguration.getRegistrationService() != null ? defaultConfiguration.getRegistrationService().toString() : "");
        textRegistrationPort.setText(defaultConfiguration.getRegistrationPort() != null ? defaultConfiguration.getRegistrationPort().toString() : "");
        textRegistrationWsdl.setText(defaultConfiguration.getRegistrationWSDL());
        buttonDedupRelationships.setSelection(defaultConfiguration.isDedupRelationships());
        buttonDetectDerivedRelationships.setSelection(defaultConfiguration.isDetectDerivedRelationships());    	
    }
    
    public void init(IWorkbench workbench) {
    }
    
    private CMDBConfiguration getConfiguration() {
    	return CMDBPlugin.INSTANCE.getConfiguration();    	
    }
	
}