
package it.unibo.cmdb.cmdbf.client;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.InvalidPropertyTypeFaultType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.PropertyNameType;

public class InvalidPropertyException extends Exception {
	private static final long serialVersionUID = 4906873245209487368L;
    protected String localName;
    protected String namespace;

    public InvalidPropertyException(InvalidPropertyTypeFaultType fault) {
    	PropertyNameType propertyName = fault.getPropertyName();
    	if(propertyName != null) {
    		this.localName = propertyName.getLocalName();
    		this.namespace = propertyName.getNamespace();
    	}
    }
    
    public String getLocalName() {
        return localName;
    }
    
    public String getNamespace() {
        return namespace;
    }
}
