/**
 */
package it.unibo.cmdb.cmdbf.client.model.cmdbf.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Mdr Scoped Id Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.MdrScopedIdTypeImpl#getMdrId <em>Mdr Id</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.MdrScopedIdTypeImpl#getLocalId <em>Local Id</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MdrScopedIdTypeImpl extends MinimalEObjectImpl.Container implements MdrScopedIdType {
	/**
	 * The default value of the '{@link #getMdrId() <em>Mdr Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMdrId()
	 * @generated
	 * @ordered
	 */
	protected static final String MDR_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMdrId() <em>Mdr Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMdrId()
	 * @generated
	 * @ordered
	 */
	protected String mdrId = MDR_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getLocalId() <em>Local Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalId()
	 * @generated
	 * @ordered
	 */
	protected static final String LOCAL_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocalId() <em>Local Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalId()
	 * @generated
	 * @ordered
	 */
	protected String localId = LOCAL_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MdrScopedIdTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CmdbfPackage.Literals.MDR_SCOPED_ID_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getMdrId() {
		return mdrId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public void setMdrId(String newMdrId) {
		EObject container =  eContainer();
		removeFromContainer(container);
		
		String oldMdrId = mdrId;
		mdrId = newMdrId;
		
		addToContainer(container);
		
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.MDR_SCOPED_ID_TYPE__MDR_ID, oldMdrId, mdrId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLocalId() {
		return localId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public void setLocalId(String newLocalId) {
		EObject container =  eContainer();
		removeFromContainer(container);
		
		String oldLocalId = localId;
		localId = newLocalId;
		
		addToContainer(container);
		
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.MDR_SCOPED_ID_TYPE__LOCAL_ID, oldLocalId, localId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean init(String value) {
		Matcher matcher = pattern.matcher(value);
		boolean match = matcher.find(); 
		if (match) {
			mdrId = unescape(matcher.group(1));
			final String localId = unescape(matcher.group(2));
			setMdrId(mdrId);
			setLocalId(localId);
		}
		return match;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CmdbfPackage.MDR_SCOPED_ID_TYPE__MDR_ID:
				return getMdrId();
			case CmdbfPackage.MDR_SCOPED_ID_TYPE__LOCAL_ID:
				return getLocalId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CmdbfPackage.MDR_SCOPED_ID_TYPE__MDR_ID:
				setMdrId((String)newValue);
				return;
			case CmdbfPackage.MDR_SCOPED_ID_TYPE__LOCAL_ID:
				setLocalId((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CmdbfPackage.MDR_SCOPED_ID_TYPE__MDR_ID:
				setMdrId(MDR_ID_EDEFAULT);
				return;
			case CmdbfPackage.MDR_SCOPED_ID_TYPE__LOCAL_ID:
				setLocalId(LOCAL_ID_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CmdbfPackage.MDR_SCOPED_ID_TYPE__MDR_ID:
				return MDR_ID_EDEFAULT == null ? mdrId != null : !MDR_ID_EDEFAULT.equals(mdrId);
			case CmdbfPackage.MDR_SCOPED_ID_TYPE__LOCAL_ID:
				return LOCAL_ID_EDEFAULT == null ? localId != null : !LOCAL_ID_EDEFAULT.equals(localId);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case CmdbfPackage.MDR_SCOPED_ID_TYPE___INIT__STRING:
				return init((String)arguments.get(0));
		}
		return super.eInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();
		final StringBuffer buffer = new StringBuffer();
		buffer.append("'{");
		buffer.append(escape(getMdrId()));
		buffer.append(",");
		buffer.append(escape(getLocalId()));
		buffer.append("}'");
		return buffer.toString();
	}
	
	@Override
	public boolean equals(Object obj) {
		boolean equals = false;
		if(obj instanceof MdrScopedIdType){
			MdrScopedIdType id = (MdrScopedIdType)obj;
			if(mdrId != null)
				equals = mdrId.equals(id.getMdrId());
			else
				equals = id.getMdrId() == null;
			if(localId != null)
				equals &= localId.equals(id.getLocalId());
			else
				equals = id.getLocalId() == null;
		}
		return equals;
    }
	
	@Override
	public int hashCode() {
		int hash = 23;
		hash *= 37;
		if(mdrId != null)
			hash += mdrId.hashCode();
		hash *= 37;
		if(localId != null)
			hash += localId.hashCode();		
		return hash;
	}

	@Override
	public int compareTo(MdrScopedIdType id) {
		int compare = 0;
		if(mdrId != null){
			if(id.getMdrId()!=null)
				compare = mdrId.compareTo(id.getMdrId());
			else
				compare = 1;
		}
		else {
			if(id.getMdrId()!=null)
				compare = -1;
			else
				compare = 0;
		}
		
		if(compare == 0) {
			if(localId != null) {
				if(id.getLocalId() != null)
					compare = localId.compareTo(id.getLocalId());
				else
					compare = 1;
			}
			else {
				if(id.getLocalId() != null) 
					compare = -1;
				else
					compare = 0;
			}
		}
		return compare;
	}
		
	private static final char[] escapeArray = { '\\', ',' };
	private static final Pattern pattern = Pattern.compile("\\{((?:[^\\,\\\\]|\\\\\\,|\\\\\\\\)*),((?:[^\\,\\\\]|\\\\\\,|\\\\\\\\)*)\\}");

	private static String escape(final String value) {
		if(value != null) {
			StringBuffer buffer = new StringBuffer();
			for (int i = 0; i < value.length(); i++) {
				char c = value.charAt(i);
				for (int j = 0; j < escapeArray.length; j++) {
					if (c == escapeArray[j]) {
						buffer.append('\\');
					}
				}
				buffer.append(c);
			}
			return buffer.toString();
		}
		else
			return null;
	}

	private static String unescape(final String value) {
		if(value != null) {
			StringBuffer buffer = new StringBuffer();
			for (int i = 0; i < value.length(); i++) {
				char c = value.charAt(i);
				if (c == '\\' && i + 1 < value.length()) {
					c = value.charAt(++i);
				}
				buffer.append(c);
			}
			return buffer.toString();
		}
		else
			return null;
	}
	
	private void addToContainer(EObject container) {
		if(container != null) {
			EStructuralFeature feature = container.eClass().getEStructuralFeature(EOPPOSITE_FEATURE_BASE - eContainerFeatureID());
			if(feature.getEType().isInstance(this)) {
				if(feature.isMany()) {
					@SuppressWarnings("unchecked")
					EList<MdrScopedIdType> list = (EList<MdrScopedIdType>)container.eGet(feature);
					list.add(this);
				}
				else {
					container.eSet(feature, this);
				}
			}
		}
	}
	
	private void removeFromContainer(EObject container) {
		if(container != null) {
			EStructuralFeature feature = container.eClass().getEStructuralFeature(EOPPOSITE_FEATURE_BASE - eContainerFeatureID());
			if(feature.getEType().isInstance(this)) {
				if(feature.isMany()) {
					EList<?> list = (EList<?>)container.eGet(feature);
					list.remove(this);
				}
				else {
					container.eUnset(feature);
				}
			}
		}
	}

} //MdrScopedIdTypeImpl
