/**
 */
package it.unibo.cmdb.cmdbf.client.model.cmdbf.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.Model;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Relationship Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RelationshipTypeImpl#getSourceItem <em>Source Item</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.RelationshipTypeImpl#getTargetItem <em>Target Item</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RelationshipTypeImpl extends ModelElementImpl implements RelationshipType {
	/**
	 * The cached value of the '{@link #getSourceItem() <em>Source Item</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceItem()
	 * @generated
	 * @ordered
	 */
	protected ItemType sourceItem;

	/**
	 * The cached value of the '{@link #getTargetItem() <em>Target Item</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetItem()
	 * @generated
	 * @ordered
	 */
	protected ItemType targetItem;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationshipTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CmdbfPackage.Literals.RELATIONSHIP_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ItemType getSourceItem() {
		return sourceItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSourceItem(ItemType newSourceItem, NotificationChain msgs) {
		ItemType oldSourceItem = sourceItem;
		sourceItem = newSourceItem;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CmdbfPackage.RELATIONSHIP_TYPE__SOURCE_ITEM, oldSourceItem, newSourceItem);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSourceItem(ItemType newSourceItem) {
		if (newSourceItem != sourceItem) {
			NotificationChain msgs = null;
			if (sourceItem != null)
				msgs = ((InternalEObject)sourceItem).eInverseRemove(this, CmdbfPackage.ITEM_TYPE__RELATIONSHIP_BY_SOURCE, ItemType.class, msgs);
			if (newSourceItem != null)
				msgs = ((InternalEObject)newSourceItem).eInverseAdd(this, CmdbfPackage.ITEM_TYPE__RELATIONSHIP_BY_SOURCE, ItemType.class, msgs);
			msgs = basicSetSourceItem(newSourceItem, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.RELATIONSHIP_TYPE__SOURCE_ITEM, newSourceItem, newSourceItem));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ItemType getTargetItem() {
		return targetItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTargetItem(ItemType newTargetItem, NotificationChain msgs) {
		ItemType oldTargetItem = targetItem;
		targetItem = newTargetItem;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CmdbfPackage.RELATIONSHIP_TYPE__TARGET_ITEM, oldTargetItem, newTargetItem);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTargetItem(ItemType newTargetItem) {
		if (newTargetItem != targetItem) {
			NotificationChain msgs = null;
			if (targetItem != null)
				msgs = ((InternalEObject)targetItem).eInverseRemove(this, CmdbfPackage.ITEM_TYPE__RELATIONSHIP_BY_TARGET, ItemType.class, msgs);
			if (newTargetItem != null)
				msgs = ((InternalEObject)newTargetItem).eInverseAdd(this, CmdbfPackage.ITEM_TYPE__RELATIONSHIP_BY_TARGET, ItemType.class, msgs);
			msgs = basicSetTargetItem(newTargetItem, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CmdbfPackage.RELATIONSHIP_TYPE__TARGET_ITEM, newTargetItem, newTargetItem));
	}
	
	@Override
	public boolean isDeregister() {
		boolean removed = false;
		for(MdrScopedIdType id : getInstanceId())		
			removed |= getParent().getParent().getRemovedRelationshipId().contains(id);
		return removed;
	}

	@Override
	public void setDeregister(boolean newDeregister) {
		Model model = getParent().getParent(); 
		if(newDeregister) {
			model.remove(this);
		}
		else {
			for(MdrScopedIdType id : getInstanceId())		
				model.getRemovedItemId().remove(id);
		}
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CmdbfPackage.RELATIONSHIP_TYPE__SOURCE_ITEM:
				if (sourceItem != null)
					msgs = ((InternalEObject)sourceItem).eInverseRemove(this, CmdbfPackage.ITEM_TYPE__RELATIONSHIP_BY_SOURCE, ItemType.class, msgs);
				return basicSetSourceItem((ItemType)otherEnd, msgs);
			case CmdbfPackage.RELATIONSHIP_TYPE__TARGET_ITEM:
				if (targetItem != null)
					msgs = ((InternalEObject)targetItem).eInverseRemove(this, CmdbfPackage.ITEM_TYPE__RELATIONSHIP_BY_TARGET, ItemType.class, msgs);
				return basicSetTargetItem((ItemType)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CmdbfPackage.RELATIONSHIP_TYPE__SOURCE_ITEM:
				return basicSetSourceItem(null, msgs);
			case CmdbfPackage.RELATIONSHIP_TYPE__TARGET_ITEM:
				return basicSetTargetItem(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CmdbfPackage.RELATIONSHIP_TYPE__SOURCE_ITEM:
				return getSourceItem();
			case CmdbfPackage.RELATIONSHIP_TYPE__TARGET_ITEM:
				return getTargetItem();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CmdbfPackage.RELATIONSHIP_TYPE__SOURCE_ITEM:
				setSourceItem((ItemType)newValue);
				return;
			case CmdbfPackage.RELATIONSHIP_TYPE__TARGET_ITEM:
				setTargetItem((ItemType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CmdbfPackage.RELATIONSHIP_TYPE__SOURCE_ITEM:
				setSourceItem((ItemType)null);
				return;
			case CmdbfPackage.RELATIONSHIP_TYPE__TARGET_ITEM:
				setTargetItem((ItemType)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CmdbfPackage.RELATIONSHIP_TYPE__SOURCE_ITEM:
				return sourceItem != null;
			case CmdbfPackage.RELATIONSHIP_TYPE__TARGET_ITEM:
				return targetItem != null;
		}
		return super.eIsSet(featureID);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		String mdrId = getParent()!=null ? getParent().getMdrId() : null;		
		result.append(" (");
		if(getSourceItem() != null) {
			MdrScopedIdType instanceId = getSourceItem().findInstanceId();
			if(instanceId != null) {
				if(mdrId==null || !mdrId.equals(instanceId.getMdrId()))
					result.append(instanceId.toString());
				else
					result.append(instanceId.getLocalId());
			}
		}
		result.append(" -> ");
		if(getTargetItem() != null) {
			MdrScopedIdType instanceId = getTargetItem().findInstanceId();
			if(instanceId != null) {
				if(mdrId==null || !mdrId.equals(instanceId.getMdrId()))
					result.append(instanceId.toString());
				else
					result.append(instanceId.getLocalId());
			}
		}
		result.append(")");
		
		return result.toString();
	}

} //RelationshipTypeImpl
