package it.unibo.cmdb.cmdbf.client.model.cmdbf.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;

public class CmdbfEObjectList<T> extends EObjectContainmentEList<T> implements Adapter, Comparator<Object> {

	private static final long serialVersionUID = 1L;	
	protected final Map<Object, T> index;
	protected final int inverseFeatureID;
	protected final int keyFeatureID;

	public CmdbfEObjectList(Class<?> dataClass, InternalEObject owner, int featureID, int inverseFeatureID, int keyFeatureID) {
	    super(dataClass, owner, featureID);
		index = new TreeMap<Object, T>(this);
		this.inverseFeatureID = inverseFeatureID; 
		this.keyFeatureID = keyFeatureID;
		assert(getFeatureType() instanceof EClass);
	}
	
	public CmdbfEObjectList(Class<?> dataClass, InternalEObject owner, int featureID, int keyFeatureID) {
		this(dataClass, owner, featureID, Notification.NO_FEATURE_ID, keyFeatureID);
	}
	
	public CmdbfEObjectList(Class<?> dataClass, InternalEObject owner, int featureID) {
		this(dataClass, owner, featureID, Notification.NO_FEATURE_ID, Notification.NO_FEATURE_ID);
	}

	@Override
	protected boolean hasNavigableInverse() {
		if(inverseFeatureID == Notification.NO_FEATURE_ID)
			return super.hasNavigableInverse();
		else
			return true;
  	}

	@Override
	public int getInverseFeatureID() {
		if(inverseFeatureID == Notification.NO_FEATURE_ID)
			return super.getInverseFeatureID();
		else
			return inverseFeatureID;
	}
	  
	@Override
	public Class<?> getInverseFeatureClass() {
		if(inverseFeatureID == Notification.NO_FEATURE_ID)
			return super.getInverseFeatureClass();
		else
			return dataClass;
	}
	
	@Override
	public boolean contains(Object object) {
		return find(object) != null;
	}
	
	@Override
	public NotificationChain inverseAdd(T object, NotificationChain notifications) {
		indexAdd(object);
		return super.inverseAdd(object, notifications);
	}
	
	@Override
	public NotificationChain inverseRemove(T object, NotificationChain notifications) {
		indexRemove(object);
		return super.inverseRemove(object, notifications);
	}
		
	@SuppressWarnings("unchecked")
	@Override
	public void notifyChanged(Notification notification) {
		switch(notification.getEventType()){
		case Notification.ADD:
			if(notification.getFeature() == getKeyEStructuralFeature()){
				Object key = notification.getNewValue();
				if(find(key) == null)
					index.put(key, (T)notification.getNotifier());
				else
					throw new IllegalStateException("Duplicated id: " + key.toString());
			}			
			break;
		case Notification.ADD_MANY:
			if(notification.getFeature() == getKeyEStructuralFeature()){
				Collection<?> list = (Collection<?>)notification.getNewValue();				
				for(Object key : list) {
					if(find(key) == null)
						index.put(key, (T)notification.getNotifier());
					else
						throw new IllegalStateException("Duplicated id: " + key.toString());
				}
			}			
			break;
		case Notification.REMOVE:
			if(notification.getFeature() == getKeyEStructuralFeature()){
				index.remove(notification.getOldValue());
			}			
			break;
		case Notification.REMOVE_MANY:
			if(notification.getFeature() == getKeyEStructuralFeature()){
				Collection<?> list = (Collection<?>)notification.getNewValue();				
				for(Object key : list) {
					index.remove(key);
				}
			}			
			break;
		case Notification.SET:
			if(notification.getFeature() == getKeyEStructuralFeature()){
				index.remove(notification.getOldValue());
				Object key = notification.getNewValue();
				if(find(key) == null)
					index.put(key, (T)notification.getNotifier());
				else
					throw new IllegalStateException("Duplicated id: " + key.toString());
			}
			break;
		case Notification.UNSET:
			if(notification.getFeature() == getKeyEStructuralFeature()){
				index.remove(notification.getOldValue());
			}
			break;
		}		
	}

	@Override
	public void setTarget(Notifier target) { }
	
	@Override
	public Notifier getTarget() { return null;	}

	@Override
	public boolean isAdapterForType(Object type) { return false; }
	

	public T find(final Object o) {
		T item = null;
		if(keyFeatureID == Notification.NO_FEATURE_ID) {
			item = index.get(o);
		}
		else if(getFeatureType().isInstance(o) && getKeyEStructuralFeature().isMany()) {
			Iterator<?> iterator = ((Iterable<?>)((EObject)o).eGet(getKeyEStructuralFeature())).iterator();
			while (item == null && iterator.hasNext()) {
				item = index.get(iterator.next());
			}
		}
		else if(getKeyFeatureType().isInstance(o)) {
			item = index.get(o);
		}		
		return item;
	}
	
	protected boolean indexAdd(final T item) {
		boolean added = false;
		if (find(item) == null) {
			if(keyFeatureID == Notification.NO_FEATURE_ID) {
				final T old = index.put(item, item);
				assert (old == null || old == item);
			}
			else if(getKeyEStructuralFeature().isMany()) {
				for (Object key : ((Iterable<?>)((EObject)item).eGet(getKeyEStructuralFeature()))) {
					final T old = index.put(key, item);
					assert (old == null || old == item);
				}				
				((EObject)item).eAdapters().add(this);
			}
			else {
				Object key = ((EObject)item).eGet(getKeyEStructuralFeature());
				final T old = index.put(key, item);
				assert (old == null || old == item);				
				((EObject)item).eAdapters().add(this);
			}
			added = true;
		}
		return added;
	}
	
	protected T indexRemove(final Object o) {
		final T item = find(o);
		if (item != null) {
			if(keyFeatureID == Notification.NO_FEATURE_ID) {
				final T old = index.remove(item);
				assert (old == item);								
			}
			else if(getKeyEStructuralFeature().isMany()) {
				for (Object key : ((Iterable<?>)((EObject)item).eGet(getKeyEStructuralFeature()))) {
					final T old = index.remove(key);
					assert (old == item);
				}				
				((EObject)item).eAdapters().remove(this);
			}
			else {
				Object key = ((EObject)item).eGet(getKeyEStructuralFeature());
				final T old = index.remove(key);
				assert (old == item);				
				((EObject)item).eAdapters().remove(this);
			}			
		}
		return item;
	}
	
	protected EStructuralFeature getKeyEStructuralFeature() {
		return ((EClass)getFeatureType()).getEStructuralFeature(keyFeatureID);
	}

	protected EClassifier getKeyFeatureType() {
		return getKeyEStructuralFeature().getEType();
	}

	@SuppressWarnings("unchecked")
	@Override
	public int compare(Object obj1, Object obj2) {
		int cmp = 0;
		if(obj1 != null) {
			if(obj2 != null) {
				cmp = ((Comparable<T>)obj1).compareTo((T)obj2);
			}
			else
				cmp = 1;
		}
		else {
			if(obj2 != null)
				cmp = -1;
			else
				cmp = 0;
		}
		return cmp;
	}
}