/**
 */
package it.unibo.cmdb.cmdbf.client.model.cmdbf.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage
 * @generated
 */
public class CmdbfSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static CmdbfPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CmdbfSwitch() {
		if (modelPackage == null) {
			modelPackage = CmdbfPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case CmdbfPackage.ACCEPTED_TYPE: {
				AcceptedType acceptedType = (AcceptedType)theEObject;
				T result = caseAcceptedType(acceptedType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.COMPARISON_OPERATOR_TYPE: {
				ComparisonOperatorType comparisonOperatorType = (ComparisonOperatorType)theEObject;
				T result = caseComparisonOperatorType(comparisonOperatorType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.CONSTRAINT_TYPE: {
				ConstraintType constraintType = (ConstraintType)theEObject;
				T result = caseConstraintType(constraintType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.CONTENT_SELECTOR_TYPE: {
				ContentSelectorType contentSelectorType = (ContentSelectorType)theEObject;
				T result = caseContentSelectorType(contentSelectorType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.DECLINED_TYPE: {
				DeclinedType declinedType = (DeclinedType)theEObject;
				T result = caseDeclinedType(declinedType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.DEPTH_LIMIT_TYPE: {
				DepthLimitType depthLimitType = (DepthLimitType)theEObject;
				T result = caseDepthLimitType(depthLimitType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.DEREGISTER_INSTANCE_RESPONSE_TYPE: {
				DeregisterInstanceResponseType deregisterInstanceResponseType = (DeregisterInstanceResponseType)theEObject;
				T result = caseDeregisterInstanceResponseType(deregisterInstanceResponseType);
				if (result == null) result = caseModelUpdateInstanceResponse(deregisterInstanceResponseType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.DEREGISTER_REQUEST_TYPE: {
				DeregisterRequestType deregisterRequestType = (DeregisterRequestType)theEObject;
				T result = caseDeregisterRequestType(deregisterRequestType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.DEREGISTER_RESPONSE_TYPE: {
				DeregisterResponseType deregisterResponseType = (DeregisterResponseType)theEObject;
				T result = caseDeregisterResponseType(deregisterResponseType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.DEREGISTRATION_ERROR_FAULT_TYPE: {
				DeregistrationErrorFaultType deregistrationErrorFaultType = (DeregistrationErrorFaultType)theEObject;
				T result = caseDeregistrationErrorFaultType(deregistrationErrorFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.DOCUMENT_ROOT: {
				DocumentRoot documentRoot = (DocumentRoot)theEObject;
				T result = caseDocumentRoot(documentRoot);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.EDGES_TYPE: {
				EdgesType edgesType = (EdgesType)theEObject;
				T result = caseEdgesType(edgesType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.EQUAL_OPERATOR_TYPE: {
				EqualOperatorType equalOperatorType = (EqualOperatorType)theEObject;
				T result = caseEqualOperatorType(equalOperatorType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.EXPENSIVE_QUERY_ERROR_FAULT_TYPE: {
				ExpensiveQueryErrorFaultType expensiveQueryErrorFaultType = (ExpensiveQueryErrorFaultType)theEObject;
				T result = caseExpensiveQueryErrorFaultType(expensiveQueryErrorFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.INSTANCE_ID_CONSTRAINT_TYPE: {
				InstanceIdConstraintType instanceIdConstraintType = (InstanceIdConstraintType)theEObject;
				T result = caseInstanceIdConstraintType(instanceIdConstraintType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.INVALID_MDR_FAULT_TYPE: {
				InvalidMDRFaultType invalidMDRFaultType = (InvalidMDRFaultType)theEObject;
				T result = caseInvalidMDRFaultType(invalidMDRFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.INVALID_PROPERTY_TYPE_FAULT_TYPE: {
				InvalidPropertyTypeFaultType invalidPropertyTypeFaultType = (InvalidPropertyTypeFaultType)theEObject;
				T result = caseInvalidPropertyTypeFaultType(invalidPropertyTypeFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.INVALID_RECORD_FAULT_TYPE: {
				InvalidRecordFaultType invalidRecordFaultType = (InvalidRecordFaultType)theEObject;
				T result = caseInvalidRecordFaultType(invalidRecordFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.ITEM_LIST_TYPE: {
				ItemListType itemListType = (ItemListType)theEObject;
				T result = caseItemListType(itemListType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.ITEM_TEMPLATE_TYPE: {
				ItemTemplateType itemTemplateType = (ItemTemplateType)theEObject;
				T result = caseItemTemplateType(itemTemplateType);
				if (result == null) result = caseModelTemplate(itemTemplateType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.ITEM_TYPE: {
				ItemType itemType = (ItemType)theEObject;
				T result = caseItemType(itemType);
				if (result == null) result = caseModelElement(itemType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.MDR_SCOPED_ID_LIST_TYPE: {
				MdrScopedIdListType mdrScopedIdListType = (MdrScopedIdListType)theEObject;
				T result = caseMdrScopedIdListType(mdrScopedIdListType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.MDR_SCOPED_ID_TYPE: {
				MdrScopedIdType mdrScopedIdType = (MdrScopedIdType)theEObject;
				T result = caseMdrScopedIdType(mdrScopedIdType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.NODES_TYPE: {
				NodesType nodesType = (NodesType)theEObject;
				T result = caseNodesType(nodesType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.NULL_OPERATOR_TYPE: {
				NullOperatorType nullOperatorType = (NullOperatorType)theEObject;
				T result = caseNullOperatorType(nullOperatorType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.PREFIX_MAPPING_TYPE: {
				PrefixMappingType prefixMappingType = (PrefixMappingType)theEObject;
				T result = casePrefixMappingType(prefixMappingType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.PROPERTY_NAME_TYPE: {
				PropertyNameType propertyNameType = (PropertyNameType)theEObject;
				T result = casePropertyNameType(propertyNameType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.PROPERTY_SET_TYPE: {
				PropertySetType propertySetType = (PropertySetType)theEObject;
				T result = casePropertySetType(propertySetType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.PROPERTY_VALUE_TYPE: {
				PropertyValueType propertyValueType = (PropertyValueType)theEObject;
				T result = casePropertyValueType(propertyValueType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.QNAME_TYPE: {
				QNameType qNameType = (QNameType)theEObject;
				T result = caseQNameType(qNameType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.QUERY_ERROR_FAULT_TYPE: {
				QueryErrorFaultType queryErrorFaultType = (QueryErrorFaultType)theEObject;
				T result = caseQueryErrorFaultType(queryErrorFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.QUERY_RESULT_TYPE: {
				QueryResultType queryResultType = (QueryResultType)theEObject;
				T result = caseQueryResultType(queryResultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.QUERY_TYPE: {
				QueryType queryType = (QueryType)theEObject;
				T result = caseQueryType(queryType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.RECORD_CONSTRAINT_TYPE: {
				RecordConstraintType recordConstraintType = (RecordConstraintType)theEObject;
				T result = caseRecordConstraintType(recordConstraintType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.RECORD_METADATA_TYPE: {
				RecordMetadataType recordMetadataType = (RecordMetadataType)theEObject;
				T result = caseRecordMetadataType(recordMetadataType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.RECORD_TYPE: {
				RecordType recordType = (RecordType)theEObject;
				T result = caseRecordType(recordType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.RECORD_TYPE_TYPE: {
				RecordTypeType recordTypeType = (RecordTypeType)theEObject;
				T result = caseRecordTypeType(recordTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.REGISTER_INSTANCE_RESPONSE_TYPE: {
				RegisterInstanceResponseType registerInstanceResponseType = (RegisterInstanceResponseType)theEObject;
				T result = caseRegisterInstanceResponseType(registerInstanceResponseType);
				if (result == null) result = caseModelUpdateInstanceResponse(registerInstanceResponseType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.REGISTER_REQUEST_TYPE: {
				RegisterRequestType registerRequestType = (RegisterRequestType)theEObject;
				T result = caseRegisterRequestType(registerRequestType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.REGISTER_RESPONSE_TYPE: {
				RegisterResponseType registerResponseType = (RegisterResponseType)theEObject;
				T result = caseRegisterResponseType(registerResponseType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.REGISTRATION_ERROR_FAULT_TYPE: {
				RegistrationErrorFaultType registrationErrorFaultType = (RegistrationErrorFaultType)theEObject;
				T result = caseRegistrationErrorFaultType(registrationErrorFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.RELATIONSHIP_LIST_TYPE: {
				RelationshipListType relationshipListType = (RelationshipListType)theEObject;
				T result = caseRelationshipListType(relationshipListType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.RELATIONSHIP_REF_TYPE: {
				RelationshipRefType relationshipRefType = (RelationshipRefType)theEObject;
				T result = caseRelationshipRefType(relationshipRefType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.RELATIONSHIP_TEMPLATE_TYPE: {
				RelationshipTemplateType relationshipTemplateType = (RelationshipTemplateType)theEObject;
				T result = caseRelationshipTemplateType(relationshipTemplateType);
				if (result == null) result = caseModelTemplate(relationshipTemplateType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.RELATIONSHIP_TYPE: {
				RelationshipType relationshipType = (RelationshipType)theEObject;
				T result = caseRelationshipType(relationshipType);
				if (result == null) result = caseModelElement(relationshipType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.SELECTED_RECORD_TYPE_TYPE: {
				SelectedRecordTypeType selectedRecordTypeType = (SelectedRecordTypeType)theEObject;
				T result = caseSelectedRecordTypeType(selectedRecordTypeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.SELECTOR_TYPE: {
				SelectorType selectorType = (SelectorType)theEObject;
				T result = caseSelectorType(selectorType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.STRING_OPERATOR_TYPE: {
				StringOperatorType stringOperatorType = (StringOperatorType)theEObject;
				T result = caseStringOperatorType(stringOperatorType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.UNKNOWN_TEMPLATE_ID_FAULT_TYPE: {
				UnknownTemplateIDFaultType unknownTemplateIDFaultType = (UnknownTemplateIDFaultType)theEObject;
				T result = caseUnknownTemplateIDFaultType(unknownTemplateIDFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.UNSUPPORTED_CONSTRAINT_FAULT_TYPE: {
				UnsupportedConstraintFaultType unsupportedConstraintFaultType = (UnsupportedConstraintFaultType)theEObject;
				T result = caseUnsupportedConstraintFaultType(unsupportedConstraintFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.UNSUPPORTED_RECORD_TYPE_FAULT_TYPE: {
				UnsupportedRecordTypeFaultType unsupportedRecordTypeFaultType = (UnsupportedRecordTypeFaultType)theEObject;
				T result = caseUnsupportedRecordTypeFaultType(unsupportedRecordTypeFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.UNSUPPORTED_SELECTOR_FAULT_TYPE: {
				UnsupportedSelectorFaultType unsupportedSelectorFaultType = (UnsupportedSelectorFaultType)theEObject;
				T result = caseUnsupportedSelectorFaultType(unsupportedSelectorFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.XPATH_ERROR_FAULT_TYPE: {
				XPathErrorFaultType xPathErrorFaultType = (XPathErrorFaultType)theEObject;
				T result = caseXPathErrorFaultType(xPathErrorFaultType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.XPATH_EXPRESSION_TYPE: {
				XPathExpressionType xPathExpressionType = (XPathExpressionType)theEObject;
				T result = caseXPathExpressionType(xPathExpressionType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.MODEL_ELEMENT: {
				ModelElement modelElement = (ModelElement)theEObject;
				T result = caseModelElement(modelElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.MODEL_TEMPLATE: {
				ModelTemplate modelTemplate = (ModelTemplate)theEObject;
				T result = caseModelTemplate(modelTemplate);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.MODEL_UPDATE_INSTANCE_RESPONSE: {
				ModelUpdateInstanceResponse modelUpdateInstanceResponse = (ModelUpdateInstanceResponse)theEObject;
				T result = caseModelUpdateInstanceResponse(modelUpdateInstanceResponse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.MODEL_UPDATE_RESPONSE: {
				ModelUpdateResponse modelUpdateResponse = (ModelUpdateResponse)theEObject;
				T result = caseModelUpdateResponse(modelUpdateResponse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.MODEL_RECORD_TYPE: {
				ModelRecordType modelRecordType = (ModelRecordType)theEObject;
				T result = caseModelRecordType(modelRecordType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.MODEL: {
				Model model = (Model)theEObject;
				T result = caseModel(model);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case CmdbfPackage.MODEL_METADATA: {
				ModelMetadata modelMetadata = (ModelMetadata)theEObject;
				T result = caseModelMetadata(modelMetadata);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Accepted Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Accepted Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAcceptedType(AcceptedType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Comparison Operator Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Comparison Operator Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComparisonOperatorType(ComparisonOperatorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constraint Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constraint Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstraintType(ConstraintType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Content Selector Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Content Selector Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContentSelectorType(ContentSelectorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Declined Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Declined Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDeclinedType(DeclinedType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Depth Limit Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Depth Limit Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDepthLimitType(DepthLimitType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Deregister Instance Response Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Deregister Instance Response Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDeregisterInstanceResponseType(DeregisterInstanceResponseType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Deregister Request Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Deregister Request Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDeregisterRequestType(DeregisterRequestType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Deregister Response Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Deregister Response Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDeregisterResponseType(DeregisterResponseType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Deregistration Error Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Deregistration Error Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDeregistrationErrorFaultType(DeregistrationErrorFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Document Root</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Document Root</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDocumentRoot(DocumentRoot object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Edges Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Edges Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEdgesType(EdgesType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Equal Operator Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Equal Operator Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEqualOperatorType(EqualOperatorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expensive Query Error Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expensive Query Error Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpensiveQueryErrorFaultType(ExpensiveQueryErrorFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Instance Id Constraint Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Instance Id Constraint Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInstanceIdConstraintType(InstanceIdConstraintType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Invalid MDR Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Invalid MDR Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInvalidMDRFaultType(InvalidMDRFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Invalid Property Type Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Invalid Property Type Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInvalidPropertyTypeFaultType(InvalidPropertyTypeFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Invalid Record Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Invalid Record Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInvalidRecordFaultType(InvalidRecordFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Item List Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Item List Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseItemListType(ItemListType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Item Template Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Item Template Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseItemTemplateType(ItemTemplateType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Item Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Item Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseItemType(ItemType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mdr Scoped Id List Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mdr Scoped Id List Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMdrScopedIdListType(MdrScopedIdListType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mdr Scoped Id Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mdr Scoped Id Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMdrScopedIdType(MdrScopedIdType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Nodes Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Nodes Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNodesType(NodesType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Null Operator Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Null Operator Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNullOperatorType(NullOperatorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Prefix Mapping Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Prefix Mapping Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePrefixMappingType(PrefixMappingType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Property Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property Name Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePropertyNameType(PropertyNameType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Property Set Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property Set Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePropertySetType(PropertySetType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Property Value Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property Value Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePropertyValueType(PropertyValueType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>QName Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>QName Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQNameType(QNameType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Error Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Error Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryErrorFaultType(QueryErrorFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Result Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Result Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryResultType(QueryResultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryType(QueryType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Record Constraint Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Record Constraint Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRecordConstraintType(RecordConstraintType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Record Metadata Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Record Metadata Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRecordMetadataType(RecordMetadataType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Record Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Record Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRecordType(RecordType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Record Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Record Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRecordTypeType(RecordTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Register Instance Response Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Register Instance Response Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRegisterInstanceResponseType(RegisterInstanceResponseType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Register Request Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Register Request Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRegisterRequestType(RegisterRequestType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Register Response Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Register Response Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRegisterResponseType(RegisterResponseType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Registration Error Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Registration Error Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRegistrationErrorFaultType(RegistrationErrorFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Relationship List Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Relationship List Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRelationshipListType(RelationshipListType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Relationship Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Relationship Ref Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRelationshipRefType(RelationshipRefType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Relationship Template Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Relationship Template Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRelationshipTemplateType(RelationshipTemplateType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Relationship Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Relationship Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRelationshipType(RelationshipType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Selected Record Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Selected Record Type Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSelectedRecordTypeType(SelectedRecordTypeType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Selector Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Selector Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSelectorType(SelectorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>String Operator Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>String Operator Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStringOperatorType(StringOperatorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unknown Template ID Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unknown Template ID Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnknownTemplateIDFaultType(UnknownTemplateIDFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unsupported Constraint Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unsupported Constraint Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnsupportedConstraintFaultType(UnsupportedConstraintFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unsupported Record Type Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unsupported Record Type Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnsupportedRecordTypeFaultType(UnsupportedRecordTypeFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unsupported Selector Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unsupported Selector Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnsupportedSelectorFaultType(UnsupportedSelectorFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>XPath Error Fault Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>XPath Error Fault Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseXPathErrorFaultType(XPathErrorFaultType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>XPath Expression Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>XPath Expression Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseXPathExpressionType(XPathExpressionType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModelElement(ModelElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Template</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModelTemplate(ModelTemplate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Update Instance Response</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Update Instance Response</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModelUpdateInstanceResponse(ModelUpdateInstanceResponse object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Update Response</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Update Response</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModelUpdateResponse(ModelUpdateResponse object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Record Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Record Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModelRecordType(ModelRecordType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModel(Model object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Metadata</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Metadata</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModelMetadata(ModelMetadata object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //CmdbfSwitch
