import java.net.URL;

import javax.xml.namespace.QName;

import org.eclipse.emf.common.util.URI;

import it.unibo.cmdb.monitoring.Monitoring;


public class Test {
	private static final String query =
			"<cmdbf:query xmlns:cmdbf=\"http://schemas.dmtf.org/cmdbf/1/tns/serviceData\">\n" + 
			"   <cmdbf:itemTemplate id=\"nodes\">\n" + 
			"      <cmdbf:recordConstraint>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"SERVER_DEV\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"PORT_DEV\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"LINK_IF\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"NET_IF\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"LINK\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"NET\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"SW\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"FS\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"SW_INST\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"APP\"/>\n" + 
			"      </cmdbf:recordConstraint>\n" + 
			"   </cmdbf:itemTemplate>\n" + 
			"   <cmdbf:relationshipTemplate id=\"edges\" >\n" + 
			"  	  <cmdbf:recordConstraint>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"NodeInfInterfaceComposition\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"DeviceDeviceComposition\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"NodeInfServiceRealization\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"DeviceSystemSoftwareAssignment\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"PortDevLinkIfAggregation\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"LinkIfNetIfAggregation\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"InfInterfaceInfServiceAssignment\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"InfServiceAppServiceUsedBy\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"InfServiceInfServiceUsedBy\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"AppServiceAppServiceUsedBy\"/>\n" + 
			"         <cmdbf:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"SwAppHostingUsedBy\"/>\n" +
			"      </cmdbf:recordConstraint>\n" + 
			"   </cmdbf:relationshipTemplate>\n" + 
			"</cmdbf:query>";
	
	private static final String queryServiceWSDL = "http://localhost:8080/cmdbuild/services/soap/CMDBfQuery?wsdl";
	private static final String queryServiceName = "{http://schemas.dmtf.org/cmdbf/1/tns/query}CMDBfQueryImplService";
	private static final String queryPortName = "{http://schemas.dmtf.org/cmdbf/1/tns/query}CMDBfQueryImplPort";
	private static final String registrationServiceWSDL = "http://localhost:8080/cmdbuild/services/soap/CMDBfRegistration?wsdl";
	private static final String registrationServiceName = "{http://schemas.dmtf.org/cmdbf/1/tns/registration}CMDBfRegistrationImplService";
	private static final String registrationPortName = "{http://schemas.dmtf.org/cmdbf/1/tns/registration}CMDBfRegistrationImplPort";
	
	public static void main(String[] args) throws Exception {
		Monitoring monitoring = new Monitoring(
			new URL(queryServiceWSDL), QName.valueOf(queryServiceName), QName.valueOf(queryPortName),
			new URL(registrationServiceWSDL), QName.valueOf(registrationServiceName), QName.valueOf(registrationPortName),
			"admin", "admin",
			"/tmp/monitoring/atl",
			URI.createFileURI("/home/luca/Projects/cmdb-unibo/opensource/cmdb-monitoring/src/main/model/cmdbuild2icinga.atl"),
			"genHostFile",
			URI.createFileURI("/home/luca/Projects/cmdb-unibo/opensource/cmdb-monitoring/src/main/model/icinga.mtl"));
		monitoring.generateConfiguration(query, "/tmp/monitoring/icinga");
	}

}
