package it.unibo.cmdb.monitoring;

import java.net.URL;

import javax.xml.namespace.QName;

import it.unibo.cmdb.monitoring.model.icinga.IcingaPackage;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

import it.unibo.cmdb.cmdbf.client.CMDBClient;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.Model;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.util.CmdbfResourceFactoryImpl;

public class Monitoring {
	private CMDBClient cmdb;
	private Model2Model m2m;
	private Model2Text m2t;	
	
	public Monitoring(URL queryServiceWSDL, QName queryServiceName, QName queryPortName, URL registrationServiceWSDL, QName registrationServiceName, QName registrationPortName, String username, String password, String compiledPath, URI monitoringTransformation, String textTemplate, URI textTransformation) throws Exception {
		this(
			new CMDBClient(queryServiceWSDL, queryServiceName, queryPortName, registrationServiceWSDL, registrationServiceName, registrationPortName, username, password),
			compiledPath, monitoringTransformation, textTemplate, textTransformation);
	}
	
	public Monitoring(CMDBClient cmdbClient, String compiledPath, URI monitoringTransformation, String textTemplate, URI textTransformation) throws Exception {		
		cmdb = cmdbClient;
		m2m = new Model2Model(compiledPath, "Cmdb", "Monitoring", CmdbfPackage.eINSTANCE.getNsURI(), IcingaPackage.eINSTANCE.getNsURI(), monitoringTransformation);
		m2t = new Model2Text(compiledPath, textTemplate, textTransformation);
	}
	
	public void generateConfiguration(String query, String outputPath) throws Exception {
		Model cmdbModel = cmdb.query(query);
		Resource resource = new CmdbfResourceFactoryImpl().createResource(URI.createURI("cmdb.xmi"));
        resource.getContents().add(cmdbModel);
		
		Resource monitoringModel = m2m.transform(cmdbModel.eResource());
		m2t.transform(monitoringModel, outputPath);
	}
}
