/**
 */
package it.unibo.cmdb.monitoring.model.icinga;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see it.unibo.cmdb.monitoring.model.icinga.IcingaFactory
 * @model kind="package"
 * @generated
 */
public interface IcingaPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "icinga";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.unibo.it/cmdb/monitoring/icinga";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "icinga";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	IcingaPackage eINSTANCE = it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl.init();

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.UserVarImpl <em>User Var</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.UserVarImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getUserVar()
	 * @generated
	 */
	int USER_VAR = 0;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_VAR__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_VAR__VALUE = 1;

	/**
	 * The number of structural features of the '<em>User Var</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_VAR_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>User Var</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_VAR_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.UserValueImpl <em>User Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.UserValueImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getUserValue()
	 * @generated
	 */
	int USER_VALUE = 1;

	/**
	 * The number of structural features of the '<em>User Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_VALUE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>User Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_VALUE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.SimpleUserValueImpl <em>Simple User Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.SimpleUserValueImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getSimpleUserValue()
	 * @generated
	 */
	int SIMPLE_USER_VALUE = 2;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_USER_VALUE__VALUE = USER_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Simple User Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_USER_VALUE_FEATURE_COUNT = USER_VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Simple User Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_USER_VALUE_OPERATION_COUNT = USER_VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.StringUserValueImpl <em>String User Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.StringUserValueImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getStringUserValue()
	 * @generated
	 */
	int STRING_USER_VALUE = 3;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_USER_VALUE__VALUE = SIMPLE_USER_VALUE__VALUE;

	/**
	 * The number of structural features of the '<em>String User Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_USER_VALUE_FEATURE_COUNT = SIMPLE_USER_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>String User Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_USER_VALUE_OPERATION_COUNT = SIMPLE_USER_VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.NumericUserValueImpl <em>Numeric User Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.NumericUserValueImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNumericUserValue()
	 * @generated
	 */
	int NUMERIC_USER_VALUE = 4;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_USER_VALUE__VALUE = SIMPLE_USER_VALUE__VALUE;

	/**
	 * The number of structural features of the '<em>Numeric User Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_USER_VALUE_FEATURE_COUNT = SIMPLE_USER_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Numeric User Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_USER_VALUE_OPERATION_COUNT = SIMPLE_USER_VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ComplexUserValueImpl <em>Complex User Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ComplexUserValueImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getComplexUserValue()
	 * @generated
	 */
	int COMPLEX_USER_VALUE = 5;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_USER_VALUE__VALUE = USER_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Complex User Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_USER_VALUE_FEATURE_COUNT = USER_VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Complex User Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_USER_VALUE_OPERATION_COUNT = USER_VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CommandArgumentImpl <em>Command Argument</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CommandArgumentImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCommandArgument()
	 * @generated
	 */
	int COMMAND_ARGUMENT = 6;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ARGUMENT__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ARGUMENT__KEY = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ARGUMENT__DESCRIPTION = 2;

	/**
	 * The feature id for the '<em><b>Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ARGUMENT__REQUIRED = 3;

	/**
	 * The feature id for the '<em><b>Skip key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ARGUMENT__SKIP_KEY = 4;

	/**
	 * The feature id for the '<em><b>Set if</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ARGUMENT__SET_IF = 5;

	/**
	 * The feature id for the '<em><b>Order</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ARGUMENT__ORDER = 6;

	/**
	 * The feature id for the '<em><b>Repeat key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ARGUMENT__REPEAT_KEY = 7;

	/**
	 * The number of structural features of the '<em>Command Argument</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ARGUMENT_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>Command Argument</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ARGUMENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CommandEnvImpl <em>Command Env</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CommandEnvImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCommandEnv()
	 * @generated
	 */
	int COMMAND_ENV = 7;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ENV__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ENV__KEY = 1;

	/**
	 * The number of structural features of the '<em>Command Env</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ENV_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Command Env</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_ENV_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.DatabaseCleanupImpl <em>Database Cleanup</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.DatabaseCleanupImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getDatabaseCleanup()
	 * @generated
	 */
	int DATABASE_CLEANUP = 8;

	/**
	 * The feature id for the '<em><b>Acknowledgements age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__ACKNOWLEDGEMENTS_AGE = 0;

	/**
	 * The feature id for the '<em><b>Commenthistory age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__COMMENTHISTORY_AGE = 1;

	/**
	 * The feature id for the '<em><b>Contactnotifications age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__CONTACTNOTIFICATIONS_AGE = 2;

	/**
	 * The feature id for the '<em><b>Contactnotificationmethods age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__CONTACTNOTIFICATIONMETHODS_AGE = 3;

	/**
	 * The feature id for the '<em><b>Downtimehistory age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__DOWNTIMEHISTORY_AGE = 4;

	/**
	 * The feature id for the '<em><b>Eventhandlers age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__EVENTHANDLERS_AGE = 5;

	/**
	 * The feature id for the '<em><b>Externalcommands age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__EXTERNALCOMMANDS_AGE = 6;

	/**
	 * The feature id for the '<em><b>Flappinghistory age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__FLAPPINGHISTORY_AGE = 7;

	/**
	 * The feature id for the '<em><b>Hostchecks age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__HOSTCHECKS_AGE = 8;

	/**
	 * The feature id for the '<em><b>Logentries age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__LOGENTRIES_AGE = 9;

	/**
	 * The feature id for the '<em><b>Notifications age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__NOTIFICATIONS_AGE = 10;

	/**
	 * The feature id for the '<em><b>Processevents age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__PROCESSEVENTS_AGE = 11;

	/**
	 * The feature id for the '<em><b>Statehistory age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__STATEHISTORY_AGE = 12;

	/**
	 * The feature id for the '<em><b>Servicechecks age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__SERVICECHECKS_AGE = 13;

	/**
	 * The feature id for the '<em><b>Systemcommands age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP__SYSTEMCOMMANDS_AGE = 14;

	/**
	 * The number of structural features of the '<em>Database Cleanup</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP_FEATURE_COUNT = 15;

	/**
	 * The number of operations of the '<em>Database Cleanup</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATABASE_CLEANUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.TimeRangeImpl <em>Time Range</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.TimeRangeImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getTimeRange()
	 * @generated
	 */
	int TIME_RANGE = 9;

	/**
	 * The feature id for the '<em><b>Directive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_RANGE__DIRECTIVE = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_RANGE__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Time Range</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_RANGE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Time Range</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_RANGE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationTimesImpl <em>Notification Times</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.NotificationTimesImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNotificationTimes()
	 * @generated
	 */
	int NOTIFICATION_TIMES = 10;

	/**
	 * The feature id for the '<em><b>Begin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_TIMES__BEGIN = 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_TIMES__END = 1;

	/**
	 * The number of structural features of the '<em>Notification Times</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_TIMES_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Notification Times</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_TIMES_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.Checkable <em>Checkable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.Checkable
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCheckable()
	 * @generated
	 */
	int CHECKABLE = 11;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECKABLE__DEPENDENCIES = 0;

	/**
	 * The feature id for the '<em><b>Notifications</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECKABLE__NOTIFICATIONS = 1;

	/**
	 * The feature id for the '<em><b>Scheduled Downtimes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECKABLE__SCHEDULED_DOWNTIMES = 2;

	/**
	 * The number of structural features of the '<em>Checkable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECKABLE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Checkable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECKABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.ZoneElement <em>Zone Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.ZoneElement
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getZoneElement()
	 * @generated
	 */
	int ZONE_ELEMENT = 12;

	/**
	 * The feature id for the '<em><b>Zone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE_ELEMENT__ZONE = 0;

	/**
	 * The number of structural features of the '<em>Zone Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE_ELEMENT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Zone Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE_ELEMENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ConfigurationObjectImpl <em>Configuration Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ConfigurationObjectImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getConfigurationObject()
	 * @generated
	 */
	int CONFIGURATION_OBJECT = 13;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_OBJECT__NAME = 0;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_OBJECT__IMPORT = 1;

	/**
	 * The number of structural features of the '<em>Configuration Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_OBJECT_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Configuration Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_OBJECT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CommandImpl <em>Command</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CommandImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCommand()
	 * @generated
	 */
	int COMMAND = 14;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Execute</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND__EXECUTE = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Command</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND__COMMAND = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Env</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND__ENV = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Vars</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND__VARS = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND__TIMEOUT = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Arguments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND__ARGUMENTS = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Command</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Command</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMAND_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CheckCommandImpl <em>Check Command</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CheckCommandImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCheckCommand()
	 * @generated
	 */
	int CHECK_COMMAND = 15;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_COMMAND__NAME = COMMAND__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_COMMAND__IMPORT = COMMAND__IMPORT;

	/**
	 * The feature id for the '<em><b>Execute</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_COMMAND__EXECUTE = COMMAND__EXECUTE;

	/**
	 * The feature id for the '<em><b>Command</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_COMMAND__COMMAND = COMMAND__COMMAND;

	/**
	 * The feature id for the '<em><b>Env</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_COMMAND__ENV = COMMAND__ENV;

	/**
	 * The feature id for the '<em><b>Vars</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_COMMAND__VARS = COMMAND__VARS;

	/**
	 * The feature id for the '<em><b>Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_COMMAND__TIMEOUT = COMMAND__TIMEOUT;

	/**
	 * The feature id for the '<em><b>Arguments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_COMMAND__ARGUMENTS = COMMAND__ARGUMENTS;

	/**
	 * The feature id for the '<em><b>Zone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_COMMAND__ZONE = COMMAND_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Check Command</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_COMMAND_FEATURE_COUNT = COMMAND_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Check Command</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_COMMAND_OPERATION_COUNT = COMMAND_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationCommandImpl <em>Notification Command</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.NotificationCommandImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNotificationCommand()
	 * @generated
	 */
	int NOTIFICATION_COMMAND = 16;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMMAND__NAME = COMMAND__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMMAND__IMPORT = COMMAND__IMPORT;

	/**
	 * The feature id for the '<em><b>Execute</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMMAND__EXECUTE = COMMAND__EXECUTE;

	/**
	 * The feature id for the '<em><b>Command</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMMAND__COMMAND = COMMAND__COMMAND;

	/**
	 * The feature id for the '<em><b>Env</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMMAND__ENV = COMMAND__ENV;

	/**
	 * The feature id for the '<em><b>Vars</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMMAND__VARS = COMMAND__VARS;

	/**
	 * The feature id for the '<em><b>Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMMAND__TIMEOUT = COMMAND__TIMEOUT;

	/**
	 * The feature id for the '<em><b>Arguments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMMAND__ARGUMENTS = COMMAND__ARGUMENTS;

	/**
	 * The feature id for the '<em><b>Zone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMMAND__ZONE = COMMAND_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Notification Command</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMMAND_FEATURE_COUNT = COMMAND_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Notification Command</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMMAND_OPERATION_COUNT = COMMAND_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.EventCommandImpl <em>Event Command</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.EventCommandImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getEventCommand()
	 * @generated
	 */
	int EVENT_COMMAND = 17;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_COMMAND__NAME = COMMAND__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_COMMAND__IMPORT = COMMAND__IMPORT;

	/**
	 * The feature id for the '<em><b>Execute</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_COMMAND__EXECUTE = COMMAND__EXECUTE;

	/**
	 * The feature id for the '<em><b>Command</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_COMMAND__COMMAND = COMMAND__COMMAND;

	/**
	 * The feature id for the '<em><b>Env</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_COMMAND__ENV = COMMAND__ENV;

	/**
	 * The feature id for the '<em><b>Vars</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_COMMAND__VARS = COMMAND__VARS;

	/**
	 * The feature id for the '<em><b>Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_COMMAND__TIMEOUT = COMMAND__TIMEOUT;

	/**
	 * The feature id for the '<em><b>Arguments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_COMMAND__ARGUMENTS = COMMAND__ARGUMENTS;

	/**
	 * The number of structural features of the '<em>Event Command</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_COMMAND_FEATURE_COUNT = COMMAND_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Event Command</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_COMMAND_OPERATION_COUNT = COMMAND_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ScheduledDowntimeImpl <em>Scheduled Downtime</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ScheduledDowntimeImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getScheduledDowntime()
	 * @generated
	 */
	int SCHEDULED_DOWNTIME = 18;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULED_DOWNTIME__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULED_DOWNTIME__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Zone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULED_DOWNTIME__ZONE = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Checkable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULED_DOWNTIME__CHECKABLE = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Author</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULED_DOWNTIME__AUTHOR = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULED_DOWNTIME__COMMENT = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Fixed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULED_DOWNTIME__FIXED = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Duration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULED_DOWNTIME__DURATION = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Ranges</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULED_DOWNTIME__RANGES = CONFIGURATION_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Scheduled Downtime</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULED_DOWNTIME_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>Scheduled Downtime</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULED_DOWNTIME_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl <em>Dependency</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getDependency()
	 * @generated
	 */
	int DEPENDENCY = 19;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Zone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY__ZONE = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY__PARENT = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Child</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY__CHILD = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Disable checks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY__DISABLE_CHECKS = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Disable notifications</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY__DISABLE_NOTIFICATIONS = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Ignore soft states</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY__IGNORE_SOFT_STATES = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Period</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY__PERIOD = CONFIGURATION_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>States</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY__STATES = CONFIGURATION_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Dependency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Dependency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl <em>Notification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNotification()
	 * @generated
	 */
	int NOTIFICATION = 20;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Zone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__ZONE = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Checkable</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__CHECKABLE = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Vars</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__VARS = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Users</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__USERS = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>User groups</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__USER_GROUPS = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Times</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__TIMES = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Command</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__COMMAND = CONFIGURATION_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__INTERVAL = CONFIGURATION_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Period</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__PERIOD = CONFIGURATION_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Types</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__TYPES = CONFIGURATION_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>States</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__STATES = CONFIGURATION_OBJECT_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>Notification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 11;

	/**
	 * The number of operations of the '<em>Notification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.TimePeriodImpl <em>Time Period</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.TimePeriodImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getTimePeriod()
	 * @generated
	 */
	int TIME_PERIOD = 21;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PERIOD__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PERIOD__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Zone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PERIOD__ZONE = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Display name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PERIOD__DISPLAY_NAME = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Update</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PERIOD__UPDATE = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Ranges</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PERIOD__RANGES = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Time Period</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PERIOD_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Time Period</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PERIOD_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.HostImpl <em>Host</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.HostImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getHost()
	 * @generated
	 */
	int HOST = 22;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__DEPENDENCIES = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Notifications</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__NOTIFICATIONS = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Scheduled Downtimes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__SCHEDULED_DOWNTIMES = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Zone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ZONE = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Display name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__DISPLAY_NAME = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ADDRESS = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Address6</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ADDRESS6 = CONFIGURATION_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__GROUPS = CONFIGURATION_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Vars</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__VARS = CONFIGURATION_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Check command</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__CHECK_COMMAND = CONFIGURATION_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Max check attempts</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__MAX_CHECK_ATTEMPTS = CONFIGURATION_OBJECT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Check period</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__CHECK_PERIOD = CONFIGURATION_OBJECT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Check interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__CHECK_INTERVAL = CONFIGURATION_OBJECT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Retry interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__RETRY_INTERVAL = CONFIGURATION_OBJECT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Enable notifications</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ENABLE_NOTIFICATIONS = CONFIGURATION_OBJECT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Enable active checks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ENABLE_ACTIVE_CHECKS = CONFIGURATION_OBJECT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Enable passive checks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ENABLE_PASSIVE_CHECKS = CONFIGURATION_OBJECT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Enable event handler</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ENABLE_EVENT_HANDLER = CONFIGURATION_OBJECT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable flapping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ENABLE_FLAPPING = CONFIGURATION_OBJECT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Enable perfdata</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ENABLE_PERFDATA = CONFIGURATION_OBJECT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Event command</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__EVENT_COMMAND = CONFIGURATION_OBJECT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Flapping threshold</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__FLAPPING_THRESHOLD = CONFIGURATION_OBJECT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Volatile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__VOLATILE = CONFIGURATION_OBJECT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Command endpoint</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__COMMAND_ENDPOINT = CONFIGURATION_OBJECT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Notes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__NOTES = CONFIGURATION_OBJECT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Notes url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__NOTES_URL = CONFIGURATION_OBJECT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Action url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ACTION_URL = CONFIGURATION_OBJECT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Icon image</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ICON_IMAGE = CONFIGURATION_OBJECT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Icon image alt</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__ICON_IMAGE_ALT = CONFIGURATION_OBJECT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Services</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST__SERVICES = CONFIGURATION_OBJECT_FEATURE_COUNT + 29;

	/**
	 * The number of structural features of the '<em>Host</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 30;

	/**
	 * The number of operations of the '<em>Host</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.HostGroupImpl <em>Host Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.HostGroupImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getHostGroup()
	 * @generated
	 */
	int HOST_GROUP = 23;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST_GROUP__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST_GROUP__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Display name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST_GROUP__DISPLAY_NAME = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST_GROUP__GROUPS = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Host Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST_GROUP_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Host Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOST_GROUP_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl <em>Service</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getService()
	 * @generated
	 */
	int SERVICE = 24;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__DEPENDENCIES = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Notifications</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__NOTIFICATIONS = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Scheduled Downtimes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__SCHEDULED_DOWNTIMES = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Zone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__ZONE = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Display name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__DISPLAY_NAME = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Host</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__HOST = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__GROUPS = CONFIGURATION_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Vars</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__VARS = CONFIGURATION_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Check command</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__CHECK_COMMAND = CONFIGURATION_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Max check attempts</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__MAX_CHECK_ATTEMPTS = CONFIGURATION_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Check period</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__CHECK_PERIOD = CONFIGURATION_OBJECT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Check interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__CHECK_INTERVAL = CONFIGURATION_OBJECT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Retry interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__RETRY_INTERVAL = CONFIGURATION_OBJECT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Enable notifications</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__ENABLE_NOTIFICATIONS = CONFIGURATION_OBJECT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Enable active checks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__ENABLE_ACTIVE_CHECKS = CONFIGURATION_OBJECT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Enable passive checks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__ENABLE_PASSIVE_CHECKS = CONFIGURATION_OBJECT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Enable event handler</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__ENABLE_EVENT_HANDLER = CONFIGURATION_OBJECT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Enable flapping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__ENABLE_FLAPPING = CONFIGURATION_OBJECT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enable perfdata</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__ENABLE_PERFDATA = CONFIGURATION_OBJECT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Event command</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__EVENT_COMMAND = CONFIGURATION_OBJECT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Flapping threshold</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__FLAPPING_THRESHOLD = CONFIGURATION_OBJECT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Volatile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__VOLATILE = CONFIGURATION_OBJECT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Command endpoint</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__COMMAND_ENDPOINT = CONFIGURATION_OBJECT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Notes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__NOTES = CONFIGURATION_OBJECT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Notes url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__NOTES_URL = CONFIGURATION_OBJECT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Action url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__ACTION_URL = CONFIGURATION_OBJECT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Icon image</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__ICON_IMAGE = CONFIGURATION_OBJECT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Icon image alt</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__ICON_IMAGE_ALT = CONFIGURATION_OBJECT_FEATURE_COUNT + 27;

	/**
	 * The number of structural features of the '<em>Service</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 28;

	/**
	 * The number of operations of the '<em>Service</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceGroupImpl <em>Service Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ServiceGroupImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getServiceGroup()
	 * @generated
	 */
	int SERVICE_GROUP = 25;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_GROUP__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_GROUP__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Display name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_GROUP__DISPLAY_NAME = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_GROUP__GROUPS = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Service Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_GROUP_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Service Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_GROUP_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.UserImpl <em>User</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.UserImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getUser()
	 * @generated
	 */
	int USER = 26;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Zone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__ZONE = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Display name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__DISPLAY_NAME = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Email</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__EMAIL = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Pager</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__PAGER = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Vars</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__VARS = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__GROUPS = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Enable notifications</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__ENABLE_NOTIFICATIONS = CONFIGURATION_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Period</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__PERIOD = CONFIGURATION_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Types</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__TYPES = CONFIGURATION_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>States</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER__STATES = CONFIGURATION_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>User</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>User</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.UserGroupImpl <em>User Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.UserGroupImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getUserGroup()
	 * @generated
	 */
	int USER_GROUP = 27;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_GROUP__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_GROUP__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Zone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_GROUP__ZONE = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Display name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_GROUP__DISPLAY_NAME = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_GROUP__GROUPS = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>User Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_GROUP_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>User Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_GROUP_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ZoneImpl <em>Zone</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ZoneImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getZone()
	 * @generated
	 */
	int ZONE = 28;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Endpoints</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE__ENDPOINTS = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE__PARENT = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Global</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE__GLOBAL = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE__ELEMENTS = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Subzones</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE__SUBZONES = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Zone</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Zone</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZONE_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.EndpointImpl <em>Endpoint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.EndpointImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getEndpoint()
	 * @generated
	 */
	int ENDPOINT = 29;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT__HOST = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT__PORT = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Log duration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT__LOG_DURATION = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Endpoint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Endpoint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CheckerComponentImpl <em>Checker Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CheckerComponentImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCheckerComponent()
	 * @generated
	 */
	int CHECKER_COMPONENT = 30;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECKER_COMPONENT__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECKER_COMPONENT__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The number of structural features of the '<em>Checker Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECKER_COMPONENT_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Checker Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECKER_COMPONENT_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationComponentImpl <em>Notification Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.NotificationComponentImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNotificationComponent()
	 * @generated
	 */
	int NOTIFICATION_COMPONENT = 31;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMPONENT__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMPONENT__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Enable ha</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMPONENT__ENABLE_HA = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Notification Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMPONENT_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Notification Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_COMPONENT_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CheckResultReaderImpl <em>Check Result Reader</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CheckResultReaderImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCheckResultReader()
	 * @generated
	 */
	int CHECK_RESULT_READER = 32;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_RESULT_READER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_RESULT_READER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Spool dir</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_RESULT_READER__SPOOL_DIR = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Check Result Reader</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_RESULT_READER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Check Result Reader</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_RESULT_READER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ApiListenerImpl <em>Api Listener</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ApiListenerImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getApiListener()
	 * @generated
	 */
	int API_LISTENER = 33;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Cert path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER__CERT_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Key path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER__KEY_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ca path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER__CA_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Crl path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER__CRL_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Bind host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER__BIND_HOST = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Bind port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER__BIND_PORT = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Accept config</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER__ACCEPT_CONFIG = CONFIGURATION_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Accept commands</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER__ACCEPT_COMMANDS = CONFIGURATION_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Api Listener</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Api Listener</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_LISTENER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.LiveStatusListenerImpl <em>Live Status Listener</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.LiveStatusListenerImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getLiveStatusListener()
	 * @generated
	 */
	int LIVE_STATUS_LISTENER = 34;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIVE_STATUS_LISTENER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIVE_STATUS_LISTENER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Socket type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIVE_STATUS_LISTENER__SOCKET_TYPE = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Bind host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIVE_STATUS_LISTENER__BIND_HOST = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Bind port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIVE_STATUS_LISTENER__BIND_PORT = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Socket path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIVE_STATUS_LISTENER__SOCKET_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Compat log path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIVE_STATUS_LISTENER__COMPAT_LOG_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Live Status Listener</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIVE_STATUS_LISTENER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Live Status Listener</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIVE_STATUS_LISTENER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ExternalCommandListenerImpl <em>External Command Listener</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ExternalCommandListenerImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getExternalCommandListener()
	 * @generated
	 */
	int EXTERNAL_COMMAND_LISTENER = 35;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_COMMAND_LISTENER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_COMMAND_LISTENER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Command path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_COMMAND_LISTENER__COMMAND_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>External Command Listener</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_COMMAND_LISTENER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>External Command Listener</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_COMMAND_LISTENER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CompatLoggerImpl <em>Compat Logger</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CompatLoggerImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCompatLogger()
	 * @generated
	 */
	int COMPAT_LOGGER = 36;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPAT_LOGGER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPAT_LOGGER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Log dir</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPAT_LOGGER__LOG_DIR = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Rotation method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPAT_LOGGER__ROTATION_METHOD = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Compat Logger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPAT_LOGGER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Compat Logger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPAT_LOGGER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.FileLoggerImpl <em>File Logger</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.FileLoggerImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getFileLogger()
	 * @generated
	 */
	int FILE_LOGGER = 37;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_LOGGER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_LOGGER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_LOGGER__PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_LOGGER__SEVERITY = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>File Logger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_LOGGER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>File Logger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_LOGGER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.SyslogLoggerImpl <em>Syslog Logger</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.SyslogLoggerImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getSyslogLogger()
	 * @generated
	 */
	int SYSLOG_LOGGER = 38;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSLOG_LOGGER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSLOG_LOGGER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSLOG_LOGGER__SEVERITY = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Syslog Logger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSLOG_LOGGER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Syslog Logger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSLOG_LOGGER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.GelfWriterImpl <em>Gelf Writer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.GelfWriterImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getGelfWriter()
	 * @generated
	 */
	int GELF_WRITER = 39;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GELF_WRITER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GELF_WRITER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GELF_WRITER__HOST = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GELF_WRITER__PORT = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GELF_WRITER__SOURCE = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Gelf Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GELF_WRITER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Gelf Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GELF_WRITER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.GraphiteWriterImpl <em>Graphite Writer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.GraphiteWriterImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getGraphiteWriter()
	 * @generated
	 */
	int GRAPHITE_WRITER = 40;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHITE_WRITER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHITE_WRITER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHITE_WRITER__HOST = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHITE_WRITER__PORT = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Host name template</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHITE_WRITER__HOST_NAME_TEMPLATE = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Service name template</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHITE_WRITER__SERVICE_NAME_TEMPLATE = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Graphite Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHITE_WRITER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Graphite Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHITE_WRITER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.IcingaStatusWriterImpl <em>Status Writer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaStatusWriterImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getIcingaStatusWriter()
	 * @generated
	 */
	int ICINGA_STATUS_WRITER = 41;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICINGA_STATUS_WRITER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICINGA_STATUS_WRITER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Status path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICINGA_STATUS_WRITER__STATUS_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Update interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICINGA_STATUS_WRITER__UPDATE_INTERVAL = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Status Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICINGA_STATUS_WRITER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Status Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICINGA_STATUS_WRITER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.OpenTsdbWriterImpl <em>Open Tsdb Writer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.OpenTsdbWriterImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getOpenTsdbWriter()
	 * @generated
	 */
	int OPEN_TSDB_WRITER = 42;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_TSDB_WRITER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_TSDB_WRITER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_TSDB_WRITER__HOST = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_TSDB_WRITER__PORT = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Open Tsdb Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_TSDB_WRITER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Open Tsdb Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_TSDB_WRITER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.PerfdataWriterImpl <em>Perfdata Writer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.PerfdataWriterImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getPerfdataWriter()
	 * @generated
	 */
	int PERFDATA_WRITER = 43;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFDATA_WRITER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFDATA_WRITER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Host perfdata path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFDATA_WRITER__HOST_PERFDATA_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Service perfdata path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFDATA_WRITER__SERVICE_PERFDATA_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Host temp path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFDATA_WRITER__HOST_TEMP_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Service temp path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFDATA_WRITER__SERVICE_TEMP_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Host format template</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFDATA_WRITER__HOST_FORMAT_TEMPLATE = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Service format template</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFDATA_WRITER__SERVICE_FORMAT_TEMPLATE = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Rotation interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFDATA_WRITER__ROTATION_INTERVAL = CONFIGURATION_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Perfdata Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFDATA_WRITER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>Perfdata Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFDATA_WRITER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.StatusDataWriterImpl <em>Status Data Writer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.StatusDataWriterImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getStatusDataWriter()
	 * @generated
	 */
	int STATUS_DATA_WRITER = 44;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS_DATA_WRITER__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS_DATA_WRITER__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Status path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS_DATA_WRITER__STATUS_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Objects path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS_DATA_WRITER__OBJECTS_PATH = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Update interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS_DATA_WRITER__UPDATE_INTERVAL = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Status Data Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS_DATA_WRITER_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Status Data Writer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS_DATA_WRITER_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl <em>Ido Connection</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getIdoConnection()
	 * @generated
	 */
	int IDO_CONNECTION = 45;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__NAME = CONFIGURATION_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__IMPORT = CONFIGURATION_OBJECT__IMPORT;

	/**
	 * The feature id for the '<em><b>Host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__HOST = CONFIGURATION_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__PORT = CONFIGURATION_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>User</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__USER = CONFIGURATION_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__PASSWORD = CONFIGURATION_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Database</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__DATABASE = CONFIGURATION_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Table prefix</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__TABLE_PREFIX = CONFIGURATION_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Instance name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__INSTANCE_NAME = CONFIGURATION_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Instance description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__INSTANCE_DESCRIPTION = CONFIGURATION_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Enable ha</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__ENABLE_HA = CONFIGURATION_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Failover timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__FAILOVER_TIMEOUT = CONFIGURATION_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Cleanup</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__CLEANUP = CONFIGURATION_OBJECT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Categories</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION__CATEGORIES = CONFIGURATION_OBJECT_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Ido Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION_FEATURE_COUNT = CONFIGURATION_OBJECT_FEATURE_COUNT + 12;

	/**
	 * The number of operations of the '<em>Ido Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_CONNECTION_OPERATION_COUNT = CONFIGURATION_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoMySqlConnectionImpl <em>Ido My Sql Connection</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IdoMySqlConnectionImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getIdoMySqlConnection()
	 * @generated
	 */
	int IDO_MY_SQL_CONNECTION = 46;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__NAME = IDO_CONNECTION__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__IMPORT = IDO_CONNECTION__IMPORT;

	/**
	 * The feature id for the '<em><b>Host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__HOST = IDO_CONNECTION__HOST;

	/**
	 * The feature id for the '<em><b>Port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__PORT = IDO_CONNECTION__PORT;

	/**
	 * The feature id for the '<em><b>User</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__USER = IDO_CONNECTION__USER;

	/**
	 * The feature id for the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__PASSWORD = IDO_CONNECTION__PASSWORD;

	/**
	 * The feature id for the '<em><b>Database</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__DATABASE = IDO_CONNECTION__DATABASE;

	/**
	 * The feature id for the '<em><b>Table prefix</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__TABLE_PREFIX = IDO_CONNECTION__TABLE_PREFIX;

	/**
	 * The feature id for the '<em><b>Instance name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__INSTANCE_NAME = IDO_CONNECTION__INSTANCE_NAME;

	/**
	 * The feature id for the '<em><b>Instance description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__INSTANCE_DESCRIPTION = IDO_CONNECTION__INSTANCE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Enable ha</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__ENABLE_HA = IDO_CONNECTION__ENABLE_HA;

	/**
	 * The feature id for the '<em><b>Failover timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__FAILOVER_TIMEOUT = IDO_CONNECTION__FAILOVER_TIMEOUT;

	/**
	 * The feature id for the '<em><b>Cleanup</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__CLEANUP = IDO_CONNECTION__CLEANUP;

	/**
	 * The feature id for the '<em><b>Categories</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__CATEGORIES = IDO_CONNECTION__CATEGORIES;

	/**
	 * The feature id for the '<em><b>Socket path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION__SOCKET_PATH = IDO_CONNECTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ido My Sql Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION_FEATURE_COUNT = IDO_CONNECTION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Ido My Sql Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_MY_SQL_CONNECTION_OPERATION_COUNT = IDO_CONNECTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoPgSqlConnectionImpl <em>Ido Pg Sql Connection</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IdoPgSqlConnectionImpl
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getIdoPgSqlConnection()
	 * @generated
	 */
	int IDO_PG_SQL_CONNECTION = 47;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__NAME = IDO_CONNECTION__NAME;

	/**
	 * The feature id for the '<em><b>Import</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__IMPORT = IDO_CONNECTION__IMPORT;

	/**
	 * The feature id for the '<em><b>Host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__HOST = IDO_CONNECTION__HOST;

	/**
	 * The feature id for the '<em><b>Port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__PORT = IDO_CONNECTION__PORT;

	/**
	 * The feature id for the '<em><b>User</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__USER = IDO_CONNECTION__USER;

	/**
	 * The feature id for the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__PASSWORD = IDO_CONNECTION__PASSWORD;

	/**
	 * The feature id for the '<em><b>Database</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__DATABASE = IDO_CONNECTION__DATABASE;

	/**
	 * The feature id for the '<em><b>Table prefix</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__TABLE_PREFIX = IDO_CONNECTION__TABLE_PREFIX;

	/**
	 * The feature id for the '<em><b>Instance name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__INSTANCE_NAME = IDO_CONNECTION__INSTANCE_NAME;

	/**
	 * The feature id for the '<em><b>Instance description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__INSTANCE_DESCRIPTION = IDO_CONNECTION__INSTANCE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Enable ha</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__ENABLE_HA = IDO_CONNECTION__ENABLE_HA;

	/**
	 * The feature id for the '<em><b>Failover timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__FAILOVER_TIMEOUT = IDO_CONNECTION__FAILOVER_TIMEOUT;

	/**
	 * The feature id for the '<em><b>Cleanup</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__CLEANUP = IDO_CONNECTION__CLEANUP;

	/**
	 * The feature id for the '<em><b>Categories</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION__CATEGORIES = IDO_CONNECTION__CATEGORIES;

	/**
	 * The number of structural features of the '<em>Ido Pg Sql Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION_FEATURE_COUNT = IDO_CONNECTION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Ido Pg Sql Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDO_PG_SQL_CONNECTION_OPERATION_COUNT = IDO_CONNECTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCategory <em>Database Category</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCategory
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getDatabaseCategory()
	 * @generated
	 */
	int DATABASE_CATEGORY = 48;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.NotificationType <em>Notification Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.NotificationType
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNotificationType()
	 * @generated
	 */
	int NOTIFICATION_TYPE = 49;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.LogRotationMethod <em>Log Rotation Method</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.LogRotationMethod
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getLogRotationMethod()
	 * @generated
	 */
	int LOG_ROTATION_METHOD = 50;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.LogSeverity <em>Log Severity</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.LogSeverity
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getLogSeverity()
	 * @generated
	 */
	int LOG_SEVERITY = 51;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.SocketType <em>Socket Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.SocketType
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getSocketType()
	 * @generated
	 */
	int SOCKET_TYPE = 52;

	/**
	 * The meta object id for the '{@link it.unibo.cmdb.monitoring.model.icinga.State <em>State</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see it.unibo.cmdb.monitoring.model.icinga.State
	 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getState()
	 * @generated
	 */
	int STATE = 53;


	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.UserVar <em>User Var</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>User Var</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.UserVar
	 * @generated
	 */
	EClass getUserVar();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.UserVar#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.UserVar#getKey()
	 * @see #getUserVar()
	 * @generated
	 */
	EAttribute getUserVar_Key();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.UserVar#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Value</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.UserVar#getValue()
	 * @see #getUserVar()
	 * @generated
	 */
	EReference getUserVar_Value();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.UserValue <em>User Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>User Value</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.UserValue
	 * @generated
	 */
	EClass getUserValue();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.SimpleUserValue <em>Simple User Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Simple User Value</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.SimpleUserValue
	 * @generated
	 */
	EClass getSimpleUserValue();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.SimpleUserValue#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.SimpleUserValue#getValue()
	 * @see #getSimpleUserValue()
	 * @generated
	 */
	EAttribute getSimpleUserValue_Value();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.StringUserValue <em>String User Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String User Value</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.StringUserValue
	 * @generated
	 */
	EClass getStringUserValue();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.NumericUserValue <em>Numeric User Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Numeric User Value</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.NumericUserValue
	 * @generated
	 */
	EClass getNumericUserValue();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.ComplexUserValue <em>Complex User Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Complex User Value</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ComplexUserValue
	 * @generated
	 */
	EClass getComplexUserValue();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.ComplexUserValue#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Value</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ComplexUserValue#getValue()
	 * @see #getComplexUserValue()
	 * @generated
	 */
	EReference getComplexUserValue_Value();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.CommandArgument <em>Command Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Command Argument</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandArgument
	 * @generated
	 */
	EClass getCommandArgument();

	/**
	 * Returns the meta object for the attribute list '{@link it.unibo.cmdb.monitoring.model.icinga.CommandArgument#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Value</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandArgument#getValue()
	 * @see #getCommandArgument()
	 * @generated
	 */
	EAttribute getCommandArgument_Value();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.CommandArgument#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandArgument#getKey()
	 * @see #getCommandArgument()
	 * @generated
	 */
	EAttribute getCommandArgument_Key();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.CommandArgument#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandArgument#getDescription()
	 * @see #getCommandArgument()
	 * @generated
	 */
	EAttribute getCommandArgument_Description();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.CommandArgument#isRequired <em>Required</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Required</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandArgument#isRequired()
	 * @see #getCommandArgument()
	 * @generated
	 */
	EAttribute getCommandArgument_Required();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.CommandArgument#isSkip_key <em>Skip key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Skip key</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandArgument#isSkip_key()
	 * @see #getCommandArgument()
	 * @generated
	 */
	EAttribute getCommandArgument_Skip_key();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.CommandArgument#getSet_if <em>Set if</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Set if</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandArgument#getSet_if()
	 * @see #getCommandArgument()
	 * @generated
	 */
	EAttribute getCommandArgument_Set_if();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.CommandArgument#isOrder <em>Order</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Order</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandArgument#isOrder()
	 * @see #getCommandArgument()
	 * @generated
	 */
	EAttribute getCommandArgument_Order();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.CommandArgument#isRepeat_key <em>Repeat key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Repeat key</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandArgument#isRepeat_key()
	 * @see #getCommandArgument()
	 * @generated
	 */
	EAttribute getCommandArgument_Repeat_key();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.CommandEnv <em>Command Env</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Command Env</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandEnv
	 * @generated
	 */
	EClass getCommandEnv();

	/**
	 * Returns the meta object for the attribute list '{@link it.unibo.cmdb.monitoring.model.icinga.CommandEnv#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Value</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandEnv#getValue()
	 * @see #getCommandEnv()
	 * @generated
	 */
	EAttribute getCommandEnv_Value();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.CommandEnv#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CommandEnv#getKey()
	 * @see #getCommandEnv()
	 * @generated
	 */
	EAttribute getCommandEnv_Key();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup <em>Database Cleanup</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Database Cleanup</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup
	 * @generated
	 */
	EClass getDatabaseCleanup();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getAcknowledgements_age <em>Acknowledgements age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Acknowledgements age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getAcknowledgements_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Acknowledgements_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getCommenthistory_age <em>Commenthistory age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Commenthistory age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getCommenthistory_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Commenthistory_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getContactnotifications_age <em>Contactnotifications age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Contactnotifications age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getContactnotifications_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Contactnotifications_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getContactnotificationmethods_age <em>Contactnotificationmethods age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Contactnotificationmethods age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getContactnotificationmethods_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Contactnotificationmethods_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getDowntimehistory_age <em>Downtimehistory age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Downtimehistory age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getDowntimehistory_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Downtimehistory_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getEventhandlers_age <em>Eventhandlers age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Eventhandlers age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getEventhandlers_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Eventhandlers_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getExternalcommands_age <em>Externalcommands age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Externalcommands age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getExternalcommands_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Externalcommands_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getFlappinghistory_age <em>Flappinghistory age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Flappinghistory age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getFlappinghistory_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Flappinghistory_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getHostchecks_age <em>Hostchecks age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hostchecks age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getHostchecks_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Hostchecks_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getLogentries_age <em>Logentries age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Logentries age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getLogentries_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Logentries_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getNotifications_age <em>Notifications age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Notifications age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getNotifications_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Notifications_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getProcessevents_age <em>Processevents age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Processevents age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getProcessevents_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Processevents_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getStatehistory_age <em>Statehistory age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Statehistory age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getStatehistory_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Statehistory_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getServicechecks_age <em>Servicechecks age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Servicechecks age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getServicechecks_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Servicechecks_age();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getSystemcommands_age <em>Systemcommands age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Systemcommands age</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCleanup#getSystemcommands_age()
	 * @see #getDatabaseCleanup()
	 * @generated
	 */
	EAttribute getDatabaseCleanup_Systemcommands_age();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.TimeRange <em>Time Range</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Range</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.TimeRange
	 * @generated
	 */
	EClass getTimeRange();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.TimeRange#getDirective <em>Directive</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Directive</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.TimeRange#getDirective()
	 * @see #getTimeRange()
	 * @generated
	 */
	EAttribute getTimeRange_Directive();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.TimeRange#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.TimeRange#getValue()
	 * @see #getTimeRange()
	 * @generated
	 */
	EAttribute getTimeRange_Value();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.NotificationTimes <em>Notification Times</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Notification Times</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.NotificationTimes
	 * @generated
	 */
	EClass getNotificationTimes();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.NotificationTimes#getBegin <em>Begin</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Begin</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.NotificationTimes#getBegin()
	 * @see #getNotificationTimes()
	 * @generated
	 */
	EAttribute getNotificationTimes_Begin();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.NotificationTimes#getEnd <em>End</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.NotificationTimes#getEnd()
	 * @see #getNotificationTimes()
	 * @generated
	 */
	EAttribute getNotificationTimes_End();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.Checkable <em>Checkable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Checkable</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Checkable
	 * @generated
	 */
	EClass getCheckable();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Checkable#getDependencies <em>Dependencies</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Dependencies</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Checkable#getDependencies()
	 * @see #getCheckable()
	 * @generated
	 */
	EReference getCheckable_Dependencies();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Checkable#getNotifications <em>Notifications</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Notifications</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Checkable#getNotifications()
	 * @see #getCheckable()
	 * @generated
	 */
	EReference getCheckable_Notifications();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Checkable#getScheduledDowntimes <em>Scheduled Downtimes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Scheduled Downtimes</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Checkable#getScheduledDowntimes()
	 * @see #getCheckable()
	 * @generated
	 */
	EReference getCheckable_ScheduledDowntimes();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.ZoneElement <em>Zone Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Zone Element</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ZoneElement
	 * @generated
	 */
	EClass getZoneElement();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.ZoneElement#getZone <em>Zone</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Zone</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ZoneElement#getZone()
	 * @see #getZoneElement()
	 * @generated
	 */
	EReference getZoneElement_Zone();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.ConfigurationObject <em>Configuration Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Configuration Object</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ConfigurationObject
	 * @generated
	 */
	EClass getConfigurationObject();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ConfigurationObject#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ConfigurationObject#getName()
	 * @see #getConfigurationObject()
	 * @generated
	 */
	EAttribute getConfigurationObject_Name();

	/**
	 * Returns the meta object for the attribute list '{@link it.unibo.cmdb.monitoring.model.icinga.ConfigurationObject#getImport <em>Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Import</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ConfigurationObject#getImport()
	 * @see #getConfigurationObject()
	 * @generated
	 */
	EAttribute getConfigurationObject_Import();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.Command <em>Command</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Command</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Command
	 * @generated
	 */
	EClass getCommand();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Command#getExecute <em>Execute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Execute</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Command#getExecute()
	 * @see #getCommand()
	 * @generated
	 */
	EAttribute getCommand_Execute();

	/**
	 * Returns the meta object for the attribute list '{@link it.unibo.cmdb.monitoring.model.icinga.Command#getCommand <em>Command</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Command</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Command#getCommand()
	 * @see #getCommand()
	 * @generated
	 */
	EAttribute getCommand_Command();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Command#getEnv <em>Env</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Env</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Command#getEnv()
	 * @see #getCommand()
	 * @generated
	 */
	EReference getCommand_Env();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Command#getVars <em>Vars</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Vars</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Command#getVars()
	 * @see #getCommand()
	 * @generated
	 */
	EReference getCommand_Vars();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Command#getTimeout <em>Timeout</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timeout</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Command#getTimeout()
	 * @see #getCommand()
	 * @generated
	 */
	EAttribute getCommand_Timeout();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Command#getArguments <em>Arguments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Arguments</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Command#getArguments()
	 * @see #getCommand()
	 * @generated
	 */
	EReference getCommand_Arguments();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.CheckCommand <em>Check Command</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Check Command</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CheckCommand
	 * @generated
	 */
	EClass getCheckCommand();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.NotificationCommand <em>Notification Command</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Notification Command</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.NotificationCommand
	 * @generated
	 */
	EClass getNotificationCommand();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.EventCommand <em>Event Command</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Command</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.EventCommand
	 * @generated
	 */
	EClass getEventCommand();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime <em>Scheduled Downtime</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scheduled Downtime</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime
	 * @generated
	 */
	EClass getScheduledDowntime();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#getCheckable <em>Checkable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Checkable</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#getCheckable()
	 * @see #getScheduledDowntime()
	 * @generated
	 */
	EReference getScheduledDowntime_Checkable();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#getAuthor <em>Author</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Author</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#getAuthor()
	 * @see #getScheduledDowntime()
	 * @generated
	 */
	EAttribute getScheduledDowntime_Author();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#getComment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comment</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#getComment()
	 * @see #getScheduledDowntime()
	 * @generated
	 */
	EAttribute getScheduledDowntime_Comment();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#isFixed <em>Fixed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fixed</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#isFixed()
	 * @see #getScheduledDowntime()
	 * @generated
	 */
	EAttribute getScheduledDowntime_Fixed();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#getDuration <em>Duration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Duration</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#getDuration()
	 * @see #getScheduledDowntime()
	 * @generated
	 */
	EAttribute getScheduledDowntime_Duration();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#getRanges <em>Ranges</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Ranges</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime#getRanges()
	 * @see #getScheduledDowntime()
	 * @generated
	 */
	EReference getScheduledDowntime_Ranges();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.Dependency <em>Dependency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Dependency</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Dependency
	 * @generated
	 */
	EClass getDependency();

	/**
	 * Returns the meta object for the container reference '{@link it.unibo.cmdb.monitoring.model.icinga.Dependency#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Parent</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Dependency#getParent()
	 * @see #getDependency()
	 * @generated
	 */
	EReference getDependency_Parent();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Dependency#getChild <em>Child</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Child</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Dependency#getChild()
	 * @see #getDependency()
	 * @generated
	 */
	EReference getDependency_Child();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Dependency#isDisable_checks <em>Disable checks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Disable checks</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Dependency#isDisable_checks()
	 * @see #getDependency()
	 * @generated
	 */
	EAttribute getDependency_Disable_checks();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Dependency#isDisable_notifications <em>Disable notifications</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Disable notifications</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Dependency#isDisable_notifications()
	 * @see #getDependency()
	 * @generated
	 */
	EAttribute getDependency_Disable_notifications();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Dependency#isIgnore_soft_states <em>Ignore soft states</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ignore soft states</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Dependency#isIgnore_soft_states()
	 * @see #getDependency()
	 * @generated
	 */
	EAttribute getDependency_Ignore_soft_states();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Dependency#getPeriod <em>Period</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Period</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Dependency#getPeriod()
	 * @see #getDependency()
	 * @generated
	 */
	EReference getDependency_Period();

	/**
	 * Returns the meta object for the attribute list '{@link it.unibo.cmdb.monitoring.model.icinga.Dependency#getStates <em>States</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>States</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Dependency#getStates()
	 * @see #getDependency()
	 * @generated
	 */
	EAttribute getDependency_States();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.Notification <em>Notification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Notification</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Notification
	 * @generated
	 */
	EClass getNotification();

	/**
	 * Returns the meta object for the container reference '{@link it.unibo.cmdb.monitoring.model.icinga.Notification#getCheckable <em>Checkable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Checkable</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Notification#getCheckable()
	 * @see #getNotification()
	 * @generated
	 */
	EReference getNotification_Checkable();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Notification#getVars <em>Vars</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Vars</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Notification#getVars()
	 * @see #getNotification()
	 * @generated
	 */
	EReference getNotification_Vars();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Notification#getUsers <em>Users</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Users</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Notification#getUsers()
	 * @see #getNotification()
	 * @generated
	 */
	EReference getNotification_Users();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Notification#getUser_groups <em>User groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>User groups</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Notification#getUser_groups()
	 * @see #getNotification()
	 * @generated
	 */
	EReference getNotification_User_groups();

	/**
	 * Returns the meta object for the containment reference '{@link it.unibo.cmdb.monitoring.model.icinga.Notification#getTimes <em>Times</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Times</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Notification#getTimes()
	 * @see #getNotification()
	 * @generated
	 */
	EReference getNotification_Times();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Notification#getCommand <em>Command</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Command</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Notification#getCommand()
	 * @see #getNotification()
	 * @generated
	 */
	EReference getNotification_Command();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Notification#getInterval <em>Interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Interval</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Notification#getInterval()
	 * @see #getNotification()
	 * @generated
	 */
	EAttribute getNotification_Interval();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Notification#getPeriod <em>Period</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Period</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Notification#getPeriod()
	 * @see #getNotification()
	 * @generated
	 */
	EReference getNotification_Period();

	/**
	 * Returns the meta object for the attribute list '{@link it.unibo.cmdb.monitoring.model.icinga.Notification#getTypes <em>Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Types</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Notification#getTypes()
	 * @see #getNotification()
	 * @generated
	 */
	EAttribute getNotification_Types();

	/**
	 * Returns the meta object for the attribute list '{@link it.unibo.cmdb.monitoring.model.icinga.Notification#getStates <em>States</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>States</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Notification#getStates()
	 * @see #getNotification()
	 * @generated
	 */
	EAttribute getNotification_States();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.TimePeriod <em>Time Period</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Period</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.TimePeriod
	 * @generated
	 */
	EClass getTimePeriod();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.TimePeriod#getDisplay_name <em>Display name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Display name</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.TimePeriod#getDisplay_name()
	 * @see #getTimePeriod()
	 * @generated
	 */
	EAttribute getTimePeriod_Display_name();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.TimePeriod#getUpdate <em>Update</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Update</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.TimePeriod#getUpdate()
	 * @see #getTimePeriod()
	 * @generated
	 */
	EAttribute getTimePeriod_Update();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.TimePeriod#getRanges <em>Ranges</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Ranges</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.TimePeriod#getRanges()
	 * @see #getTimePeriod()
	 * @generated
	 */
	EReference getTimePeriod_Ranges();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.Host <em>Host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Host</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host
	 * @generated
	 */
	EClass getHost();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getDisplay_name <em>Display name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Display name</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getDisplay_name()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Display_name();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getAddress <em>Address</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Address</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getAddress()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Address();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getAddress6 <em>Address6</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Address6</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getAddress6()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Address6();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getGroups <em>Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Groups</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getGroups()
	 * @see #getHost()
	 * @generated
	 */
	EReference getHost_Groups();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getVars <em>Vars</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Vars</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getVars()
	 * @see #getHost()
	 * @generated
	 */
	EReference getHost_Vars();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getCheck_command <em>Check command</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Check command</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getCheck_command()
	 * @see #getHost()
	 * @generated
	 */
	EReference getHost_Check_command();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getMax_check_attempts <em>Max check attempts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max check attempts</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getMax_check_attempts()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Max_check_attempts();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getCheck_period <em>Check period</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Check period</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getCheck_period()
	 * @see #getHost()
	 * @generated
	 */
	EReference getHost_Check_period();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getCheck_interval <em>Check interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Check interval</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getCheck_interval()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Check_interval();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getRetry_interval <em>Retry interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Retry interval</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getRetry_interval()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Retry_interval();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_notifications <em>Enable notifications</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable notifications</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_notifications()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Enable_notifications();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_active_checks <em>Enable active checks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable active checks</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_active_checks()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Enable_active_checks();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_passive_checks <em>Enable passive checks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable passive checks</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_passive_checks()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Enable_passive_checks();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_event_handler <em>Enable event handler</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable event handler</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_event_handler()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Enable_event_handler();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_flapping <em>Enable flapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable flapping</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_flapping()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Enable_flapping();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_perfdata <em>Enable perfdata</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable perfdata</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#isEnable_perfdata()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Enable_perfdata();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getEvent_command <em>Event command</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Event command</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getEvent_command()
	 * @see #getHost()
	 * @generated
	 */
	EReference getHost_Event_command();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getFlapping_threshold <em>Flapping threshold</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Flapping threshold</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getFlapping_threshold()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Flapping_threshold();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#isVolatile <em>Volatile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Volatile</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#isVolatile()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Volatile();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getCommand_endpoint <em>Command endpoint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Command endpoint</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getCommand_endpoint()
	 * @see #getHost()
	 * @generated
	 */
	EReference getHost_Command_endpoint();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getNotes <em>Notes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Notes</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getNotes()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Notes();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getNotes_url <em>Notes url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Notes url</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getNotes_url()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Notes_url();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getAction_url <em>Action url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Action url</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getAction_url()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Action_url();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getIcon_image <em>Icon image</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Icon image</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getIcon_image()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Icon_image();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getIcon_image_alt <em>Icon image alt</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Icon image alt</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getIcon_image_alt()
	 * @see #getHost()
	 * @generated
	 */
	EAttribute getHost_Icon_image_alt();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Host#getServices <em>Services</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Services</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Host#getServices()
	 * @see #getHost()
	 * @generated
	 */
	EReference getHost_Services();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.HostGroup <em>Host Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Host Group</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.HostGroup
	 * @generated
	 */
	EClass getHostGroup();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.HostGroup#getDisplay_name <em>Display name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Display name</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.HostGroup#getDisplay_name()
	 * @see #getHostGroup()
	 * @generated
	 */
	EAttribute getHostGroup_Display_name();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.HostGroup#getGroups <em>Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Groups</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.HostGroup#getGroups()
	 * @see #getHostGroup()
	 * @generated
	 */
	EReference getHostGroup_Groups();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.Service <em>Service</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service
	 * @generated
	 */
	EClass getService();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getDisplay_name <em>Display name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Display name</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getDisplay_name()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Display_name();

	/**
	 * Returns the meta object for the container reference '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getHost <em>Host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Host</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getHost()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_Host();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getGroups <em>Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Groups</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getGroups()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_Groups();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getVars <em>Vars</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Vars</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getVars()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_Vars();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getCheck_command <em>Check command</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Check command</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getCheck_command()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_Check_command();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getMax_check_attempts <em>Max check attempts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max check attempts</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getMax_check_attempts()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Max_check_attempts();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getCheck_period <em>Check period</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Check period</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getCheck_period()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_Check_period();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getCheck_interval <em>Check interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Check interval</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getCheck_interval()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Check_interval();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getRetry_interval <em>Retry interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Retry interval</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getRetry_interval()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Retry_interval();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_notifications <em>Enable notifications</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable notifications</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_notifications()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Enable_notifications();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_active_checks <em>Enable active checks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable active checks</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_active_checks()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Enable_active_checks();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_passive_checks <em>Enable passive checks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable passive checks</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_passive_checks()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Enable_passive_checks();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_event_handler <em>Enable event handler</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable event handler</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_event_handler()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Enable_event_handler();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_flapping <em>Enable flapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable flapping</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_flapping()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Enable_flapping();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_perfdata <em>Enable perfdata</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable perfdata</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#isEnable_perfdata()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Enable_perfdata();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getEvent_command <em>Event command</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Event command</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getEvent_command()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_Event_command();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getFlapping_threshold <em>Flapping threshold</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Flapping threshold</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getFlapping_threshold()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Flapping_threshold();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#isVolatile <em>Volatile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Volatile</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#isVolatile()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Volatile();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getCommand_endpoint <em>Command endpoint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Command endpoint</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getCommand_endpoint()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_Command_endpoint();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getNotes <em>Notes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Notes</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getNotes()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Notes();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getNotes_url <em>Notes url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Notes url</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getNotes_url()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Notes_url();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getAction_url <em>Action url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Action url</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getAction_url()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Action_url();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getIcon_image <em>Icon image</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Icon image</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getIcon_image()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Icon_image();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Service#getIcon_image_alt <em>Icon image alt</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Icon image alt</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Service#getIcon_image_alt()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Icon_image_alt();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.ServiceGroup <em>Service Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service Group</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ServiceGroup
	 * @generated
	 */
	EClass getServiceGroup();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ServiceGroup#getDisplay_name <em>Display name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Display name</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ServiceGroup#getDisplay_name()
	 * @see #getServiceGroup()
	 * @generated
	 */
	EAttribute getServiceGroup_Display_name();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.ServiceGroup#getGroups <em>Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Groups</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ServiceGroup#getGroups()
	 * @see #getServiceGroup()
	 * @generated
	 */
	EReference getServiceGroup_Groups();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.User <em>User</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>User</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.User
	 * @generated
	 */
	EClass getUser();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.User#getDisplay_name <em>Display name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Display name</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.User#getDisplay_name()
	 * @see #getUser()
	 * @generated
	 */
	EAttribute getUser_Display_name();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.User#getEmail <em>Email</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Email</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.User#getEmail()
	 * @see #getUser()
	 * @generated
	 */
	EAttribute getUser_Email();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.User#getPager <em>Pager</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pager</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.User#getPager()
	 * @see #getUser()
	 * @generated
	 */
	EAttribute getUser_Pager();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.User#getVars <em>Vars</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Vars</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.User#getVars()
	 * @see #getUser()
	 * @generated
	 */
	EReference getUser_Vars();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.User#getGroups <em>Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Groups</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.User#getGroups()
	 * @see #getUser()
	 * @generated
	 */
	EReference getUser_Groups();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.User#isEnable_notifications <em>Enable notifications</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable notifications</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.User#isEnable_notifications()
	 * @see #getUser()
	 * @generated
	 */
	EAttribute getUser_Enable_notifications();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.User#getPeriod <em>Period</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Period</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.User#getPeriod()
	 * @see #getUser()
	 * @generated
	 */
	EReference getUser_Period();

	/**
	 * Returns the meta object for the attribute list '{@link it.unibo.cmdb.monitoring.model.icinga.User#getTypes <em>Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Types</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.User#getTypes()
	 * @see #getUser()
	 * @generated
	 */
	EAttribute getUser_Types();

	/**
	 * Returns the meta object for the attribute list '{@link it.unibo.cmdb.monitoring.model.icinga.User#getStates <em>States</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>States</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.User#getStates()
	 * @see #getUser()
	 * @generated
	 */
	EAttribute getUser_States();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.UserGroup <em>User Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>User Group</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.UserGroup
	 * @generated
	 */
	EClass getUserGroup();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.UserGroup#getDisplay_name <em>Display name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Display name</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.UserGroup#getDisplay_name()
	 * @see #getUserGroup()
	 * @generated
	 */
	EAttribute getUserGroup_Display_name();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.UserGroup#getGroups <em>Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Groups</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.UserGroup#getGroups()
	 * @see #getUserGroup()
	 * @generated
	 */
	EReference getUserGroup_Groups();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.Zone <em>Zone</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Zone</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Zone
	 * @generated
	 */
	EClass getZone();

	/**
	 * Returns the meta object for the reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getEndpoints <em>Endpoints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Endpoints</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Zone#getEndpoints()
	 * @see #getZone()
	 * @generated
	 */
	EReference getZone_Endpoints();

	/**
	 * Returns the meta object for the container reference '{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Parent</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Zone#getParent()
	 * @see #getZone()
	 * @generated
	 */
	EReference getZone_Parent();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Zone#isGlobal <em>Global</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Global</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Zone#isGlobal()
	 * @see #getZone()
	 * @generated
	 */
	EAttribute getZone_Global();

	/**
	 * Returns the meta object for the reference '{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getElements <em>Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Elements</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Zone#getElements()
	 * @see #getZone()
	 * @generated
	 */
	EReference getZone_Elements();

	/**
	 * Returns the meta object for the containment reference list '{@link it.unibo.cmdb.monitoring.model.icinga.Zone#getSubzones <em>Subzones</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Subzones</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Zone#getSubzones()
	 * @see #getZone()
	 * @generated
	 */
	EReference getZone_Subzones();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.Endpoint <em>Endpoint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Endpoint</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Endpoint
	 * @generated
	 */
	EClass getEndpoint();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Endpoint#getHost <em>Host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Endpoint#getHost()
	 * @see #getEndpoint()
	 * @generated
	 */
	EAttribute getEndpoint_Host();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Endpoint#getPort <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Port</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Endpoint#getPort()
	 * @see #getEndpoint()
	 * @generated
	 */
	EAttribute getEndpoint_Port();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.Endpoint#getLog_duration <em>Log duration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Log duration</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.Endpoint#getLog_duration()
	 * @see #getEndpoint()
	 * @generated
	 */
	EAttribute getEndpoint_Log_duration();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.CheckerComponent <em>Checker Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Checker Component</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CheckerComponent
	 * @generated
	 */
	EClass getCheckerComponent();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.NotificationComponent <em>Notification Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Notification Component</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.NotificationComponent
	 * @generated
	 */
	EClass getNotificationComponent();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.NotificationComponent#isEnable_ha <em>Enable ha</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable ha</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.NotificationComponent#isEnable_ha()
	 * @see #getNotificationComponent()
	 * @generated
	 */
	EAttribute getNotificationComponent_Enable_ha();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.CheckResultReader <em>Check Result Reader</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Check Result Reader</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CheckResultReader
	 * @generated
	 */
	EClass getCheckResultReader();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.CheckResultReader#getSpool_dir <em>Spool dir</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Spool dir</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CheckResultReader#getSpool_dir()
	 * @see #getCheckResultReader()
	 * @generated
	 */
	EAttribute getCheckResultReader_Spool_dir();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.ApiListener <em>Api Listener</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Api Listener</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ApiListener
	 * @generated
	 */
	EClass getApiListener();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ApiListener#getCert_path <em>Cert path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cert path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ApiListener#getCert_path()
	 * @see #getApiListener()
	 * @generated
	 */
	EAttribute getApiListener_Cert_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ApiListener#getKey_path <em>Key path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ApiListener#getKey_path()
	 * @see #getApiListener()
	 * @generated
	 */
	EAttribute getApiListener_Key_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ApiListener#getCa_path <em>Ca path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ca path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ApiListener#getCa_path()
	 * @see #getApiListener()
	 * @generated
	 */
	EAttribute getApiListener_Ca_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ApiListener#getCrl_path <em>Crl path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Crl path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ApiListener#getCrl_path()
	 * @see #getApiListener()
	 * @generated
	 */
	EAttribute getApiListener_Crl_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ApiListener#getBind_host <em>Bind host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bind host</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ApiListener#getBind_host()
	 * @see #getApiListener()
	 * @generated
	 */
	EAttribute getApiListener_Bind_host();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ApiListener#getBind_port <em>Bind port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bind port</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ApiListener#getBind_port()
	 * @see #getApiListener()
	 * @generated
	 */
	EAttribute getApiListener_Bind_port();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ApiListener#isAccept_config <em>Accept config</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Accept config</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ApiListener#isAccept_config()
	 * @see #getApiListener()
	 * @generated
	 */
	EAttribute getApiListener_Accept_config();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ApiListener#isAccept_commands <em>Accept commands</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Accept commands</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ApiListener#isAccept_commands()
	 * @see #getApiListener()
	 * @generated
	 */
	EAttribute getApiListener_Accept_commands();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener <em>Live Status Listener</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Live Status Listener</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener
	 * @generated
	 */
	EClass getLiveStatusListener();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener#getSocket_type <em>Socket type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Socket type</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener#getSocket_type()
	 * @see #getLiveStatusListener()
	 * @generated
	 */
	EAttribute getLiveStatusListener_Socket_type();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener#getBind_host <em>Bind host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bind host</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener#getBind_host()
	 * @see #getLiveStatusListener()
	 * @generated
	 */
	EAttribute getLiveStatusListener_Bind_host();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener#getBind_port <em>Bind port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bind port</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener#getBind_port()
	 * @see #getLiveStatusListener()
	 * @generated
	 */
	EAttribute getLiveStatusListener_Bind_port();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener#getSocket_path <em>Socket path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Socket path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener#getSocket_path()
	 * @see #getLiveStatusListener()
	 * @generated
	 */
	EAttribute getLiveStatusListener_Socket_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener#getCompat_log_path <em>Compat log path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Compat log path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.LiveStatusListener#getCompat_log_path()
	 * @see #getLiveStatusListener()
	 * @generated
	 */
	EAttribute getLiveStatusListener_Compat_log_path();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.ExternalCommandListener <em>External Command Listener</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Command Listener</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ExternalCommandListener
	 * @generated
	 */
	EClass getExternalCommandListener();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.ExternalCommandListener#getCommand_path <em>Command path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Command path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.ExternalCommandListener#getCommand_path()
	 * @see #getExternalCommandListener()
	 * @generated
	 */
	EAttribute getExternalCommandListener_Command_path();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.CompatLogger <em>Compat Logger</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Compat Logger</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CompatLogger
	 * @generated
	 */
	EClass getCompatLogger();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.CompatLogger#getLog_dir <em>Log dir</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Log dir</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CompatLogger#getLog_dir()
	 * @see #getCompatLogger()
	 * @generated
	 */
	EAttribute getCompatLogger_Log_dir();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.CompatLogger#getRotation_method <em>Rotation method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rotation method</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.CompatLogger#getRotation_method()
	 * @see #getCompatLogger()
	 * @generated
	 */
	EAttribute getCompatLogger_Rotation_method();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.FileLogger <em>File Logger</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>File Logger</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.FileLogger
	 * @generated
	 */
	EClass getFileLogger();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.FileLogger#getPath <em>Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.FileLogger#getPath()
	 * @see #getFileLogger()
	 * @generated
	 */
	EAttribute getFileLogger_Path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.FileLogger#getSeverity <em>Severity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Severity</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.FileLogger#getSeverity()
	 * @see #getFileLogger()
	 * @generated
	 */
	EAttribute getFileLogger_Severity();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.SyslogLogger <em>Syslog Logger</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Syslog Logger</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.SyslogLogger
	 * @generated
	 */
	EClass getSyslogLogger();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.SyslogLogger#getSeverity <em>Severity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Severity</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.SyslogLogger#getSeverity()
	 * @see #getSyslogLogger()
	 * @generated
	 */
	EAttribute getSyslogLogger_Severity();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.GelfWriter <em>Gelf Writer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Gelf Writer</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.GelfWriter
	 * @generated
	 */
	EClass getGelfWriter();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.GelfWriter#getHost <em>Host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.GelfWriter#getHost()
	 * @see #getGelfWriter()
	 * @generated
	 */
	EAttribute getGelfWriter_Host();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.GelfWriter#getPort <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Port</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.GelfWriter#getPort()
	 * @see #getGelfWriter()
	 * @generated
	 */
	EAttribute getGelfWriter_Port();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.GelfWriter#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Source</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.GelfWriter#getSource()
	 * @see #getGelfWriter()
	 * @generated
	 */
	EAttribute getGelfWriter_Source();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.GraphiteWriter <em>Graphite Writer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Graphite Writer</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.GraphiteWriter
	 * @generated
	 */
	EClass getGraphiteWriter();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.GraphiteWriter#getHost <em>Host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.GraphiteWriter#getHost()
	 * @see #getGraphiteWriter()
	 * @generated
	 */
	EAttribute getGraphiteWriter_Host();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.GraphiteWriter#getPort <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Port</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.GraphiteWriter#getPort()
	 * @see #getGraphiteWriter()
	 * @generated
	 */
	EAttribute getGraphiteWriter_Port();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.GraphiteWriter#getHost_name_template <em>Host name template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host name template</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.GraphiteWriter#getHost_name_template()
	 * @see #getGraphiteWriter()
	 * @generated
	 */
	EAttribute getGraphiteWriter_Host_name_template();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.GraphiteWriter#getService_name_template <em>Service name template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Service name template</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.GraphiteWriter#getService_name_template()
	 * @see #getGraphiteWriter()
	 * @generated
	 */
	EAttribute getGraphiteWriter_Service_name_template();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.IcingaStatusWriter <em>Status Writer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Status Writer</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IcingaStatusWriter
	 * @generated
	 */
	EClass getIcingaStatusWriter();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IcingaStatusWriter#getStatus_path <em>Status path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IcingaStatusWriter#getStatus_path()
	 * @see #getIcingaStatusWriter()
	 * @generated
	 */
	EAttribute getIcingaStatusWriter_Status_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IcingaStatusWriter#getUpdate_interval <em>Update interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Update interval</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IcingaStatusWriter#getUpdate_interval()
	 * @see #getIcingaStatusWriter()
	 * @generated
	 */
	EAttribute getIcingaStatusWriter_Update_interval();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.OpenTsdbWriter <em>Open Tsdb Writer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Open Tsdb Writer</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.OpenTsdbWriter
	 * @generated
	 */
	EClass getOpenTsdbWriter();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.OpenTsdbWriter#getHost <em>Host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.OpenTsdbWriter#getHost()
	 * @see #getOpenTsdbWriter()
	 * @generated
	 */
	EAttribute getOpenTsdbWriter_Host();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.OpenTsdbWriter#getPort <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Port</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.OpenTsdbWriter#getPort()
	 * @see #getOpenTsdbWriter()
	 * @generated
	 */
	EAttribute getOpenTsdbWriter_Port();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter <em>Perfdata Writer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Perfdata Writer</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter
	 * @generated
	 */
	EClass getPerfdataWriter();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getHost_perfdata_path <em>Host perfdata path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host perfdata path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getHost_perfdata_path()
	 * @see #getPerfdataWriter()
	 * @generated
	 */
	EAttribute getPerfdataWriter_Host_perfdata_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getService_perfdata_path <em>Service perfdata path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Service perfdata path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getService_perfdata_path()
	 * @see #getPerfdataWriter()
	 * @generated
	 */
	EAttribute getPerfdataWriter_Service_perfdata_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getHost_temp_path <em>Host temp path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host temp path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getHost_temp_path()
	 * @see #getPerfdataWriter()
	 * @generated
	 */
	EAttribute getPerfdataWriter_Host_temp_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getService_temp_path <em>Service temp path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Service temp path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getService_temp_path()
	 * @see #getPerfdataWriter()
	 * @generated
	 */
	EAttribute getPerfdataWriter_Service_temp_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getHost_format_template <em>Host format template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host format template</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getHost_format_template()
	 * @see #getPerfdataWriter()
	 * @generated
	 */
	EAttribute getPerfdataWriter_Host_format_template();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getService_format_template <em>Service format template</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Service format template</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getService_format_template()
	 * @see #getPerfdataWriter()
	 * @generated
	 */
	EAttribute getPerfdataWriter_Service_format_template();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getRotation_interval <em>Rotation interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rotation interval</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.PerfdataWriter#getRotation_interval()
	 * @see #getPerfdataWriter()
	 * @generated
	 */
	EAttribute getPerfdataWriter_Rotation_interval();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.StatusDataWriter <em>Status Data Writer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Status Data Writer</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.StatusDataWriter
	 * @generated
	 */
	EClass getStatusDataWriter();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.StatusDataWriter#getStatus_path <em>Status path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.StatusDataWriter#getStatus_path()
	 * @see #getStatusDataWriter()
	 * @generated
	 */
	EAttribute getStatusDataWriter_Status_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.StatusDataWriter#getObjects_path <em>Objects path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Objects path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.StatusDataWriter#getObjects_path()
	 * @see #getStatusDataWriter()
	 * @generated
	 */
	EAttribute getStatusDataWriter_Objects_path();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.StatusDataWriter#getUpdate_interval <em>Update interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Update interval</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.StatusDataWriter#getUpdate_interval()
	 * @see #getStatusDataWriter()
	 * @generated
	 */
	EAttribute getStatusDataWriter_Update_interval();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection <em>Ido Connection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Ido Connection</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection
	 * @generated
	 */
	EClass getIdoConnection();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getHost <em>Host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getHost()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EAttribute getIdoConnection_Host();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getPort <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Port</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getPort()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EAttribute getIdoConnection_Port();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getUser <em>User</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>User</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getUser()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EAttribute getIdoConnection_User();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getPassword <em>Password</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Password</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getPassword()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EAttribute getIdoConnection_Password();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getDatabase <em>Database</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Database</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getDatabase()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EAttribute getIdoConnection_Database();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getTable_prefix <em>Table prefix</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Table prefix</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getTable_prefix()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EAttribute getIdoConnection_Table_prefix();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getInstance_name <em>Instance name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Instance name</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getInstance_name()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EAttribute getIdoConnection_Instance_name();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getInstance_description <em>Instance description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Instance description</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getInstance_description()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EAttribute getIdoConnection_Instance_description();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#isEnable_ha <em>Enable ha</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enable ha</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#isEnable_ha()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EAttribute getIdoConnection_Enable_ha();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getFailover_timeout <em>Failover timeout</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Failover timeout</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getFailover_timeout()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EAttribute getIdoConnection_Failover_timeout();

	/**
	 * Returns the meta object for the containment reference '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getCleanup <em>Cleanup</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Cleanup</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getCleanup()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EReference getIdoConnection_Cleanup();

	/**
	 * Returns the meta object for the attribute list '{@link it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getCategories <em>Categories</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Categories</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoConnection#getCategories()
	 * @see #getIdoConnection()
	 * @generated
	 */
	EAttribute getIdoConnection_Categories();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.IdoMySqlConnection <em>Ido My Sql Connection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Ido My Sql Connection</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoMySqlConnection
	 * @generated
	 */
	EClass getIdoMySqlConnection();

	/**
	 * Returns the meta object for the attribute '{@link it.unibo.cmdb.monitoring.model.icinga.IdoMySqlConnection#getSocket_path <em>Socket path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Socket path</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoMySqlConnection#getSocket_path()
	 * @see #getIdoMySqlConnection()
	 * @generated
	 */
	EAttribute getIdoMySqlConnection_Socket_path();

	/**
	 * Returns the meta object for class '{@link it.unibo.cmdb.monitoring.model.icinga.IdoPgSqlConnection <em>Ido Pg Sql Connection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Ido Pg Sql Connection</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.IdoPgSqlConnection
	 * @generated
	 */
	EClass getIdoPgSqlConnection();

	/**
	 * Returns the meta object for enum '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCategory <em>Database Category</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Database Category</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCategory
	 * @generated
	 */
	EEnum getDatabaseCategory();

	/**
	 * Returns the meta object for enum '{@link it.unibo.cmdb.monitoring.model.icinga.NotificationType <em>Notification Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Notification Type</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.NotificationType
	 * @generated
	 */
	EEnum getNotificationType();

	/**
	 * Returns the meta object for enum '{@link it.unibo.cmdb.monitoring.model.icinga.LogRotationMethod <em>Log Rotation Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Log Rotation Method</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.LogRotationMethod
	 * @generated
	 */
	EEnum getLogRotationMethod();

	/**
	 * Returns the meta object for enum '{@link it.unibo.cmdb.monitoring.model.icinga.LogSeverity <em>Log Severity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Log Severity</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.LogSeverity
	 * @generated
	 */
	EEnum getLogSeverity();

	/**
	 * Returns the meta object for enum '{@link it.unibo.cmdb.monitoring.model.icinga.SocketType <em>Socket Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Socket Type</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.SocketType
	 * @generated
	 */
	EEnum getSocketType();

	/**
	 * Returns the meta object for enum '{@link it.unibo.cmdb.monitoring.model.icinga.State <em>State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>State</em>'.
	 * @see it.unibo.cmdb.monitoring.model.icinga.State
	 * @generated
	 */
	EEnum getState();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	IcingaFactory getIcingaFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.UserVarImpl <em>User Var</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.UserVarImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getUserVar()
		 * @generated
		 */
		EClass USER_VAR = eINSTANCE.getUserVar();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER_VAR__KEY = eINSTANCE.getUserVar_Key();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference USER_VAR__VALUE = eINSTANCE.getUserVar_Value();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.UserValueImpl <em>User Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.UserValueImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getUserValue()
		 * @generated
		 */
		EClass USER_VALUE = eINSTANCE.getUserValue();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.SimpleUserValueImpl <em>Simple User Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.SimpleUserValueImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getSimpleUserValue()
		 * @generated
		 */
		EClass SIMPLE_USER_VALUE = eINSTANCE.getSimpleUserValue();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SIMPLE_USER_VALUE__VALUE = eINSTANCE.getSimpleUserValue_Value();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.StringUserValueImpl <em>String User Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.StringUserValueImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getStringUserValue()
		 * @generated
		 */
		EClass STRING_USER_VALUE = eINSTANCE.getStringUserValue();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.NumericUserValueImpl <em>Numeric User Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.NumericUserValueImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNumericUserValue()
		 * @generated
		 */
		EClass NUMERIC_USER_VALUE = eINSTANCE.getNumericUserValue();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ComplexUserValueImpl <em>Complex User Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ComplexUserValueImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getComplexUserValue()
		 * @generated
		 */
		EClass COMPLEX_USER_VALUE = eINSTANCE.getComplexUserValue();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPLEX_USER_VALUE__VALUE = eINSTANCE.getComplexUserValue_Value();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CommandArgumentImpl <em>Command Argument</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CommandArgumentImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCommandArgument()
		 * @generated
		 */
		EClass COMMAND_ARGUMENT = eINSTANCE.getCommandArgument();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND_ARGUMENT__VALUE = eINSTANCE.getCommandArgument_Value();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND_ARGUMENT__KEY = eINSTANCE.getCommandArgument_Key();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND_ARGUMENT__DESCRIPTION = eINSTANCE.getCommandArgument_Description();

		/**
		 * The meta object literal for the '<em><b>Required</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND_ARGUMENT__REQUIRED = eINSTANCE.getCommandArgument_Required();

		/**
		 * The meta object literal for the '<em><b>Skip key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND_ARGUMENT__SKIP_KEY = eINSTANCE.getCommandArgument_Skip_key();

		/**
		 * The meta object literal for the '<em><b>Set if</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND_ARGUMENT__SET_IF = eINSTANCE.getCommandArgument_Set_if();

		/**
		 * The meta object literal for the '<em><b>Order</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND_ARGUMENT__ORDER = eINSTANCE.getCommandArgument_Order();

		/**
		 * The meta object literal for the '<em><b>Repeat key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND_ARGUMENT__REPEAT_KEY = eINSTANCE.getCommandArgument_Repeat_key();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CommandEnvImpl <em>Command Env</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CommandEnvImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCommandEnv()
		 * @generated
		 */
		EClass COMMAND_ENV = eINSTANCE.getCommandEnv();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND_ENV__VALUE = eINSTANCE.getCommandEnv_Value();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND_ENV__KEY = eINSTANCE.getCommandEnv_Key();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.DatabaseCleanupImpl <em>Database Cleanup</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.DatabaseCleanupImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getDatabaseCleanup()
		 * @generated
		 */
		EClass DATABASE_CLEANUP = eINSTANCE.getDatabaseCleanup();

		/**
		 * The meta object literal for the '<em><b>Acknowledgements age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__ACKNOWLEDGEMENTS_AGE = eINSTANCE.getDatabaseCleanup_Acknowledgements_age();

		/**
		 * The meta object literal for the '<em><b>Commenthistory age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__COMMENTHISTORY_AGE = eINSTANCE.getDatabaseCleanup_Commenthistory_age();

		/**
		 * The meta object literal for the '<em><b>Contactnotifications age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__CONTACTNOTIFICATIONS_AGE = eINSTANCE.getDatabaseCleanup_Contactnotifications_age();

		/**
		 * The meta object literal for the '<em><b>Contactnotificationmethods age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__CONTACTNOTIFICATIONMETHODS_AGE = eINSTANCE.getDatabaseCleanup_Contactnotificationmethods_age();

		/**
		 * The meta object literal for the '<em><b>Downtimehistory age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__DOWNTIMEHISTORY_AGE = eINSTANCE.getDatabaseCleanup_Downtimehistory_age();

		/**
		 * The meta object literal for the '<em><b>Eventhandlers age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__EVENTHANDLERS_AGE = eINSTANCE.getDatabaseCleanup_Eventhandlers_age();

		/**
		 * The meta object literal for the '<em><b>Externalcommands age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__EXTERNALCOMMANDS_AGE = eINSTANCE.getDatabaseCleanup_Externalcommands_age();

		/**
		 * The meta object literal for the '<em><b>Flappinghistory age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__FLAPPINGHISTORY_AGE = eINSTANCE.getDatabaseCleanup_Flappinghistory_age();

		/**
		 * The meta object literal for the '<em><b>Hostchecks age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__HOSTCHECKS_AGE = eINSTANCE.getDatabaseCleanup_Hostchecks_age();

		/**
		 * The meta object literal for the '<em><b>Logentries age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__LOGENTRIES_AGE = eINSTANCE.getDatabaseCleanup_Logentries_age();

		/**
		 * The meta object literal for the '<em><b>Notifications age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__NOTIFICATIONS_AGE = eINSTANCE.getDatabaseCleanup_Notifications_age();

		/**
		 * The meta object literal for the '<em><b>Processevents age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__PROCESSEVENTS_AGE = eINSTANCE.getDatabaseCleanup_Processevents_age();

		/**
		 * The meta object literal for the '<em><b>Statehistory age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__STATEHISTORY_AGE = eINSTANCE.getDatabaseCleanup_Statehistory_age();

		/**
		 * The meta object literal for the '<em><b>Servicechecks age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__SERVICECHECKS_AGE = eINSTANCE.getDatabaseCleanup_Servicechecks_age();

		/**
		 * The meta object literal for the '<em><b>Systemcommands age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATABASE_CLEANUP__SYSTEMCOMMANDS_AGE = eINSTANCE.getDatabaseCleanup_Systemcommands_age();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.TimeRangeImpl <em>Time Range</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.TimeRangeImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getTimeRange()
		 * @generated
		 */
		EClass TIME_RANGE = eINSTANCE.getTimeRange();

		/**
		 * The meta object literal for the '<em><b>Directive</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TIME_RANGE__DIRECTIVE = eINSTANCE.getTimeRange_Directive();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TIME_RANGE__VALUE = eINSTANCE.getTimeRange_Value();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationTimesImpl <em>Notification Times</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.NotificationTimesImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNotificationTimes()
		 * @generated
		 */
		EClass NOTIFICATION_TIMES = eINSTANCE.getNotificationTimes();

		/**
		 * The meta object literal for the '<em><b>Begin</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION_TIMES__BEGIN = eINSTANCE.getNotificationTimes_Begin();

		/**
		 * The meta object literal for the '<em><b>End</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION_TIMES__END = eINSTANCE.getNotificationTimes_End();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.Checkable <em>Checkable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.Checkable
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCheckable()
		 * @generated
		 */
		EClass CHECKABLE = eINSTANCE.getCheckable();

		/**
		 * The meta object literal for the '<em><b>Dependencies</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHECKABLE__DEPENDENCIES = eINSTANCE.getCheckable_Dependencies();

		/**
		 * The meta object literal for the '<em><b>Notifications</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHECKABLE__NOTIFICATIONS = eINSTANCE.getCheckable_Notifications();

		/**
		 * The meta object literal for the '<em><b>Scheduled Downtimes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHECKABLE__SCHEDULED_DOWNTIMES = eINSTANCE.getCheckable_ScheduledDowntimes();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.ZoneElement <em>Zone Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.ZoneElement
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getZoneElement()
		 * @generated
		 */
		EClass ZONE_ELEMENT = eINSTANCE.getZoneElement();

		/**
		 * The meta object literal for the '<em><b>Zone</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ZONE_ELEMENT__ZONE = eINSTANCE.getZoneElement_Zone();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ConfigurationObjectImpl <em>Configuration Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ConfigurationObjectImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getConfigurationObject()
		 * @generated
		 */
		EClass CONFIGURATION_OBJECT = eINSTANCE.getConfigurationObject();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONFIGURATION_OBJECT__NAME = eINSTANCE.getConfigurationObject_Name();

		/**
		 * The meta object literal for the '<em><b>Import</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONFIGURATION_OBJECT__IMPORT = eINSTANCE.getConfigurationObject_Import();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CommandImpl <em>Command</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CommandImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCommand()
		 * @generated
		 */
		EClass COMMAND = eINSTANCE.getCommand();

		/**
		 * The meta object literal for the '<em><b>Execute</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND__EXECUTE = eINSTANCE.getCommand_Execute();

		/**
		 * The meta object literal for the '<em><b>Command</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND__COMMAND = eINSTANCE.getCommand_Command();

		/**
		 * The meta object literal for the '<em><b>Env</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMMAND__ENV = eINSTANCE.getCommand_Env();

		/**
		 * The meta object literal for the '<em><b>Vars</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMMAND__VARS = eINSTANCE.getCommand_Vars();

		/**
		 * The meta object literal for the '<em><b>Timeout</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMMAND__TIMEOUT = eINSTANCE.getCommand_Timeout();

		/**
		 * The meta object literal for the '<em><b>Arguments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMMAND__ARGUMENTS = eINSTANCE.getCommand_Arguments();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CheckCommandImpl <em>Check Command</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CheckCommandImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCheckCommand()
		 * @generated
		 */
		EClass CHECK_COMMAND = eINSTANCE.getCheckCommand();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationCommandImpl <em>Notification Command</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.NotificationCommandImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNotificationCommand()
		 * @generated
		 */
		EClass NOTIFICATION_COMMAND = eINSTANCE.getNotificationCommand();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.EventCommandImpl <em>Event Command</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.EventCommandImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getEventCommand()
		 * @generated
		 */
		EClass EVENT_COMMAND = eINSTANCE.getEventCommand();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ScheduledDowntimeImpl <em>Scheduled Downtime</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ScheduledDowntimeImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getScheduledDowntime()
		 * @generated
		 */
		EClass SCHEDULED_DOWNTIME = eINSTANCE.getScheduledDowntime();

		/**
		 * The meta object literal for the '<em><b>Checkable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCHEDULED_DOWNTIME__CHECKABLE = eINSTANCE.getScheduledDowntime_Checkable();

		/**
		 * The meta object literal for the '<em><b>Author</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULED_DOWNTIME__AUTHOR = eINSTANCE.getScheduledDowntime_Author();

		/**
		 * The meta object literal for the '<em><b>Comment</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULED_DOWNTIME__COMMENT = eINSTANCE.getScheduledDowntime_Comment();

		/**
		 * The meta object literal for the '<em><b>Fixed</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULED_DOWNTIME__FIXED = eINSTANCE.getScheduledDowntime_Fixed();

		/**
		 * The meta object literal for the '<em><b>Duration</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULED_DOWNTIME__DURATION = eINSTANCE.getScheduledDowntime_Duration();

		/**
		 * The meta object literal for the '<em><b>Ranges</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCHEDULED_DOWNTIME__RANGES = eINSTANCE.getScheduledDowntime_Ranges();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl <em>Dependency</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getDependency()
		 * @generated
		 */
		EClass DEPENDENCY = eINSTANCE.getDependency();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DEPENDENCY__PARENT = eINSTANCE.getDependency_Parent();

		/**
		 * The meta object literal for the '<em><b>Child</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DEPENDENCY__CHILD = eINSTANCE.getDependency_Child();

		/**
		 * The meta object literal for the '<em><b>Disable checks</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DEPENDENCY__DISABLE_CHECKS = eINSTANCE.getDependency_Disable_checks();

		/**
		 * The meta object literal for the '<em><b>Disable notifications</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DEPENDENCY__DISABLE_NOTIFICATIONS = eINSTANCE.getDependency_Disable_notifications();

		/**
		 * The meta object literal for the '<em><b>Ignore soft states</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DEPENDENCY__IGNORE_SOFT_STATES = eINSTANCE.getDependency_Ignore_soft_states();

		/**
		 * The meta object literal for the '<em><b>Period</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DEPENDENCY__PERIOD = eINSTANCE.getDependency_Period();

		/**
		 * The meta object literal for the '<em><b>States</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DEPENDENCY__STATES = eINSTANCE.getDependency_States();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl <em>Notification</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNotification()
		 * @generated
		 */
		EClass NOTIFICATION = eINSTANCE.getNotification();

		/**
		 * The meta object literal for the '<em><b>Checkable</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTIFICATION__CHECKABLE = eINSTANCE.getNotification_Checkable();

		/**
		 * The meta object literal for the '<em><b>Vars</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTIFICATION__VARS = eINSTANCE.getNotification_Vars();

		/**
		 * The meta object literal for the '<em><b>Users</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTIFICATION__USERS = eINSTANCE.getNotification_Users();

		/**
		 * The meta object literal for the '<em><b>User groups</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTIFICATION__USER_GROUPS = eINSTANCE.getNotification_User_groups();

		/**
		 * The meta object literal for the '<em><b>Times</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTIFICATION__TIMES = eINSTANCE.getNotification_Times();

		/**
		 * The meta object literal for the '<em><b>Command</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTIFICATION__COMMAND = eINSTANCE.getNotification_Command();

		/**
		 * The meta object literal for the '<em><b>Interval</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION__INTERVAL = eINSTANCE.getNotification_Interval();

		/**
		 * The meta object literal for the '<em><b>Period</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTIFICATION__PERIOD = eINSTANCE.getNotification_Period();

		/**
		 * The meta object literal for the '<em><b>Types</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION__TYPES = eINSTANCE.getNotification_Types();

		/**
		 * The meta object literal for the '<em><b>States</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION__STATES = eINSTANCE.getNotification_States();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.TimePeriodImpl <em>Time Period</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.TimePeriodImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getTimePeriod()
		 * @generated
		 */
		EClass TIME_PERIOD = eINSTANCE.getTimePeriod();

		/**
		 * The meta object literal for the '<em><b>Display name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TIME_PERIOD__DISPLAY_NAME = eINSTANCE.getTimePeriod_Display_name();

		/**
		 * The meta object literal for the '<em><b>Update</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TIME_PERIOD__UPDATE = eINSTANCE.getTimePeriod_Update();

		/**
		 * The meta object literal for the '<em><b>Ranges</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TIME_PERIOD__RANGES = eINSTANCE.getTimePeriod_Ranges();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.HostImpl <em>Host</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.HostImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getHost()
		 * @generated
		 */
		EClass HOST = eINSTANCE.getHost();

		/**
		 * The meta object literal for the '<em><b>Display name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__DISPLAY_NAME = eINSTANCE.getHost_Display_name();

		/**
		 * The meta object literal for the '<em><b>Address</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__ADDRESS = eINSTANCE.getHost_Address();

		/**
		 * The meta object literal for the '<em><b>Address6</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__ADDRESS6 = eINSTANCE.getHost_Address6();

		/**
		 * The meta object literal for the '<em><b>Groups</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOST__GROUPS = eINSTANCE.getHost_Groups();

		/**
		 * The meta object literal for the '<em><b>Vars</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOST__VARS = eINSTANCE.getHost_Vars();

		/**
		 * The meta object literal for the '<em><b>Check command</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOST__CHECK_COMMAND = eINSTANCE.getHost_Check_command();

		/**
		 * The meta object literal for the '<em><b>Max check attempts</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__MAX_CHECK_ATTEMPTS = eINSTANCE.getHost_Max_check_attempts();

		/**
		 * The meta object literal for the '<em><b>Check period</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOST__CHECK_PERIOD = eINSTANCE.getHost_Check_period();

		/**
		 * The meta object literal for the '<em><b>Check interval</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__CHECK_INTERVAL = eINSTANCE.getHost_Check_interval();

		/**
		 * The meta object literal for the '<em><b>Retry interval</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__RETRY_INTERVAL = eINSTANCE.getHost_Retry_interval();

		/**
		 * The meta object literal for the '<em><b>Enable notifications</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__ENABLE_NOTIFICATIONS = eINSTANCE.getHost_Enable_notifications();

		/**
		 * The meta object literal for the '<em><b>Enable active checks</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__ENABLE_ACTIVE_CHECKS = eINSTANCE.getHost_Enable_active_checks();

		/**
		 * The meta object literal for the '<em><b>Enable passive checks</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__ENABLE_PASSIVE_CHECKS = eINSTANCE.getHost_Enable_passive_checks();

		/**
		 * The meta object literal for the '<em><b>Enable event handler</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__ENABLE_EVENT_HANDLER = eINSTANCE.getHost_Enable_event_handler();

		/**
		 * The meta object literal for the '<em><b>Enable flapping</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__ENABLE_FLAPPING = eINSTANCE.getHost_Enable_flapping();

		/**
		 * The meta object literal for the '<em><b>Enable perfdata</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__ENABLE_PERFDATA = eINSTANCE.getHost_Enable_perfdata();

		/**
		 * The meta object literal for the '<em><b>Event command</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOST__EVENT_COMMAND = eINSTANCE.getHost_Event_command();

		/**
		 * The meta object literal for the '<em><b>Flapping threshold</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__FLAPPING_THRESHOLD = eINSTANCE.getHost_Flapping_threshold();

		/**
		 * The meta object literal for the '<em><b>Volatile</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__VOLATILE = eINSTANCE.getHost_Volatile();

		/**
		 * The meta object literal for the '<em><b>Command endpoint</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOST__COMMAND_ENDPOINT = eINSTANCE.getHost_Command_endpoint();

		/**
		 * The meta object literal for the '<em><b>Notes</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__NOTES = eINSTANCE.getHost_Notes();

		/**
		 * The meta object literal for the '<em><b>Notes url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__NOTES_URL = eINSTANCE.getHost_Notes_url();

		/**
		 * The meta object literal for the '<em><b>Action url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__ACTION_URL = eINSTANCE.getHost_Action_url();

		/**
		 * The meta object literal for the '<em><b>Icon image</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__ICON_IMAGE = eINSTANCE.getHost_Icon_image();

		/**
		 * The meta object literal for the '<em><b>Icon image alt</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST__ICON_IMAGE_ALT = eINSTANCE.getHost_Icon_image_alt();

		/**
		 * The meta object literal for the '<em><b>Services</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOST__SERVICES = eINSTANCE.getHost_Services();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.HostGroupImpl <em>Host Group</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.HostGroupImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getHostGroup()
		 * @generated
		 */
		EClass HOST_GROUP = eINSTANCE.getHostGroup();

		/**
		 * The meta object literal for the '<em><b>Display name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOST_GROUP__DISPLAY_NAME = eINSTANCE.getHostGroup_Display_name();

		/**
		 * The meta object literal for the '<em><b>Groups</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOST_GROUP__GROUPS = eINSTANCE.getHostGroup_Groups();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl <em>Service</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getService()
		 * @generated
		 */
		EClass SERVICE = eINSTANCE.getService();

		/**
		 * The meta object literal for the '<em><b>Display name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__DISPLAY_NAME = eINSTANCE.getService_Display_name();

		/**
		 * The meta object literal for the '<em><b>Host</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE__HOST = eINSTANCE.getService_Host();

		/**
		 * The meta object literal for the '<em><b>Groups</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE__GROUPS = eINSTANCE.getService_Groups();

		/**
		 * The meta object literal for the '<em><b>Vars</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE__VARS = eINSTANCE.getService_Vars();

		/**
		 * The meta object literal for the '<em><b>Check command</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE__CHECK_COMMAND = eINSTANCE.getService_Check_command();

		/**
		 * The meta object literal for the '<em><b>Max check attempts</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__MAX_CHECK_ATTEMPTS = eINSTANCE.getService_Max_check_attempts();

		/**
		 * The meta object literal for the '<em><b>Check period</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE__CHECK_PERIOD = eINSTANCE.getService_Check_period();

		/**
		 * The meta object literal for the '<em><b>Check interval</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__CHECK_INTERVAL = eINSTANCE.getService_Check_interval();

		/**
		 * The meta object literal for the '<em><b>Retry interval</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__RETRY_INTERVAL = eINSTANCE.getService_Retry_interval();

		/**
		 * The meta object literal for the '<em><b>Enable notifications</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__ENABLE_NOTIFICATIONS = eINSTANCE.getService_Enable_notifications();

		/**
		 * The meta object literal for the '<em><b>Enable active checks</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__ENABLE_ACTIVE_CHECKS = eINSTANCE.getService_Enable_active_checks();

		/**
		 * The meta object literal for the '<em><b>Enable passive checks</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__ENABLE_PASSIVE_CHECKS = eINSTANCE.getService_Enable_passive_checks();

		/**
		 * The meta object literal for the '<em><b>Enable event handler</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__ENABLE_EVENT_HANDLER = eINSTANCE.getService_Enable_event_handler();

		/**
		 * The meta object literal for the '<em><b>Enable flapping</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__ENABLE_FLAPPING = eINSTANCE.getService_Enable_flapping();

		/**
		 * The meta object literal for the '<em><b>Enable perfdata</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__ENABLE_PERFDATA = eINSTANCE.getService_Enable_perfdata();

		/**
		 * The meta object literal for the '<em><b>Event command</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE__EVENT_COMMAND = eINSTANCE.getService_Event_command();

		/**
		 * The meta object literal for the '<em><b>Flapping threshold</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__FLAPPING_THRESHOLD = eINSTANCE.getService_Flapping_threshold();

		/**
		 * The meta object literal for the '<em><b>Volatile</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__VOLATILE = eINSTANCE.getService_Volatile();

		/**
		 * The meta object literal for the '<em><b>Command endpoint</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE__COMMAND_ENDPOINT = eINSTANCE.getService_Command_endpoint();

		/**
		 * The meta object literal for the '<em><b>Notes</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__NOTES = eINSTANCE.getService_Notes();

		/**
		 * The meta object literal for the '<em><b>Notes url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__NOTES_URL = eINSTANCE.getService_Notes_url();

		/**
		 * The meta object literal for the '<em><b>Action url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__ACTION_URL = eINSTANCE.getService_Action_url();

		/**
		 * The meta object literal for the '<em><b>Icon image</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__ICON_IMAGE = eINSTANCE.getService_Icon_image();

		/**
		 * The meta object literal for the '<em><b>Icon image alt</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE__ICON_IMAGE_ALT = eINSTANCE.getService_Icon_image_alt();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceGroupImpl <em>Service Group</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ServiceGroupImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getServiceGroup()
		 * @generated
		 */
		EClass SERVICE_GROUP = eINSTANCE.getServiceGroup();

		/**
		 * The meta object literal for the '<em><b>Display name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE_GROUP__DISPLAY_NAME = eINSTANCE.getServiceGroup_Display_name();

		/**
		 * The meta object literal for the '<em><b>Groups</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_GROUP__GROUPS = eINSTANCE.getServiceGroup_Groups();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.UserImpl <em>User</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.UserImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getUser()
		 * @generated
		 */
		EClass USER = eINSTANCE.getUser();

		/**
		 * The meta object literal for the '<em><b>Display name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER__DISPLAY_NAME = eINSTANCE.getUser_Display_name();

		/**
		 * The meta object literal for the '<em><b>Email</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER__EMAIL = eINSTANCE.getUser_Email();

		/**
		 * The meta object literal for the '<em><b>Pager</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER__PAGER = eINSTANCE.getUser_Pager();

		/**
		 * The meta object literal for the '<em><b>Vars</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference USER__VARS = eINSTANCE.getUser_Vars();

		/**
		 * The meta object literal for the '<em><b>Groups</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference USER__GROUPS = eINSTANCE.getUser_Groups();

		/**
		 * The meta object literal for the '<em><b>Enable notifications</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER__ENABLE_NOTIFICATIONS = eINSTANCE.getUser_Enable_notifications();

		/**
		 * The meta object literal for the '<em><b>Period</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference USER__PERIOD = eINSTANCE.getUser_Period();

		/**
		 * The meta object literal for the '<em><b>Types</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER__TYPES = eINSTANCE.getUser_Types();

		/**
		 * The meta object literal for the '<em><b>States</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER__STATES = eINSTANCE.getUser_States();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.UserGroupImpl <em>User Group</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.UserGroupImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getUserGroup()
		 * @generated
		 */
		EClass USER_GROUP = eINSTANCE.getUserGroup();

		/**
		 * The meta object literal for the '<em><b>Display name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USER_GROUP__DISPLAY_NAME = eINSTANCE.getUserGroup_Display_name();

		/**
		 * The meta object literal for the '<em><b>Groups</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference USER_GROUP__GROUPS = eINSTANCE.getUserGroup_Groups();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ZoneImpl <em>Zone</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ZoneImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getZone()
		 * @generated
		 */
		EClass ZONE = eINSTANCE.getZone();

		/**
		 * The meta object literal for the '<em><b>Endpoints</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ZONE__ENDPOINTS = eINSTANCE.getZone_Endpoints();

		/**
		 * The meta object literal for the '<em><b>Parent</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ZONE__PARENT = eINSTANCE.getZone_Parent();

		/**
		 * The meta object literal for the '<em><b>Global</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ZONE__GLOBAL = eINSTANCE.getZone_Global();

		/**
		 * The meta object literal for the '<em><b>Elements</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ZONE__ELEMENTS = eINSTANCE.getZone_Elements();

		/**
		 * The meta object literal for the '<em><b>Subzones</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ZONE__SUBZONES = eINSTANCE.getZone_Subzones();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.EndpointImpl <em>Endpoint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.EndpointImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getEndpoint()
		 * @generated
		 */
		EClass ENDPOINT = eINSTANCE.getEndpoint();

		/**
		 * The meta object literal for the '<em><b>Host</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ENDPOINT__HOST = eINSTANCE.getEndpoint_Host();

		/**
		 * The meta object literal for the '<em><b>Port</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ENDPOINT__PORT = eINSTANCE.getEndpoint_Port();

		/**
		 * The meta object literal for the '<em><b>Log duration</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ENDPOINT__LOG_DURATION = eINSTANCE.getEndpoint_Log_duration();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CheckerComponentImpl <em>Checker Component</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CheckerComponentImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCheckerComponent()
		 * @generated
		 */
		EClass CHECKER_COMPONENT = eINSTANCE.getCheckerComponent();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationComponentImpl <em>Notification Component</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.NotificationComponentImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNotificationComponent()
		 * @generated
		 */
		EClass NOTIFICATION_COMPONENT = eINSTANCE.getNotificationComponent();

		/**
		 * The meta object literal for the '<em><b>Enable ha</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION_COMPONENT__ENABLE_HA = eINSTANCE.getNotificationComponent_Enable_ha();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CheckResultReaderImpl <em>Check Result Reader</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CheckResultReaderImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCheckResultReader()
		 * @generated
		 */
		EClass CHECK_RESULT_READER = eINSTANCE.getCheckResultReader();

		/**
		 * The meta object literal for the '<em><b>Spool dir</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHECK_RESULT_READER__SPOOL_DIR = eINSTANCE.getCheckResultReader_Spool_dir();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ApiListenerImpl <em>Api Listener</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ApiListenerImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getApiListener()
		 * @generated
		 */
		EClass API_LISTENER = eINSTANCE.getApiListener();

		/**
		 * The meta object literal for the '<em><b>Cert path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute API_LISTENER__CERT_PATH = eINSTANCE.getApiListener_Cert_path();

		/**
		 * The meta object literal for the '<em><b>Key path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute API_LISTENER__KEY_PATH = eINSTANCE.getApiListener_Key_path();

		/**
		 * The meta object literal for the '<em><b>Ca path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute API_LISTENER__CA_PATH = eINSTANCE.getApiListener_Ca_path();

		/**
		 * The meta object literal for the '<em><b>Crl path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute API_LISTENER__CRL_PATH = eINSTANCE.getApiListener_Crl_path();

		/**
		 * The meta object literal for the '<em><b>Bind host</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute API_LISTENER__BIND_HOST = eINSTANCE.getApiListener_Bind_host();

		/**
		 * The meta object literal for the '<em><b>Bind port</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute API_LISTENER__BIND_PORT = eINSTANCE.getApiListener_Bind_port();

		/**
		 * The meta object literal for the '<em><b>Accept config</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute API_LISTENER__ACCEPT_CONFIG = eINSTANCE.getApiListener_Accept_config();

		/**
		 * The meta object literal for the '<em><b>Accept commands</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute API_LISTENER__ACCEPT_COMMANDS = eINSTANCE.getApiListener_Accept_commands();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.LiveStatusListenerImpl <em>Live Status Listener</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.LiveStatusListenerImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getLiveStatusListener()
		 * @generated
		 */
		EClass LIVE_STATUS_LISTENER = eINSTANCE.getLiveStatusListener();

		/**
		 * The meta object literal for the '<em><b>Socket type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LIVE_STATUS_LISTENER__SOCKET_TYPE = eINSTANCE.getLiveStatusListener_Socket_type();

		/**
		 * The meta object literal for the '<em><b>Bind host</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LIVE_STATUS_LISTENER__BIND_HOST = eINSTANCE.getLiveStatusListener_Bind_host();

		/**
		 * The meta object literal for the '<em><b>Bind port</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LIVE_STATUS_LISTENER__BIND_PORT = eINSTANCE.getLiveStatusListener_Bind_port();

		/**
		 * The meta object literal for the '<em><b>Socket path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LIVE_STATUS_LISTENER__SOCKET_PATH = eINSTANCE.getLiveStatusListener_Socket_path();

		/**
		 * The meta object literal for the '<em><b>Compat log path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LIVE_STATUS_LISTENER__COMPAT_LOG_PATH = eINSTANCE.getLiveStatusListener_Compat_log_path();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.ExternalCommandListenerImpl <em>External Command Listener</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.ExternalCommandListenerImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getExternalCommandListener()
		 * @generated
		 */
		EClass EXTERNAL_COMMAND_LISTENER = eINSTANCE.getExternalCommandListener();

		/**
		 * The meta object literal for the '<em><b>Command path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXTERNAL_COMMAND_LISTENER__COMMAND_PATH = eINSTANCE.getExternalCommandListener_Command_path();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.CompatLoggerImpl <em>Compat Logger</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.CompatLoggerImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getCompatLogger()
		 * @generated
		 */
		EClass COMPAT_LOGGER = eINSTANCE.getCompatLogger();

		/**
		 * The meta object literal for the '<em><b>Log dir</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPAT_LOGGER__LOG_DIR = eINSTANCE.getCompatLogger_Log_dir();

		/**
		 * The meta object literal for the '<em><b>Rotation method</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPAT_LOGGER__ROTATION_METHOD = eINSTANCE.getCompatLogger_Rotation_method();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.FileLoggerImpl <em>File Logger</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.FileLoggerImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getFileLogger()
		 * @generated
		 */
		EClass FILE_LOGGER = eINSTANCE.getFileLogger();

		/**
		 * The meta object literal for the '<em><b>Path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FILE_LOGGER__PATH = eINSTANCE.getFileLogger_Path();

		/**
		 * The meta object literal for the '<em><b>Severity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FILE_LOGGER__SEVERITY = eINSTANCE.getFileLogger_Severity();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.SyslogLoggerImpl <em>Syslog Logger</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.SyslogLoggerImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getSyslogLogger()
		 * @generated
		 */
		EClass SYSLOG_LOGGER = eINSTANCE.getSyslogLogger();

		/**
		 * The meta object literal for the '<em><b>Severity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SYSLOG_LOGGER__SEVERITY = eINSTANCE.getSyslogLogger_Severity();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.GelfWriterImpl <em>Gelf Writer</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.GelfWriterImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getGelfWriter()
		 * @generated
		 */
		EClass GELF_WRITER = eINSTANCE.getGelfWriter();

		/**
		 * The meta object literal for the '<em><b>Host</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GELF_WRITER__HOST = eINSTANCE.getGelfWriter_Host();

		/**
		 * The meta object literal for the '<em><b>Port</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GELF_WRITER__PORT = eINSTANCE.getGelfWriter_Port();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GELF_WRITER__SOURCE = eINSTANCE.getGelfWriter_Source();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.GraphiteWriterImpl <em>Graphite Writer</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.GraphiteWriterImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getGraphiteWriter()
		 * @generated
		 */
		EClass GRAPHITE_WRITER = eINSTANCE.getGraphiteWriter();

		/**
		 * The meta object literal for the '<em><b>Host</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GRAPHITE_WRITER__HOST = eINSTANCE.getGraphiteWriter_Host();

		/**
		 * The meta object literal for the '<em><b>Port</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GRAPHITE_WRITER__PORT = eINSTANCE.getGraphiteWriter_Port();

		/**
		 * The meta object literal for the '<em><b>Host name template</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GRAPHITE_WRITER__HOST_NAME_TEMPLATE = eINSTANCE.getGraphiteWriter_Host_name_template();

		/**
		 * The meta object literal for the '<em><b>Service name template</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GRAPHITE_WRITER__SERVICE_NAME_TEMPLATE = eINSTANCE.getGraphiteWriter_Service_name_template();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.IcingaStatusWriterImpl <em>Status Writer</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaStatusWriterImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getIcingaStatusWriter()
		 * @generated
		 */
		EClass ICINGA_STATUS_WRITER = eINSTANCE.getIcingaStatusWriter();

		/**
		 * The meta object literal for the '<em><b>Status path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ICINGA_STATUS_WRITER__STATUS_PATH = eINSTANCE.getIcingaStatusWriter_Status_path();

		/**
		 * The meta object literal for the '<em><b>Update interval</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ICINGA_STATUS_WRITER__UPDATE_INTERVAL = eINSTANCE.getIcingaStatusWriter_Update_interval();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.OpenTsdbWriterImpl <em>Open Tsdb Writer</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.OpenTsdbWriterImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getOpenTsdbWriter()
		 * @generated
		 */
		EClass OPEN_TSDB_WRITER = eINSTANCE.getOpenTsdbWriter();

		/**
		 * The meta object literal for the '<em><b>Host</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OPEN_TSDB_WRITER__HOST = eINSTANCE.getOpenTsdbWriter_Host();

		/**
		 * The meta object literal for the '<em><b>Port</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OPEN_TSDB_WRITER__PORT = eINSTANCE.getOpenTsdbWriter_Port();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.PerfdataWriterImpl <em>Perfdata Writer</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.PerfdataWriterImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getPerfdataWriter()
		 * @generated
		 */
		EClass PERFDATA_WRITER = eINSTANCE.getPerfdataWriter();

		/**
		 * The meta object literal for the '<em><b>Host perfdata path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERFDATA_WRITER__HOST_PERFDATA_PATH = eINSTANCE.getPerfdataWriter_Host_perfdata_path();

		/**
		 * The meta object literal for the '<em><b>Service perfdata path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERFDATA_WRITER__SERVICE_PERFDATA_PATH = eINSTANCE.getPerfdataWriter_Service_perfdata_path();

		/**
		 * The meta object literal for the '<em><b>Host temp path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERFDATA_WRITER__HOST_TEMP_PATH = eINSTANCE.getPerfdataWriter_Host_temp_path();

		/**
		 * The meta object literal for the '<em><b>Service temp path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERFDATA_WRITER__SERVICE_TEMP_PATH = eINSTANCE.getPerfdataWriter_Service_temp_path();

		/**
		 * The meta object literal for the '<em><b>Host format template</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERFDATA_WRITER__HOST_FORMAT_TEMPLATE = eINSTANCE.getPerfdataWriter_Host_format_template();

		/**
		 * The meta object literal for the '<em><b>Service format template</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERFDATA_WRITER__SERVICE_FORMAT_TEMPLATE = eINSTANCE.getPerfdataWriter_Service_format_template();

		/**
		 * The meta object literal for the '<em><b>Rotation interval</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERFDATA_WRITER__ROTATION_INTERVAL = eINSTANCE.getPerfdataWriter_Rotation_interval();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.StatusDataWriterImpl <em>Status Data Writer</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.StatusDataWriterImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getStatusDataWriter()
		 * @generated
		 */
		EClass STATUS_DATA_WRITER = eINSTANCE.getStatusDataWriter();

		/**
		 * The meta object literal for the '<em><b>Status path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATUS_DATA_WRITER__STATUS_PATH = eINSTANCE.getStatusDataWriter_Status_path();

		/**
		 * The meta object literal for the '<em><b>Objects path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATUS_DATA_WRITER__OBJECTS_PATH = eINSTANCE.getStatusDataWriter_Objects_path();

		/**
		 * The meta object literal for the '<em><b>Update interval</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATUS_DATA_WRITER__UPDATE_INTERVAL = eINSTANCE.getStatusDataWriter_Update_interval();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl <em>Ido Connection</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IdoConnectionImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getIdoConnection()
		 * @generated
		 */
		EClass IDO_CONNECTION = eINSTANCE.getIdoConnection();

		/**
		 * The meta object literal for the '<em><b>Host</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_CONNECTION__HOST = eINSTANCE.getIdoConnection_Host();

		/**
		 * The meta object literal for the '<em><b>Port</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_CONNECTION__PORT = eINSTANCE.getIdoConnection_Port();

		/**
		 * The meta object literal for the '<em><b>User</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_CONNECTION__USER = eINSTANCE.getIdoConnection_User();

		/**
		 * The meta object literal for the '<em><b>Password</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_CONNECTION__PASSWORD = eINSTANCE.getIdoConnection_Password();

		/**
		 * The meta object literal for the '<em><b>Database</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_CONNECTION__DATABASE = eINSTANCE.getIdoConnection_Database();

		/**
		 * The meta object literal for the '<em><b>Table prefix</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_CONNECTION__TABLE_PREFIX = eINSTANCE.getIdoConnection_Table_prefix();

		/**
		 * The meta object literal for the '<em><b>Instance name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_CONNECTION__INSTANCE_NAME = eINSTANCE.getIdoConnection_Instance_name();

		/**
		 * The meta object literal for the '<em><b>Instance description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_CONNECTION__INSTANCE_DESCRIPTION = eINSTANCE.getIdoConnection_Instance_description();

		/**
		 * The meta object literal for the '<em><b>Enable ha</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_CONNECTION__ENABLE_HA = eINSTANCE.getIdoConnection_Enable_ha();

		/**
		 * The meta object literal for the '<em><b>Failover timeout</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_CONNECTION__FAILOVER_TIMEOUT = eINSTANCE.getIdoConnection_Failover_timeout();

		/**
		 * The meta object literal for the '<em><b>Cleanup</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IDO_CONNECTION__CLEANUP = eINSTANCE.getIdoConnection_Cleanup();

		/**
		 * The meta object literal for the '<em><b>Categories</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_CONNECTION__CATEGORIES = eINSTANCE.getIdoConnection_Categories();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoMySqlConnectionImpl <em>Ido My Sql Connection</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IdoMySqlConnectionImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getIdoMySqlConnection()
		 * @generated
		 */
		EClass IDO_MY_SQL_CONNECTION = eINSTANCE.getIdoMySqlConnection();

		/**
		 * The meta object literal for the '<em><b>Socket path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDO_MY_SQL_CONNECTION__SOCKET_PATH = eINSTANCE.getIdoMySqlConnection_Socket_path();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.impl.IdoPgSqlConnectionImpl <em>Ido Pg Sql Connection</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IdoPgSqlConnectionImpl
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getIdoPgSqlConnection()
		 * @generated
		 */
		EClass IDO_PG_SQL_CONNECTION = eINSTANCE.getIdoPgSqlConnection();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.DatabaseCategory <em>Database Category</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.DatabaseCategory
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getDatabaseCategory()
		 * @generated
		 */
		EEnum DATABASE_CATEGORY = eINSTANCE.getDatabaseCategory();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.NotificationType <em>Notification Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.NotificationType
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getNotificationType()
		 * @generated
		 */
		EEnum NOTIFICATION_TYPE = eINSTANCE.getNotificationType();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.LogRotationMethod <em>Log Rotation Method</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.LogRotationMethod
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getLogRotationMethod()
		 * @generated
		 */
		EEnum LOG_ROTATION_METHOD = eINSTANCE.getLogRotationMethod();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.LogSeverity <em>Log Severity</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.LogSeverity
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getLogSeverity()
		 * @generated
		 */
		EEnum LOG_SEVERITY = eINSTANCE.getLogSeverity();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.SocketType <em>Socket Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.SocketType
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getSocketType()
		 * @generated
		 */
		EEnum SOCKET_TYPE = eINSTANCE.getSocketType();

		/**
		 * The meta object literal for the '{@link it.unibo.cmdb.monitoring.model.icinga.State <em>State</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see it.unibo.cmdb.monitoring.model.icinga.State
		 * @see it.unibo.cmdb.monitoring.model.icinga.impl.IcingaPackageImpl#getState()
		 * @generated
		 */
		EEnum STATE = eINSTANCE.getState();

	}

} //IcingaPackage
