/**
 */
package it.unibo.cmdb.monitoring.model.icinga.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

import it.unibo.cmdb.monitoring.model.icinga.Checkable;
import it.unibo.cmdb.monitoring.model.icinga.Dependency;
import it.unibo.cmdb.monitoring.model.icinga.IcingaPackage;
import it.unibo.cmdb.monitoring.model.icinga.State;
import it.unibo.cmdb.monitoring.model.icinga.TimePeriod;
import it.unibo.cmdb.monitoring.model.icinga.Zone;
import it.unibo.cmdb.monitoring.model.icinga.ZoneElement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Dependency</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl#getZone <em>Zone</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl#getChild <em>Child</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl#isDisable_checks <em>Disable checks</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl#isDisable_notifications <em>Disable notifications</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl#isIgnore_soft_states <em>Ignore soft states</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl#getPeriod <em>Period</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.DependencyImpl#getStates <em>States</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DependencyImpl extends ConfigurationObjectImpl implements Dependency {
	/**
	 * The cached value of the '{@link #getZone() <em>Zone</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getZone()
	 * @generated
	 * @ordered
	 */
	protected Zone zone;

	/**
	 * The cached value of the '{@link #getChild() <em>Child</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChild()
	 * @generated
	 * @ordered
	 */
	protected Checkable child;

	/**
	 * The default value of the '{@link #isDisable_checks() <em>Disable checks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDisable_checks()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DISABLE_CHECKS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDisable_checks() <em>Disable checks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDisable_checks()
	 * @generated
	 * @ordered
	 */
	protected boolean disable_checks = DISABLE_CHECKS_EDEFAULT;

	/**
	 * The default value of the '{@link #isDisable_notifications() <em>Disable notifications</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDisable_notifications()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DISABLE_NOTIFICATIONS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDisable_notifications() <em>Disable notifications</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDisable_notifications()
	 * @generated
	 * @ordered
	 */
	protected boolean disable_notifications = DISABLE_NOTIFICATIONS_EDEFAULT;

	/**
	 * The default value of the '{@link #isIgnore_soft_states() <em>Ignore soft states</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIgnore_soft_states()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IGNORE_SOFT_STATES_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIgnore_soft_states() <em>Ignore soft states</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIgnore_soft_states()
	 * @generated
	 * @ordered
	 */
	protected boolean ignore_soft_states = IGNORE_SOFT_STATES_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPeriod() <em>Period</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPeriod()
	 * @generated
	 * @ordered
	 */
	protected TimePeriod period;

	/**
	 * The cached value of the '{@link #getStates() <em>States</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStates()
	 * @generated
	 * @ordered
	 */
	protected EList<State> states;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DependencyImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IcingaPackage.Literals.DEPENDENCY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Zone getZone() {
		if (zone != null && zone.eIsProxy()) {
			InternalEObject oldZone = (InternalEObject)zone;
			zone = (Zone)eResolveProxy(oldZone);
			if (zone != oldZone) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IcingaPackage.DEPENDENCY__ZONE, oldZone, zone));
			}
		}
		return zone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Zone basicGetZone() {
		return zone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetZone(Zone newZone, NotificationChain msgs) {
		Zone oldZone = zone;
		zone = newZone;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IcingaPackage.DEPENDENCY__ZONE, oldZone, newZone);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setZone(Zone newZone) {
		if (newZone != zone) {
			NotificationChain msgs = null;
			if (zone != null)
				msgs = ((InternalEObject)zone).eInverseRemove(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
			if (newZone != null)
				msgs = ((InternalEObject)newZone).eInverseAdd(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
			msgs = basicSetZone(newZone, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.DEPENDENCY__ZONE, newZone, newZone));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Checkable getParent() {
		if (eContainerFeatureID() != IcingaPackage.DEPENDENCY__PARENT) return null;
		return (Checkable)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParent(Checkable newParent, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newParent, IcingaPackage.DEPENDENCY__PARENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(Checkable newParent) {
		if (newParent != eInternalContainer() || (eContainerFeatureID() != IcingaPackage.DEPENDENCY__PARENT && newParent != null)) {
			if (EcoreUtil.isAncestor(this, newParent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, IcingaPackage.CHECKABLE__DEPENDENCIES, Checkable.class, msgs);
			msgs = basicSetParent(newParent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.DEPENDENCY__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Checkable getChild() {
		if (child != null && child.eIsProxy()) {
			InternalEObject oldChild = (InternalEObject)child;
			child = (Checkable)eResolveProxy(oldChild);
			if (child != oldChild) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IcingaPackage.DEPENDENCY__CHILD, oldChild, child));
			}
		}
		return child;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Checkable basicGetChild() {
		return child;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setChild(Checkable newChild) {
		Checkable oldChild = child;
		child = newChild;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.DEPENDENCY__CHILD, oldChild, child));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isDisable_checks() {
		return disable_checks;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDisable_checks(boolean newDisable_checks) {
		boolean oldDisable_checks = disable_checks;
		disable_checks = newDisable_checks;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.DEPENDENCY__DISABLE_CHECKS, oldDisable_checks, disable_checks));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isDisable_notifications() {
		return disable_notifications;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDisable_notifications(boolean newDisable_notifications) {
		boolean oldDisable_notifications = disable_notifications;
		disable_notifications = newDisable_notifications;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.DEPENDENCY__DISABLE_NOTIFICATIONS, oldDisable_notifications, disable_notifications));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIgnore_soft_states() {
		return ignore_soft_states;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIgnore_soft_states(boolean newIgnore_soft_states) {
		boolean oldIgnore_soft_states = ignore_soft_states;
		ignore_soft_states = newIgnore_soft_states;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.DEPENDENCY__IGNORE_SOFT_STATES, oldIgnore_soft_states, ignore_soft_states));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TimePeriod getPeriod() {
		if (period != null && period.eIsProxy()) {
			InternalEObject oldPeriod = (InternalEObject)period;
			period = (TimePeriod)eResolveProxy(oldPeriod);
			if (period != oldPeriod) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IcingaPackage.DEPENDENCY__PERIOD, oldPeriod, period));
			}
		}
		return period;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TimePeriod basicGetPeriod() {
		return period;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPeriod(TimePeriod newPeriod) {
		TimePeriod oldPeriod = period;
		period = newPeriod;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.DEPENDENCY__PERIOD, oldPeriod, period));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<State> getStates() {
		if (states == null) {
			states = new EDataTypeUniqueEList<State>(State.class, this, IcingaPackage.DEPENDENCY__STATES);
		}
		return states;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IcingaPackage.DEPENDENCY__ZONE:
				if (zone != null)
					msgs = ((InternalEObject)zone).eInverseRemove(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
				return basicSetZone((Zone)otherEnd, msgs);
			case IcingaPackage.DEPENDENCY__PARENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetParent((Checkable)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IcingaPackage.DEPENDENCY__ZONE:
				return basicSetZone(null, msgs);
			case IcingaPackage.DEPENDENCY__PARENT:
				return basicSetParent(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case IcingaPackage.DEPENDENCY__PARENT:
				return eInternalContainer().eInverseRemove(this, IcingaPackage.CHECKABLE__DEPENDENCIES, Checkable.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IcingaPackage.DEPENDENCY__ZONE:
				if (resolve) return getZone();
				return basicGetZone();
			case IcingaPackage.DEPENDENCY__PARENT:
				return getParent();
			case IcingaPackage.DEPENDENCY__CHILD:
				if (resolve) return getChild();
				return basicGetChild();
			case IcingaPackage.DEPENDENCY__DISABLE_CHECKS:
				return isDisable_checks();
			case IcingaPackage.DEPENDENCY__DISABLE_NOTIFICATIONS:
				return isDisable_notifications();
			case IcingaPackage.DEPENDENCY__IGNORE_SOFT_STATES:
				return isIgnore_soft_states();
			case IcingaPackage.DEPENDENCY__PERIOD:
				if (resolve) return getPeriod();
				return basicGetPeriod();
			case IcingaPackage.DEPENDENCY__STATES:
				return getStates();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IcingaPackage.DEPENDENCY__ZONE:
				setZone((Zone)newValue);
				return;
			case IcingaPackage.DEPENDENCY__PARENT:
				setParent((Checkable)newValue);
				return;
			case IcingaPackage.DEPENDENCY__CHILD:
				setChild((Checkable)newValue);
				return;
			case IcingaPackage.DEPENDENCY__DISABLE_CHECKS:
				setDisable_checks((Boolean)newValue);
				return;
			case IcingaPackage.DEPENDENCY__DISABLE_NOTIFICATIONS:
				setDisable_notifications((Boolean)newValue);
				return;
			case IcingaPackage.DEPENDENCY__IGNORE_SOFT_STATES:
				setIgnore_soft_states((Boolean)newValue);
				return;
			case IcingaPackage.DEPENDENCY__PERIOD:
				setPeriod((TimePeriod)newValue);
				return;
			case IcingaPackage.DEPENDENCY__STATES:
				getStates().clear();
				getStates().addAll((Collection<? extends State>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IcingaPackage.DEPENDENCY__ZONE:
				setZone((Zone)null);
				return;
			case IcingaPackage.DEPENDENCY__PARENT:
				setParent((Checkable)null);
				return;
			case IcingaPackage.DEPENDENCY__CHILD:
				setChild((Checkable)null);
				return;
			case IcingaPackage.DEPENDENCY__DISABLE_CHECKS:
				setDisable_checks(DISABLE_CHECKS_EDEFAULT);
				return;
			case IcingaPackage.DEPENDENCY__DISABLE_NOTIFICATIONS:
				setDisable_notifications(DISABLE_NOTIFICATIONS_EDEFAULT);
				return;
			case IcingaPackage.DEPENDENCY__IGNORE_SOFT_STATES:
				setIgnore_soft_states(IGNORE_SOFT_STATES_EDEFAULT);
				return;
			case IcingaPackage.DEPENDENCY__PERIOD:
				setPeriod((TimePeriod)null);
				return;
			case IcingaPackage.DEPENDENCY__STATES:
				getStates().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IcingaPackage.DEPENDENCY__ZONE:
				return zone != null;
			case IcingaPackage.DEPENDENCY__PARENT:
				return getParent() != null;
			case IcingaPackage.DEPENDENCY__CHILD:
				return child != null;
			case IcingaPackage.DEPENDENCY__DISABLE_CHECKS:
				return disable_checks != DISABLE_CHECKS_EDEFAULT;
			case IcingaPackage.DEPENDENCY__DISABLE_NOTIFICATIONS:
				return disable_notifications != DISABLE_NOTIFICATIONS_EDEFAULT;
			case IcingaPackage.DEPENDENCY__IGNORE_SOFT_STATES:
				return ignore_soft_states != IGNORE_SOFT_STATES_EDEFAULT;
			case IcingaPackage.DEPENDENCY__PERIOD:
				return period != null;
			case IcingaPackage.DEPENDENCY__STATES:
				return states != null && !states.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == ZoneElement.class) {
			switch (derivedFeatureID) {
				case IcingaPackage.DEPENDENCY__ZONE: return IcingaPackage.ZONE_ELEMENT__ZONE;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == ZoneElement.class) {
			switch (baseFeatureID) {
				case IcingaPackage.ZONE_ELEMENT__ZONE: return IcingaPackage.DEPENDENCY__ZONE;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (disable_checks: ");
		result.append(disable_checks);
		result.append(", disable_notifications: ");
		result.append(disable_notifications);
		result.append(", ignore_soft_states: ");
		result.append(ignore_soft_states);
		result.append(", states: ");
		result.append(states);
		result.append(')');
		return result.toString();
	}

} //DependencyImpl
