/**
 */
package it.unibo.cmdb.monitoring.model.icinga.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import it.unibo.cmdb.monitoring.model.icinga.Checkable;
import it.unibo.cmdb.monitoring.model.icinga.IcingaPackage;
import it.unibo.cmdb.monitoring.model.icinga.Notification;
import it.unibo.cmdb.monitoring.model.icinga.NotificationCommand;
import it.unibo.cmdb.monitoring.model.icinga.NotificationTimes;
import it.unibo.cmdb.monitoring.model.icinga.NotificationType;
import it.unibo.cmdb.monitoring.model.icinga.State;
import it.unibo.cmdb.monitoring.model.icinga.TimePeriod;
import it.unibo.cmdb.monitoring.model.icinga.User;
import it.unibo.cmdb.monitoring.model.icinga.UserGroup;
import it.unibo.cmdb.monitoring.model.icinga.UserVar;
import it.unibo.cmdb.monitoring.model.icinga.Zone;
import it.unibo.cmdb.monitoring.model.icinga.ZoneElement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Notification</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl#getZone <em>Zone</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl#getCheckable <em>Checkable</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl#getVars <em>Vars</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl#getUsers <em>Users</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl#getUser_groups <em>User groups</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl#getTimes <em>Times</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl#getCommand <em>Command</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl#getInterval <em>Interval</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl#getPeriod <em>Period</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl#getTypes <em>Types</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.NotificationImpl#getStates <em>States</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class NotificationImpl extends ConfigurationObjectImpl implements Notification {
	/**
	 * The cached value of the '{@link #getZone() <em>Zone</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getZone()
	 * @generated
	 * @ordered
	 */
	protected Zone zone;

	/**
	 * The cached value of the '{@link #getVars() <em>Vars</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVars()
	 * @generated
	 * @ordered
	 */
	protected EList<UserVar> vars;

	/**
	 * The cached value of the '{@link #getUsers() <em>Users</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsers()
	 * @generated
	 * @ordered
	 */
	protected EList<User> users;

	/**
	 * The cached value of the '{@link #getUser_groups() <em>User groups</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUser_groups()
	 * @generated
	 * @ordered
	 */
	protected EList<UserGroup> user_groups;

	/**
	 * The cached value of the '{@link #getTimes() <em>Times</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimes()
	 * @generated
	 * @ordered
	 */
	protected NotificationTimes times;

	/**
	 * The cached value of the '{@link #getCommand() <em>Command</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCommand()
	 * @generated
	 * @ordered
	 */
	protected NotificationCommand command;

	/**
	 * The default value of the '{@link #getInterval() <em>Interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInterval()
	 * @generated
	 * @ordered
	 */
	protected static final int INTERVAL_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getInterval() <em>Interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInterval()
	 * @generated
	 * @ordered
	 */
	protected int interval = INTERVAL_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPeriod() <em>Period</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPeriod()
	 * @generated
	 * @ordered
	 */
	protected TimePeriod period;

	/**
	 * The cached value of the '{@link #getTypes() <em>Types</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypes()
	 * @generated
	 * @ordered
	 */
	protected EList<NotificationType> types;

	/**
	 * The cached value of the '{@link #getStates() <em>States</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStates()
	 * @generated
	 * @ordered
	 */
	protected EList<State> states;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NotificationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IcingaPackage.Literals.NOTIFICATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Zone getZone() {
		if (zone != null && zone.eIsProxy()) {
			InternalEObject oldZone = (InternalEObject)zone;
			zone = (Zone)eResolveProxy(oldZone);
			if (zone != oldZone) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.RESOLVE, IcingaPackage.NOTIFICATION__ZONE, oldZone, zone));
			}
		}
		return zone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Zone basicGetZone() {
		return zone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetZone(Zone newZone, NotificationChain msgs) {
		Zone oldZone = zone;
		zone = newZone;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.NOTIFICATION__ZONE, oldZone, newZone);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setZone(Zone newZone) {
		if (newZone != zone) {
			NotificationChain msgs = null;
			if (zone != null)
				msgs = ((InternalEObject)zone).eInverseRemove(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
			if (newZone != null)
				msgs = ((InternalEObject)newZone).eInverseAdd(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
			msgs = basicSetZone(newZone, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.NOTIFICATION__ZONE, newZone, newZone));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Checkable getCheckable() {
		if (eContainerFeatureID() != IcingaPackage.NOTIFICATION__CHECKABLE) return null;
		return (Checkable)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCheckable(Checkable newCheckable, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newCheckable, IcingaPackage.NOTIFICATION__CHECKABLE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCheckable(Checkable newCheckable) {
		if (newCheckable != eInternalContainer() || (eContainerFeatureID() != IcingaPackage.NOTIFICATION__CHECKABLE && newCheckable != null)) {
			if (EcoreUtil.isAncestor(this, newCheckable))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newCheckable != null)
				msgs = ((InternalEObject)newCheckable).eInverseAdd(this, IcingaPackage.CHECKABLE__NOTIFICATIONS, Checkable.class, msgs);
			msgs = basicSetCheckable(newCheckable, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.NOTIFICATION__CHECKABLE, newCheckable, newCheckable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<UserVar> getVars() {
		if (vars == null) {
			vars = new EObjectContainmentEList<UserVar>(UserVar.class, this, IcingaPackage.NOTIFICATION__VARS);
		}
		return vars;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<User> getUsers() {
		if (users == null) {
			users = new EObjectResolvingEList<User>(User.class, this, IcingaPackage.NOTIFICATION__USERS);
		}
		return users;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<UserGroup> getUser_groups() {
		if (user_groups == null) {
			user_groups = new EObjectResolvingEList<UserGroup>(UserGroup.class, this, IcingaPackage.NOTIFICATION__USER_GROUPS);
		}
		return user_groups;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationTimes getTimes() {
		return times;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTimes(NotificationTimes newTimes, NotificationChain msgs) {
		NotificationTimes oldTimes = times;
		times = newTimes;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.NOTIFICATION__TIMES, oldTimes, newTimes);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimes(NotificationTimes newTimes) {
		if (newTimes != times) {
			NotificationChain msgs = null;
			if (times != null)
				msgs = ((InternalEObject)times).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - IcingaPackage.NOTIFICATION__TIMES, null, msgs);
			if (newTimes != null)
				msgs = ((InternalEObject)newTimes).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - IcingaPackage.NOTIFICATION__TIMES, null, msgs);
			msgs = basicSetTimes(newTimes, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.NOTIFICATION__TIMES, newTimes, newTimes));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationCommand getCommand() {
		if (command != null && command.eIsProxy()) {
			InternalEObject oldCommand = (InternalEObject)command;
			command = (NotificationCommand)eResolveProxy(oldCommand);
			if (command != oldCommand) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.RESOLVE, IcingaPackage.NOTIFICATION__COMMAND, oldCommand, command));
			}
		}
		return command;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationCommand basicGetCommand() {
		return command;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCommand(NotificationCommand newCommand) {
		NotificationCommand oldCommand = command;
		command = newCommand;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.NOTIFICATION__COMMAND, oldCommand, command));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getInterval() {
		return interval;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInterval(int newInterval) {
		int oldInterval = interval;
		interval = newInterval;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.NOTIFICATION__INTERVAL, oldInterval, interval));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TimePeriod getPeriod() {
		if (period != null && period.eIsProxy()) {
			InternalEObject oldPeriod = (InternalEObject)period;
			period = (TimePeriod)eResolveProxy(oldPeriod);
			if (period != oldPeriod) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.RESOLVE, IcingaPackage.NOTIFICATION__PERIOD, oldPeriod, period));
			}
		}
		return period;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TimePeriod basicGetPeriod() {
		return period;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPeriod(TimePeriod newPeriod) {
		TimePeriod oldPeriod = period;
		period = newPeriod;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.NOTIFICATION__PERIOD, oldPeriod, period));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<NotificationType> getTypes() {
		if (types == null) {
			types = new EDataTypeUniqueEList<NotificationType>(NotificationType.class, this, IcingaPackage.NOTIFICATION__TYPES);
		}
		return types;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<State> getStates() {
		if (states == null) {
			states = new EDataTypeUniqueEList<State>(State.class, this, IcingaPackage.NOTIFICATION__STATES);
		}
		return states;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IcingaPackage.NOTIFICATION__ZONE:
				if (zone != null)
					msgs = ((InternalEObject)zone).eInverseRemove(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
				return basicSetZone((Zone)otherEnd, msgs);
			case IcingaPackage.NOTIFICATION__CHECKABLE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetCheckable((Checkable)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IcingaPackage.NOTIFICATION__ZONE:
				return basicSetZone(null, msgs);
			case IcingaPackage.NOTIFICATION__CHECKABLE:
				return basicSetCheckable(null, msgs);
			case IcingaPackage.NOTIFICATION__VARS:
				return ((InternalEList<?>)getVars()).basicRemove(otherEnd, msgs);
			case IcingaPackage.NOTIFICATION__TIMES:
				return basicSetTimes(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case IcingaPackage.NOTIFICATION__CHECKABLE:
				return eInternalContainer().eInverseRemove(this, IcingaPackage.CHECKABLE__NOTIFICATIONS, Checkable.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IcingaPackage.NOTIFICATION__ZONE:
				if (resolve) return getZone();
				return basicGetZone();
			case IcingaPackage.NOTIFICATION__CHECKABLE:
				return getCheckable();
			case IcingaPackage.NOTIFICATION__VARS:
				return getVars();
			case IcingaPackage.NOTIFICATION__USERS:
				return getUsers();
			case IcingaPackage.NOTIFICATION__USER_GROUPS:
				return getUser_groups();
			case IcingaPackage.NOTIFICATION__TIMES:
				return getTimes();
			case IcingaPackage.NOTIFICATION__COMMAND:
				if (resolve) return getCommand();
				return basicGetCommand();
			case IcingaPackage.NOTIFICATION__INTERVAL:
				return getInterval();
			case IcingaPackage.NOTIFICATION__PERIOD:
				if (resolve) return getPeriod();
				return basicGetPeriod();
			case IcingaPackage.NOTIFICATION__TYPES:
				return getTypes();
			case IcingaPackage.NOTIFICATION__STATES:
				return getStates();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IcingaPackage.NOTIFICATION__ZONE:
				setZone((Zone)newValue);
				return;
			case IcingaPackage.NOTIFICATION__CHECKABLE:
				setCheckable((Checkable)newValue);
				return;
			case IcingaPackage.NOTIFICATION__VARS:
				getVars().clear();
				getVars().addAll((Collection<? extends UserVar>)newValue);
				return;
			case IcingaPackage.NOTIFICATION__USERS:
				getUsers().clear();
				getUsers().addAll((Collection<? extends User>)newValue);
				return;
			case IcingaPackage.NOTIFICATION__USER_GROUPS:
				getUser_groups().clear();
				getUser_groups().addAll((Collection<? extends UserGroup>)newValue);
				return;
			case IcingaPackage.NOTIFICATION__TIMES:
				setTimes((NotificationTimes)newValue);
				return;
			case IcingaPackage.NOTIFICATION__COMMAND:
				setCommand((NotificationCommand)newValue);
				return;
			case IcingaPackage.NOTIFICATION__INTERVAL:
				setInterval((Integer)newValue);
				return;
			case IcingaPackage.NOTIFICATION__PERIOD:
				setPeriod((TimePeriod)newValue);
				return;
			case IcingaPackage.NOTIFICATION__TYPES:
				getTypes().clear();
				getTypes().addAll((Collection<? extends NotificationType>)newValue);
				return;
			case IcingaPackage.NOTIFICATION__STATES:
				getStates().clear();
				getStates().addAll((Collection<? extends State>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IcingaPackage.NOTIFICATION__ZONE:
				setZone((Zone)null);
				return;
			case IcingaPackage.NOTIFICATION__CHECKABLE:
				setCheckable((Checkable)null);
				return;
			case IcingaPackage.NOTIFICATION__VARS:
				getVars().clear();
				return;
			case IcingaPackage.NOTIFICATION__USERS:
				getUsers().clear();
				return;
			case IcingaPackage.NOTIFICATION__USER_GROUPS:
				getUser_groups().clear();
				return;
			case IcingaPackage.NOTIFICATION__TIMES:
				setTimes((NotificationTimes)null);
				return;
			case IcingaPackage.NOTIFICATION__COMMAND:
				setCommand((NotificationCommand)null);
				return;
			case IcingaPackage.NOTIFICATION__INTERVAL:
				setInterval(INTERVAL_EDEFAULT);
				return;
			case IcingaPackage.NOTIFICATION__PERIOD:
				setPeriod((TimePeriod)null);
				return;
			case IcingaPackage.NOTIFICATION__TYPES:
				getTypes().clear();
				return;
			case IcingaPackage.NOTIFICATION__STATES:
				getStates().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IcingaPackage.NOTIFICATION__ZONE:
				return zone != null;
			case IcingaPackage.NOTIFICATION__CHECKABLE:
				return getCheckable() != null;
			case IcingaPackage.NOTIFICATION__VARS:
				return vars != null && !vars.isEmpty();
			case IcingaPackage.NOTIFICATION__USERS:
				return users != null && !users.isEmpty();
			case IcingaPackage.NOTIFICATION__USER_GROUPS:
				return user_groups != null && !user_groups.isEmpty();
			case IcingaPackage.NOTIFICATION__TIMES:
				return times != null;
			case IcingaPackage.NOTIFICATION__COMMAND:
				return command != null;
			case IcingaPackage.NOTIFICATION__INTERVAL:
				return interval != INTERVAL_EDEFAULT;
			case IcingaPackage.NOTIFICATION__PERIOD:
				return period != null;
			case IcingaPackage.NOTIFICATION__TYPES:
				return types != null && !types.isEmpty();
			case IcingaPackage.NOTIFICATION__STATES:
				return states != null && !states.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == ZoneElement.class) {
			switch (derivedFeatureID) {
				case IcingaPackage.NOTIFICATION__ZONE: return IcingaPackage.ZONE_ELEMENT__ZONE;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == ZoneElement.class) {
			switch (baseFeatureID) {
				case IcingaPackage.ZONE_ELEMENT__ZONE: return IcingaPackage.NOTIFICATION__ZONE;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (interval: ");
		result.append(interval);
		result.append(", types: ");
		result.append(types);
		result.append(", states: ");
		result.append(states);
		result.append(')');
		return result.toString();
	}

} //NotificationImpl
