/**
 */
package it.unibo.cmdb.monitoring.model.icinga.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import it.unibo.cmdb.monitoring.model.icinga.Endpoint;
import it.unibo.cmdb.monitoring.model.icinga.IcingaPackage;
import it.unibo.cmdb.monitoring.model.icinga.Zone;
import it.unibo.cmdb.monitoring.model.icinga.ZoneElement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Zone</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ZoneImpl#getEndpoints <em>Endpoints</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ZoneImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ZoneImpl#isGlobal <em>Global</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ZoneImpl#getElements <em>Elements</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ZoneImpl#getSubzones <em>Subzones</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ZoneImpl extends ConfigurationObjectImpl implements Zone {
	/**
	 * The cached value of the '{@link #getEndpoints() <em>Endpoints</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEndpoints()
	 * @generated
	 * @ordered
	 */
	protected EList<Endpoint> endpoints;

	/**
	 * The default value of the '{@link #isGlobal() <em>Global</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isGlobal()
	 * @generated
	 * @ordered
	 */
	protected static final boolean GLOBAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isGlobal() <em>Global</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isGlobal()
	 * @generated
	 * @ordered
	 */
	protected boolean global = GLOBAL_EDEFAULT;

	/**
	 * The cached value of the '{@link #getElements() <em>Elements</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getElements()
	 * @generated
	 * @ordered
	 */
	protected ZoneElement elements;

	/**
	 * The cached value of the '{@link #getSubzones() <em>Subzones</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubzones()
	 * @generated
	 * @ordered
	 */
	protected EList<Zone> subzones;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZoneImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IcingaPackage.Literals.ZONE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Endpoint> getEndpoints() {
		if (endpoints == null) {
			endpoints = new EObjectResolvingEList<Endpoint>(Endpoint.class, this, IcingaPackage.ZONE__ENDPOINTS);
		}
		return endpoints;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Zone getParent() {
		if (eContainerFeatureID() != IcingaPackage.ZONE__PARENT) return null;
		return (Zone)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParent(Zone newParent, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newParent, IcingaPackage.ZONE__PARENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(Zone newParent) {
		if (newParent != eInternalContainer() || (eContainerFeatureID() != IcingaPackage.ZONE__PARENT && newParent != null)) {
			if (EcoreUtil.isAncestor(this, newParent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, IcingaPackage.ZONE__SUBZONES, Zone.class, msgs);
			msgs = basicSetParent(newParent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.ZONE__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isGlobal() {
		return global;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setGlobal(boolean newGlobal) {
		boolean oldGlobal = global;
		global = newGlobal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.ZONE__GLOBAL, oldGlobal, global));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ZoneElement getElements() {
		if (elements != null && elements.eIsProxy()) {
			InternalEObject oldElements = (InternalEObject)elements;
			elements = (ZoneElement)eResolveProxy(oldElements);
			if (elements != oldElements) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IcingaPackage.ZONE__ELEMENTS, oldElements, elements));
			}
		}
		return elements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ZoneElement basicGetElements() {
		return elements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetElements(ZoneElement newElements, NotificationChain msgs) {
		ZoneElement oldElements = elements;
		elements = newElements;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IcingaPackage.ZONE__ELEMENTS, oldElements, newElements);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setElements(ZoneElement newElements) {
		if (newElements != elements) {
			NotificationChain msgs = null;
			if (elements != null)
				msgs = ((InternalEObject)elements).eInverseRemove(this, IcingaPackage.ZONE_ELEMENT__ZONE, ZoneElement.class, msgs);
			if (newElements != null)
				msgs = ((InternalEObject)newElements).eInverseAdd(this, IcingaPackage.ZONE_ELEMENT__ZONE, ZoneElement.class, msgs);
			msgs = basicSetElements(newElements, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IcingaPackage.ZONE__ELEMENTS, newElements, newElements));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Zone> getSubzones() {
		if (subzones == null) {
			subzones = new EObjectContainmentWithInverseEList<Zone>(Zone.class, this, IcingaPackage.ZONE__SUBZONES, IcingaPackage.ZONE__PARENT);
		}
		return subzones;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IcingaPackage.ZONE__PARENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetParent((Zone)otherEnd, msgs);
			case IcingaPackage.ZONE__ELEMENTS:
				if (elements != null)
					msgs = ((InternalEObject)elements).eInverseRemove(this, IcingaPackage.ZONE_ELEMENT__ZONE, ZoneElement.class, msgs);
				return basicSetElements((ZoneElement)otherEnd, msgs);
			case IcingaPackage.ZONE__SUBZONES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getSubzones()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IcingaPackage.ZONE__PARENT:
				return basicSetParent(null, msgs);
			case IcingaPackage.ZONE__ELEMENTS:
				return basicSetElements(null, msgs);
			case IcingaPackage.ZONE__SUBZONES:
				return ((InternalEList<?>)getSubzones()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case IcingaPackage.ZONE__PARENT:
				return eInternalContainer().eInverseRemove(this, IcingaPackage.ZONE__SUBZONES, Zone.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IcingaPackage.ZONE__ENDPOINTS:
				return getEndpoints();
			case IcingaPackage.ZONE__PARENT:
				return getParent();
			case IcingaPackage.ZONE__GLOBAL:
				return isGlobal();
			case IcingaPackage.ZONE__ELEMENTS:
				if (resolve) return getElements();
				return basicGetElements();
			case IcingaPackage.ZONE__SUBZONES:
				return getSubzones();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IcingaPackage.ZONE__ENDPOINTS:
				getEndpoints().clear();
				getEndpoints().addAll((Collection<? extends Endpoint>)newValue);
				return;
			case IcingaPackage.ZONE__PARENT:
				setParent((Zone)newValue);
				return;
			case IcingaPackage.ZONE__GLOBAL:
				setGlobal((Boolean)newValue);
				return;
			case IcingaPackage.ZONE__ELEMENTS:
				setElements((ZoneElement)newValue);
				return;
			case IcingaPackage.ZONE__SUBZONES:
				getSubzones().clear();
				getSubzones().addAll((Collection<? extends Zone>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IcingaPackage.ZONE__ENDPOINTS:
				getEndpoints().clear();
				return;
			case IcingaPackage.ZONE__PARENT:
				setParent((Zone)null);
				return;
			case IcingaPackage.ZONE__GLOBAL:
				setGlobal(GLOBAL_EDEFAULT);
				return;
			case IcingaPackage.ZONE__ELEMENTS:
				setElements((ZoneElement)null);
				return;
			case IcingaPackage.ZONE__SUBZONES:
				getSubzones().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IcingaPackage.ZONE__ENDPOINTS:
				return endpoints != null && !endpoints.isEmpty();
			case IcingaPackage.ZONE__PARENT:
				return getParent() != null;
			case IcingaPackage.ZONE__GLOBAL:
				return global != GLOBAL_EDEFAULT;
			case IcingaPackage.ZONE__ELEMENTS:
				return elements != null;
			case IcingaPackage.ZONE__SUBZONES:
				return subzones != null && !subzones.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (global: ");
		result.append(global);
		result.append(')');
		return result.toString();
	}

} //ZoneImpl
