import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.cmdbuild.common.Constants;
import org.cmdbuild.dms.DocumentDelete;
import org.cmdbuild.dms.DocumentDownload;
import org.cmdbuild.dms.DocumentSearch;
import org.cmdbuild.dms.DocumentUpdate;
import org.cmdbuild.dms.Metadata;
import org.cmdbuild.dms.MetadataGroup;
import org.cmdbuild.dms.StorableDocument;
import org.cmdbuild.dms.StoredDocument;
import org.cmdbuild.dms.cmis.CategoryLookupConverter;
import org.cmdbuild.dms.cmis.CmisDmsConfiguration;
import org.cmdbuild.dms.cmis.CmisDmsService;
import org.cmdbuild.dms.exception.DmsError;


public class Test implements CmisDmsConfiguration, CategoryLookupConverter {

	private CmisDmsService service;
	private static final SimpleDateFormat CMDBUILD_DATETIME_PARSING_FORMAT = new SimpleDateFormat(Constants.SOAP_ALL_DATES_PARSING_PATTERN);
	
	public Test() {
		service = new CmisDmsService(this, this);
	}
	
	public void run() throws DmsError {
		service.getTypeDefinitions();
		
		service.upload(new StorableDocument() {
			public Iterable<MetadataGroup> getMetadataGroups() { return null; }
			public List<String> getPath() {	return Arrays.asList("ArchiMate","Technology","Node","Device","ClientDevice","OrganizationUnitClientDevice","Id6022215"); }
			public String getClassName() { return "OrganizationUnitClientDevice"; }
			public Long getCardId() {	return 6022215L;	}			
			public String getFileName() { return "test.txt"; }
			public String getDescription() { return "test"; }
			public String getCategory() { return "Document"; }
			public InputStream getInputStream() { return new ByteArrayInputStream("prova".getBytes());}
			public String getAuthor() { return "luca.bompani@unibo.it";}
		});
		
		service.upload(new StorableDocument() {
			public Iterable<MetadataGroup> getMetadataGroups() { return null; }
			public List<String> getPath() {	return Arrays.asList("ArchiMate","Technology","Node","Device","ClientDevice","OrganizationUnitClientDevice","Id6022215"); }
			public String getClassName() { return "OrganizationUnitClientDevice"; }
			public Long getCardId() {	return 6022215L;	}			
			public String getFileName() { return "test.txt"; }
			public String getDescription() { return "test aaa bbb ccc"; }
			public String getCategory() { return "Image"; }
			public InputStream getInputStream() { return new ByteArrayInputStream("prova aaa bbb ccc".getBytes());}
			public String getAuthor() { return "luca.bompani@unibo.it";}
		});
		
		service.updateDescriptionAndMetadata(new DocumentUpdate() {
			public List<String> getPath() {	return Arrays.asList("ArchiMate","Technology","Node","Device","ClientDevice","OrganizationUnitClientDevice","Id6022215"); }
			public String getClassName() { return "OrganizationUnitClientDevice"; }
			public Long getCardId() {	return 6022215L;	}			
			public String getFileName() { return "test.txt"; }
			public String getDescription() { return "test 123"; }
			public String getCategory() { return null; }
			public String getAuthor() { return "admin"; }
			public Iterable<MetadataGroup> getMetadataGroups() {
				List<MetadataGroup> groups = new ArrayList<MetadataGroup>();
				groups.add(new MetadataGroup() {
					public String getName() {return "Displayable";}
					public Iterable<Metadata> getMetadata() {
						List<Metadata> metadatas = new ArrayList<Metadata>();
						metadatas.add(new Metadata() {
							public String getName() {return "cmdbuild:width";}
							public String getValue() {return Integer.toString(300);}
						});
						metadatas.add(new Metadata() {
							public String getName() {return "cmdbuild:height";}
							public String getValue() {return Integer.toString(200);}
						});
						metadatas.add(new Metadata() {
							public String getName() {return "cmdbuild:sizeRatio";}
							public String getValue() {return Double.toString(0.5);}
						});
						return metadatas;
					}
				});
				groups.add(new MetadataGroup() {
					public String getName() {return "Creation date/time";}
					public Iterable<Metadata> getMetadata() {
						List<Metadata> metadatas = new ArrayList<Metadata>();
						metadatas.add(new Metadata() {
							public String getName() {return "cmdbuild:creationDate";}
							public String getValue() {return CMDBUILD_DATETIME_PARSING_FORMAT.format(new Date());}
						});
						metadatas.add(new Metadata() {
							public String getName() {return "cmdbuild:creationDateTime";}
							public String getValue() {return CMDBUILD_DATETIME_PARSING_FORMAT.format(new Date());}
						});
						return metadatas;
					}
				});
				groups.add(new MetadataGroup() {
					public String getName() {return "Image format";}
					public Iterable<Metadata> getMetadata() {
						List<Metadata> metadatas = new ArrayList<Metadata>();
						metadatas.add(new Metadata() {
							public String getName() {return "cmdbuild:imageFormat";}
							public String getValue() {return "raw";}
						});
						metadatas.add(new Metadata() {
							public String getName() {return "cmdbuild:colored";}
							public String getValue() {return Boolean.toString(true);}
						});
						return metadatas;
					}
				});
				return groups; 
			}			
		});
		
		service.search(new DocumentSearch() {			
			public List<String> getPath() {	return Arrays.asList("ArchiMate","Technology","Node","Device","ClientDevice","OrganizationUnitClientDevice","Id6022215"); }
			public String getClassName() { return "OrganizationUnitClientDevice"; }
			public Long getCardId() {	return 6022215L;	}
		});
		
		service.download(new DocumentDownload() {
			public List<String> getPath() {	return Arrays.asList("ArchiMate","Technology","Node","Device","ClientDevice","OrganizationUnitClientDevice","Id6022215"); }
			public String getClassName() { return "OrganizationUnitClientDevice"; }
			public Long getCardId() {	return 6022215L;	}			
			public String getFileName() { return "I48-38_SIW_20141203_121129_STR00493LABMART.html"; }
		});
		
		service.create(new DocumentSearch() {
			public List<String> getPath() {	return Arrays.asList("aaa","bbb","ccc","test","xxxxxx"); }
			public String getClassName() { return null; }
			public Long getCardId() {	return null;	}
		});
		
		service.copy(new StoredDocument() {
			public String getPath() { return "/ArchiMate/Technology/Node/Device/ClientDevice/OrganizationUnitClientDevice/Id6022215"; }
			public String getName() { return "test.txt";}
		}, new DocumentSearch() {
			public List<String> getPath() {	return Arrays.asList("ArchiMate","Technology","Node","Device","ClientDevice","OrganizationUnitClientDevice","Id6022215"); }
			public String getClassName() { return "OrganizationUnitClientDevice"; }
			public Long getCardId() {	return 6022215L;	}						
		},new DocumentSearch() {
			public List<String> getPath() {	return Arrays.asList("aaa","bbb","ccc","test","xxxxxx"); }
			public String getClassName() { return null; }
			public Long getCardId() {	return null;	}
		});
		
		service.delete(new DocumentDelete() {			
			public List<String> getPath() {	return Arrays.asList("ArchiMate","Technology","Node","Device","ClientDevice","OrganizationUnitClientDevice","Id6022215"); }
			public String getClassName() { return "OrganizationUnitClientDevice"; }
			public Long getCardId() {	return 6022215L;	}			
			public String getFileName() { return "test.txt"; }			
		});
		
		service.create(new DocumentSearch() {
			public List<String> getPath() {	return Arrays.asList("aaa","bbb","ccc","test","yyyyyy"); }
			public String getClassName() { return null; }
			public Long getCardId() {	return null;	}
		});
		
		service.move(new StoredDocument() {
			public String getPath() { return "/aaa/bbb/ccc/test/yyyyyy"; }
			public String getName() { return "test.txt";}
		}, new DocumentSearch() {
			public List<String> getPath() {	return Arrays.asList("aaa","bbb","ccc","test","xxxxxx"); }
			public String getClassName() { return null; }
			public Long getCardId() {	return null;	}						
		},new DocumentSearch() {
			public List<String> getPath() {	return Arrays.asList("aaa","bbb","ccc","test","yyyyyy"); }
			public String getClassName() { return null; }
			public Long getCardId() {	return null;	}
		});
		
		service.delete(new DocumentSearch() {
			public List<String> getPath() {	return Arrays.asList("aaa"); }
			public String getClassName() { return null; }
			public Long getCardId() {	return null;	}
		});
	}

	public static void main(String[] args) throws DmsError {
		Test test = new Test();
		test.run();
	}

	@Override
	public boolean isEnabled() {
		return true;
	}

	@Override
	public String getCmisUrl() {
		return "http://localhost:8080/alfresco/api/cmis/versions/1.1/atom/";
	}

	@Override
	public String getCmisUser() {
		return "admin";
	}

	@Override
	public String getCmisPassword() {
		return "admin";
	}

	@Override
	public String getCmdbuildCategory() {
		return "AlfrescoCategory";
	}

	@Override
	public String getCmisPath() {
		return "/User Homes/cmdbuild";
	}

	@Override
	public String getAlfrescoCustomUri() {
		return "org.cmdbuild.dms.alfresco";
	}

	@Override
	public String getCustomModelFileContent() {
		StringBuilder  stringBuilder = new StringBuilder();
		try {
		    String ls = System.getProperty("line.separator");
			BufferedReader reader = new BufferedReader(new FileReader ("../cmdbuild-dms-cmis-alfresco/cmisCustomModel.xml"));
		    String line = null;
		    while( ( line = reader.readLine() ) != null ) {
		        stringBuilder.append( line );
		        stringBuilder.append( ls );
		    }					
		    reader.close();
		} catch (Exception e) {
			e.printStackTrace();
		}		
		return stringBuilder.toString();
	}

	@Override
	public String getMetadataAutocompletionFileContent() {
		return null;
	}

	@Override
	public void addListener(ChangeListener listener) {
	}

	@Override
	public String getService() {
		return "cmis";
	}

	@Override
	public String getCmisModelType() {
		return "custom";
	}

	@Override
	public Object toCmis(String value) {
		return value;
	}

	@Override
	public String fromCmis(Object value) {
		return value != null ? value.toString() : null;
	}
}
