package tests.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.cmdbuild.config.DmsProperties;
import org.cmdbuild.dms.cmis.CmisDmsConfiguration;

public class ForwardingDMSProperties  implements CmisDmsConfiguration {
	private static final String CMIS_BINDING = "cmis.binding";
	private static final String CMIS_LOCAL_FACTORY = "cmis.local.factory";	
	private static final String CMIS_PARAM_PREFIX = "cmis.param.";
	
	DmsProperties _origProperties = null;
	
	public ForwardingDMSProperties(DmsProperties origProperties) {
		_origProperties = origProperties;
		setProperty(CMIS_BINDING, BindingType.ATOMPUB.value());
		setProperty(CMIS_LOCAL_FACTORY, null);
	}
	
	public String getCmisBindingType() {
		return _origProperties.getProperty(CMIS_BINDING);
	}

	public String getLocalServiceFactory() {
		return _origProperties.getProperty(CMIS_LOCAL_FACTORY);
	}

	public Map<String, String> getSessionParameters() {
		HashMap<String, String> result = new HashMap<String, String>();
		for (String propName : stringPropertyNames()) {
			if (propName.startsWith(CMIS_PARAM_PREFIX)){
				result.put(propName.substring(CMIS_PARAM_PREFIX.length()), getProperty(propName));
			}
		}
		return result;
	}

	public void setProperty(String key, String value) {
		_origProperties.setProperty(key, value);
	}

	public  String getProperty(String key) {
		return _origProperties.getProperty(key);
	}
	
	public Set<String> stringPropertyNames() {
		return _origProperties.stringPropertyNames();
	}


	public String getCustomModelFileContent() {
		return _origProperties.getCustomModelFileContent();
	}

	public String getAlfrescoCustomPrefix() {
		return _origProperties.getAlfrescoCustomPrefix();
	}

	public String getAlfrescoCustomUri() {
		return _origProperties.getAlfrescoCustomUri();
	}

	public String getAlfrescoPassword() {
		return _origProperties.getAlfrescoPassword();
	}

	public String getAlfrescoUser() {
		return _origProperties.getAlfrescoUser();
	}

	public String getCmdbuildCategory() {
		return _origProperties.getCmdbuildCategory();
	}

	public long getDelayBetweenFtpAndWebserviceOperations() {
		return _origProperties.getDelayBetweenFtpAndWebserviceOperations();
	}

	@Override
	public String getMetadataAutocompletionFileContent() {
		return  _origProperties.getMetadataAutocompletionFileContent();
	}

	public boolean isEnabled() {
		return _origProperties.isEnabled();
	}

	@Override
	public void addListener(ChangeListener listener) {
	}

	@Override
	public String getService() {
		return "cmis";
	}

	@Override
	public String getCmisModelType() {
		return "custom";
	}

	@Override
	public String getCmisUrl() {
		return _origProperties.getCmisUrl();
	}

	@Override
	public String getCmisUser() {
		return _origProperties.getCmisUser();
	}

	@Override
	public String getCmisPassword() {
		return _origProperties.getCmisPassword();
	}

	@Override
	public String getCmisPath() {
		return _origProperties.getCmisPath();
	}
}
