import it.unibo.cmdbuild.rest.CMDBuildClient;
import it.unibo.cmdbuild.rest.Card;
import it.unibo.cmdbuild.rest.Table;

import it.unibo.cmdbuild.nagios.NagiosExport;
import it.unibo.cmdbuild.nagios.ScpClient;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;

import com.jcraft.jsch.JSchException;

public class Test {

	public static void main(String[] args) throws Exception {
		Test test = new Test(new URI(
				"https://lbvm04.personale.dir.unibo.it/cmdbuild"), "admin",
				"sqPnntpxmmQqG0rMIxyW");
		test.exportBP("nagios@lbvm04.personale.dir.unibo.it:/usr/local/nagiosbp/etc/nagios-bp.conf", "/home/luca/Projects/workspace/nagios.key");
		test.exportNagios("nagios@lbvm04.personale.dir.unibo.it:/etc/nagios3/conf.d/cmdb.cfg", "/home/luca/Projects/workspace/nagios.key");
		test.exportNagvis("nagios@lbvm04.personale.dir.unibo.it:/usr/local/nagvis/etc/maps/", "/home/luca/Projects/workspace/nagios.key");
		//test.showGraph(367,"LOBApplication");
	}

	CMDBuildClient cmdb;
	private NagiosExport nagiosExport;

	public Test(URI uri, String username, String password)
			throws Exception {
		cmdb = new CMDBuildClient(uri, username, password);
		nagiosExport = new NagiosExport(cmdb);
		
	}

	public void exportBP(String target, String identity) throws IOException, JSchException {
		StringWriter writer = new StringWriter();
		nagiosExport.exportBP(writer);
		writer.flush();
		String config = writer.toString();
		ScpClient scpClient = new ScpClient();
		scpClient.addIdentity(identity);
		scpClient.write(config, target);
	}

	public void exportNagios(String target, String identity) throws IOException, JSchException {
		StringWriter writer = new StringWriter();
		nagiosExport.exportNagios(writer);
		writer.flush();
		String config = writer.toString();
		ScpClient scpClient = new ScpClient();
		scpClient.addIdentity(identity);
		scpClient.write(config, target);
	}

	public void exportNagvis(String target, String identity) throws IOException, JSchException {
		for(Table clazz : cmdb.classes()) {
			for(Card card : clazz.cards()) {
				if(nagiosExport.isMap(card)) {
					StringWriter writer = new StringWriter();
					//com.mxgraph.view.mxGraph graph = 
					nagiosExport.exportNagvis(card, writer);
					writer.flush();
					String config = writer.toString();
					ScpClient scpClient = new ScpClient();
					scpClient.addIdentity(identity);
					scpClient.write(config, target + card.getSchema().getName() + Integer.toString(card.getId()) + ".cfg");
					//javax.swing.JFrame frame = new javax.swing.JFrame(card.get("Code").getValue());
					//com.mxgraph.swing.mxGraphComponent graphComponent = new com.mxgraph.swing.mxGraphComponent(graph);
					//frame.getContentPane().add(graphComponent);
					//frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
					//frame.setSize(800, 600);
					//frame.setVisible(true);
				}
			}
		}
	}
}