package it.unibo.cmdbuild.rest;

import org.json.JSONException;
import org.json.JSONObject;

public class Relation extends Element {

	private int class1;
	private int card1;
	private int class2;
	private int card2;

	public enum Direction {
		DIRECT, INVERSE
	}

	public Relation(Card card, JSONObject json, Domain schema)
			throws JSONException {
		super(json, schema, null);
		this.class1 = card.getSchema().getId();
		this.card1 = card.getId();
		this.class2 = json.getInt("dst_cid");
		this.card2 = json.getInt("dst_id");
		this.parseAttributes(json.getJSONObject("rel_attr"));
		assert (getCard1().isInstanceOf(((Domain) getSchema()).getClass1()));
		assert (getCard2().isInstanceOf(((Domain) getSchema()).getClass2()));
	}

	public Card getCard1() {
		return getCMDB().getClass(class1).getCard(card1);
	}

	public Card getCard2() {
		return getCMDB().getClass(class2).getCard(card2);
	}

	@Override
	public String toString() {
		//return getCard1().toString() + " --" + getSchema().toString() + "--> " + getCard2().toString();
		return getSchema().toString();
	}
}
