package it.unibo.cmdbuild.rest;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Table extends Schema {

	public enum TableType {
		STANDARD, SIMPLETABLE;
	}

	public enum Type {
		CLASS, PROCESSCLASS;
	}

	private Type type;
	private TableType tableType;
	private int parent;
	private String description;
	private boolean isSuperClass;
	private Map<Integer, Card> cards = new HashMap<Integer, Card>();

	public Table(JSONObject json, CMDBuildClient cmdb) throws JSONException {
		super(json, cmdb);
		this.type = Enum.valueOf(Type.class, json.getString("type")
				.toUpperCase());
		this.tableType = Enum.valueOf(TableType.class,
				json.getString("tableType").toUpperCase());
		this.description = json.getString("text");
		this.isSuperClass = json.getBoolean("superclass");
		this.parent = json.optInt("parent", -1);
	}

	public void parseInstances(JSONArray jsArray) throws JSONException {
		for (int i = 0; i < jsArray.length(); i++) {
			JSONObject jsItem = jsArray.getJSONObject(i);
			Card card = new Card(jsItem, this);
			assert (!cards.containsKey(card.getId()));
			cards.put(card.getId(), card);
		}
	}

	public boolean isSubclassOf(Table schema) {
		boolean found = false;
		Table clazz = this;
		while (!found && clazz != null) {
			found = (clazz == schema);
			clazz = clazz.getParent();
		}
		return found;
	}

	public Card getCard(int id) {
		return cards.get(id);
	}

	public Collection<Card> cards() {
		return cards.values();
	}

	public Type getType() {
		return type;
	};

	public TableType getTableType() {
		return tableType;
	};

	public String getDescription() {
		return description;
	}

	public boolean isSuperClass() {
		return isSuperClass;
	}

	public Table getParent() {
		return parent != -1 ? getCMDB().getClass(parent) : null;
	}
}
