package it.unibo.cmdb.archimate;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordDialog extends Dialog {
	static final String CMDB_USER = "CMDBUser";
	
	private Text usernameText;
	private Text passwordText;
	private String username;
	private String password;

	public PasswordDialog(Shell parentShell) {
		super(parentShell);
	}

	protected Control createDialogArea(Composite parent) {
		IDialogSettings settings = CMDBPlugin.INSTANCE.getDialogSettings();
		
		Composite composite = (Composite)super.createDialogArea(parent);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		composite.setLayout(gridLayout);
		
		Label usernameLabel = new Label(composite, SWT.RIGHT);
		usernameLabel.setText(Messages.CMDBDialog_User);
		usernameText = new Text(composite, SWT.SINGLE);
		GridData usernameGridData = new GridData();
		usernameGridData.horizontalAlignment = GridData.FILL;
		usernameGridData.grabExcessHorizontalSpace = true;
		usernameText.setLayoutData(usernameGridData);
		String user = settings.get(CMDB_USER);
		if(user != null)
			usernameText.setText(user);
		
		Label passwordLabel = new Label(composite, SWT.RIGHT);
		passwordLabel.setText(Messages.CMDBDialog_Password);
		passwordText = new Text(composite, SWT.SINGLE | SWT.PASSWORD);
		GridData passwordGridData = new GridData();
		passwordGridData.horizontalAlignment = GridData.FILL;
		passwordGridData.grabExcessHorizontalSpace = true;
		passwordText.setLayoutData(passwordGridData);

		return composite;
	}
	
	@Override
	protected void okPressed() {
		username = usernameText.getText();
		password = passwordText.getText();
		IDialogSettings settings = CMDBPlugin.INSTANCE.getDialogSettings();
		settings.put(CMDB_USER, username);		
		super.okPressed();
	}
	
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText("Insert CMDB credentials");
    }
	
	public String getUsername() {
		return username;
	}
	
	public String getPassword() {
		return password;
	}
}