
package it.unibo.cmdb.cmdbf.client;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.ConstraintType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.UnsupportedConstraintFaultType;

public class UnsupportedConstraintException extends Exception{
	private static final long serialVersionUID = -323991274463293521L;
	protected String localName;
    protected String namespace;
    
    public UnsupportedConstraintException(UnsupportedConstraintFaultType fault){
    	ConstraintType constraint = fault.getConstraint();
    	if(constraint != null) {
    		this.localName = constraint.getLocalName();
    		this.namespace = constraint.getNamespace();
    	}
    }

    public String getLocalName() {
        return localName;
    }


    public String getNamespace() {
        return namespace;
    }
}
